VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetallesCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public NumeroDocumento As Long
Public Renglon As Integer
Public CodigoItem As String
Public Descripcion As String
Public Presentacion As String
Public FactorEmpaque As Double
Public CantidadFacturada As Double
Public CantidadPromocion As Double
Public PrecioNominal As Currency        ' Precio unitario que aparece en el renglon de la Fact.Prov... Ambos precios por Presentacion (FactorEmpaque)
Public PrecioEfectivo As Currency       ' Precio resultante despues de la aplicacin de los descuentos, antes del prorrateo de CantProm
Public Impuesto1 As Double              ' Porcentaje de Impuesto1 cargado
Public Impuesto2 As Double              ' Porcentaje de Impuesto2 Cargado
Public CostoUnitario As Currency        ' = ((Facturadas / (Facturadas + Promocion)) * FactorDescuentosRecibo) / FactorEmpaque i.e. Precio Neto UNITARIO
Public Recibidas As Double              ' Cantidad de unidades efectivamente ingresadas a los almacenes.
Public Almacen As String
Public Devueltas As Double

Public isSerial As Boolean              ' Para no incluir en detalles "regulares" durante reimpresion

Public Function PorcentajeImpuesto1() As Double
  PorcentajeImpuesto1 = Impuesto1 / ValorTotal * 100
End Function

Public Function PorcentajeImpuesto2() As Double
  PorcentajeImpuesto2 = Impuesto2 / ValorTotal * 100
End Function

Public Function ValorTotal() As Currency
  ValorTotal = PrecioEfectivo * Cantidad
End Function

Public Function Cantidad() As Double
  Cantidad = CantidadFacturada + CantidadPromocion
End Function

Public Function CantidadTotal() As Double
    
    CantidadTotal = (CantidadFacturada + CantidadPromocion) * FactorEmpaque

End Function

Public Function Proveedor() As String
Dim instRecibo As clsReciboMercancia

    Set instRecibo = New clsReciboMercancia
    If instRecibo.Load(Me.NumeroDocumento) Then
        Proveedor = instRecibo.CodigoProveedor
    Else
        Proveedor = "<INVALIDO>"
    End If
    Set instRecibo = Nothing
    
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleCompra.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, v, s) As Boolean
Dim bRetVal As Boolean

    bRetVal = True
    
    Select Case sVarId
    
    Case "CANTIDADFACTURADA", "CANTFACT"
        v = Me.CantidadFacturada
        s = FormatNumero(Me.CantidadFacturada, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))

    Case "CANTIDADPROMOCION"
        v = Me.CantidadPromocion
        s = FormatNumero(Me.CantidadPromocion, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
        
    Case "CANTIDAD"
        v = Me.Cantidad
        s = FormatNumero(v, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
        
    Case "CANTIDADTOTAL"
        v = Me.CantidadTotal
        s = FormatNumero(v, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
    
    Case "CODIGO", "ARTICULO"
        v = Me.CodigoItem
        s = v

    Case "COSTOUNITARIO"
        v = Me.CostoUnitario
        s = FormatNumero(v, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))

    Case "DESCRIPCION"
        v = Me.Descripcion
        s = v

    Case "FACTOREMPAQUE"
        v = Me.FactorEmpaque
        s = s = FormatNumero(v, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))

    Case "PRECIOEFECTIVO"
        v = Me.PrecioEfectivo
        s = FormatNumero(v, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))

    Case "TOTALRENGLON", "VALORRENGLON"
        v = Me.PrecioEfectivo * Me.Cantidad
        s = FormatNumero(v, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        
    Case "PRECIONOMINAL"
        v = Me.PrecioNominal
        s = FormatNumero(v, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))

    Case "PRESENTACION", "UNIDAD"
        v = Me.Presentacion
        s = v

    Case "TIPOIMPUESTO1"
        v = Me.Impuesto1
        s = v

    Case "TIPOIMPUESTO2"
        v = Me.Impuesto2
        s = v

    Case Else
    
        bRetVal = ExtendEval(sVarId, v, s)
        
    End Select
    
    EvalVar = bRetVal

End Function
