VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetalleSerial"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroDetalle As Long
Public NumeroDocumento As Long
Public TipoDocumento As String
Public Renglon As Integer
Public CodigoItem As String
Public Serial As String
Public FechaTransaccion As Date
Public isTemporal As Integer
Public prevStatus As Integer
Public Tipo As Integer

Private rsIterador As Recordset

Public Function Fecha() As Date

    Fecha = FechaTransaccion

End Function

Public Sub LoadInstance(rs As Recordset, Optional ByVal pDest As clsDetalleSerial = Nothing)

    If pDest Is Nothing Then
        Set pDest = Me
    End If
    
    With rs
    pDest.NumeroDetalle = GetNumeroFromVariant(.Fields("NumeroDetalle"))
    pDest.NumeroDocumento = GetNumeroFromVariant(.Fields("NumeroDocumento"))
    pDest.TipoDocumento = GetStringFromVariant(.Fields("TipoDocumento"))
    pDest.Renglon = GetNumeroFromVariant(.Fields("Renglon"))
    pDest.CodigoItem = GetStringFromVariant(.Fields("CodigoItem"))
    pDest.Serial = GetStringFromVariant(.Fields("Serial"))
    pDest.FechaTransaccion = GetDateFromVariant(.Fields("FechaTransaccion"))
    pDest.Tipo = GetNumeroFromVariant(.Fields("Tipo"))
    pDest.isTemporal = GetNumeroFromVariant(.Fields("isTemporal"))
    pDest.prevStatus = GetNumeroFromVariant(.Fields("prevStatus"))
    End With

End Sub

Public Function IniciarIterador(istrCodigoItem As String, istrSerial As String, ByVal idtFechaInicio As Date) As Boolean
Dim sQry As String

    sQry = "SELECT * FROM SerialesDetalles "
    sQry = sQry & "WHERE CodigoItem = " & StringDB(istrCodigoItem) & " AND isTemporal = 0 "
    sQry = sQry & "AND Serial = " & StringDB(istrSerial) & " "
    sQry = sQry & "AND FechaTransaccion >= " & FechaDB(idtFechaInicio) & " "
    sQry = sQry & "ORDER BY FechaTransaccion, NumeroDetalle"

    Set rsIterador = dbHandle.Execute(sQry)
    
    If rsIterador.EOF Then
        Set rsIterador = Nothing
        IniciarIterador = False
    Else
        IniciarIterador = True
    End If

End Function

Public Function NextDetalle() As clsDetalleSerial
Dim pRetVal As clsDetalleSerial

    If rsIterador Is Nothing Then
'        Err.Raise vbObjectError + 1001, "clsDetalleSerial::NextDetalle", "Iterador no Iniciado"
        Set NextDetalle = Nothing
        Exit Function
    End If

    If rsIterador.EOF Then
        Set NextDetalle = Nothing
        Exit Function
    End If

    Set pRetVal = New clsDetalleSerial
    LoadInstance rsIterador, pRetVal
    rsIterador.MoveNext
    
    Set NextDetalle = pRetVal

End Function

Public Sub EndIterador()

    Set rsIterador = Nothing

End Sub

Public Function DocumentoRelacionado() As Object
Dim pInstancer As clsInstanciadorEntidad, pDoc As Object

    Set pInstancer = New clsInstanciadorEntidad
    Set pDoc = pInstancer.EntidadDOCUMENTO(Me.TipoDocumento, Me.NumeroDocumento)
    Set pInstancer = Nothing

    Set DocumentoRelacionado = pDoc

End Function

Public Function ReferenciaDocumento() As String
Dim pDoc As Object, sRetVal As String

  On Error GoTo Invalido

  Set pDoc = DocumentoRelacionado
  sRetVal = pDoc.Referencia

ResumePoint:
  Set pDoc = Nothing
  ReferenciaDocumento = sRetVal
  Exit Function

Invalido:
  ReportException "Serial " & Me.Serial & ", Articulo " & Me.CodigoItem & ", ReferenciaDocumento invalida. Err:" & Err.Number & ", TDoc=" & Me.TipoDocumento & ", NDoc=" & Me.NumeroDocumento
  Err.Clear
  sRetVal = Me.TipoDocumento & "-" & Format(Me.NumeroDocumento, "000000")
  Resume ResumePoint

End Function

Public Function Operador() As String
Dim pDoc As Object, sRetVal As String

  On Error GoTo Invalido

  Set pDoc = DocumentoRelacionado
  sRetVal = pDoc.Operador

ResumePoint:
  Set pDoc = Nothing
  Operador = sRetVal
  Exit Function

Invalido:
  ReportException "Serial " & Me.Serial & ", Articulo " & Me.CodigoItem & ", ReferenciaDocumento invalida. Err:" & Err.Number & ", TDoc=" & Me.TipoDocumento & ", NDoc=" & Me.NumeroDocumento
  Err.Clear
  sRetVal = "INVALIDO"
  Resume ResumePoint

End Function

Private Function NumeroProximoDetalle() As Long
Dim rs As Recordset, lngRetVal As Long

  Set rs = dbHandle.Execute("SELECT MAX(NumeroDetalle) AS maxNumero FROM SerialesDetalles")
  If rs.EOF Then
    lngRetVal = 0
  Else
    lngRetVal = GetNumeroFromVariant(rs.Fields("maxNumero"))
  End If
  Set rs = Nothing
  
  NumeroProximoDetalle = lngRetVal + 1
  
End Function

Public Function RegistrarDetalle( _
    ByVal ilngNumDoc As Long, _
    istrTipoDoc As String, _
    ByVal inRenglon As Integer, _
    istrCodigoItem As String, _
    istrSerial As String, _
    ByVal idtFechaTransaccion As Date, _
    ByVal inTipo As Integer, _
    ByVal isTemporal As Boolean, _
    ByVal inPrevStatus As Integer) As Boolean
Dim sQry As String, isOk As Boolean

  isOk = True
  sQry = "INSERT INTO SerialesDetalles (NumeroDetalle, NumeroDocumento, TipoDocumento, Renglon, CodigoItem, Serial, Tipo, FechaTransaccion, isTemporal, prevStatus) VALUES ("
  sQry = sQry & NumeroDB(NumeroProximoDetalle) & ", "
  sQry = sQry & NumeroDB(ilngNumDoc) & ", "
  sQry = sQry & StringDB(istrTipoDoc) & ", "
  sQry = sQry & NumeroDB(inRenglon) & ", "
  sQry = sQry & StringDB(istrCodigoItem) & ", "
  sQry = sQry & StringDB(istrSerial) & ", "
  sQry = sQry & NumeroDB(inTipo) & ", "
  sQry = sQry & FechaDB(idtFechaTransaccion) & ", "
  sQry = sQry & NumeroDB(isTemporal) & ", "
  sQry = sQry & NumeroDB(inPrevStatus) & ")"

  dbHandle.Execute sQry
  RegistrarDetalle = isOk
End Function

Public Sub StartIteradorDocumento(istrTipoDoc As String, ByVal ilngNumDoc As Long)
Dim sQry As String

  sQry = "SELECT * FROM SerialesDetalles WHERE NumeroDocumento = " & NumeroDB(ilngNumDoc) & " AND "
  sQry = sQry & "TipoDocumento = " & StringDB(istrTipoDoc) & " "
  sQry = sQry & "ORDER BY Renglon, CodigoItem, Serial"

  Set rsIterador = dbHandle.Execute(sQry)

End Sub

Public Sub Revertir()
Dim pSerial As clsSeriales

  Set pSerial = New clsSeriales
  If pSerial.Load(Me.CodigoItem, Me.Serial) Then
    If Me.prevStatus = 2 Then
      dbHandle.Execute "DELETE FROM Seriales WHERE CodigoItem = " & StringDB(Me.CodigoItem) & " AND Serial = " & StringDB(Me.Serial)
    Else
      pSerial.Locked = 0
      pSerial.EnStock = Me.prevStatus
      dbHandle.Execute "UPDATE Seriales SET EnStock = " & NumeroDB(pSerial.EnStock) & ", Locked = " & NumeroDB(pSerial.Locked) & " WHERE CodigoItem = " & StringDB(Me.CodigoItem) & " AND Serial = " & StringDB(Me.Serial)
    End If
  End If
  dbHandle.Execute "DELETE FROM serialesDetalles WHERE NumeroDetalle = " & NumeroDB(Me.NumeroDetalle)
  Set pSerial = Nothing
End Sub
