VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetalleOrdenRWS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroOrden As Long          ' Numero de la Orden de Trabajo
Public NumeroRenglon As Long        ' Para ordenar cronolgicamente
Public CodigoProducto As String     ' Referencia a un producto (en itemsVenta)
Public Descripcion As String        ' Pasa como descripcin a la factura
Public Observaciones As String
Public PrecioUnitario As Currency   ' Permite controlar el precio de factura desde la orden...
Public Cantidad As Double

Public RefSerial As String

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleOrdenRWS.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId As String, ByRef vRetBuffer As Variant, ByRef sRetString As String) As Boolean
Dim bRetVal As Boolean
Dim pItemVenta As clsItemVenta

    bRetVal = True
    
    Select Case sVarId

    Case "CODIGO", "CODIGO_PRODUCTO", "CODIGO_ITEM"
        sRetString = Me.CodigoProducto
        vRetBuffer = sRetString
    
    Case "DESCRIPCION"
        sRetString = Me.Descripcion
        vRetBuffer = sRetString

    Case "CANTIDAD"
        vRetBuffer = Me.Cantidad
        sRetString = Trim(FormatNumero(Cantidad, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "PRECIO_VENTA"
        vRetBuffer = Me.PrecioUnitario
        sRetString = Trim(FormatNumero(Me.PrecioUnitario, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_RENGLON", "TOTAL_PVENTA"
        vRetBuffer = Me.PrecioTotal
        sRetString = Trim(FormatNumero(PrecioTotal, Empresa.MascaraPrecios, Len(Empresa.MascaraMonetarios)))
    
    Case Else
        
        Set pItemVenta = New clsItemVenta
        If pItemVenta.Load(Me.CodigoProducto) Then
            bRetVal = pItemVenta.EvalVar(sVarId, vRetBuffer, sRetString)
        Else
            bRetVal = False
        End If
        Set pItemVenta = Nothing
    
    End Select
    
    If bRetVal = False Then
      bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
    End If

    EvalVar = bRetVal

End Function

Public Property Get PrecioTotal() As Currency

    PrecioTotal = Me.PrecioUnitario * Me.Cantidad

End Property

Public Sub LoadInstance(pDetalle As clsDetalleOrdenRWS, rs As Recordset)

    With pDetalle
    .NumeroOrden = rs.Fields("NumeroOrden")
    .NumeroRenglon = rs.Fields("NumeroRenglon")
    .CodigoProducto = rs.Fields("CodigoProducto")
    .Descripcion = rs.Fields("Descripcion")
'    .Observaciones = rs.Fields("Observaciones")
    .PrecioUnitario = rs.Fields("PrecioUnitario")
    .Cantidad = rs.Fields("Cantidad")
    End With

End Sub
