VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetalleOrdenCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroDocumento As Long      ' Numero de la orden
Public Renglon As Integer           ' Numero del Renglon dentro de la orden
Public CodigoItem As String         ' Codigo del artculo
Public Descripcion As String        ' Descripcion del artculo
Public Presentacion As String       ' Tipo de unidad pedida
Public FactorEmpaque As Double      ' Cantidad de unidades por empaque
Public Cantidad As Double           ' Cantidad de unidades|Empaque requeridas
Public PrecioRequerido As Currency  ' Precio (por empaque) pedido
Public Recibidas As Double          ' Cantidad de unidades|Empaque recibidas
Public PrecioMedio As Currency      ' Precio medio de las unidades|empaque recibidas

Public Function CantidadPendiente() As Double
Dim qry As String, Recibidas As Double, rs As Recordset

    qry = "SELECT SUM(Cantidad) AS TotRec FROM ocRecibidas WHERE NumeroOrden = " & NumeroDB(Me.NumeroDocumento) & " AND NumeroRenglon = " & NumeroDB(Me.Renglon)
    Set rs = dbHandle.Execute(qry)
    If rs.EOF Then
        Recibidas = 0
    Else
        Recibidas = GetNumeroFromVariant(rs.Fields("TotRec"))
    End If
    
    If Recibidas > Cantidad Then Recibidas = Cantidad
    CantidadPendiente = Cantidad - Recibidas

    
End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsDetalleOrdenCompra)
Dim lpDest As clsDetalleOrdenCompra

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If
    
    With lpDest
    .NumeroDocumento = GetNumeroFromVariant(rs!NumeroDocumento)
    .Renglon = GetNumeroFromVariant(rs!Renglon)
    .CodigoItem = GetStringFromVariant(rs!CodigoItem)
    .Descripcion = GetStringFromVariant(rs!Descripcion)
    .Presentacion = GetStringFromVariant(rs!Presentacion)
    .FactorEmpaque = GetNumeroFromVariant(rs!FactorEmpaque)
    .Cantidad = GetNumeroFromVariant(rs!Cantidad)
    .PrecioRequerido = GetNumeroFromVariant(rs!PrecioRequerido)
    .Recibidas = GetNumeroFromVariant(rs!Recibidas)
    .PrecioMedio = GetNumeroFromVariant(rs!PrecioMedio)
    End With

End Sub

Public Function Renglones(ilngNumOrden As Long) As Collection
Dim pDestCol As Collection, pInst As clsDetalleOrdenCompra, rs As Recordset

    Set pDestCol = New Collection
    Set rs = dbHandle.Execute("SELECT * FROM ocDetalles WHERE NumeroDocumento = " & NumeroDB(ilngNumOrden) & " ORDER BY Renglon")

    Do While Not rs.EOF
        Set pInst = New clsDetalleOrdenCompra
        LoadInstance rs, pInst
        pDestCol.Add pInst
        Set pInst = Nothing
        rs.MoveNext
    Loop

    Set rs = Nothing

    Set Renglones = pDestCol

End Function

Public Sub RegistrarEntrada(odblCantidadRecibida As Double, ivmPrecioUnitario As Currency, istrTipoDocumento As String, ilngNumeroDocumento As Long, istrUnidad As String, idblFactor As Double, idtFecha As Date)
Dim dblCantidadAsignada As Double, dblCantidadRecibida As Double
Dim sQuery As String, pDetalleEntrega As clsDetalleEntregaOC
Dim vmPrecioUnitario As Currency

    dblCantidadRecibida = odblCantidadRecibida * idblFactor / FactorEmpaque     ' Cantidad Recibida, en las unidades del renglon
    If dblCantidadRecibida > Cantidad - Recibidas Then
        dblCantidadRecibida = Cantidad - Recibidas
    End If
    dblCantidadAsignada = dblCantidadRecibida * FactorEmpaque / idblFactor      ' Cantidad Asignada, en las unidades de entrada

    odblCantidadRecibida = odblCantidadRecibida - dblCantidadAsignada           ' Ok!

    Set pDetalleEntrega = New clsDetalleEntregaOC
    pDetalleEntrega.Registrar NumeroDocumento, Renglon, idtFecha, CodigoItem, dblCantidadRecibida, ivmPrecioUnitario, istrUnidad, idblFactor, istrTipoDocumento, ilngNumeroDocumento
    Set pDetalleEntrega = Nothing

    vmPrecioUnitario = ivmPrecioUnitario * idblFactor / FactorEmpaque
    
    sQuery = "UPDATE ocDetalles SET PrecioMedio = (PrecioMedio * Recibidas + " & NumeroDB(vmPrecioUnitario) & " * " & NumeroDB(dblCantidadRecibida) & ") / (Recibidas + " & NumeroDB(dblCantidadRecibida) & ") WHERE NumeroDocumento = " & NumeroDB(Me.NumeroDocumento) & " AND Renglon = " & NumeroDB(Me.Renglon)
    dbHandle.Execute sQuery
    sQuery = "UPDATE ocDetalles SET Recibidas = Recibidas + " & NumeroDB(dblCantidadRecibida) & " WHERE NumeroDocumento = " & NumeroDB(Me.NumeroDocumento) & " AND Renglon = " & NumeroDB(Me.Renglon)
    dbHandle.Execute sQuery

End Sub

Public Function Entregas() As Collection
Dim pEntrega As clsDetalleEntregaOC
Dim retCol As Collection

    Set pEntrega = New clsDetalleEntregaOC
    Set retCol = pEntrega.EntregasRenglon(NumeroDocumento, Renglon)
    Set pEntrega = Nothing

    Set Entregas = retCol

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleOC.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function


Public Function EvalVar(sVarId, v, s) As Boolean
Dim bRetVal As Boolean, pItem As New clsItemInventario, pOrden As clsOrdenesCompra
Dim pAlmacenCotsPP As clsAlmacenCotsPP, pCot As clsCotsProvProd

    bRetVal = True
    
    Select Case sVarId
    
    Case "CANTIDAD"
        v = Me.Cantidad
        s = FormatNumero(Me.Cantidad, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))

    Case "CODIGO", "ARTICULO"
        v = Me.CodigoItem
        s = FormatNumero(v, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))

    Case "REFPARTEPROVEEDOR", "CODIGOPRODUCTOPROVEEDOR"
        If Me.CodigoItem = "" Then
            v = ""
            s = ""
        Else
            Set pAlmacenCotsPP = New clsAlmacenCotsPP
            Set pOrden = New clsOrdenesCompra
            If Not pOrden.Load(Me.NumeroDocumento) Then
                s = ""
            Else
                Set pCot = pAlmacenCotsPP.GetInstance(pOrden.CodigoProveedor, Me.CodigoItem)
                If Not pCot Is Nothing Then
                    s = pCot.RefProductoProveedor
                Else
                    s = ""
                End If
            End If
            If s = "" Then s = Me.CodigoItem
            Set pOrden = Nothing
            Set pAlmacenCotsPP = Nothing
            v = s
        End If
    
    Case "COSTOUNITARIO", "PRECIO", "PRECIOREQUERIDO"
        v = Me.PrecioRequerido
        s = FormatNumero(v, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))

    Case "DESCRIPCION"
        v = Me.Descripcion
        s = v

    Case "FACTOREMPAQUE"
        v = Me.FactorEmpaque
        s = s = FormatNumero(v, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))

    Case "PRECIOEFECTIVO"
        v = Me.PrecioMedio
        s = FormatNumero(v, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))

    Case "PRECIOTOTAL", "VALORRENGLON"
        v = Me.PrecioRequerido * Me.Cantidad
        s = FormatNumero(v, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))

    Case "PRESENTACION", "UNIDAD"
        v = Me.Presentacion
        s = v

    Case "TIPOIMPUESTO1"
        If pItem.Load(Me.CodigoItem) Then
            v = pItem.claseImpuesto1
        Else
            v = ""
        End If
        s = v

    Case "TIPOIMPUESTO2"
        If pItem.Load(Me.CodigoItem) Then
            v = pItem.ClaseImpuesto2
        Else
            v = ""
        End If
        s = v

    Case Else

        bRetVal = ExtendEval(sVarId, v, s)

    End Select

    EvalVar = bRetVal

End Function

