VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetalleCuentaEntidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public CodigoEntidad As String
Public TipoEntidad As String
Public Correlativo As Long
Public Documento As Long
Public Fecha As Date
Public refPeriodo As Long   ' ao * 100 + mes
Public Descripcion As String
Public Debe As Currency, _
        Haber As Currency


Public Function Add(iDocumento As Long, _
                    stCodigoEntidad As String, _
                    stTipoEntidad As String, _
                    dtFecha As Date, _
                    stDescripcion As String, _
                    vmMontoDetalle As Currency, _
                    iComprobante As clsBufferComprobante) As Boolean
Dim isOk As Boolean, instDocumento As clsDocumentosISPC
Dim objEntidad As Object, instanciador As clsInstanciadorEntidad

    If iDocumento <> 0 Then             ' No es necesario que el movimiento se asocie con un documento
      Set instDocumento = New clsDocumentosISPC
      If Not instDocumento.Load(iDocumento) Then
        Err.Raise 10001, "DetalleCuentaEntidad:Add", "Referencia a documento no registrado (" & iDocumento & ")"
        Exit Function
      End If
      If Abs(instDocumento.Saldo + vmMontoDetalle) < 0.1 Then
        vmMontoDetalle = -instDocumento.Saldo
      End If
    End If

    With Me
    .CodigoEntidad = stCodigoEntidad
    .TipoEntidad = stTipoEntidad
    .Documento = iDocumento                 ' Puede NO estar asociado con un documento...
    .Fecha = dtFecha
    .refPeriodo = mPeriodos.refPeriodo(Year(dtFecha), Month(dtFecha))
    .Descripcion = stDescripcion
    If vmMontoDetalle < 0 Then
      .Debe = 0@
      .Haber = -vmMontoDetalle
    Else
      .Debe = vmMontoDetalle
      .Haber = 0@
    End If
    End With

    AlmacenDetallesEntidad.Add Me  ' Asigna Correlativo (a nivel de entidad)
    
    If iDocumento <> 0 Then             ' No es necesario que el movimiento se asocie con un documento
      On Error Resume Next
      instDocumento.RegistrarVariacion vmMontoDetalle, iComprobante    ' Podra ser que el documento tuviera algo que agregar al comprobante
      If Err.Number Then Err.Clear
      On Error GoTo 0
    End If
    
    AlmacenSaldosEntidad.RegistrarVariacion stCodigoEntidad, stTipoEntidad, Me.refPeriodo, vmMontoDetalle, False
    Set instanciador = New clsInstanciadorEntidad
    Set objEntidad = instanciador.EntidadPersonaComercial(Me.TipoEntidad, Me.CodigoEntidad)
    If Not objEntidad Is Nothing Then
      isOk = objEntidad.RegistrarVariacionSaldo(vmMontoDetalle, stDescripcion, iComprobante)
    End If
    
    Set objEntidad = Nothing
    Set instanciador = Nothing

    Add = True

End Function
