VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetalleCotizacion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

    Public NumeroDocumento As Long      ' Numero de la factura
    Public Renglon As Integer           ' Numero del renglon (0..32767)
    Public CodigoItem As String         ' Cdigo del item (puede estar en blanco)
    Public Descripcion As String        ' Descripcion del item
    Public Presentacion As String       ' Tipo de presentacion UNIDAD | itemVenta(CodigoItem).Presentacion
    Public FactorEmpaque As Double      ' Cantidad de unidades por empaque
    Public Cantidad As Double           ' Cantidad de unidades
    Public PrecioLista As Currency      ' Precio de lista del producto
    Public PrecioVenta As Currency      ' Precio de venta  (como debi aparecer en la edicin del detalle)
    Public PrecioEfectivo As Currency   ' Precio final (incluyendo descuentos globales y pronto pago)
    Public Impuesto1 As Double          ' Porcentaje del impuesto aplicado
    Public Impuesto2 As Double          ' Segundo porcentaje de impuesto aplicado.
    Public CostoUnitario As Currency    ' Costo unitario (standard)
    Public CantidadFacturada As Double  ' Cantidad de unidades facturadas

    Public isSerial As Boolean          ' No es necesario aqu, pero s en los detalles de factura.
                                        ' y como DetalleCotizacion es "hermana" de DetalleFactura, entonces...
' Acumuladores para los Detalles de Factura (u otros usos generales)
Public AcumPLista As Currency, _
        AcumPVenta As Currency, _
        AcumPFinal As Currency

' Estos campos solamente son accesibles cuando el registro se toma de la coleccion "Detalles"
' de una factura. Se usan para sub-totalizar a efectos de impresion

Public NumeroProducto As Long

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleCotizacion.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean
Dim pItemVenta As clsItemVenta

    bRetVal = True
    
    Select Case sVarId

    Case "SUBTOT_PLISTA"
        sRetString = FormatNumero(AcumPLista, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPLista

    Case "SUBTOT_PVENTA"
        sRetString = FormatNumero(AcumPVenta, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPVenta

    Case "SUBTOT_PFINAL"
        sRetString = FormatNumero(AcumPFinal, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPFinal

    Case "NITEM"
        sRetString = FormatNumero(NumeroProducto, "##0", 3)
        vRetBuffer = NumeroProducto

    Case "CODIGO", "CODIGO_PRODUCTO", "CODIGO_ITEM"
        sRetString = CodigoItem
        vRetBuffer = sRetString
    
    Case "DESCRIPCION"
        sRetString = Descripcion
        vRetBuffer = sRetString

    Case "PRESENTACION"
        sRetString = Presentacion
        vRetBuffer = sRetString

    Case "FACTOR_EMPAQUE"
        vRetBuffer = FactorEmpaque
        sRetString = Trim(FormatNumero(FactorEmpaque, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "CANTIDAD"
        vRetBuffer = Cantidad
        sRetString = Trim(FormatNumero(Cantidad, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "PRECIO_LISTA"
        vRetBuffer = PrecioLista
        sRetString = Trim(FormatNumero(PrecioLista, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_LISTA_UNITARIO"
        If FactorEmpaque <> 0 Then
            vRetBuffer = PrecioLista / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_VENTA"
        vRetBuffer = PrecioVenta
        sRetString = Trim(FormatNumero(PrecioVenta, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_VENTA_UNITARIO"
        If FactorEmpaque <> 0 Then
            vRetBuffer = PrecioVenta / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_EFECTIVO"
        If Cantidad <> 0 Then
            vRetBuffer = PrecioEfectivo / Cantidad
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_EFECTIVO_UNITARIO"
        If Cantidad <> 0 Then
            vRetBuffer = PrecioEfectivo / Cantidad / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_RENGLON"
        vRetBuffer = PrecioEfectivo
        sRetString = Trim(FormatNumero(PrecioEfectivo, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_PLISTA"
        vRetBuffer = PrecioLista * Cantidad
        sRetString = Trim(FormatNumero(PrecioLista * Cantidad, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))
    
    Case "TOTAL_PVENTA"
        vRetBuffer = PrecioVenta * Cantidad
        sRetString = Trim(FormatNumero(PrecioVenta * Cantidad, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))
    
    Case Else
        
        bRetVal = False
        
        Set pItemVenta = New clsItemVenta
        If pItemVenta.Load(Me.CodigoItem) Then
            bRetVal = pItemVenta.EvalVar(sVarId, vRetBuffer, sRetString)
        End If
        If bRetVal = False Then
            bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
        End If
        Set pItemVenta = Nothing

    End Select
    
    EvalVar = bRetVal

End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsDetalleCotizacion = Nothing)

    If pDest Is Nothing Then Set pDest = Me
    
    With pDest
    .Cantidad = rs.Fields("Cantidad")
    .CodigoItem = rs.Fields("CodigoItem")
    .CostoUnitario = rs.Fields("CostoUnitario")
    .Descripcion = rs.Fields("Descripcion")
    .FactorEmpaque = rs.Fields("FactorEmpaque")
    .Impuesto1 = rs.Fields("Impuesto1")
    .Impuesto2 = rs.Fields("Impuesto2")
    .NumeroDocumento = rs.Fields("NumeroDocumento")
    .PrecioEfectivo = rs.Fields("PrecioEfectivo")
    .PrecioLista = rs.Fields("PrecioLista")
    .PrecioVenta = rs.Fields("PrecioVenta")
    .Presentacion = rs.Fields("Presentacion")
    .Renglon = rs.Fields("Renglon")
    .Cantidad = rs.Fields("Cantidad")
    .CantidadFacturada = rs.Fields("CantidadFacturada")
    .isSerial = False
    End With

End Sub

Public Function RenglonesCotizacion(ByVal ilngNumCot As Long) As Collection
Dim pDestCol As Collection, pInst As clsDetalleCotizacion, rs As Recordset

    Set pDestCol = New Collection
    Set rs = dbHandle.Execute("SELECT * FROM CotizacionesDetalles WHERE NumeroDocumento = " & NumeroDB(ilngNumCot) & " ORDER BY Renglon")

    Do While Not rs.EOF
        Set pInst = New clsDetalleCotizacion
        LoadInstance rs, pInst
        pDestCol.Add pInst
        Set pInst = Nothing
        rs.MoveNext
    Loop
    
    Set rs = Nothing
    
    Set RenglonesCotizacion = pDestCol

End Function

Public Property Get PrecioTotal() As Double
    
    PrecioTotal = PrecioVenta * Cantidad

End Property

Public Function Descuento() As Double
Dim dblTemp As Double
    If PrecioLista = 0 Then
        Descuento = 0
        Exit Function
    End If
    dblTemp = PrecioLista - PrecioVenta
    dblTemp = dblTemp / PrecioLista
    dblTemp = dblTemp * 100
    Descuento = dblTemp
End Function

Public Sub RegistrarEntrega(odblCantidadEntregada As Double, ivmPrecioUnitario As Currency, istrTipoDocumento As String, ilngNumeroDocumento As Long, istrUnidad As String, idblFactor As Double, idtFecha As Date)
Dim dblCantidadAsignada As Double, dblCantidadRecibida As Double
Dim sQuery As String, pDetalleEntrega As clsDetalleEntregaCotizacion

    dblCantidadRecibida = odblCantidadEntregada * idblFactor / Me.FactorEmpaque ' Cantidad Recibida, en las unidades del renglon
    If dblCantidadRecibida > Me.Cantidad - Me.CantidadFacturada Then
        dblCantidadRecibida = Me.Cantidad - Me.CantidadFacturada
    End If
    dblCantidadAsignada = dblCantidadRecibida * Me.FactorEmpaque / idblFactor   ' Cantidad Asignada, en las unidades de entrada

    odblCantidadEntregada = odblCantidadEntregada - dblCantidadAsignada

    Set pDetalleEntrega = New clsDetalleEntregaCotizacion
    pDetalleEntrega.Registrar Me.NumeroDocumento, Me.Renglon, idtFecha, Me.CodigoItem, dblCantidadRecibida, ivmPrecioUnitario, istrUnidad, idblFactor, istrTipoDocumento, ilngNumeroDocumento
    Set pDetalleEntrega = Nothing

    sQuery = "UPDATE CotizacionesDetalles SET CantidadFacturada = CantidadFacturada + " & NumeroDB(dblCantidadRecibida) & " WHERE NumeroDocumento = " & NumeroDB(Me.NumeroDocumento) & " AND Renglon = " & NumeroDB(Me.Renglon)
    dbHandle.Execute sQuery

End Sub

Public Function Entregas() As Collection
Dim pEntrega As clsDetalleEntregaCotizacion
Dim retCol As Collection

    Set pEntrega = New clsDetalleEntregaCotizacion
    Set retCol = pEntrega.EntregasRenglon(Me.NumeroDocumento, Me.Renglon)
    Set pEntrega = Nothing

    Set Entregas = retCol

End Function
