VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCuentasPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' Modulo de servicio para SesionPOS
Option Explicit

Private Const Q_RETRIES = 7

Public IDCuenta As Long                 ' Clave de la cuenta
Public Vendedor As String               ' Cdigo del vendedor (generalmente mesonero) que atiende la cuenta
Public qPersonas As Integer             ' Cantidad de personas
Public HoraApertura As Date             ' Hora (y fecha) de la primera comanda
Public HoraUltimaTransaccion As Date    ' Hora (y fecha) de la ultima actividad
Public Estado As Integer                ' 1: En Proceso. 2: Cerrada (Impresa).
Public codigoCuenta As String           ' El estado CERO (Libre) se produce en una Mesa cuando no tiene consumos, i.e. la cuenta asociada No Existe
Public Ambiente As String
Public IDMesa As Long
Public mCliente As String               ' Cdigo del cliente (para delivery)

Public nCuenta As Long, nSubCuenta As Long
Public nUltimoRenglon As Long

Private Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)

Public Property Let Numero(ilngNumeroCuenta As Long)
  IDCuenta = Numero
End Property

Public Property Get Numero() As Long
  Numero = IDCuenta
End Property

Public Function ProximaCuentaPOS() As Long
Dim sQuery As String, rs As Recordset, NumeroCuenta As Long

  sQuery = "SELECT Max(idCuenta) AS Ultima FROM CuentasPOS;"
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If rs.EOF Then
    NumeroCuenta = 0
  Else
    NumeroCuenta = GetNumeroFromVariant(rs!Ultima)
  End If
  Set rs = Nothing
  ProximaCuentaPOS = NumeroCuenta + 1
End Function

Public Function Cliente(lNumCuenta As Long) As String
Dim rs As Recordset, stRetVal As String

    Set rs = dbHandle.OpenRecordset("SELECT Cliente FROM CuentasPOS WHERE idCuenta = " & lNumCuenta, dbOpenForwardOnly)
    If rs.EOF Then
        stRetVal = ""
    Else
        stRetVal = GetStringFromVariant(rs.Fields("Cliente"))
    End If
    Set rs = Nothing
    
    Cliente = stRetVal

End Function

Public Function MachineID() As Long
    MachineID = mMachineID.MachineID
End Function

Public Sub SetData(Numero As Long, sMesonero As String, nPax As Integer)
    dbHandle.Execute "UPDATE CuentasPOS SET Vendedor = " & StringDB(sMesonero) & ", Personas = " & nPax & " WHERE IDCuenta = " & Numero
End Sub

Private Sub LoadInstance(rs As Recordset, Optional pDest As clsCuentasPOS = Nothing)
Dim lDest As clsCuentasPOS

  Set lDest = pDest
  If lDest Is Nothing Then Set lDest = Me
  With lDest
    .IDCuenta = GetNumeroFromVariant(rs.Fields("idCuenta"))
    .Vendedor = rs.Fields("Vendedor")
    .qPersonas = rs.Fields("Personas")
    .mCliente = GetStringFromVariant(rs.Fields("Cliente"))
    .HoraApertura = GetDateFromVariant(rs.Fields("HoraApertura"))
    .HoraUltimaTransaccion = GetDateFromVariant(rs.Fields("HoraUltimaTransaccion"))
    .Estado = GetNumeroFromVariant(rs!Estado)
    
    On Error Resume Next
    .codigoCuenta = GetStringFromVariant(rs.Fields("CodigoCuenta"))
    If Err.Number Then
      Err.Clear
      .codigoCuenta = ""
    End If
    
    On Error Resume Next
    .Ambiente = GetStringFromVariant(rs.Fields("Ambiente"))
    If Err.Number Then
      Err.Clear
      .Ambiente = ""
    End If
    
    On Error Resume Next
    .IDMesa = GetNumeroFromVariant(rs.Fields("idMesa"))
    If Err.Number Then
      Err.Clear
      .IDMesa = 0
    End If

  End With

End Sub

Public Function LoadFromCodigo(istrCodigo As String) As Boolean
Dim isOk As Boolean, rs As Recordset

  isOk = True
  On Error GoTo ErrHandler
  
  Set rs = dbHandle.OpenRecordset("SELECT * FROM CuentasPOS WHERE CodigoCuenta = " & StringDB(istrCodigo), dbOpenForwardOnly)
  If Not rs.EOF Then
    LoadInstance rs, Me
  Else
    isOk = False
  End If

ResumePoint:
  Set rs = Nothing
  LoadFromCodigo = isOk
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsCuentasPOS::LoadFromCodigo"
  Err.Clear
  isOk = False
  Resume ResumePoint

End Function

Public Function Load(Numero As Long) As Boolean
Dim isOk As Boolean, rs As Recordset

  isOk = True
  On Error GoTo ErrHandler
  
  Set rs = dbHandle.OpenRecordset("SELECT * FROM CuentasPOS WHERE IDCuenta = " & Trim(Str(Numero)), dbOpenForwardOnly)
  If Not rs.EOF Then
    LoadInstance rs, Me
  Else
      IDCuenta = Numero
      Vendedor = ""
      qPersonas = 0
      mCliente = ""
      HoraApertura = Now
      HoraUltimaTransaccion = Now
      Estado = 0
      Me.codigoCuenta = ""
      Me.mCliente = ""
      Me.IDMesa = 0
  End If

ResumePoint:
  Set rs = Nothing
  Load = isOk
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsCuentasPOS::Load"
  Err.Clear
  isOk = False
  Resume ResumePoint

End Function

Public Function IndicePrecio(lNumero As Long) As Integer
Dim pAmbiente As clsAmbiente, n As Integer

  If lNumero = 0 Then
    IndicePrecio = nPrecioStandard
    Exit Function
  End If

  Set pAmbiente = New clsAmbiente
  If pAmbiente.LoadByNumero(lNumero) Then
    IndicePrecio = pAmbiente.IndicePrecio
  Else
    IndicePrecio = nPrecioStandard
  End If
  Set pAmbiente = Nothing

End Function

Public Function Porcentaje(lNumero As Long) As Double
Dim pAmbiente As clsAmbiente

    If lNumero = 0 Then
        Porcentaje = 0
        Exit Function
    End If

    If Me.Load(lNumero) Then
      Set pAmbiente = New clsAmbiente
      If pAmbiente.Load(Me.Ambiente) Then
        Porcentaje = pAmbiente.PorcentajeServicio
      ElseIf pAmbiente.LoadByNumero(lNumero) Then
        Porcentaje = pAmbiente.PorcentajeServicio
      Else
        Porcentaje = 0
      End If
      Set pAmbiente = Nothing
    Else
      Porcentaje = 0
    End If

End Function

Public Function MontoConsumo(Optional ByVal lNumero As Long = 0) As Currency
Dim Total As Currency, p As Double, pRenglon As clsRenglonSesion, colDet As Collection

    If lNumero = 0 Then lNumero = Me.Numero
    Total = 0
    p = Porcentaje(lNumero)
    Set colDet = Me.Detalles(lNumero, SesionActiva.SessionID)
    For Each pRenglon In colDet
        Total = Total + pRenglon.PrecioTotal
    Next
    MontoConsumo = Total

End Function

Public Function MontoServicio(Optional ByVal lNumero As Long = 0) As Currency
Dim Total As Currency, p As Double, pRenglon As clsRenglonSesion, colDet As Collection
Dim pAmbiente As clsAmbiente

    If lNumero = 0 Then lNumero = 0
    If GetSetting(AppName, "General", "CobrarServicio", "-1") = "0" Then
      MontoServicio = 0
      Exit Function
    End If

    If lNumero = 0 Then
        MontoServicio = 0
        Exit Function
    End If

    If Not Me.Load(lNumero) Then
      MontoServicio = 0
      Exit Function
    End If

    Set pAmbiente = New clsAmbiente
    If Not pAmbiente.Load(Me.Ambiente) Then
      If Not pAmbiente.LoadByNumero(lNumero) Then
        MontoServicio = 0
        Exit Function
      End If
    End If
    
    If pAmbiente.Codigo = "DELIVERY" Then
      Total = MontoServicioDelivery
      If Total <> 0 Then
        MontoServicio = Total
        Exit Function
      End If
    End If

    Total = 0
    p = pAmbiente.PorcentajeServicio
    Set colDet = Me.Detalles(lNumero, SesionActiva.SessionID)
    For Each pRenglon In colDet
        Total = Total + pRenglon.PrecioTotal * p / 100#
    Next
    
    Set pAmbiente = Nothing
    
    Total = Int((Total + 5) / 10) * 10

    MontoServicio = Total

End Function

Public Function Impuesto(Optional ByVal lNumero As Long = 0) As Currency
Dim Total As Currency, p As Double, pRenglon As clsRenglonSesion, colDet As Collection
    
    If lNumero = 0 Then lNumero = Me.Numero
    Total = 0
    p = Porcentaje(lNumero)
    Set colDet = Me.Detalles(lNumero, SesionActiva.SessionID)
    For Each pRenglon In colDet
        Total = Total + pRenglon.ValorImpuesto
    Next
    Impuesto = Total

End Function

Public Function Imagen(lNumero As Long) As String
Dim pAmbiente As clsAmbiente, sTemp As String, lSubCuenta As Long

  If lNumero = 0 Then
      Imagen = ""
      Exit Function
  End If
  
  If lNumero <= 100000 Then              ' Cuentas Libres
    Imagen = Format(lNumero, "00000")
    Exit Function
  End If

  If lNumero > 10000000 And lNumero <= 100000000 Then          ' Cuentas de Caja
    If Not Me.Load(lNumero) Then
      Imagen = ""
    Else
      Imagen = Me.codigoCuenta
    End If
    Exit Function
  End If

  Set pAmbiente = New clsAmbiente
  If pAmbiente.LoadByNumero(lNumero) Then
    sTemp = pAmbiente.Prefijo & Format(pAmbiente.NumeroCuenta(lNumero), "00000")
    lSubCuenta = pAmbiente.NumeroSubCuenta(lNumero)
    If lSubCuenta Then
      sTemp = sTemp & "/" & Trim(Str(lSubCuenta))
    End If
  Else
    sTemp = "INV:ACCT-ID"
  End If
  Set pAmbiente = Nothing

  Imagen = sTemp

End Function

' Nota, Rev. 4.1.5 (04-10-2002):
' Las funciones de las cuentas, segn el rengo del nmero, sern las siguientes:
'          1 ...     100.000 : Cuentas "libres" (tarjetas de consumo, cuentas no asociadas con ambientes)
'    100.001 ...  10.000.000 : Cuenta de ambiente.
' 10.000.001 ... 100.000.000 : Cuentas "de caja"
'100.000.001 ...             : Sub cuentas de ambiente
'
' El formato de las referencias de cuentas es:
' [<PrefijoAmbiente>]<NumeroCuenta>[/<NumeroSubCuenta>]
' <PrefijoAmbiente> ::= 'A'..'Z' ^ Ambiente(p) ^ p.Prefijo = <PrefijoAmbiente>

Public Function Translate(stCodigo As String) As Long
Dim ch As String, pAmbiente As clsAmbiente, lRetVal As Long

  If Not ValidarReferencia(stCodigo) Then
    Translate = 0
    Exit Function
  End If

  Set pAmbiente = New clsAmbiente
  ch = left(stCodigo, 1)
  If ch >= "A" And ch <= "Z" Then
    pAmbiente.LoadByPrefijo (ch)
    lRetVal = pAmbiente.CalcularNumero(nCuenta, nSubCuenta)
  Else
    If left(stCodigo, 6) = "229999" Or left(stCodigo, 7) = "2209999" Then
      lRetVal = Val(Mid(stCodigo, 9, 4))
    Else
      lRetVal = Val(stCodigo)
    End If
  End If

  Translate = lRetVal
End Function

' Usada desde clsSesionPOS para cargar detalles

Public Function Detalles(lCuenta As Long, lSesion As Long) As Collection
Attribute Detalles.VB_Description = "Devuelve una coleccion de clsRenglonSesion con todos los productos cargados a la cuenta"
Dim retCol As Collection, pRenglonSesion As clsRenglonSesion, rs As Recordset, pItemVenta As clsItemVenta
Dim nIntentos As Integer

    On Error GoTo ErrHandler

    Set rs = dbHandle.OpenRecordset("SELECT * FROM RenglonesCuentaPOS WHERE IDCuenta = " & Trim(Str(lCuenta)), dbOpenForwardOnly)
    
    Set retCol = New Collection
    
    Do While Not rs.EOF
      Set pItemVenta = AlmacenItemsVenta.ItemVenta(rs.Fields("CodigoItem"))
      If Not pItemVenta Is Nothing Then
        Set pRenglonSesion = New clsRenglonSesion
        pRenglonSesion.CodigoItem = rs.Fields("CodigoItem")
        pRenglonSesion.Cantidad = rs.Fields("Cantidad")
        pRenglonSesion.PrecioUnitario = rs.Fields("PrecioUnitario")
        pRenglonSesion.NumeroRenglon = GetNumeroFromVariant(rs.Fields("NumeroRenglon"))
        pRenglonSesion.SesionID = lSesion
        pRenglonSesion.PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItemVenta.TipoImpuesto1)
        pRenglonSesion.TipoImpuesto = pItemVenta.TipoImpuesto1
        pRenglonSesion.Usuario = GetStringFromVariant(rs.Fields("Usuario"))
        retCol.Add pRenglonSesion
      End If
      rs.MoveNext
    Loop

ResumePoint:
    Set pItemVenta = Nothing
    Set rs = Nothing
    Set Detalles = retCol
    Exit Function

ErrHandler:
    If Err.Number = 3189 Then
        nIntentos = nIntentos + 1
        If nIntentos < Q_RETRIES Then
            Sleep CLng(Rnd * 200)   ' Demora de 0 a 200 ms
            Resume
        End If
    End If

    ReportarError False, Err.Number, Err.Description, "CuentasPOS.DetallesCuentaPOS"
    Err.Clear
    Set retCol = Nothing
    Resume ResumePoint

End Function

Public Function ProximaCuentaDelivery() As Long
Dim pAmbiente As clsAmbiente, lNumero As Long, sQuery As String, rs As Recordset

  Set pAmbiente = New clsAmbiente
  
  If pAmbiente.Load("DELIVERY") Then
    sQuery = "SELECT MAX(IdCuenta) AS Ultimo FROM CuentasPOS WHERE IdCuenta BETWEEN " & NumeroDB(pAmbiente.AccountOffset) & " AND " & NumeroDB(pAmbiente.AccountOffset + 9998)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
      lNumero = 0
    Else
      lNumero = GetNumeroFromVariant(rs.Fields("Ultimo"))
    End If
    Set rs = Nothing

    If lNumero = 0 Then
      lNumero = pAmbiente.AccountOffset
    Else
      lNumero = lNumero + 1
    End If
  Else
    lNumero = -1
  End If

  ProximaCuentaDelivery = lNumero

End Function

' Cuentas de Terminal (Cuentas cargadas por las cajas)

Public Function ProximaCuentaTerminal(lngTerminal As Long) As Long
Dim lBase As Long, lTope As Long
Dim sQuery As String, rs As Recordset
Dim lRetVal As Long

  lBase = 10000000 + (lngTerminal * 1000) + 1
  lTope = lBase + 998
  sQuery = "SELECT MAX(idCuenta) AS Ultima FROM CuentasPOS WHERE idCuenta BETWEEN " & NumeroDB(lBase) & " AND " & NumeroDB(lTope)
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If rs.EOF Then
    lRetVal = lBase
  Else
    lRetVal = GetNumeroFromVariant(rs.Fields("Ultima"))
    If lRetVal = 0 Then
      lRetVal = lBase
    Else
      lRetVal = lRetVal + 1
    End If
  End If
  Set rs = Nothing
  
  If lRetVal > lTope Then
    mAdvertencia "ERROR FATAL:" & vbCrLf & "Desbordamiento de almacn de cuentas para el terminal " & lngTerminal
    End
  End If

  ProximaCuentaTerminal = lRetVal

End Function

Public Function nTarjetasTransito() As Long
Dim lBase As Long, lTope As Long
Dim sQuery As String, rs As Recordset
Dim lRetVal As Long

  lBase = 1
  lTope = 100000
  sQuery = "SELECT Count(idCuenta) AS Q FROM CuentasPOS WHERE idCuenta BETWEEN " & NumeroDB(lBase) & " AND " & NumeroDB(lTope)
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If rs.EOF Then
    lRetVal = 0
  Else
    lRetVal = GetNumeroFromVariant(rs.Fields("Q"))
  End If
  Set rs = Nothing

  nTarjetasTransito = lRetVal
End Function

Public Function nCuentasTerminal(lngTerminal As Long) As Integer
Dim lBase As Long, lTope As Long
Dim sQuery As String, rs As Recordset
Dim iRetVal As Integer

  lBase = 10000000 + (lngTerminal * 1000) + 1
  lTope = lBase + 998
  sQuery = "SELECT Count(idCuenta) AS Q FROM CuentasPOS WHERE idCuenta BETWEEN " & NumeroDB(lBase) & " AND " & NumeroDB(lTope)
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If rs.EOF Then
    iRetVal = 0
  Else
    iRetVal = GetNumeroFromVariant(rs.Fields("Q"))
  End If
  Set rs = Nothing

  nCuentasTerminal = iRetVal
End Function

Public Function CuentasTerminal(lngTerminal As Long) As Collection
Dim lBase As Long, lTope As Long
Dim sQuery As String, rs As Recordset
Dim pRetCol As Collection, pCuenta As clsCuentasPOS

  lBase = 10000000 + (lngTerminal * 1000) + 1
  lTope = lBase + 998
  sQuery = "SELECT * FROM CuentasPOS WHERE idCuenta BETWEEN " & NumeroDB(lBase) & " AND " & NumeroDB(lTope) & " ORDER BY HoraUltimaTransaccion;"
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If Not rs.EOF Then
    Set pRetCol = New Collection
    Do While Not rs.EOF
      Set pCuenta = New clsCuentasPOS
      LoadInstance rs, pCuenta
      pRetCol.Add pCuenta
      rs.MoveNext
    Loop
  End If
  Set rs = Nothing
  Set CuentasTerminal = pRetCol
End Function


' Es usada desde el programa de expendio de barra...
' ... y desde otro verguero de sitios
Public Function AddDetalleCuentaPOS(lNumeroCuenta As Long, stCodigoItem As String, dblCantidad As Double, vmPrecioUnitario As Currency, Optional isRestaurante As Boolean = False, Optional ByVal bMerge As Boolean = False, Optional strUsuario As String = "") As Boolean
Dim rs As Recordset, isNew As Boolean, isOk As Boolean
Dim fGetData As frmDatosCuentaPOS, sQuery As String
Dim fGetDelivery As frmGetDatosDelivery
Dim isDelivery As Boolean, pAmbiente As clsAmbiente

    On Error GoTo ErrHandler

    If lNumeroCuenta = 0 Then
      lNumeroCuenta = ProximaCuentaPOS
      Me.IDCuenta = lNumeroCuenta
    End If

    Set rs = dbHandle.OpenRecordset("SELECT IDCuenta FROM CuentasPOS WHERE IdCuenta =" & NumeroDB(lNumeroCuenta), dbOpenForwardOnly)
    isNew = rs.EOF
    Set rs = Nothing

    If isNew Then
        Me.codigoCuenta = Me.Imagen(lNumeroCuenta)
        Me.qPersonas = 1
        isOk = True
        Me.Vendedor = ""
        Me.qPersonas = 0
        If isRestaurante Then
            Set fGetData = New frmDatosCuentaPOS
            Set pAmbiente = New clsAmbiente
            If pAmbiente.LoadByNumero(lNumeroCuenta) Then
              Me.Ambiente = pAmbiente.Codigo
            Else
              Me.Ambiente = ""
            End If
            Set pAmbiente = Nothing
            Me.IDMesa = lNumeroCuenta Mod 100000
            fGetData.lblIDMesa = Me.codigoCuenta
            fGetData.Show vbModal
            If fGetData.Result Then
                Me.Vendedor = fGetData.ucVendedor.Text
                Me.qPersonas = fGetData.numPersonas
            Else
                isOk = False
            End If
            Unload fGetData
            Set fGetData = Nothing
        End If
        
        isDelivery = False
        Me.Ambiente = ""
        Set pAmbiente = New clsAmbiente
        If pAmbiente.LoadByNumero(lNumeroCuenta) Then
            isDelivery = pAmbiente.Codigo = "DELIVERY"
            Me.Ambiente = pAmbiente.Codigo
        End If
        Set pAmbiente = Nothing

        If isDelivery Then
            Set fGetDelivery = frmGetDatosDelivery
            fGetDelivery.Show vbModal
            If fGetDelivery.bResult Then
                isOk = True
                Me.Vendedor = UsuarioActivo.Codigo
                Me.mCliente = fGetDelivery.txTelefono.Text
            Else
                isOk = False
            End If
            Unload fGetDelivery
            Set fGetDelivery = Nothing
        End If

        If Not isOk Then
            AddDetalleCuentaPOS = False
            Exit Function
        End If

        sQuery = "INSERT INTO CuentasPOS (IDCuenta, Vendedor, Personas, Cliente, Ambiente, CodigoCuenta, idMesa) SELECT " & NumeroDB(lNumeroCuenta) & ", " & StringDB(Me.Vendedor) & ", " & NumeroDB(Me.qPersonas) & ", " & StringDB(Me.mCliente) & ", " & StringDB(Me.Ambiente) & ", " & StringDB(Me.codigoCuenta) & ", " & NumeroDB(Me.IDMesa) & ";"
        dbHandle.Execute sQuery, dbFailOnError
    End If
    
    If bMerge Then
      sQuery = "UPDATE RenglonesCuentaPOS SET Cantidad = Cantidad + " & NumeroDB(dblCantidad) & " "
      sQuery = sQuery & "WHERE IDCuenta = " & NumeroDB(lNumeroCuenta) & " "
      sQuery = sQuery & "AND CodigoItem = " & StringDB(stCodigoItem) & " "
      sQuery = sQuery & "AND PrecioUnitario = " & NumeroDB(vmPrecioUnitario) & " "
      sQuery = sQuery & "AND Usuario = " & StringDB(strUsuario)
      dbHandle.Execute sQuery, dbFailOnError
    
      If dbHandle.RecordsAffected < 1 Then
        bMerge = False
      End If
    End If

    If Not bMerge Then
     Set rs = dbHandle.OpenRecordset("SELECT MAX(NumeroRenglon) AS Last FROM RenglonesCuentaPOS WHERE IdCuenta = " & NumeroDB(lNumeroCuenta), dbOpenForwardOnly)
      If rs.EOF Then
        nUltimoRenglon = 1
      Else
        nUltimoRenglon = GetNumeroFromVariant(rs.Fields("Last")) + 1
      End If
      Set rs = Nothing
      sQuery = "INSERT INTO RenglonesCuentaPOS (IdCuenta, CodigoItem, Cantidad, PrecioUnitario, NumeroRenglon, Usuario) "
      sQuery = sQuery & "SELECT " & NumeroDB(lNumeroCuenta) & ", "
      sQuery = sQuery & StringDB(stCodigoItem) & ", "
      sQuery = sQuery & NumeroDB(dblCantidad) & ", "
      sQuery = sQuery & NumeroDB(vmPrecioUnitario) & ", "
      sQuery = sQuery & NumeroDB(nUltimoRenglon) & ", "
      sQuery = sQuery & StringDB(strUsuario)
      dbHandle.Execute sQuery, dbFailOnError
    End If

    sQuery = "DELETE * FROM RenglonesCuentaPOS WHERE IdCuenta = " & NumeroDB(lNumeroCuenta) & " AND Cantidad <= 0"
    dbHandle.Execute sQuery, dbFailOnError

    dbHandle.Execute "UPDATE CuentasPOS SET Estado = 1 WHERE idCuenta = " & NumeroDB(lNumeroCuenta), dbFailOnError
    If dblCantidad < 0 Then
      If Detalles(lNumeroCuenta, 0).Count = 0 Then
        dbHandle.Execute "DELETE FROM CuentasPOS WHERE idCuenta = " & NumeroDB(lNumeroCuenta), dbFailOnError
      End If
    End If
  
    AddDetalleCuentaPOS = True
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsCuentasPOS::AddDetalleCuentaPOS"
    Err.Clear
    AddDetalleCuentaPOS = False

End Function

Public Function EliminarLinea(ilngNumeroCuenta As Long, istrCodigoItem As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "DELETE * FROM RenglonesCuentaPOS WHERE IDCuenta = " & NumeroDB(ilngNumeroCuenta) & " AND CodigoItem = " & StringDB(istrCodigoItem)
    dbHandle.Execute sQuery, dbFailOnError
    If Detalles(ilngNumeroCuenta, 0).Count = 0 Then
        bRetVal = EliminarDetalles(ilngNumeroCuenta)
    End If

ResumePoint:

    EliminarLinea = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "clsCuentasPOS::EliminarLinea"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function EliminarRenglonNumero(ilngNumeroCuenta As Long, ilngRenglon As Long) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "DELETE * FROM RenglonesCuentaPOS WHERE IDCuenta = " & NumeroDB(ilngNumeroCuenta) & " AND NumeroRenglon = " & NumeroDB(ilngRenglon)
    dbHandle.Execute sQuery, dbFailOnError
    If Detalles(ilngNumeroCuenta, 0).Count = 0 Then
        bRetVal = EliminarDetalles(ilngNumeroCuenta)
    End If

ResumePoint:

    EliminarRenglonNumero = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "clsCuentasPOS::EliminarRenglonNumero"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function EliminarDetalles(NumeroCuenta As Long) As Boolean
Dim bRetVal As Boolean

    If NumeroCuenta = 0 Then
        EliminarDetalles = True
        Exit Function
    End If

    bRetVal = True
    dbHandle.Execute "DELETE * FROM CuentasPOS WHERE IDCuenta = " & Trim(Str(NumeroCuenta)), dbFailOnError
    dbHandle.Execute "DELETE * FROM RenglonesCuentaPOS WHERE IDCuenta = " & Trim(Str(NumeroCuenta)), dbFailOnError
    
ResumePoint:
    
    EliminarDetalles = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "CuentasPOS.EliminarDetalles"
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function Eliminar(ilCuenta As Long, isCodigo As String, idCantidad As Double) As Boolean
Dim rs As Recordset, isOk As Boolean, dfCantidad As Double

    isOk = True
    On Error GoTo ErrHandler
    
    Set rs = dbHandle.OpenRecordset("SELECT * FROM RenglonesCuentaPOS WHERE idCuenta = " & ilCuenta & " AND CodigoItem = " & StringDB(isCodigo), dbOpenForwardOnly)
    If rs.EOF Then
        isOk = False
    Else
        dfCantidad = rs.Fields("Cantidad")
    End If
    
    Set rs = Nothing
    
    If isOk Then
        If idCantidad = 0 Then idCantidad = dfCantidad
        
        If dfCantidad < idCantidad Then
            isOk = False
        ElseIf dfCantidad = idCantidad Then
            dbHandle.Execute "DELETE * FROM RenglonesCuentaPOS WHERE idCuenta = " & ilCuenta & " AND CodigoItem = " & StringDB(isCodigo), dbFailOnError
        Else
            dbHandle.Execute "UPDATE RenglonesCuentaPOS SET Cantidad = Cantidad - " & idCantidad & " WHERE idCuenta = " & ilCuenta & " AND CodigoItem = " & StringDB(isCodigo), dbFailOnError
        End If
    End If

ResumePoint:
    
    Eliminar = isOk
    Exit Function

ErrHandler:
    
    ReportarError False, Err.Number, Err.Description, "clsCuentasPOS::Eliminar"
    Set rs = Nothing
    isOk = False
    Resume ResumePoint

End Function

Public Function FormatRenglonCuenta(pRenglon As clsRenglonSesion) As String
Dim stOut As String
    
    stOut = stFullLength(pRenglon.Descripcion, 20) & " "
    stOut = stOut & FormatNumero(pRenglon.Cantidad, Empresa.MascaraCantidades, 7) & " "
    stOut = stOut & FormatNumero(pRenglon.PrecioTotalConIVA, "###,##0.00", 10)
    
    FormatRenglonCuenta = stOut

End Function

Public Sub DisplayToTextBox(lNumeroCuenta As Long, txDest As TextBox)
Dim pRenglon As clsRenglonSesion, stOut As String
Dim MontoVenta As Currency, MontoImpuesto As Currency, MontoServicio As Currency, Total As Currency
Dim colDet As Collection, p As Double, i As Integer

    txDest.Text = ""
    Set colDet = Detalles(lNumeroCuenta, 0)

    p = Porcentaje(lNumeroCuenta)

    If colDet Is Nothing Then Exit Sub
    If colDet.Count = 0 Then
        Set colDet = Nothing
        Exit Sub
    End If

    MontoVenta = Me.MontoConsumo(lNumeroCuenta)
    MontoImpuesto = Me.Impuesto(lNumeroCuenta)
    MontoServicio = Me.MontoServicio(lNumeroCuenta)
    Total = MontoVenta + MontoImpuesto + MontoServicio

    txDest.Text = ""
    
    txDest.SelText = "---------------------------------------" & vbCrLf
    txDest.SelText = "Descripcion              Cant.    Total" & vbCrLf
    txDest.SelText = "---------------------------------------" & vbCrLf
    
    For Each pRenglon In colDet
        stOut = FormatRenglonCuenta(pRenglon)
        txDest.SelText = stOut & vbCrLf
    Next
    
    txDest.SelText = "---------------------------------------" & vbCrLf
    
    txDest.SelText = "               TOTAL         " & FormatNumero(MontoVenta + MontoImpuesto, "###,##0.00", 10) & vbCrLf
    If MontoServicio <> 0 Then
        txDest.SelText = "               Servicio      " & FormatNumero(MontoServicio, "###,##0.00", 10) & vbCrLf
    End If
    If MontoServicio <> 0 Then
        txDest.SelText = "               A pagar       " & FormatNumero(Total, "###,##0.00", 10) & vbCrLf
    End If

    Set colDet = Nothing
    
End Sub

Public Sub DisplayCuenta(lNumeroCuenta As Long, lNumeroSesion As Long)
Dim fView As lfView
    
    Set fView = New lfView
    DisplayToTextBox lNumeroCuenta, fView.Text1
    
    ShowNonModal fView
    Unload fView
    Set fView = Nothing

End Sub

Public Sub ImprimirCuenta(lNumeroCuenta As Long, lNumeroSesion As Long)
Dim sSub As String
Dim lPrinter As CLinePrinter
Dim pItemVenta As clsItemVenta

    Me.IDCuenta = lNumeroCuenta
    
    If pScript Is Nothing Then Exit Sub
  
    On Error GoTo ErrHandler
    Set lPrinter = New CLinePrinter
    Set pItemVenta = New clsItemVenta

    If LoadScriptFile("CuentaPOSImprimir.vbs") Then
      pScript.AddObject "Cuenta", Me
      pScript.AddObject "Producto", pItemVenta
      pScript.AddObject "Impresora", lPrinter
      pScript.AddObject "Empresa", Empresa
      pScript.AddObject "Factoria", New CFactoria
      pScript.Run "ImprimirCuenta"
      pScript.Reset
    End If
    Set pItemVenta = Nothing
    Set lPrinter = Nothing
    
    dbHandle.Execute "UPDATE CuentasPOS SET Estado = 2 WHERE IDCuenta = " & Trim(Str(lNumeroCuenta)), dbFailOnError
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Handler, "clsCuentasPOS::ImprimirCuenta"
    pScript.Reset
    Set lPrinter = Nothing
    Set pItemVenta = Nothing
    Err.Clear
    Exit Sub

End Sub

'AddProducto(stCodigoProducto As String, dblCantidad As Double, vmPrecio As Currency)
Public Function CerrarFactura(NumeroCuenta As Long, vmEfectivo As Currency, vmVisa As Currency, vmMaster As Currency, vmOtrasTTC As Currency, vmTarjetasDebito As Currency, vmCheques As Currency, vmAmex As Currency, vmOtros As Currency, Optional isTracaleable As Boolean = True) As Boolean
Dim pRenglon As clsRenglonSesion
Dim rs As Recordset

    If Not SesionActiva.SetCuenta(NumeroCuenta) Then
        CerrarFactura = False
        Exit Function
    End If

    Set rs = dbHandle.OpenRecordset("SELECT Vendedor, Personas FROM CuentasPOS WHERE IDCuenta = " & NumeroDB(NumeroCuenta), dbOpenForwardOnly)
    If Not rs.EOF Then
        Me.Vendedor = rs!Vendedor
        Me.qPersonas = rs!Personas
    Else
        Me.Vendedor = ""
        Me.qPersonas = 1
    End If

    For Each pRenglon In Me.Detalles(NumeroCuenta, 0)
        SesionActiva.AddProducto pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario
    Next
    
    If Not SesionActiva.CerrarFactura(vmEfectivo, vmVisa, vmMaster, vmOtrasTTC, vmTarjetasDebito, vmCheques) Then
        SesionActiva.Reinit
        CerrarFactura = False
        Exit Function
    End If

    CerrarFactura = True

End Function

Public Function ValidarReferencia(stRefCuenta As String) As Boolean
Dim s As Integer, i As Integer
Dim ch As String, sIdAmbiente As String, sNumCuenta As String, sNumSubcuenta As String
Dim sImagen As String, pAmbiente As clsAmbiente

  s = 0: i = 1
  
  Set pAmbiente = New clsAmbiente
  For i = 1 To Len(stRefCuenta)
    ch = UCase(Mid(stRefCuenta, i, 1))
    Select Case s
    Case 0
      Select Case ch
      Case "A" To "Z"
        If pAmbiente.LoadByPrefijo(ch) Then
          s = 1
          sIdAmbiente = ch
        Else
          s = 7
          Exit For
        End If
      Case "0" To "9"
        sIdAmbiente = ""
        sNumCuenta = ch
        s = 2               ' No se aceptan sub cuentas
      Case Else
        s = 6
        Exit For            ' No es ni una letra ni un numero, ergo es invlida
      End Select

    Case 1
      Select Case ch
      Case "0" To "9"
        sNumCuenta = ch
        s = 3
      Case Else
        s = 6
        Exit For
      End Select
    
    Case 2
      Select Case ch
      Case "0" To "9"
        sNumCuenta = sNumCuenta & ch
      Case Else
        s = 6
        Exit For
      End Select
      
    Case 3
      Select Case ch
      Case "0" To "9"
        sNumCuenta = sNumCuenta & ch
      Case "-", "/"
        s = 4
      Case Else
        s = 6
        Exit For
      End Select

    Case 4
      Select Case ch
      Case "0" To "9"
        sNumSubcuenta = sNumSubcuenta & ch
      Case Else
        s = 6
        Exit For
      End Select
    End Select
  Next

  Select Case s
  Case 1
    mAdvertencia "ERROR: Referencia incompleta"
    ValidarReferencia = False
    Exit Function
  Case 2
    pAmbiente.Prefijo = ""
    If left(sNumCuenta, 6) = "229999" Or left(sNumCuenta, 7) = "2209999" Then
      sNumCuenta = Mid(sNumCuenta, 9, 4)
    End If
    nCuenta = Val(sNumCuenta)
    nSubCuenta = 0
  Case 3
    nCuenta = Val(sNumCuenta)
    nSubCuenta = 0
  Case 4
    nCuenta = Val(sNumCuenta)
    nSubCuenta = Val(sNumSubcuenta)
  Case 6
    mAdvertencia "ERROR: Elemento invlido cerca de la posicin " & i
    ValidarReferencia = False
    Exit Function
  Case 7
    mAdvertencia "Prefijo de ambiente invlido"
    ValidarReferencia = False
    Exit Function
  Case Else
    mAdvertencia "ERROR: Cdigo de estado imprevisto en ValidarReferencia"
    ValidarReferencia = False
    Exit Function
  End Select

  If pAmbiente.Codigo <> "" Then
    If Not pAmbiente.AceptaMesa((nCuenta)) Then
      mAdvertencia "Numero de mesa invlido"
      ValidarReferencia = False
      Exit Function
    End If
  Else
    If nCuenta < 1 Or nCuenta > 100000 Then
      mAdvertencia "Las cuentas libres deben estar entre 1 y 100000"
      ValidarReferencia = False
      Exit Function
    End If
  End If

  sImagen = pAmbiente.Prefijo & Format(nCuenta, "00000")
  If s = 4 Then
    sImagen = sImagen & "/" & Trim(Str(nSubCuenta))
  End If
  Me.Ambiente = pAmbiente.Codigo
  stRefCuenta = sImagen
  ValidarReferencia = True

End Function

Public Sub CreateNew(sCodigoCuenta As String, sCodigoAmbiente As String, sMesonero As String, nqPax As Integer, sCliente As String, Optional ByVal Numero As Long = 0)
Dim pAmbiente As clsAmbiente
Dim rs As Recordset, sQuery As String

  Set pAmbiente = New clsAmbiente
  If Not pAmbiente.Load(sCodigoAmbiente) Then
    Set pAmbiente = Nothing
  End If

  If Numero = 0 Then
    sQuery = "SELECT MAX(idCuenta) AS Ultima FROM CuentasPOS WHERE idCuenta "
    If pAmbiente Is Nothing Then
      sQuery = sQuery & "< 100000;"
    Else
      sQuery = sQuery & "BETWEEN " & NumeroDB(pAmbiente.AccountOffset) & " AND " & NumeroDB(pAmbiente.AccountOffset + 9999) & ";"
    End If
  
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
      Me.IDCuenta = 0
    Else
      Me.IDCuenta = GetNumeroFromVariant(rs.Fields("Ultima"))
    End If
    
    Set rs = Nothing
    If Me.IDCuenta = 0 Then
      Me.IDCuenta = pAmbiente.AccountOffset
    Else
      Me.IDCuenta = Me.IDCuenta + 1
    End If
  Else
    Me.IDCuenta = Numero
  End If
  
  sQuery = "INSERT INTO CuentasPOS (idCuenta, Vendedor, Personas, Cliente, CodigoCuenta, Ambiente, idMesa) SELECT "
  sQuery = sQuery & NumeroDB(Me.IDCuenta) & ", "
  sQuery = sQuery & StringDB(sMesonero) & ", "
  sQuery = sQuery & NumeroDB(nqPax) & ", "
  sQuery = sQuery & StringDB(sCliente) & ", "
  sQuery = sQuery & StringDB(sCodigoCuenta) & ", "
  sQuery = sQuery & StringDB(sCodigoAmbiente) & ", "
  sQuery = sQuery & NumeroDB(IDCuenta Mod 100000)

  Vendedor = sMesonero
  codigoCuenta = sCodigoCuenta
  qPersonas = nqPax
  Me.Ambiente = sCodigoAmbiente

  dbHandle.Execute sQuery, dbFailOnError

End Sub

Public Sub Transferir(ilngCuentaOrigen As Long, ilngCuentaDestino As Long, Optional isRestaurante As Boolean = False)
Dim pCol As Collection, pCuentaDest As clsCuentasPOS
Dim pRenglon As clsRenglonSesion

  If ilngCuentaOrigen = ilngCuentaDestino Then Exit Sub
  Set pCol = Me.Detalles(ilngCuentaOrigen, 0)
  Set pCuentaDest = New clsCuentasPOS
  For Each pRenglon In pCol
    With pRenglon
    pCuentaDest.AddDetalleCuentaPOS ilngCuentaDestino, .CodigoItem, .Cantidad, .PrecioUnitario, isRestaurante
    End With
  Next
  Set pCuentaDest = Nothing
  Me.EliminarDetalles ilngCuentaOrigen

End Sub

Public Function GetRenglonNumero(lngNumeroCuenta As Long, lngNumeroRenglon As Long) As clsRenglonSesion
Dim rs As Recordset, sQuery As String, pRenglon As clsRenglonSesion

  sQuery = "SELECT * FROM RenglonesCuentaPOS WHERE IDCuenta = " & NumeroDB(lngNumeroCuenta) & " AND NumeroRenglon = " & NumeroDB(lngNumeroRenglon)
  Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
  If Not rs.EOF Then
    Set pRenglon = New clsRenglonSesion
    With pRenglon
    .Cantidad = GetNumeroFromVariant(rs.Fields("Cantidad"))
    .PrecioUnitario = GetNumeroFromVariant(rs.Fields("PrecioUnitario"))
    .PrecioLista = .PrecioUnitario
    .CodigoItem = GetStringFromVariant(rs.Fields("CodigoItem"))
    .NumeroRenglon = GetNumeroFromVariant(rs.Fields("NumeroRenglon"))
    End With
  End If
  Set rs = Nothing
  
  Set GetRenglonNumero = pRenglon
End Function
