VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCuenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Codigo As String

'local variable(s) to hold property value(s)
Public Titulo As String 'local copy
Public Saldo As Double 'local copy
Public Status As Byte 'local copy
Public lado As Byte 'local copy

Public Property Get NombreTabla() As String
  NombreTabla = "Cuentas"
End Property

Public Property Get TipoEntidad() As String
  TipoEntidad = "CTA"
End Property

Public Property Get Nombre() As String
  Nombre = Titulo
End Property

Public Function Factor() As Integer

    Factor = IIf(lado, -1, 1)

End Function

Public Function ValidarCodigo(stiCodigo As String) As Boolean
    
    ValidarCodigo = AlmacenCuentas.ValidarCuenta(stiCodigo)

End Function

Public Function Load(ByVal Codigo As String) As Boolean
Dim RetVal As Boolean
    Me.Codigo = Codigo
    RetVal = AlmacenCuentas.LoadCuenta(Codigo, Me)
    Load = RetVal
End Function

Public Function Eliminar()
    If Abs(Me.Saldo) > 0.01 Then
        mAdvertencia "La cuenta tiene un saldo... No se puede eliminar"
        Eliminar = False
        Exit Function
    End If
    
    If (Me.Status = 1 And AlmacenCuentas.TieneSubordinadas(Me)) Or _
        (Me.Status = 2 And AlmacenDetalles.TieneDetalles(Me)) Then
        mAdvertencia "Imposible eliminar la cuenta... Tiene elementos subordinados"
        Eliminar = False
        Exit Function
    End If
    
    Eliminar = AlmacenCuentas.Eliminar(Me)

End Function

Public Function CreateNew(stiCodigo As String, stiTitulo As String) As Boolean
Dim lCuenta As clsCuenta, _
    stCodigoSubordinante As String, _
    ok2Create As Boolean, _
    lPrefijo As clsPrefijo

    stCodigoSubordinante = mCodigos.CodigoSubordinante(stiCodigo)
    
    On Error GoTo PrefixErr
    Set lPrefijo = AlmacenPrefijos.Item(Left(stiCodigo, 1))
    If (lPrefijo Is Nothing) Then
        mAdvertencia "Prefijo '" & Left(stiCodigo, 1) & "' no definido"
        ok2Create = False
    ElseIf (stCodigoSubordinante = "") Then
        ok2Create = True
        ' Creacin de nuevo Grupo/Prefijo
    Else
        Set lCuenta = New clsCuenta
        If Not lCuenta.Load(stCodigoSubordinante) Then
            ok2Create = False
            mAdvertencia "La cuenta no tiene subordinante"
        Else
            ok2Create = (lCuenta.Status <> 2)
            If (lCuenta.Status = 0) Then    ' Si la cuenta no tena una funcin asignada
                lCuenta.SetStatus 1         ' definirla como cuenta de control
            End If
            If Not ok2Create Then mAdvertencia "Cuenta subordinada a cuenta de detalle"
        End If
        Set lCuenta = Nothing
    End If
    
    If Not ok2Create Then
        CreateNew = False
        Exit Function
    End If
    
    Codigo = stiCodigo
    Titulo = stiTitulo
    Saldo = 0#
    Status = 0
    If (Codigo = Empresa.CuentaGanPer) Then Status = 2
    lado = lPrefijo.lado
    AlmacenCuentas.Add Me
    CreateNew = True
    Set lPrefijo = Nothing
    Exit Function
PrefixErr:
    If Err.Number = 5 Then
        Set lPrefijo = Nothing
        Resume Next
    End If
    On Error GoTo 0
    Resume
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenCuentas.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenCuentas.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim RetVal As Boolean
    RetVal = AlmacenCuentas.LoadCuenta(Me.Codigo, Me)
    Refresh = RetVal
End Function

Public Function SaldoPeriodo(ByVal Anho As Integer, ByVal periodo As Byte) As Double
Dim cSaldo As clsSaldoCuentaPeriodo
Dim bResult As Boolean
Dim dRetVal As Double

    Set cSaldo = New clsSaldoCuentaPeriodo
    bResult = cSaldo.Load(Me.Codigo, Anho, periodo)
    dRetVal = cSaldo.SaldoFinal
    Set cSaldo = Nothing
    SaldoPeriodo = dRetVal
End Function

Public Function SaldoInicialPeriodo(ByVal Anho As Integer, ByVal periodo As Integer) As Double
Dim cSaldo As clsSaldoCuentaPeriodo
Dim bResult As Boolean
Dim dRetVal As Double

    Set cSaldo = New clsSaldoCuentaPeriodo
    bResult = cSaldo.Load(Me.Codigo, Anho, periodo)
    dRetVal = cSaldo.SaldoInicial
    Set cSaldo = Nothing
    SaldoInicialPeriodo = dRetVal
End Function

Public Sub RegistrarVariacion(ByVal Variacion As Double, ByVal periodo As Long, Reverse As Boolean, Cierre As Boolean)
Dim linstCuenta As clsCuenta, _
    stSubordinante As String, _
    isResultado As Boolean

    isResultado = (Me.Funcion = 4) Or (Me.Funcion = 5)

    stSubordinante = CodigoSubordinante(Me.Codigo)
    If stSubordinante <> "" Then
        Set linstCuenta = New clsCuenta
        If linstCuenta.Load(stSubordinante) Then
            linstCuenta.RegistrarVariacion Variacion, periodo, Reverse, Cierre
        Else
            Err.Raise 1002, "Cuenta.RegistrarVariacionSaldo", "SUBORDINANTE NO REGISTRADA"
        End If
        Set linstCuenta = Nothing
    End If
    
    AlmacenSaldos.RegistrarVariacion Me.Codigo, periodo, Variacion, Reverse, Cierre
    
    If Not (isResultado And Empresa.isBeforeCierre(periodo)) Then ' En otro caso, no se altera el saldo
        AlmacenCuentas.RegistrarVariacion Me, Variacion
    End If

End Sub

Public Function SetStatus(newStatus As Integer) As Boolean
    If newStatus = Me.Status Then
        SetStatus = True
    Else
        SetStatus = AlmacenCuentas.SetStatus(Me, newStatus)
        Me.Status = newStatus
    End If
End Function

Public Function CambiarTitulo(istTitulo As String) As Boolean
    If istTitulo = Me.Titulo Then
        CambiarTitulo = True
        Exit Function
    End If
    
    CambiarTitulo = AlmacenCuentas.CambiarTitulo(Me, istTitulo)
    Me.Titulo = istTitulo
End Function

Public Function Nivel() As Integer
    Nivel = mCodigos.NivelCuenta(Me.Codigo)
End Function

Public Function Funcion() As Integer
Dim p As String, Prefijo As clsPrefijo, Result As Integer
    p = Left(Me.Codigo, 1)
    Set Prefijo = AlmacenPrefijos.Item(p)
    If (Prefijo Is Nothing) Then
        Funcion = -1
        Exit Function
    End If
    Result = Prefijo.Funcion
    Set Prefijo = Nothing
    Funcion = Result
End Function

Public Sub Show()
Dim f As FIECuentas

    If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_CUENTAS) Then Exit Sub
    
    Set f = New FIECuentas
    f.SetCodigo Me.Codigo
    On Error GoTo SkipAll
    f.Show
    f.SetContexto 1
    
    While f.Visible: DoEvents: Wend

ResumePoint:

    Unload f
    Set f = Nothing

    Exit Sub

SkipAll:

    Resume ResumePoint
End Sub

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub

