VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCotizacionesLista"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Iterador Detalles:
Private indicePedidoDetalles As Long, indiceDetalle As Long, colDetalles As Collection
' IteradorPedidos
Private indicePedido As Long
Public colPedidos As Collection

Public isDescuentoConsistente As Boolean
Public isVendedorConsistente As Boolean

Public Function RenglonesPedidoCodigo(istrCodigoItem As String, ByVal idblPrecioEfectivo As Currency) As Collection
Dim rs As Recordset, strListaPedidos As String
Dim pCotizacion As clsCotizacion
Dim pColeccion As Collection
Dim pDetalle As clsDetalleCotizacion

    strListaPedidos = ""
    For Each pCotizacion In Me.colPedidos
        If strListaPedidos <> "" Then strListaPedidos = strListaPedidos & ", "
        strListaPedidos = strListaPedidos & pCotizacion.Numero
    Next

    Set pColeccion = New Collection

    Set rs = dbHandle.Execute("SELECT * FROM CotizacionesDetalles WHERE codigoItem = " & StringDB(istrCodigoItem) & " AND Cantidad > CantidadFacturada AND NumeroDocumento in (" & strListaPedidos & ") ORDER BY ABS(" & NumeroDB(idblPrecioEfectivo) & "- PrecioEfectivo/Cantidad), NumeroDocumento, Renglon")
    Do While Not rs.EOF

        Set pDetalle = New clsDetalleCotizacion
        pDetalle.LoadInstance rs
        pColeccion.Add pDetalle
        
        rs.MoveNext

    Loop
    Set rs = Nothing

    Set RenglonesPedidoCodigo = pColeccion

End Function

Public Function AddPedido(ByVal ilngNumero As Long) As clsCotizacion
Dim pCotizacion As clsCotizacion

    Set pCotizacion = New clsCotizacion
    If Not pCotizacion.Load(ilngNumero) Then
    
        Err.Raise 40001, "clsListaCotizaciones::AddPedido", "Cotizacion " & ilngNumero & " no localizada."
        AddPedido = False
        Exit Function

    End If
    
    If colPedidos.Count > 0 Then
        If pCotizacion.Descuento1 <> colPedidos.Item(colPedidos.Count).Descuento1 Or pCotizacion.Descuento2 <> colPedidos.Item(colPedidos.Count).Descuento2 Then
            isDescuentoConsistente = False
        End If
        
        If pCotizacion.CodigoVendedor <> colPedidos.Item(colPedidos.Count).CodigoVendedor Then
            isVendedorConsistente = False
        End If
    End If

    colPedidos.Add pCotizacion

    Set pCotizacion = Nothing
    
    Set AddPedido = pCotizacion

End Function

Public Sub RemovePedido(ByVal ilngNumeroPedido)
Dim i As Integer

    For i = 0 To colPedidos.Count - 1
    
        If colPedidos.Item(i).Numero = ilngNumeroPedido Then
        
            colPedidos.Remove i
            Exit Sub

        End If

    Next
    
    Err.Raise 40002, "clsCotizacionesLista::RemovePedido", "Pedido " & ilngNumeroPedido & " no est en la lista"

End Sub

Public Function GetPedido(ByVal ilngNumero As Long) As clsCotizacion
Dim i As Integer

    For i = 0 To colPedidos.Count - 1
    
        If colPedidos(i).Numero = ilngNumero Then
        
            Set GetPedido = colPedidos.Item(i)
            Exit Function

        End If

    Next

    Set GetPedido = Nothing

End Function

Public Sub ClearList()

    Do While colPedidos.Count > 0
    
        colPedidos.Remove 1

    Loop

    isVendedorConsistente = True
    isDescuentoConsistente = True

End Sub

' Iterador Detalles:

Public Function CurrentDetalle() As clsDetalleCotizacion

    If indicePedidoDetalles > colPedidos.Count Then
    
        Set CurrentDetalle = Nothing
        Exit Function

    End If

    Set CurrentDetalle = colDetalles.Item(indiceDetalle)

End Function

Public Function NextDetalle() As clsDetalleCotizacion

    indiceDetalle = indiceDetalle + 1
    
    Do While indiceDetalle > colDetalles.Count

        indicePedidoDetalles = indicePedidoDetalles + 1
        If indicePedidoDetalles > colPedidos.Count Then
        
            Set NextDetalle = Nothing
            Exit Function

        End If
        
        Set colDetalles = colPedidos.Item(indicePedidoDetalles).Detalles
        indiceDetalle = 1

    Loop

    Set NextDetalle = colDetalles.Item(indiceDetalle)

End Function

Public Function FirstDetalle() As clsDetalleCotizacion
Dim pCotizacion As clsCotizacion

    If colPedidos.Count = 0 Then
    
        Set FirstDetalle = Nothing
        Exit Function

    End If

    indicePedidoDetalles = 1
    
    Set pCotizacion = colPedidos.Item(1)
    
    Set colDetalles = pCotizacion.Detalles
    indiceDetalle = 1

    Set FirstDetalle = CurrentDetalle

End Function

' Iterador Pedidos
'
'Public Function GetPedido() As clsCotizacion
'
'End Function
'
'Public Function FirstPedido() As clsCotizacion
'
'    indicePedido = 0
'    If indicePedido >= colPedidos.Count Then
'
'
'End Function

Private Sub Class_Initialize()

    indicePedido = 0
    indicePedidoDetalles = 0
    indiceDetalle = 0
    isVendedorConsistente = True
    isDescuentoConsistente = True
    Set colPedidos = New Collection

End Sub

Private Sub Class_Terminate()

    Set colDetalles = Nothing
    Set colPedidos = Nothing

End Sub

