VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCotizacion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

    Public Numero As Long               ' Numero del documento
    Public FechaRegistro As Date        ' Fecha de registro de la factura
    Public FechaTransaccion As Date     ' Fecha de la transaccin
    Public Operador As String           ' Codigo del operador que cre la factura
    Public CodigoCliente As String      ' Cdigo del cliente
    Public NombreCliente As String      ' Nombre del cliente
    Public CodigoVendedor As String     ' Cdigo del Vendedor
    Public PrecioLista As Currency      ' Valor de la factura a precio de Lista
    Public PrecioVenta As Currency      ' Valor de la factura a precio de venta
    Public PrecioEfectivo As Currency   ' Precio EFECTIVO de venta.
    Public Impuesto1 As Currency        ' Impuesto retenido 1 (IVA)
    Public Impuesto2 As Currency        ' Impuesto retenido 2 (??)
    Public IndiceReferencia As Integer  ' Indice (selector) del precio de referencia
    Public IndiceVenta As Integer       ' Selector del precio de venta
    Public Descuento1 As Double         ' Porcentaje del primer descuento global
    Public Descuento2 As Double         ' Porcentaje del segundo descuento global
    Public Condicion As String          ' Cdigo de la condicion de venta
    Public Notas As String
    Public Estado As Integer            ' 0: Presentada; 1: Aprobada (pedido); 2: En Proceso; 3: Satisfecha; 4: Anulada; 5: Vencida

Private inProcess As Boolean
Private NextDetalle As Integer

Public pEvaluadorVariable As CExpEvalDocVenta
Public Saldo As Currency

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public TipoEntidad As String                ' Idntificacin para ISDOC

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Property Get DireccionEntrega() As String
  DireccionEntrega = ""
End Property

Public Function Descripcion() As String
    
    Descripcion = NombreCliente

End Function

Public Sub LoadInstance(rsHandle As Recordset, Optional pInstance As clsCotizacion = Nothing)
    
    If pInstance Is Nothing Then Set pInstance = Me
    
    With rsHandle
    pInstance.Numero = .Fields("Numero")
    pInstance.FechaRegistro = .Fields("FechaRegistro")
    pInstance.FechaTransaccion = .Fields("FechaTransaccion")
    pInstance.Operador = .Fields("Operador")
    pInstance.CodigoCliente = .Fields("CodigoCliente")
    pInstance.NombreCliente = .Fields("NombreCliente")
    pInstance.CodigoVendedor = .Fields("CodigoVendedor")
    pInstance.PrecioLista = .Fields("PrecioLista")
    pInstance.PrecioVenta = .Fields("PrecioVenta")
    pInstance.PrecioEfectivo = .Fields("PrecioEfectivo")
    pInstance.Impuesto1 = .Fields("Impuesto1")
    pInstance.Impuesto2 = .Fields("Impuesto2")
    pInstance.IndiceReferencia = .Fields("IndiceReferencia")
    pInstance.IndiceVenta = .Fields("IndiceVenta")
    pInstance.Descuento1 = .Fields("Descuento1")
    pInstance.Descuento2 = .Fields("Descuento2")
'    pInstance.Costo = .Fields("Costo")
    pInstance.Notas = .Fields("Notas")
    pInstance.Estado = .Fields("Estado")
    pInstance.Condicion = .Fields("Condicion")
    pInstance.Saldo = 0
    End With

End Sub

Public Function Load(Numero As Long) As Boolean
Dim rs As Recordset, isOk As Boolean

    On Error GoTo ErrHandler

    Set rs = dbHandle.Execute("SELECT * FROM Cotizaciones WHERE Numero = " & NumeroDB(Numero))
    If Not rs.EOF Then
        LoadInstance rs
        isOk = True
    Else
        isOk = False
    End If

ResumePoint:
    Set rs = Nothing
    Load = isOk

    Exit Function

ErrHandler:
    isOk = False
    Resume ResumePoint

End Function

Public Property Get Correlativo() As Long

    Correlativo = Me.Numero

End Property

Public Function Referencia() As String
    
    Referencia = TipoEntidad & "-" & Format(Numero, "000000")

End Function

Public Function Concepto() As String
Dim stRetVal As String

    Concepto = "COTIZACION " & Me.Numero

End Function

Public Function NombreArchivoFormato() As String
    
    NombreArchivoFormato = DeterminarFormato("FormatoCotizacion", "FormatosCotizacion", BuildDataPath("FormatoCotizacion.txt", AppName), Me)

End Function

Public Function Detalles() As Collection
Dim colRetVal As Collection, pDetalle As clsDetalleCotizacion

    Set pDetalle = New clsDetalleCotizacion
    Set colRetVal = pDetalle.RenglonesCotizacion(Me.Numero)
    Set pDetalle = Nothing
    
    Set Detalles = colRetVal

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evCotizacion.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean

    EvalVar = Me.pEvaluadorVariable.EvalVar(sVarId, vRetBuffer, sRetString, Me)

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

' LoadByRef recibe una "referencia" completa a un documento ISDOC,
' y carga los datos correspondientes en <Me>
' Devuelve True si existe una factura con la referencia recibida
Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lngNumDoc As Long, i As Integer

    lngNumDoc = Val(right(sRef, Len(sRef) - 4))
    
    LoadByReferenciaISDOC = Load(lngNumDoc)

End Function

' Show (ISDOC) causa que el documento se presente en una forma de
' consulta...
Public Sub Show()
Dim frmView As frmViewCotizacion

    Set frmView = New frmViewCotizacion
    frmView.SetCotizacion Me.Numero
    ShowNonModal frmView
    Unload frmView
    Set frmView = Nothing

End Sub

' Se presenta y/o imprime el documento
Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub
' **************************************************************
' ************ END ISDOC
' **************************************************************


' ******* Documento Venta *******

Public Property Get ImagenEstado() As String
    
    Select Case Me.Estado
    Case 0
        ImagenEstado = "INICIAL"
    Case 1
        ImagenEstado = "APROBADA"
    Case 2
        ImagenEstado = "EN PROCESO"
    Case 3
        ImagenEstado = "SATISFECHA"
    Case 4
        ImagenEstado = "ANULADA"
    Case 5
        ImagenEstado = "VENCIDA"
    End Select

End Property



Public Property Get Modificable() As Boolean

    Modificable = (Me.Estado < 2)

End Property

' ******* Funciones de proceso *******

Public Sub StartProcess()

    NextDetalle = 1
    inProcess = True
    StartTransaction

End Sub

Public Function NumeroProximaCotizacion() As Long
Dim lLastNumero As Long, rs As Recordset

    Set rs = dbHandle.Execute("SELECT MAX(Numero) as UltimoNumero FROM Cotizaciones")
    If rs.EOF Then
        lLastNumero = 0
    Else
        lLastNumero = GetNumeroFromVariant(rs.Fields("UltimoNumero"))
    End If
    
    NumeroProximaCotizacion = lLastNumero + 1

End Function

Public Sub UpdateCotizacion(pCotizacion As clsCotizacion, isNew As Boolean)
Dim sQuery As String

    If Not inProcess Then
        Err.Raise 1, "clsCotizacion::UpdateCotizacion", "Llamada a Update sin StartProcess"
    End If

    With pCotizacion
    If isNew Then
        If .Numero = 0 Then
            .Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
        Else
          Contadores.RegistrarEmisionDocumento Me.TipoEntidad, Me.Numero
        End If

        sQuery = "INSERT INTO cotizaciones (Numero, FechaRegistro, FechaTransaccion, Operador, CodigoCliente, NombreCliente, CodigoVendedor, PrecioLista, PrecioVenta, PrecioEfectivo, Impuesto1, IndiceReferencia, IndiceVenta, Descuento1, Descuento2, Condicion, Notas, Estado) VALUES ("
        sQuery = sQuery & NumeroDB(.Numero) & ", "
        sQuery = sQuery & FechaDB(.FechaRegistro) & ", "
        sQuery = sQuery & FechaDB(.FechaTransaccion) & ", "
        sQuery = sQuery & StringDB(.Operador) & ", "
        sQuery = sQuery & StringDB(.CodigoCliente) & ", "
        sQuery = sQuery & StringDB(.NombreCliente) & ", "
        sQuery = sQuery & StringDB(.CodigoVendedor) & ", "
        sQuery = sQuery & NumeroDB(.PrecioLista) & ", "
        sQuery = sQuery & NumeroDB(.PrecioVenta) & ", "
        sQuery = sQuery & NumeroDB(.PrecioEfectivo) & ", "
        sQuery = sQuery & NumeroDB(.Impuesto1) & ", "
        sQuery = sQuery & NumeroDB(.IndiceReferencia) & ", "
        sQuery = sQuery & NumeroDB(.IndiceVenta) & ", "
        sQuery = sQuery & NumeroDB(.Descuento1) & ", "
        sQuery = sQuery & NumeroDB(.Descuento2) & ", "
        sQuery = sQuery & StringDB(.Condicion) & ", "
        sQuery = sQuery & StringDB(.Notas) & ", "
        sQuery = sQuery & NumeroDB(.Estado) & ")"
    Else
        isNew = False
        sQuery = "UPDATE Cotizaciones SET "
        sQuery = sQuery & "FechaRegistro = " & FechaDB(.FechaRegistro) & ", "
        sQuery = sQuery & "FechaTransaccion = " & FechaDB(.FechaTransaccion) & ", "
        sQuery = sQuery & "Operador = " & StringDB(.Operador) & ", "
        sQuery = sQuery & "CodigoCliente = " & StringDB(.CodigoCliente) & ", "
        sQuery = sQuery & "NombreCliente = " & StringDB(.NombreCliente) & ", "
        sQuery = sQuery & "CodigoVendedor = " & StringDB(.CodigoVendedor) & ", "
        sQuery = sQuery & "PrecioLista = " & NumeroDB(.PrecioLista) & ", "
        sQuery = sQuery & "PrecioVenta = " & NumeroDB(.PrecioVenta) & ", "
        sQuery = sQuery & "PrecioEfectivo = " & NumeroDB(.PrecioEfectivo) & ", "
        sQuery = sQuery & "Impuesto1 = " & NumeroDB(.Impuesto1) & ", "
        sQuery = sQuery & "IndiceReferencia = " & NumeroDB(.IndiceReferencia) & ", "
        sQuery = sQuery & "IndiceVenta = " & NumeroDB(.IndiceVenta) & ", "
        sQuery = sQuery & "Descuento1 = " & NumeroDB(.Descuento1) & ", "
        sQuery = sQuery & "Descuento2 = " & NumeroDB(.Descuento2) & ", "
        sQuery = sQuery & "Condicion = " & StringDB(.Condicion) & ", "
        sQuery = sQuery & "Notas = " & StringDB(.Notas) & " "
        sQuery = sQuery & "WHERE Numero = " & NumeroDB(.Numero)
    
    End If
    End With
    dbHandle.Execute sQuery

    If Not isNew Then dbHandle.Execute "DELETE FROM CotizacionesDetalles WHERE NumeroDocumento = " & NumeroDB(pCotizacion.Numero)

End Sub

Public Sub AddDetalle(pCotizacion As clsCotizacion, istrCodigo As String, istrDescripcion As String, istrUnidad As String, idblCantidad As Double, ivmPrecioLista As Currency, ivmPrecioUnitario As Currency)
Dim sQuery As String, isNew As Boolean, vmPrecioEfectivo As Currency
Dim pItemVenta As clsItemVenta, dblFactorEmpaque As Double

    If Not inProcess Then
        Err.Raise 1, "clsCotizacion::AddDetalle", "Llamada a AddDetalle sin StartProcess"
    End If

    Set pItemVenta = New clsItemVenta
    If istrCodigo = "" Then
        dblFactorEmpaque = 0
    Else
        If Not pItemVenta.Load(istrCodigo) Then
            dblFactorEmpaque = 1
        Else
            dblFactorEmpaque = pItemVenta.FactorPresentacion(istrUnidad)
        End If
    End If

    sQuery = "INSERT INTO cotizacionesDetalles (NumeroDocumento, Renglon, CodigoItem, Descripcion, Presentacion, FactorEmpaque, Cantidad, PrecioLista, PrecioVenta, PrecioEfectivo, Impuesto1, Impuesto2) VALUES ("
    sQuery = sQuery & NumeroDB(pCotizacion.Numero) & ", "
    sQuery = sQuery & NumeroDB(NextDetalle) & ", "
    sQuery = sQuery & StringDB(istrCodigo) & ", "
    sQuery = sQuery & StringDB(istrDescripcion) & ", "
    If istrCodigo <> "" Then
        sQuery = sQuery & StringDB(istrUnidad) & ", "
        sQuery = sQuery & NumeroDB(dblFactorEmpaque) & ", "
        sQuery = sQuery & NumeroDB(idblCantidad) & ", "
        sQuery = sQuery & NumeroDB(ivmPrecioLista) & ", "
        sQuery = sQuery & NumeroDB(ivmPrecioUnitario) & ", "
        vmPrecioEfectivo = ivmPrecioUnitario * idblCantidad * (1# - ValorDescuentosSucesivos(pCotizacion.Descuento1, pCotizacion.Descuento2) / 100#)
        sQuery = sQuery & NumeroDB(vmPrecioEfectivo) & ", "
        sQuery = sQuery & NumeroDB(vmPrecioEfectivo * pItemVenta.PorcentajeImpuesto(1) / 100#) & ", "
        sQuery = sQuery & "0.0)"
    Else
        sQuery = sQuery & "'', 0, 0, 0, 0, 0, 0, 0)"
    End If

    dbHandle.Execute sQuery
    
    NextDetalle = NextDetalle + 1

    Set pItemVenta = Nothing

End Sub

Public Sub EndProcess()

    CommitTransaction
    inProcess = False
    SubmitDoc Me
  
End Sub

Public Sub AbortProcess()

    If Not inProcess Then Exit Sub
    inProcess = False
    AbortTransaction

End Sub

' ******* Utilidades varias *******

Public Function CotizacionesDeCliente(istrCodigoCliente As String, nStatus As Integer) As Collection
Dim retCol As Collection, lpCot As clsCotizacion
Dim rs As Recordset

  Set retCol = New Collection
  Set rs = dbHandle.Execute("SELECT * FROM Cotizaciones WHERE CodigoCliente = " & StringDB(istrCodigoCliente) & " AND Estado < " & NumeroDB(nStatus) & " ORDER BY Numero")
  Do While Not rs.EOF
    Set lpCot = New clsCotizacion
    LoadInstance rs, lpCot
    retCol.Add lpCot
    rs.MoveNext
  Loop
  Set rs = Nothing
  Set CotizacionesDeCliente = retCol
End Function

Public Function CotizacionesPendientesCliente(istrCodigoCliente As String) As Collection
  Set CotizacionesPendientesCliente = CotizacionesDeCliente(istrCodigoCliente, 3)
End Function

Public Function CotizacionesCliente(istrCodigoCliente As String) As Collection
  Set CotizacionesCliente = CotizacionesDeCliente(istrCodigoCliente, 4)
End Function

Public Sub SetEstado(inEstado As Integer)
  Me.Estado = inEstado
  dbHandle.Execute "UPDATE Cotizaciones SET Estado = " & NumeroDB(Me.Estado) & " WHERE Numero = " & Me.Numero
End Sub

Public Sub ActualizarNotas(istrNewNotes As String)
  Me.Notas = istrNewNotes
  dbHandle.Execute "UPDATE Cotizaciones SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & Me.Numero
End Sub

Public Sub ActualizarStatus()
Dim rs As Recordset, nEstado As Integer
  Set rs = dbHandle.Execute("SELECT Count(NumeroDocumento) AS Q FROM CotizacionesDetalles WHERE NumeroDocumento = " & NumeroDB(Me.Numero) & " AND Cantidad > CantidadFacturada")
  If rs.EOF Then
    nEstado = 3
  Else
    If GetNumeroFromVariant(rs.Fields("Q")) = 0 Then
      nEstado = 3
    End If
  End If
  Set rs = Nothing
  
  If nEstado <> 3 Then
    Set rs = dbHandle.Execute("SELECT Count(NumeroDocumento) AS Q FROM CotizacionesDetalles WHERE NumeroDocumento = " & NumeroDB(Me.Numero) & " AND CantidadFacturada <> 0")
    ' Algun renglon tiene una unidad facturada
    If rs.EOF Then
      nEstado = 1
    Else
      If GetNumeroFromVariant(rs.Fields("Q")) = 0 Then
        nEstado = 1
      Else
        nEstado = 2
      End If
    End If
  End If
  Set rs = Nothing
  
  SetEstado nEstado
End Sub

' ******* Clase *******

Private Sub Class_Initialize()
  inProcess = False
  TipoEntidad = "COT"
  Set pEvaluadorVariable = New CExpEvalDocVenta
End Sub

Private Sub Class_Terminate()
  Set pEvaluadorVariable = Nothing
End Sub

