VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsComprobanteAlmacen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' clsClassGenerator V1.0
Public Numero As Long
Public Almacen As String
Public Operador As String
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public TipoEntidadOrigen As String
Public NumeroDocumentoOrigen As Long
Public OrdenDespacho As Long
Public Descripcion As String

Public NumeroRenglon As Integer

Private inProcess As Boolean, NextDetalle As Integer
Private colItems As Collection

Public Function Load(lngNumero As Long) As Boolean
Dim rsHandle As Recordset, bRetVal As Boolean

    On Error GoTo ErrHandler
    Set rsHandle = dbHandle.Execute("SELECT * FROM ComprobantesAlmacen WHERE Numero =" & Str(lngNumero))
    If rsHandle.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        With Me
        .Numero = GetNumeroFromVariant(rsHandle.Fields("Numero"))
        .Almacen = GetStringFromVariant(rsHandle.Fields("Almacen"))
        .Operador = GetStringFromVariant(rsHandle.Fields("Operador"))
        .FechaRegistro = GetDateFromVariant(rsHandle.Fields("FechaRegistro"))
        .FechaTransaccion = GetDateFromVariant(rsHandle.Fields("FechaTransaccion"))
        .TipoEntidadOrigen = rsHandle.Fields("TipoEntidadOrigen")
        .NumeroDocumentoOrigen = GetNumeroFromVariant(rsHandle.Fields("NumeroDocumentoOrigen"))
        .OrdenDespacho = GetNumeroFromVariant(rsHandle.Fields("OrdenDespacho"))
        .Descripcion = GetStringFromVariant(rsHandle.Fields("Descripcion"))
        End With
    End If

ResumePoint:
    If Not rsHandle Is Nothing Then
        rsHandle.Close
        Set rsHandle = Nothing
    End If
    
    Load = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "ComprobantesAlmacen.Load"
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function GetByDocumento(istrTipoDocumento As String, ilngNumeroDocumento As Long) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean

    On Error GoTo ErrHandler
    
    sQuery = "SELECT * FROM ComprobantesAlmacen WHERE TipoEntidadOrigen = " & StringDB(istrTipoDocumento) & " AND NumeroDocumentoOrigen = " & NumeroDB(ilngNumeroDocumento)
    Set rs = dbHandle.Execute(sQuery)

    If rs.EOF Then
        bRetVal = False
    Else
        With Me
        .Numero = rs.Fields("Numero")
        .Almacen = rs.Fields("Almacen")
        .Operador = rs.Fields("Operador")
        .FechaRegistro = rs.Fields("FechaRegistro")
        .FechaTransaccion = rs.Fields("FechaTransaccion")
        .TipoEntidadOrigen = rs.Fields("TipoEntidadOrigen")
        .NumeroDocumentoOrigen = rs.Fields("NumeroDocumentoOrigen")
        .OrdenDespacho = rs.Fields("OrdenDespacho")
        .Descripcion = rs.Fields("Descripcion")
        End With
        bRetVal = True
    End If

ResumePoint:
    If Not rs Is Nothing Then
        rs.Close
        Set rs = Nothing
    End If
    
    GetByDocumento = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "ComprobantesAlmacen.GetByDocumento"
    bRetVal = False
    Resume ResumePoint

End Function

Private Sub Add2Coleccion(stCodigoItem As String, dblCantidad As Double, Costo As Double)
Dim i As Integer, instMINV As clsMINV
    
    NumeroRenglon = 1
    For Each instMINV In colItems
        If instMINV.CodigoItem = stCodigoItem And instMINV.Costo = Costo Then
            instMINV.Cantidad = instMINV.Cantidad + dblCantidad
            Exit Sub
        End If
        NumeroRenglon = NumeroRenglon + 1
    Next
    
    Set instMINV = New clsMINV
    instMINV.CodigoItem = stCodigoItem
    instMINV.Costo = Costo
    instMINV.Cantidad = dblCantidad
    colItems.Add instMINV
    Set instMINV = Nothing

End Sub

Public Function StartProcess(instAlmacen As clsAlmacen, _
                             dtFecha As Date, _
                             stTipoEntidad As String, _
                             lngNumeroDocumento As Long, _
                             lngNumeroOrden As Long, _
                             stDescripcion As String) As Boolean
Dim isOk As Boolean

  If Abs(dtFecha - Date) > 180 Then
    mAdvertencia "INTERVALO DUDOSO"
  End If
  While inProcess: DoEvents: Wend
  inProcess = True
  Almacen = instAlmacen.Codigo
  Operador = UsuarioActivo.Codigo
  FechaRegistro = Date
  FechaTransaccion = dtFecha
  TipoEntidadOrigen = stTipoEntidad
  NumeroDocumentoOrigen = lngNumeroDocumento
  OrdenDespacho = lngNumeroOrden
  Descripcion = stDescripcion
  isOk = AlmacenCompAlmacen.StartProcess(Me)
  If isOk Then
    Set colItems = New Collection
  End If
  StartProcess = isOk
End Function

Public Function RegistrarMINV(stCodigoItem As String, dblCantidad As Double, dblCostoUnitario As Double) As Boolean
Dim isOk As Boolean
Dim instExUbic As clsExistenciaUbicacion
Dim instItemInventario As clsItemInventario

  If Not inProcess Then
    Err.Raise ERR_WILD_OPERATION, "clsComprobanteALmacen::RegistrarMINV", "Intento de actualizar comprobante cerrdo", "ComprobantesAlmacen.AddDetalleItemInv"
  End If
  
  Set instItemInventario = New clsItemInventario
  If Not instItemInventario.Load(stCodigoItem) Then
    Err.Raise ERR_ITEM_NOT_FOUND, "clsComprobanteALmacen::RegistrarMINV", "ItemInv no localizado: " & stCodigoItem
    Set instItemInventario = Nothing
    RegistrarMINV = False
    Exit Function
  End If
  
  Add2Coleccion stCodigoItem, dblCantidad, dblCostoUnitario
  
  RegistrarMINV = True

End Function

Private Function NumeroProximoRenglon() As Long
Dim rs As Recordset, lngRetVal As Long
  Set rs = dbHandle.Execute("SELECT Max(Renglon) AS Ultimo FROM DetallesMINV WHERE NumeroDocumento = " & NumeroDB(Me.Numero))
  If rs.EOF Then
    lngRetVal = 0
  Else
    lngRetVal = GetNumeroFromVariant(rs.Fields("Ultimo"))
  End If
  rs.Close
  Set rs = Nothing
  NumeroProximoRenglon = lngRetVal + 1
End Function

Public Function AgregarMINV( _
    ByVal lngNumComprobante As Long, _
    stCodigoItem As String, _
    dblCantidad As Double, _
    dblCostoUnitario As Double, _
    Optional stCodigoAlmacen As String, _
    Optional dtFecha As Date, _
    Optional stTipoEntidad As String, _
    Optional lngNumeroDocumento As Long, _
    Optional stDescripcion As String) As Long
Dim lngRetVal As Long, isOk As Boolean
Dim instExUbic As clsExistenciaUbicacion
Dim instItemInventario As clsItemInventario
Dim instMINV As clsMINV
  
  Set instItemInventario = AlmacenItemsInventario.itemInventario(stCodigoItem)
  If instItemInventario Is Nothing Then
    Err.Raise 10001, "clsCOmprobanteAlmacen::AgregarMINV", "ERROR: referencia a componente no registrado (" & stCodigoItem & ")"
    AgregarMINV = 0
    Exit Function
  End If
  
  If lngNumComprobante = 0 Then
  ' La adicin del MINV requiere la pre-existencia del comprobante,
  ' de modo que si no existe, agrega un comprobante sin movimiento
    With Me
    .Almacen = stCodigoAlmacen
    .Descripcion = stDescripcion
    .FechaRegistro = Date
    .FechaTransaccion = dtFecha
    .NumeroDocumentoOrigen = lngNumeroDocumento
    .Operador = UsuarioActivo.Codigo
    .OrdenDespacho = 0
    .TipoEntidadOrigen = stTipoEntidad
    End With
  
    ' La secuencia siguiente simplemente graba el comprobante, pero no registra ningn movimiento.
    isOk = AlmacenCompAlmacen.StartProcess(Me)
    ' Ahora est determinado el numero del comprobante
    lngNumComprobante = Me.Numero
  End If
  
  ' Este es el proceso efectivo de agregar el MINV.
  ' No produce efectos en el comprobante contable.
  If Not Me.Load(lngNumComprobante) Then
    Err.Raise 1001, "clsComprbanteAlmacen::AgregarMINV", "ERROR: Imposible cargar el comprobante de inventario"
    lngNumComprobante = 0
    Exit Function
  End If
  
  Set instMINV = New clsMINV
  With instMINV
  If .LoadDetalleProducto(lngNumComprobante, stCodigoItem) Then
    .Cantidad = .Cantidad + dblCantidad
    .Update
  Else
    .CodigoItem = instItemInventario.Codigo
    .Cantidad = dblCantidad
    .Costo = instItemInventario.CostoUnitario
    .FechaOperacion = Me.FechaTransaccion
    .NumeroDocumento = Me.Numero
    .Renglon = NumeroProximoRenglon
    .TipoMovimiento = Me.TipoEntidadOrigen
    AlmacenMINVS.Add Me.Numero, .Renglon, .FechaOperacion, .TipoMovimiento, .CodigoItem, .Cantidad, .Costo
  End If
  End With
  
  Set instExUbic = New clsExistenciaUbicacion
  instExUbic.RegistrarVariacion instMINV.CodigoItem, Me.Almacen, 0, dblCantidad
  Set instExUbic = Nothing
  instItemInventario.RegistrarVariacionExistencia dblCantidad, instMINV.Costo, Me.FechaTransaccion
  lngRetVal = Me.Numero
  
  AgregarMINV = lngRetVal
End Function

Public Sub AbortProcess()
  AlmacenCompAlmacen.AbortProcess
  Set colItems = Nothing
  inProcess = False
End Sub

Public Function EndProcess() As Boolean
Dim instMINV As clsMINV, nRenglon As Integer, isOk As Boolean
Dim instItemInv As clsItemInventario
Dim instExUbic As clsExistenciaUbicacion

  nRenglon = 1
  Set instItemInv = New clsItemInventario
  For Each instMINV In colItems
    If Not instItemInv.Load(instMINV.CodigoItem) Then
      Err.Raise 10001, "clsComprobanteAlmacen:EndProcess", "Item no localizado: " & instMINV.CodigoItem
    End If
    isOk = AlmacenMINVS.Add(Me.Numero, nRenglon, Me.FechaTransaccion, Me.TipoEntidadOrigen, instMINV.CodigoItem, instMINV.Cantidad, instMINV.Costo)
    nRenglon = nRenglon + 1
    If isOk Then
      Set instExUbic = New clsExistenciaUbicacion
      isOk = instExUbic.RegistrarVariacion(instMINV.CodigoItem, Me.Almacen, 0, instMINV.Cantidad)
      Set instExUbic = Nothing
      If isOk Then
        isOk = instItemInv.RegistrarVariacionExistencia(instMINV.Cantidad, instMINV.Costo, Me.FechaTransaccion)
      End If
    End If
    If Not isOk Then Exit For
  Next
  
  If Not isOk Then
    AbortProcess
  End If
  
  Set colItems = Nothing
  inProcess = False
  EndProcess = isOk
End Function

Public Function DetallesComprobante(stTipoDoc As String, ByVal lNumeroDoc As Long) As Collection
Dim retCol As Collection, lDetalle As clsMINV, rs As Recordset
Dim pNumeroDoc As Long

  pNumeroDoc = lNumeroDoc
  Set rs = dbHandle.Execute("SELECT * FROM ComprobantesAlmacen WHERE TipoEntidadOrigen = " & StringDB(stTipoDoc) & " AND NumeroDocumentoOrigen =" & Str(lNumeroDoc))
  Set retCol = New Collection
  If Not rs.EOF Then
    lNumeroDoc = rs.Fields("Numero")
    rs.Close
    Set rs = dbHandle.Execute("Select * FROM DetallesMINV where NumeroDocumento =" & Str(lNumeroDoc) & " ORDER BY Renglon")
    Do While Not rs.EOF
      Set lDetalle = New clsMINV
      With lDetalle
      .NumeroDocumento = rs.Fields("NumeroDocumento")
      .Renglon = rs.Fields("Renglon")
      .FechaOperacion = rs.Fields("FechaOperacion")
      .TipoMovimiento = rs.Fields("TipoMovimiento")
      .CodigoItem = rs.Fields("CodigoItem")
      .Entradas = rs.Fields("Entradas")
      .Salidas = rs.Fields("Salidas")
      .Costo = rs.Fields("Costo")
      End With
      retCol.Add lDetalle
      rs.MoveNext
    Loop
  End If
    
  rs.Close
  Set DetallesComprobante = retCol
End Function

Private Sub Class_Initialize()
  Set colItems = Nothing
  inProcess = False
End Sub
