VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsComprobante"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Los comprobantes representan un conjunto de operaciones registradas en la contabilidad en una sola unidad de asiento. Generalmente cada comprobante debe reflejar el resultado de una transaccin."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public NumeroComprobante As Long
Attribute NumeroComprobante.VB_VarDescription = "Numero correlativo UNICO del comprobante... Referencia interna"
Public Periodo As Long
Attribute Periodo.VB_VarDescription = "Cdigo del perodo al cual pertenece el comprobante. Se forma como YYYY*100 + mm."
Public CorrelativoPeriodo As Long
Public Referencia As String
Public Descripcion As String
Public Autor As String
Public Fecha As Date
Attribute Fecha.VB_VarDescription = "Fecha y hora dl registro original del comprobante."
Public Debitos As Double
Attribute Debitos.VB_VarDescription = "Suma de los debitos registrados en el comprobante"
Public Creditos As Double
Attribute Creditos.VB_VarDescription = "Suma de los Creditos registrados en el comprobante"
Public Modificado As Date
Attribute Modificado.VB_VarDescription = "Fecha y hora de la ltima modificacion"

Private Const AnchoReporte = 137

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Property Get TipoEntidad() As String
  TipoEntidad = "CCG"
End Property

Public Property Get Numero() As Long
  Numero = NumeroComprobante
End Property

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim rs As Recordset, nComprobante As Long

  Set rs = dbHandle.Execute("SELECT NumeroComprobante FROM Comprobantes WHERE Referencia = " & StringDB(sRef))
  If rs.EOF Then
    nComprobante = 0
  Else
    nComprobante = GetNumeroFromVariant(rs.Fields("NumeroComprobante"))
  End If
  Set rs = Nothing

  LoadByReferenciaISDOC = Load(nComprobante)
  
End Function

Public Function Detalles() As Collection
Dim retCol As Collection

  Set retCol = New Collection
  AlmacenDetalles.FillDetallesComprobante Me.NumeroComprobante, retCol
  Set Detalles = retCol

End Function

Public Function Load(NumComprobante As Long) As Boolean
    Load = AlmacenComprobantes.Load(NumComprobante, Me)
End Function

Public Property Get numeroReferencia() As String
Dim lString As String
    lString = Format(Periodo, "000000") & "-" & Format(CorrelativoPeriodo, "00000")
    numeroReferencia = lString
End Property

Function ProximoNumeroPeriodo(ByVal ilPeriodo As Long) As Long
    ProximoNumeroPeriodo = AlmacenComprobantes.ProximoComprobantePeriodo(ilPeriodo)
End Function

Function ProximoNumeroComprobante() As Long
    ProximoNumeroComprobante = AlmacenComprobantes.ProximoNumero
End Function

Public Function LoadByRefPeriodo(ByVal Periodo As Long, ByVal Correlativo As Long)
    LoadByRefPeriodo = AlmacenComprobantes.LoadByRefPeriodo(Periodo, Correlativo, Me)
End Function

Public Function StartProcess() As Boolean
    AlmacenComprobantes.StartProcess
    If Me.NumeroComprobante = 0 Then    ' Registrado por primera vez:
        If Not AlmacenComprobantes.SaveNew(Me) Then
            AlmacenComprobantes.AbortProcess
            StartProcess = False
            Exit Function
        End If
        StartProcess = True
        Exit Function
    Else
        AlmacenComprobantes.ActualizarDescriptivos Me
        Me.Debitos = 0#: Me.Creditos = 0#
        StartProcess = True
    End If
End Function

Public Function EndProcess(DoViewPrint As Boolean) As Boolean
Dim bRetVal As Boolean

    bRetVal = AlmacenComprobantes.EndProcess(Me)
    If Me.Load(Me.NumeroComprobante) Then
        ExecuteScript "postComprobante.vbs", Me
        If AlmacenComprobantes.AutoPrint Then
          SubmitDoc Me
        End If
    End If
'    If AlmacenComprobantes.AutoPrint Then Me.ViewPrint
End Function

Public Function AbortProcess() As Boolean
    AbortProcess = AlmacenComprobantes.AbortProcess
End Function

Public Function AddDetalle(codigoCuenta As String, _
                           Descripcion As String, _
                           Referencia As String, _
                           ByVal Debitos As Double, _
                           ByVal Creditos As Double) As Boolean
    AddDetalle = AlmacenComprobantes.AddDetalle(Me, codigoCuenta, Descripcion, Referencia, Debitos, Creditos)
End Function

'Nombre de la Empresa
'Comprobante No. 999999-999999     Fecha: 99/99/9999      Autor: XXXXXXXX                                                  Pgina: 999
'Descripcion: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'Referencia: XXXXXXXXXXXXXXXXXXXX
'                                                                                           *** VIENEN   9.999.999.999.999,99 9.999.999.999.999,99
'9999999999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00
'-----------------------------------------------------------------------------------------------------------------------------------------
'Codigo        Titulo                                   Descripcion                                              DEBE                HABER
'-----------------------------------------------------------------------------------------------------------------------------------------
'                                                                                      *** VAN   9.999.999.999.999,99 9.999.999.999.999,99
'-----------------------------------------------------------------------------------------------------------------------------------------
'                                                                                            *** TOTAL   9.999.999.999.999,99 9.999.999.999.999,99
Private Sub Encabezado(f As lfQuickView, subTotD As Double, subTotF As Double)
    If (subTotD > 0 Or subTotF > 0) Then
        f.Add "                                                                                      *** VAN   " & _
            stRightAlign(Format(subTotD, "#,###,###,###,##0.00"), 20) & " " & _
            stRightAlign(Format(subTotF, "#,###,###,###,##0.00"), 20)
        f.PageBreak
    End If
    f.Add ""
    f.Add ""
    f.Add ""
    f.Add ""
    f.Add ""
    f.Add Empresa.NombreEmpresa
    f.Add "Comprobante No. " & Format(Me.Periodo, "000000") & "-" & Format(Me.CorrelativoPeriodo, "000000") & "     " & _
        "Fecha: " & Format(Me.Fecha, "dd/mm/yyyy") & "      Autor: " & _
        Me.Autor & "                                                  " & "Pgina: " & Format(f.Pagina, "##0")
    f.Add "Descripcion: " & Me.Descripcion
    f.Add "Referencia: " & Me.Referencia
    f.Add "-----------------------------------------------------------------------------------------------------------------------------------------"
    f.Add "Codigo        Titulo                                   Descripcion                                              DEBE                HABER"
    f.Add "-----------------------------------------------------------------------------------------------------------------------------------------"
'99999999999999999999  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00
    If (subTotD > 0 Or subTotF > 0) Then
        f.Add "                                                                                   *** VIENEN   " & _
            stRightAlign(Format(subTotD, "#,###,###,###,##0.00"), 20) & " " & _
            stRightAlign(Format(subTotF, "#,###,###,###,##0.00"), 20)
    End If
End Sub

Public Sub SendToWindow(f As lfQuickView)
Dim subTotD As Double, subTotC As Double
Dim sDetalle As String
Dim colDetalles As Collection, instDetalle As clsDetalles, instCuenta As clsCuenta
    
    Set colDetalles = New Collection: Set instCuenta = New clsCuenta
    AlmacenDetalles.FillDetallesComprobante Me.NumeroComprobante, colDetalles
    f.SetReportWidth AnchoReporte + 1
    Encabezado f, 0#, 0#
    For Each instDetalle In colDetalles
        If (f.Linea >= f.LineasPagina - 2) Then Encabezado f, subTotD, subTotC
        subTotD = subTotD + instDetalle.Debe
        subTotC = subTotC + instDetalle.Haber
        instCuenta.Load instDetalle.Cuenta
'99999999999999999999  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00
        sDetalle = stFullLength(instDetalle.Cuenta, 13) & " "
        sDetalle = sDetalle & stFullLength(instCuenta.Titulo, 40) & " "
        sDetalle = sDetalle & stFullLength(instDetalle.Descripcion, 40) & " "
        If instDetalle.Debe > 0# Then
            sDetalle = sDetalle & stRightAlign(Format(instDetalle.Debe, "#,###,###,###,##0.00"), 20)
        Else
            sDetalle = sDetalle & String(21, " ") & stRightAlign(Format(instDetalle.Haber, "#,###,###,###,##0.00"), 20)
        End If
        f.Add sDetalle
    Next
    
    f.Add String(AnchoReporte, "-")
    f.Add "                                                                                     *** TOTAL  " & _
            stRightAlign(Format(subTotD, "#,###,###,###,##0.00"), 20) & " " & _
            stRightAlign(Format(subTotC, "#,###,###,###,##0.00"), 20)
    f.Add ""
    f.Add ""
    f.Add "            Revisado Por:"
    f.Add ""
    f.Add ""
    f.Add ""
    f.Add "            _____________________________"
    
    Set instDetalle = Nothing
    Set instCuenta = Nothing
    Set colDetalles = Nothing
End Sub

Public Sub ViewPrint(Optional bAutoPrint As Boolean = False)
Dim f As lfQuickView
    
    Set f = New lfQuickView
    f.Caption = "Comprobante " & Format(Me.Periodo, "000000") & "-" & Format(Me.CorrelativoPeriodo, "000000")
    SendToWindow f
    f.Show 0
    While f.Visible: DoEvents: Wend
    Unload f
    Set f = Nothing

End Sub

Public Sub Reverse(Kill As Boolean)
    AlmacenComprobantes.Reverse Me, Kill
End Sub

Public Function Insertar(ByVal Periodo As Integer, ByVal Anho As Long, ByVal Correlativo As Long) As Boolean
    Me.Periodo = Anho * 100 + Periodo
    Me.CorrelativoPeriodo = Correlativo
    Insertar = AlmacenComprobantes.Insertar(Me)
End Function

