VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsColeccionResumen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Coleccion As Collection

Private Function Agregar(sItem As clsAtomResumen) As Boolean
Dim itemBefore As clsAtomResumen, stAfter As String, isOk As Boolean

    On Error GoTo RetErr

    isOk = True

    stAfter = ""
    For Each itemBefore In Coleccion
        If itemBefore.Codigo > sItem.Codigo Then Exit For
        stAfter = itemBefore.Codigo
    Next

    If stAfter = "" Then
        If Coleccion.Count = 0 Then
            Coleccion.Add sItem, sItem.Codigo
        Else
            Coleccion.Add sItem, sItem.Codigo, 1
        End If
    Else
        Coleccion.Add sItem, sItem.Codigo, , stAfter
    End If

ResumePoint:
    Set itemBefore = Nothing
    Agregar = isOk
    Exit Function
    
RetErr:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "ColeccionResumen.Agregar"
    Resume ' ResumePoint

End Function

Public Function Acumular(stItemCode As String, dblCantidad As Double, vmValor As Currency) As Boolean
Dim Item As clsAtomResumen, i As Integer

    On Error GoTo NotFound
    Set Item = Coleccion.Item(stItemCode)
    On Error GoTo 0

    If Item Is Nothing Then
        
        Set Item = New clsAtomResumen
        Item.Codigo = stItemCode
        Item.Cantidad = 0
        Item.Valor = 0
        Set Item.xtraData = Nothing

        If Not Agregar(Item) Then
            Acumular = False
            Exit Function
        End If
    
    End If
    
    Item.Cantidad = Item.Cantidad + dblCantidad
    Item.Valor = Item.Valor + vmValor

    Exit Function

NotFound:
    Set Item = Nothing
    Resume Next

End Function

Private Sub Class_Initialize()

    Set Coleccion = New Collection
    
End Sub

Private Sub Class_Terminate()
Dim cItem As clsAtomResumen

    For Each cItem In Coleccion
        Set cItem.xtraData = Nothing
    Next
    
    Set Coleccion = Nothing

End Sub
