VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsClientes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"

' clsClassGenerator V1.0
Public Codigo As String
Public Nombre As String
Public Tipo As String
Public RIF As String
Public NIT As String
Public CuentaActivo As String
Public CuentaIngresos As String
Public Direccion As String
Public Telefono As String
Public Zona As String
Public Ruta As String
Public Estado As String
Public Municipio As String
Public VendedorAsignado As String
Public CondicionStandard As String
Public PrecioStandard As String
Public SaldoActual As Currency
Public LimiteCredito As Currency
Public Status As Byte
Public FechaUltimaVenta As Date
Public Notas As String

' Variables "de clase"
Public FactorNormal As Currency
Public TipoEntidad As String

Public Function CGCuenta() As String
Dim stCuenta As String
    
    stCuenta = Me.CuentaActivo
    If stCuenta = "" Then stCuenta = Empresa.CuentaGeneralAcreencias

    CGCuenta = stCuenta
End Function

Public Property Get NombreTabla() As String
  NombreTabla = "Clientes"
End Property

Public Function ValidarCodigo(stiCodigo As String) As Boolean
' Requerida para ISPC
    ValidarCodigo = AlmacenClientes.Validar(stiCodigo)
End Function

Public Function Load(ByVal Codigo As String) As Boolean
' Requerida para ISPC
Dim retVal As Boolean
    
    Me.Codigo = Codigo
    retVal = AlmacenClientes.Load(Codigo, Me)
    Load = retVal

End Function

Public Function Contactos() As Collection
    Set Contactos = AlmacenContactos.Contactos(TipoEntidad, Me.Codigo)
End Function

Public Function EliminarContactos()
    
    EliminarContactos = AlmacenContactos.EliminarContactos(Me.Codigo, TipoEntidad)

End Function

Public Function Eliminar() As Boolean
Dim bRetVal As Boolean, pAtributo As clsAtributoEntidad
  
  StartTransaction
  bRetVal = EliminarContactos
  If bRetVal Then bRetVal = AlmacenClientes.Eliminar(Me.Codigo)
  If bRetVal Then
    Set pAtributo = New clsAtributoEntidad
    pAtributo.DeleteAtributosEntidad Me.TipoEntidad, Me.Codigo
    Set pAtributo = Nothing
    CommitTransaction
  Else
    AbortTransaction
  End If

  Eliminar = bRetVal
End Function

Public Sub FillComboStatus(cbx As ComboBox)
    cbx.Clear
    cbx.AddItem "Ok", 0
    cbx.AddItem "Irregular", 1
    cbx.AddItem "Malo", 2
    cbx.Text = cbx.List(Me.Status)
End Sub

Public Function ValorStatus(stStat As String)
    Select Case stStat
    Case "Ok"
        ValorStatus = 0
    Case "Irregular"
        ValorStatus = 1
    Case "Malo"
        ValorStatus = 2
    Case Else
        ValorStatus = -1
    End Select
End Function

Public Function CreateNew() As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenClientes.Add(Me)
  If bRetVal Then ExecuteScript "postNuevoCliente.vbs", Me, False
  CreateNew = bRetVal
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenClientes.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenClientes.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim retVal As Boolean
    retVal = AlmacenClientes.Load(Me.Codigo, Me)
    Refresh = retVal
End Function

Public Function ActualizarDescriptivos(iNombre As String, iTipo As String, iRif As String, istNIT As String, iCGCuenta As String, iCuentaIngreso As String, iDireccion As String, iTelefono As String, iZona As String, iRuta As String, iEstado As String, iMunicipio As String, iVendedorAsignado As String, iCondicionStandard As String, iPrecioStandard As String, iLimiteCredito As Double, iStatus As Byte, iNotas As String) As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenClientes.ActualizarDescriptivos(Me, iNombre, iTipo, iRif, istNIT, iCGCuenta, iCuentaIngreso, iDireccion, iTelefono, iZona, iRuta, iEstado, iMunicipio, iVendedorAsignado, iCondicionStandard, iPrecioStandard, iLimiteCredito, iStatus, iNotas)
  If bRetVal Then ExecuteScript "postEditCliente.vbs", Me, False
  ActualizarDescriptivos = bRetVal
End Function

Public Sub SetFechaVenta(dtFecha As Date)
    AlmacenClientes.SetFechaVenta Me, dtFecha
End Sub

Public Function RegistrarVariacionSaldo(vmVariacion As Currency, stDescripcion As String, iComprobante As clsBufferComprobante) As Boolean
Dim bRetVal As Boolean, stCuenta As String, dDebitos As Currency, dCreditos As Currency
    bRetVal = AlmacenClientes.RegistrarVariacionSaldo(Me, vmVariacion)
    If bRetVal Then
        stCuenta = Me.CGCuenta
        If stCuenta = "" Then stCuenta = Empresa.CuentaGeneralAcreencias
        If stCuenta = "" Then
            If Not iComprobante Is Nothing Then iComprobante.SetError
        Else
            If vmVariacion < 0 Then
                dCreditos = -vmVariacion
                dDebitos = 0
            Else
                dCreditos = 0
                dDebitos = vmVariacion
            End If
            If Not iComprobante Is Nothing Then iComprobante.AddDetalle stCuenta, stDescripcion, dDebitos, dCreditos
        End If
    End If
    RegistrarVariacionSaldo = bRetVal
End Function

Private Sub Class_Initialize()
    Me.TipoEntidad = "CLT"
    Me.FactorNormal = 1@
End Sub

Public Sub Show()
Dim f As FIEClientes

    If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_CLIENTES) Then Exit Sub
    
    Set f = New FIEClientes
    f.SetCodigo Me.Codigo
    On Error Resume Next
    f.Show
    If Err.Number Then
      mAdvertencia "No se puede mostrar la forma desde na forma modal"
    Else
      f.SetContexto 1
    End If
    On Error GoTo 0
    
    While f.Visible: DoEvents: Wend
    
    Unload f
    Set f = Nothing

End Sub

Public Function ValorCreditos() As Currency
Dim sQuery As String, vmRetVal As Currency, rs As Recordset

  sQuery = "SELECT SUM(Saldo) AS Creditos FROM DocumentosISPC WHERE CodigoEntidad = " & StringDB(Me.Codigo) & " AND TipoEntidad = " & StringDB(Me.TipoEntidad) & " AND Saldo < 0.0"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    vmRetVal = 0
  Else
    vmRetVal = GetNumeroFromVariant(rs.Fields("Creditos"))
    vmRetVal = -vmRetVal
  End If
  Set rs = Nothing
  
  ValorCreditos = vmRetVal

End Function

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub

