VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCierreZ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroUnico As Long
Public Numero As Long
Public idTerminal As Long
Public Apertura As Date
Public HoraUltimaOperacion As Date
Public qFacturas As Long
Public PrimeraFactura As Long
Public UltimaFactura As Long
Public Turnos As Integer
Public Gravable1 As Currency
Public Gravable2 As Currency
Public Exento As Currency
Public Impuesto1 As Currency
Public Impuesto2 As Currency
Public Servicio As Currency

Public Function Impuesto() As Currency
  Impuesto = Impuesto1 + Impuesto2
End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsCierreZ = Nothing)
Dim lpDest As clsCierreZ

    Set lpDest = pDest
    If lpDest Is Nothing Then Set lpDest = Me
    With lpDest
    .Numero = GetNumeroFromVariant(rs.Fields("Numero"))
    .NumeroUnico = GetNumeroFromVariant(rs.Fields("NumeroUnico"))
    .idTerminal = GetNumeroFromVariant(rs.Fields("idTerminal"))
    .Apertura = GetDateFromVariant(rs.Fields("Apertura"))
    .HoraUltimaOperacion = GetDateFromVariant(rs.Fields("HoraUltimaOperacion"))
    .qFacturas = GetNumeroFromVariant(rs.Fields("qFacturas"))
    .PrimeraFactura = GetNumeroFromVariant(rs.Fields("PrimeraFactura"))
    .UltimaFactura = GetNumeroFromVariant(rs.Fields("UltimaFactura"))
    .Turnos = GetNumeroFromVariant(rs.Fields("Turnos"))
    .Gravable1 = GetNumeroFromVariant(rs.Fields("Gravable1"))
    .Gravable2 = GetNumeroFromVariant(rs.Fields("Gravable2"))
    .Exento = GetNumeroFromVariant(rs.Fields("Exento"))
    .Impuesto1 = GetNumeroFromVariant(rs.Fields("Impuesto1"))
    .Impuesto2 = GetNumeroFromVariant(rs.Fields("Impuesto2"))
    .Servicio = GetNumeroFromVariant(rs.Fields("Servicio"))
    End With

End Sub

Public Function Load(ilngNumero As Long) As Boolean
Dim rs As Recordset, isOk As Boolean

    Set rs = dbHandle.Execute("SELECT * FROM CierresZ WHERE NumeroUnico = " & NumeroDB(ilngNumero))
    If rs.EOF Then
        isOk = False
    Else
        isOk = True
        LoadInstance rs
    End If
    Set rs = Nothing

    Load = isOk

End Function

' Complementos ISDOC

Public Property Get TipoEntidad() As String

    TipoEntidad = "ZTR"

End Property

Public Property Get Descripcion() As String

    Descripcion = "Z-TERM:" & Format(Me.idTerminal, "00000") & ". Cierre del " & Format(Me.Apertura, "Short Date")

End Property

Public Property Get Referencia() As String
    
    Referencia = "Z" & Format(Me.idTerminal, "00000") & "-" & Format(Me.Numero, "00000")

End Property

Public Property Get Concepto() As String

    Concepto = "Ventas del " & Format(Me.Apertura, "Short Date") & ", Terminal " & Me.idTerminal

End Property

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lTermID As Long, lNumZ As Long
Dim bRetVal As Boolean

    lTermID = Val(Mid(sRef, 2, 5))
    lNumZ = Val(Mid(sRef, 8, 5))
    
    bRetVal = LoadTerm(lNumZ, lTermID)
    
    If bRetVal = False Then
      lNumZ = Val(right(sRef, Len(sRef) - 3))  ' ZTRnnnnnn
      If Me.Load(lNumZ) Then
        bRetVal = True
      End If
    End If

  LoadByReferenciaISDOC = bRetVal

End Function

Public Function LoadTerm(ilngNumero As Long, ilngTerminal As Long) As Boolean
Dim rs As Recordset, isOk As Boolean

    Set rs = dbHandle.Execute("SELECT * FROM CierresZ WHERE Numero = " & NumeroDB(ilngNumero) & " AND idTerminal = " & NumeroDB(ilngTerminal))
    If rs.EOF Then
        isOk = False
    Else
        isOk = True
        LoadInstance rs
    End If
    Set rs = Nothing

    LoadTerm = isOk

End Function

Private Function CantidadTurnos(lngNumTerminal As Long, idtFecha As Date) As Integer
Dim sQuery As String, rs As Recordset, nRetVal As Integer

    sQuery = "SELECT COUNT(SessionID) as Q FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha)
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        nRetVal = 0
    Else
        nRetVal = GetNumeroFromVariant(rs.Fields("Q"))
    End If
    Set rs = Nothing
    
    CantidadTurnos = nRetVal

End Function

Private Function ProximoZTerminal(nTerminal As Long) As Long
Dim sQuery As String, nRetVal As Long, rs As Recordset

    sQuery = "SELECT MAX(Numero) AS UltimoNumero FROM CierresZ WHERE idTerminal = " & NumeroDB(nTerminal)
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        nRetVal = 0
    Else
        nRetVal = GetNumeroFromVariant(rs.Fields("UltimoNumero"))
    End If
    Set rs = Nothing

    ProximoZTerminal = nRetVal + 1

End Function

Private Function ListaComprobantesAlmacen(lngNumTerminal, idtFecha As Date)
Dim strRetVal As String, rs As Recordset

    Set rs = dbHandle.Execute("SELECT ComprobanteAlmacen FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha) & " AND Cerrada = 1 ORDER BY SessionID")
    strRetVal = ""
    Do While Not rs.EOF
    
        If strRetVal <> "" Then
            strRetVal = strRetVal & ", "
        End If
        strRetVal = strRetVal & GetNumeroFromVariant(rs.Fields("ComprobanteAlmacen"))
    
        rs.MoveNext
    Loop
    Set rs = Nothing

    If strRetVal = "" Then strRetVal = "0"

    ListaComprobantesAlmacen = strRetVal

End Function

'Private Sub ExportarAExcel(lngTerminal As Long, idtFecha As Date)
'Dim pApp As Excel.Application
'Dim wk As Excel.Workbook, ws As Excel.Worksheet
'Dim Row As Long, rs As Recordset, sFileName As String
'
'  On Error GoTo ErrHandler
'
'  sFileName = GetSetting(AppName, "General", "ArchivoExcel", "C:\Mis Documentos\Estadisticas.xls")
'  If Dir(sFileName) = "" Then
'    Exit Sub
'  End If
'
'  Set rs = dbHandle.Execute("SELECT * FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngTerminal) & " AND Fecha = " & FechaDB(idtFecha) & " AND Cerrada = 1 ORDER BY SessionID")
'
'  Set pApp = New Excel.Application
'  pApp.Visible = False
'  Set wk = pApp.Workbooks.Open(sFileName, , 0)
'  Set ws = wk.Sheets("Hoja1")
'
'  Row = 1
'  Do While Not rs.EOF
'    Do While Not VBA.IsEmpty(ws.Cells(Row, 1).Value)
'      Row = Row + 1
'    Loop
'    ws.Cells(Row, 1).Value = GetNumeroFromVariant(rs.Fields("SessionID"))
'    ws.Cells(Row, 2).Value = GetNumeroFromVariant(rs.Fields("MachineID"))
'    ws.Cells(Row, 3).Value = GetDateFromVariant(rs.Fields("Fecha"))
'    ws.Cells(Row, 4).Value = GetNumeroFromVariant(rs.Fields("MontoFacturado")) - GetNumeroFromVariant(rs.Fields("MontoAnulaciones"))
'    ws.Cells(Row, 5).Value = GetNumeroFromVariant(rs.Fields("ImpuestoCobrado")) - GetNumeroFromVariant(rs.Fields("ImpuestoAnulado"))
'    ws.Cells(Row, 6).Value = mPalSaco.MontoSaco(GetNumeroFromVariant(rs.Fields("SessionID")))
'    If Dir(Trim(Str(GetNumeroFromVariant(rs.Fields("SessionID")))) & ".bin") <> "" Then
'      Kill Trim(Str(GetNumeroFromVariant(rs.Fields("SessionID")))) & ".bin"
'    End If
'    rs.MoveNext
'  Loop
'  wk.Close True, sFileName
'
'ResumePoint:
'  Set rs = Nothing
'  Set ws = Nothing
'  Set wk = Nothing
'  Set pApp = Nothing
'
'  Exit Sub
'
'ErrHandler:
'  ReportarError False, Err.Number, Err.Description, "clsCierreC::ExportarAExcel"
'  Resume ResumePoint
'
'End Sub

Private Function ListaSesionesTerminal(ByVal ilngNumTerm As Long, idtFecha As Date) As String
Dim strRetVal As String, rs As Recordset

    Set rs = dbHandle.Execute("SELECT SessionID FROM SesionesPOS WHERE MachineID = " & NumeroDB(ilngNumTerm) & " AND Fecha = " & FechaDB(idtFecha) & " AND Cerrada = 1 ORDER BY SessionID")
    strRetVal = ""
    Do While Not rs.EOF
    
        If strRetVal <> "" Then
            strRetVal = strRetVal & ", "
        End If
        strRetVal = strRetVal & GetNumeroFromVariant(rs.Fields("SessionID"))
    
        rs.MoveNext
    Loop
    Set rs = Nothing
    
    If strRetVal = "" Then strRetVal = "0"

    ListaSesionesTerminal = strRetVal

End Function

Private Function CantidadFacturas(lngNumTerminal As Long, idtFecha As Date) As Long
Dim sQuery As String, rs As Recordset, lngRetVal As Long

    sQuery = "SELECT Count(NumeroTicket) as qFact FROM FacturasPOS WHERE idSesion IN (" & ListaSesionesTerminal(lngNumTerminal, idtFecha) & ")"
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        lngRetVal = 0
    Else
        lngRetVal = GetNumeroFromVariant(rs.Fields("qFact"))
    End If
    Set rs = Nothing
    
    CantidadFacturas = lngRetVal

End Function

Private Sub AcumularTotalesVenta(lngNumTerminal As Long, idtFecha As Date)
Dim rs As Recordset, sQuery As String
Dim Impuestos(3) As Double, i As Integer

  Set rs = dbHandle.Execute("SELECT Porcentaje FROM TiposImpuesto WHERE Codigo = 'IV1'")
  If rs.EOF Then
    Err.Raise 10001, "clsCierreZ", "No esta definido el porcentaje para el valor general"
  End If
  Impuestos(1) = rs.Fields("Porcentaje")
  rs.Close
  
  Set rs = dbHandle.Execute("SELECT Porcentaje FROM TiposImpuesto WHERE Codigo = 'IV2'")
  If rs.EOF Then
    Err.Raise 10001, "clsCierreZ", "No esta definido el porcentaje para el valor preferencial"
  End If
  Impuestos(2) = rs.Fields("Porcentaje")
  rs.Close
    
  sQuery = "SELECT SUM(Cantidad * PrecioUnitario * (" & dbexprBinSelect("PorcentajeImpuesto", NumeroDB(0), "1", "0") & ")) As Exento, "
  sQuery = sQuery & "SUM(Cantidad * PrecioUnitario * (" & dbexprBinSelect("PorcentajeImpuesto", NumeroDB(Impuestos(1)), "1", "0") & ")) AS Gravable1, "
  sQuery = sQuery & "SUM(Cantidad * PrecioUnitario * (" & dbexprBinSelect("PorcentajeImpuesto", NumeroDB(Impuestos(2)), "1", "0") & ")) AS Gravable2 "
  sQuery = sQuery & "FROM RenglonesFacturaPOS AS R, FacturasPOS AS F "
  sQuery = sQuery & "WHERE F.idSesion IN (" & ListaSesionesTerminal(lngNumTerminal, idtFecha) & ") "
  sQuery = sQuery & "AND R.idMaquina=F.idMaquina AND R.numeroTicket=F.NumeroTicket"
  
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    Me.Gravable1 = 0
    Me.Gravable2 = 0
    Me.Exento = 0
  Else
    Me.Gravable1 = GetNumeroFromVariant(rs.Fields("Gravable1"))
    Me.Gravable2 = GetNumeroFromVariant(rs.Fields("Gravable2"))
    Me.Exento = GetNumeroFromVariant(rs.Fields("Exento"))
  End If
  Me.Impuesto1 = Gravable1 / 100 * Impuestos(1)
  Me.Impuesto2 = Gravable2 / 100 * Impuestos(2)
  Set rs = Nothing

End Sub

Public Function HoraPrimeraFactura(lngNumeroTerminal As Long, idtFecha As Date) As Date
Dim sQuery As String, rs As Recordset, dtRetVal As Date

    sQuery = "SELECT MIN(Hora) AS dtHora FROM FacturasPOS WHERE IdSesion IN (" & ListaSesionesTerminal(lngNumeroTerminal, idtFecha) & ")"

    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        dtRetVal = DateSerial(1900, 1, 1)
    Else
        dtRetVal = GetDateFromVariant(rs.Fields("dtHora"))
    End If
    Set rs = Nothing

    HoraPrimeraFactura = dtRetVal

End Function

Public Function HoraUltimaFactura(lngNumeroTerminal As Long, idtFecha As Date) As Date
Dim sQuery As String, rs As Recordset, dtRetVal As Date

    sQuery = "SELECT MAX(Hora) AS dtHora FROM FacturasPOS WHERE IdSesion IN (" & ListaSesionesTerminal(lngNumeroTerminal, idtFecha) & ")"
    
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        dtRetVal = DateSerial(1900, 1, 1)
    Else
        dtRetVal = GetDateFromVariant(rs.Fields("dtHora"))
    End If
    Set rs = Nothing

    HoraUltimaFactura = dtRetVal

End Function

Public Function PrimeraFacturaSesiones(lngNumeroTerminal As Long, idtFecha As Date) As Long
Dim sQuery As String, rs As Recordset, lngRetVal As Long

    sQuery = "SELECT MIN(NumeroTicket) AS PrimeraFactura FROM FacturasPOS WHERE IdSesion IN (" & ListaSesionesTerminal(lngNumeroTerminal, idtFecha) & ")"
    
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        lngRetVal = 0
    Else
        lngRetVal = GetNumeroFromVariant(rs.Fields("PrimeraFactura"))
    End If
    Set rs = Nothing

    PrimeraFacturaSesiones = lngRetVal

End Function

Public Function UltimaFacturaSesiones(lngNumeroTerminal As Long, idtFecha As Date) As Long
Dim sQuery As String, rs As Recordset, lngRetVal As Long

    sQuery = "SELECT MAX(NumeroTicket) AS UltimaFactura FROM FacturasPOS WHERE IdSesion IN (" & ListaSesionesTerminal(lngNumeroTerminal, idtFecha) & ")"
    
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        lngRetVal = 0
    Else
        lngRetVal = GetNumeroFromVariant(rs.Fields("UltimaFactura"))
    End If
    Set rs = Nothing

    UltimaFacturaSesiones = lngRetVal

End Function

Public Function TotalVentaCredito(lngNumTerminal As Long, idtFecha As Date) As Currency
Dim nRetVal As Currency, sQuery As String, rs As Recordset
  sQuery = "SELECT SUM(VentasACredito) as Q FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha)
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    nRetVal = 0
  Else
    nRetVal = GetNumeroFromVariant(rs.Fields("Q"))
  End If
  Set rs = Nothing
  TotalVentaCredito = nRetVal
End Function

Private Function ProximoNumeroUnico() As Long
Dim Numero As Long, rs As Recordset

    Set rs = dbHandle.Execute("SELECT MAX(NumeroUnico) AS Ultimo FROM CierresZ")
    If rs.EOF Then
        Numero = 1
    Else
        Numero = GetNumeroFromVariant(rs.Fields("Ultimo")) + 1
    End If
    rs.Close
    Set rs = Nothing
    
    ProximoNumeroUnico = Numero

End Function

Public Function CerrarTerminal(ByVal lngNumTerminal As Long, ByVal idtFecha As Date, stSerie As String, stAlmacen As String) As Boolean
Dim f As lfProgresoOperacion, rs As Recordset, qItems As Long
Dim isOk As Boolean, Detalle As clsRenglonSesion, ItemVenta As clsItemVenta, pItemInventario As clsItemInventario
Dim lRetVal As Long, sQuery As String, pComprobanteAlmacen As clsComprobanteAlmacen
Dim TotalVenta As Currency, pComponente As clsComponenteItemVenta
Dim pComprobante As clsBufferComprobante, bContinuar As Boolean

  On Error GoTo ErrHandler

  If ListaSesionesTerminal(lngNumTerminal, idtFecha) = "0" Then
    mAdvertencia "No hay sesiones que cerrar"
    CerrarTerminal = False
    Exit Function
  End If

  If LoadScriptFile("preCierreZ.vbs") Then
    If mScriptExecute.ExisteProcedimiento(pScript, "Continuar") Then
      pScript.AddObject "OwnerObject", Me
      bContinuar = pScript.Eval("Continuar")
    End If
    If Not bContinuar Then
      CerrarTerminal = False
      Exit Function
    End If
  End If

  SetGlobalLock "CerrarZ"
  StartTransaction

  Set f = New lfProgresoOperacion
  f.Caption = "Acumulando los Totales"
  f.SetMax 6
  f.ProgressBar1.value = 0
  f.Show

'Public idTerminal As Long
  Me.idTerminal = lngNumTerminal

' 1: Acumular totales

  sQuery = "SELECT Sum(F.Impuesto) AS TotalImpuesto, Sum(F.Servicio) as TotalServicio, Sum(F.MontoVenta) as TotalVenta FROM FacturasPOS F WHERE idSesion IN (" & ListaSesionesTerminal(lngNumTerminal, idtFecha) & ")"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    Me.Impuesto1 = 0
    Me.Impuesto2 = 0
    Me.Servicio = 0
    TotalVenta = 0
  Else
    Me.Servicio = GetNumeroFromVariant(rs.Fields("TotalServicio"))
    TotalVenta = GetNumeroFromVariant(rs.Fields("TotalVenta"))
  End If
  Set rs = Nothing
  f.NextPoint

'Public PrimeraFactura As Long
  Me.PrimeraFactura = Me.PrimeraFacturaSesiones(lngNumTerminal, idtFecha)
  f.NextPoint
'Public UltimaFactura As Long
  Me.UltimaFactura = UltimaFacturaSesiones(lngNumTerminal, idtFecha)
  f.NextPoint
'Public Apertura As Date
  Me.Apertura = Me.HoraPrimeraFactura(lngNumTerminal, idtFecha)
  f.NextPoint
'Public HoraUltimaOperacion As Date
  Me.HoraUltimaOperacion = HoraUltimaFactura(lngNumTerminal, idtFecha)
  f.NextPoint
'Public qFacturas As Long
  Me.qFacturas = CantidadFacturas(lngNumTerminal, idtFecha)
  f.NextPoint
'Public Turnos As Integer
  Me.Turnos = CantidadTurnos(lngNumTerminal, idtFecha)

  f.Caption = "Calculando totales de venta"
  
  If Me.qFacturas = 0 Then
    isOk = False
  Else
    Screen.MousePointer = vbHourglass
    AcumularTotalesVenta lngNumTerminal, idtFecha
    Screen.MousePointer = vbDefault
'Public Numero As Long
    Me.Numero = ProximoZTerminal(lngNumTerminal)
'    Me.NumeroUnico = ProximoNumeroUnico
' EL registro est lleno... ahora se graba:
    sQuery = "INSERT INTO CierresZ (Numero, idTerminal, Apertura, HoraUltimaOperacion, qFacturas, PrimeraFactura, UltimaFactura, Turnos, Gravable1, Gravable2, Exento, Impuesto1, Impuesto2, Servicio) "
    sQuery = sQuery & " VALUES ("
    sQuery = sQuery & NumeroDB(Me.Numero) & ", "
    sQuery = sQuery & NumeroDB(Me.idTerminal) & ", "
    sQuery = sQuery & FechaDB(Me.Apertura) & ", "
    sQuery = sQuery & FechaDB(HoraUltimaOperacion) & ", "
    sQuery = sQuery & NumeroDB(Me.qFacturas) & ", "
    sQuery = sQuery & NumeroDB(Me.PrimeraFactura) & ", "
    sQuery = sQuery & NumeroDB(Me.UltimaFactura) & ", "
    sQuery = sQuery & NumeroDB(Me.Turnos) & ", "
    sQuery = sQuery & NumeroDB(Me.Gravable1) & ", "
    sQuery = sQuery & NumeroDB(Me.Gravable2) & ", "
    sQuery = sQuery & NumeroDB(Me.Exento) & ", "
    sQuery = sQuery & NumeroDB(Me.Impuesto1) & ", "
    sQuery = sQuery & NumeroDB(Me.Impuesto2) & ", "
    sQuery = sQuery & NumeroDB(Me.Servicio) & ");"

    dbHandle.Execute sQuery
    
    Set rs = dbHandle.Execute("SELECT @@IDENTITY")
    Me.NumeroUnico = rs(0)
    rs.Close
    Set rs = Nothing
  End If
  
' 2: Generar tabla de productos
  
  isOk = True
  sQuery = "UPDATE DetallesMINV Set TipoMovimiento = " & StringDB(TipoEntidad) & " WHERE NumeroDocumento IN (" & ListaComprobantesAlmacen(lngNumTerminal, idtFecha) & ");"
  dbHandle.Execute sQuery
  
  sQuery = "UPDATE DetallesItemVenta SET NumeroDocumento = " & NumeroDB(Me.NumeroUnico) & ", TipoDocumento = " & StringDB(TipoEntidad) & " WHERE TipoDocumento = 'SSN' AND NumeroDocumento IN (" & ListaSesionesTerminal(lngNumTerminal, idtFecha) & ");"
  dbHandle.Execute sQuery

  sQuery = "UPDATE ComprobantesAlmacen SET TipoEntidadOrigen = " & StringDB(Me.TipoEntidad) & ", NumeroDocumentoOrigen = " & NumeroDB(Me.NumeroUnico) & " WHERE TipoEntidadOrigen = 'SSN' AND NumeroDocumentoOrigen IN (" & ListaSesionesTerminal(lngNumTerminal, idtFecha) & ");"
  dbHandle.Execute sQuery

  Set pComprobante = New clsBufferComprobante
  Set pItemInventario = New clsItemInventario
  Set ItemVenta = New clsItemVenta
  
  pComprobante.StartComprobante Me.HoraPrimeraFactura(lngNumTerminal, idtFecha), Me.Referencia, Me.Concepto
  Dim Credito As Currency
  Credito = TotalVentaCredito(lngNumTerminal, idtFecha)
  pComprobante.AddDetalle Empresa.CuentaCaja, "Cierre (Z) Nro. " & Me.idTerminal & "/" & Me.Numero & ", " & Format(Me.Apertura, "Short Date"), Me.Impuesto1 + Me.Impuesto2 + Me.Servicio + TotalVenta - Credito, 0
  pComprobante.AddDetalle Empresa.CuentaGeneralAcreencias, "Cierre (Z) Nro. " & Me.idTerminal & "/" & Me.Numero & ", " & Format(Me.Apertura, "Short Date"), Credito, 0
  If Servicio > 0 Then pComprobante.AddDetalle Empresa.CuentaServicio, "Porcentajes en cierre (Z)Nro. " & Me.idTerminal & "/" & Me.Numero, 0, Me.Servicio
  If Impuesto1 + Impuesto2 > 0 Then pComprobante.AddDetalle Empresa.CuentaImpuesto1, "IVA retenido en cierre (Z)Nro. " & Me.idTerminal & "/" & Me.Numero, 0, Me.Impuesto1 + Me.Impuesto2

  f.Caption = "Desarrollando comprobante contable"

  f.SetMax 2
  f.ProgressBar1.value = 0

  sQuery = "SELECT Producto, Sum(Cantidad) AS tCantidad, PrecioUnitario, PorcentajeImpuesto "
  sQuery = sQuery & "FROM RenglonesFacturaPOS AS R, FacturasPOS AS F "
  sQuery = sQuery & "WHERE F.NumeroTicket = R.NumeroTicket "
  sQuery = sQuery & "AND F.idMaquina = r.IdMaquina "
  sQuery = sQuery & "AND F.idSesion in (" & ListaSesionesTerminal(lngNumTerminal, idtFecha) & ") "
  sQuery = sQuery & "GROUP BY Producto, PrecioUnitario, PorcentajeImpuesto "
  sQuery = sQuery & "ORDER BY Producto, PrecioUnitario;"

  Screen.MousePointer = vbHourglass
'  Set rs = New Recordset
'  rs.CursorLocation = adUseServer
'  rs.Open sQuery, dbHandle, adOpenStatic, adLockReadOnly, adCmdText
  Set rs = dbHandle.Execute(sQuery)
  Screen.MousePointer = vbDefault

  If Not rs.EOF Then
'    rs.MoveLast
    qItems = rs.RecordCount
'    rs.MoveFirst
    
    f.SetMax IIf(rs.RecordCount > 0, rs.RecordCount, 0)
    f.ProgressBar1.value = 0

    Do While Not rs.EOF And Not pComprobante.isError
      If ItemVenta.Load(GetStringFromVariant(rs.Fields("Producto"))) Then
        pComprobante.AddDetalle ItemVenta.CuentaIngresoVentas, "Cierre (Z) Nro. " & Me.idTerminal & "/" & Me.Numero, 0, GetNumeroFromVariant(rs.Fields("PrecioUnitario")) * GetNumeroFromVariant(rs.Fields("tCantidad"))
        For Each pComponente In ItemVenta.Composicion
          If pItemInventario.Load(pComponente.CodigoItemInventario) Then
            Dim sCtaCosto As String
            sCtaCosto = ItemVenta.CuentaCosto
            If sCtaCosto = "" Then sCtaCosto = pItemInventario.CuentaCosto
            pComprobante.AddDetalle sCtaCosto, "Cierre (Z) Nro. " & Me.idTerminal & "/" & Me.Numero, pItemInventario.CostoUnitario * rs.Fields("tCantidad") * pComponente.Cantidad, 0
            pComprobante.AddDetalle pItemInventario.CuentaActivo, "Cierre (Z) Nro. " & Me.idTerminal & "/" & Me.Numero, 0, pItemInventario.CostoUnitario * rs.Fields("tCantidad") * pComponente.Cantidad
          End If
        Next
      End If
      f.NextPoint
      rs.MoveNext
    Loop
  End If
  rs.Close
  Set rs = Nothing

' Calculo de comisiones por vendedor!
  If CBool(GetSetting(AppName, "General", "ComisionesPOS", "0")) Then
    f.Caption = "Calculando comisiones"
    f.SetMax 2
    f.ProgressBar1.value = 0
    sQuery = "SELECT V.Codigo, V.NoCobraComision, V.TipoComisionVenta, SUM(R.Cantidad * R.PrecioUnitario) AS TotalVenta, SUM(R.Cantidad * R.PrecioUnitario / 100 * I.PComis1) AS Comis1, SUM(R.Cantidad * R.PrecioUnitario / 100 * I.PComis2) AS Comis2, SUM(R.Cantidad * R.PrecioUnitario / 100 * I.PComis3) AS Comis3 "
    sQuery = sQuery & "FROM FacturasPOS AS F, Vendedores AS V, RenglonesFacturaPos AS R, ItemsVenta AS I, SesionesPOS S "
    sQuery = sQuery & "WHERE s.Fecha = " & FechaDB(idtFecha) & " AND s.MachineID = " & NumeroDB(lngNumTerminal) & " "
    sQuery = sQuery & "AND F.idSesion = S.SessionID "
    sQuery = sQuery & "AND F.IdMaquina = R.idMaquina AND F.numeroTicket = R.NumeroTicket "
    sQuery = sQuery & "AND ( (F.Vendedor = V.Codigo AND I.Codigo = R.Producto  AND (R.Usuario = '' OR R.Usuario IS NULL)) OR (I.Codigo = R.Producto AND R.Usuario = V.Codigo)) "
    sQuery = sQuery & "GROUP BY V.Codigo, TipoComisionVenta, V.NoCobraComision;"
  
    Set rs = dbHandle.Execute(sQuery)
    f.NextPoint
    Dim instDetalle As clsDetalleCuentaEntidad, Comision As Currency
    Set instDetalle = New clsDetalleCuentaEntidad
    Do While Not rs.EOF
      If Not rs.Fields("NoCobraComision") Then
        Comision = GetNumeroFromVariant(rs.Fields(3 + rs.Fields(2)))
        If Comision > 0 Then
          pComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Comis. en cierre Term. " & lngNumTerminal & ", Vend. " & GetStringFromVariant(rs.Fields("Codigo")) & ", el " & Format(idtFecha, "Short Date"), Comision, 0
          instDetalle.Add 0, GetStringFromVariant(rs.Fields("Codigo")), "VND", idtFecha, "Comis. en cierre Term. " & lngNumTerminal & " el " & Format(idtFecha, "Short Date"), -Comision, pComprobante
        End If
      End If
      rs.MoveNext
    Loop
    Set instDetalle = Nothing
  End If

  f.Caption = "Registrando el comprobante"
  pComprobante.Procesar

  Set ItemVenta = Nothing
  Set pItemInventario = Nothing
  Set pComprobante = Nothing

  If Not isOk Then
    CerrarTerminal = False
    AbortTransaction
    FreeGlobalLock
    f.Cerrar
    While f.Visible: DoEvents: Wend
    Unload f
    Set f = Nothing
    Exit Function
  End If

  ' Eliminar Registros temporales de la Sesion
  dbHandle.Execute "DELETE FROM AnulacionesPOS WHERE SessionID IN (SELECT SessionID FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha) & " AND Cerrada = 1)"
  dbHandle.Execute "DELETE FROM CobrosPOS WHERE SessionID IN (SELECT SessionID FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha) & "AND Cerrada = 1)"
  dbHandle.Execute "DELETE FROM RetirosPOS WHERE idSesion IN (SELECT SessionID FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha) & "AND Cerrada = 1)"
  dbHandle.Execute "INSERT INTO SesionesCerradas SELECT * FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha) & " AND Cerrada = 1"
  dbHandle.Execute "DELETE FROM SesionesPOS WHERE MachineID = " & NumeroDB(lngNumTerminal) & " AND Fecha = " & FechaDB(idtFecha) & " AND Cerrada = 1"

  CommitTransaction
  FreeGlobalLock

  f.Cerrar
  While f.Visible: DoEvents: Wend
  Unload f
  Set f = Nothing

  ExecuteScript "postCierreZ.vbs", Me, True
  If CBool(GetSetting("ClearLight", "General", "AutoResumenZ", "0")) Then
    Dim Resumen As New clsResumenZ
    Resumen.Generar Me.Numero, Me.idTerminal
  End If
    
ResumePoint:
  CerrarTerminal = isOk
  Exit Function

ErrHandler:
Dim nErrN As Long, sErrD As String
  nErrN = Err.Number: sErrD = Err.Description
  If Not f Is Nothing Then
    If f.Visible Then
      f.Hide
    End If
    Unload f
    Set f = Nothing
  End If
  AbortTransaction
  FreeGlobalLock
  ReportarError False, nErrN, sErrD, "clsCierresZ.CerrarTerminal"
  isOk = False
  Resume ResumePoint

End Function

Public Sub Show()
Dim fView As frmViewCierreZ

  Set fView = New frmViewCierreZ
  fView.SetData Me
  ShowNonModal fView
  Unload fView
  Set fView = Nothing

End Sub
