VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCGVarEvaluator"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Evaluador de Variables de VSLCg.\r\nIMPLEMENTA CvarEvaluator"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Implements CvarEvaluator

Private Result As Boolean

Public Function CVarEvaluator_EvalResult() As Boolean
CVarEvaluator_EvalResult = Result
End Function

Public Function CVarEvaluator_EvaluarVariable(stVar As String) As Double
Dim s As String, dResultado As Double
    Result = True
    s = UCase(MainID(stVar))
    Select Case s
    Case "SALDO"
        dResultado = EvaluarSaldo(stVar)
    Case "BALANCE"
        dResultado = EvaluarBalance(stVar)
    Case "PERIODOACTUAL"
        dResultado = AlmacenIndicadores.PeriodoActual
    Case "AOACTUAL"
        dResultado = AlmacenIndicadores.AnhoActual
    Case Else
        dResultado = 0
        Result = False
    End Select
    CVarEvaluator_EvaluarVariable = dResultado
End Function

Private Function EvalArg(a As String) As Double
Dim Evaluator As CexpEvaluator, VarEvaluator As clsCGVarEvaluator
Dim RetVal As Double
    Set Evaluator = New CexpEvaluator
    Set VarEvaluator = New clsCGVarEvaluator
    Evaluator.Expression = a
    Evaluator.SetVarEval VarEvaluator
    If (Evaluator.CheckSintax) Then
        RetVal = Evaluator.Valor
    Else
        RetVal = 0
        Result = False
    End If
    Set VarEvaluator = Nothing
    Set Evaluator = Nothing
    EvalArg = RetVal
End Function

Private Function EvaluarSaldo(stVar As String) As Double
Dim cCuenta As clsCuenta, nPeriodo As Integer, nAnho As Integer
' Sintax: Saldo(CodigoCuenta[,Periodo[,Anho]])
    nPeriodo = AlmacenIndicadores.PeriodoActual
    nAnho = AlmacenIndicadores.AnhoActual
    If Argument(1, stVar) = "" Then
        mAdvertencia "ERROR: La funcin 'SALDO' requiere un cdigo de cuenta"
        EvaluarSaldo = 0
        Result = False
        Exit Function
    End If
    If Argument(2, stVar) <> "" Then nPeriodo = EvalArg(Argument(2, stVar))
    If Not Result Then
        EvaluarSaldo = 0
        Exit Function
    End If
    If Argument(3, stVar) <> "" Then nAnho = EvalArg(Argument(3, stVar))
    If Not Result Then
        EvaluarSaldo = 0
        Exit Function
    End If
    If (nPeriodo > 12 Or nPeriodo < 1) Then
        mAdvertencia "ERROR (EvaluarSaldo): Periodo incorrecto" & Chr(13) & stVar
        EvaluarSaldo = 0
        Result = False
        Exit Function
    End If
    
    If (nAnho < 1980 Or nAnho > 2039) Then
        mAdvertencia "ERROR (EvaluarSaldo): Ao incorrecto" & Chr(13) & stVar
        EvaluarSaldo = 0
        Result = False
        Exit Function
    End If

    Set cCuenta = New clsCuenta
    Dim s As String
    s = Argument(1, stVar)
    If Not cCuenta.Load(s) Then
        Result = False
        mAdvertencia "Cuenta " & s & " no localizada en 'EvaluarSaldo'"
        EvaluarSaldo = 0
    Else
        EvaluarSaldo = cCuenta.SaldoPeriodo(nAnho, nPeriodo) * FactorLado(cCuenta.lado)
    End If
    Set cCuenta = Nothing
End Function

Private Function EvaluarBalance(stVar As String) As Double
Dim nPeriodoInicial As Integer, nAnhoInicial As Integer, nPeriodoFinal As Integer, nAnhoFinal As Integer
Dim args(1 To 5) As String, RefInicio As Long, RefFinal As Long
Dim i As Integer, lExpEval As CexpEvaluator
' Sintax: Balance(CodigoCuenta [,Periodo[,[Anho][,[Periodo][,Anho]]]])
    For i = 1 To 5
        args(i) = Argument(i, stVar)
    Next
    
    If (args(1)) = "" Then
        mAdvertencia "ERROR: La funcin 'BALANCE' requiere un cdigo de cuenta"
        Result = False
        EvaluarBalance = 0
        Exit Function
    End If
        
    For i = 2 To 5
        If (args(i) <> "") Then
            args(i) = Trim(Str(EvalArg(args(i))))
        End If
    Next
    
    nPeriodoInicial = AlmacenIndicadores.PeriodoActual
    nAnhoInicial = AlmacenIndicadores.AnhoActual
    nPeriodoFinal = nPeriodoInicial
    nAnhoFinal = nAnhoInicial
    If (args(2) <> "" And args(2) <> "0") Then nPeriodoInicial = Val(args(2))
    If (args(3) <> "" And args(3) <> "0") Then nAnhoInicial = Val(args(3))
    If (args(4) <> "" And args(4) <> "0") Then nPeriodoFinal = Val(args(4))
    If (args(5) <> "" And args(5) <> "0") Then nAnhoFinal = Val(args(5))
    RefInicio = nAnhoInicial: RefInicio = RefInicio * 100 + nPeriodoInicial
    RefFinal = nAnhoFinal: RefFinal = RefFinal * 100 + nPeriodoFinal
    If (RefInicio > RefFinal) Then
        Result = False
        mAdvertencia "ERROR: Inicio posterior a Fin en 'BALANCE'" & Chr(13) & stVar
        EvaluarBalance = 0
    Else
        EvaluarBalance = AlmacenSaldos.BalanceCuentaIntervalo(args(1), RefInicio, RefFinal)
    End If
End Function
