VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBufferComprobante"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Esta clase sirve como interfaz entre los mdulos operativos
' del sistema y los asientos de la contabilidad.
' Para usarlo:
'     se crea una instancia al comienzo del proceso
'     se le asigna una referencia, una descripcin y una fecha
'     se van haciendo asignaciones a las diferente cuentas
'        (se acumular por cuenta + descripcin)
'     se procesa, causando la generacin del comprobante

Private colDetalles As Collection, _
        Referencia As String, _
        Fecha As Date, _
        Descripcion As String, _
        instComprobante As clsComprobante
Public isError As Boolean

Public Function Detalles() As Collection
  Set Detalles = colDetalles
End Function

Public Sub SetError(Optional sMessage As String = "")
  If sMessage <> "" Then
    ReportarError False, 0, "SetError(" & sMessage & ")", "clsBufferComprobante"
  End If
  isError = True
End Sub

Public Sub Transferir(destino As clsBufferComprobante)
Dim instDetalle As clsDetalles
    
    If destino Is Nothing Then Exit Sub
    If destino.isError Then Exit Sub
    If isError Then
        destino.SetError
    Else
        For Each instDetalle In colDetalles
          destino.AddDetalle instDetalle.Cuenta, instDetalle.Descripcion, instDetalle.Debe, instDetalle.Haber
        Next
    End If
End Sub

Public Function Procesar() As Boolean
Dim instDetalle As clsDetalles
    
  If colDetalles.Count = 0 Or isError Then
    Procesar = True
    Exit Function
  End If
  
  If Not instComprobante.StartProcess Then
    Procesar = False
    Exit Function
  End If
  
  For Each instDetalle In colDetalles
    If instDetalle.Debe > 0 Or instDetalle.Haber > 0 Then   ' Para no procesar detalles anulados...
      If Not instComprobante.AddDetalle(instDetalle.Cuenta, instDetalle.Descripcion, instDetalle.RefDetalle, instDetalle.Debe, instDetalle.Haber) Then
        instComprobante.AbortProcess
        Procesar = False
        Exit Function
      End If
    End If
  Next
  
  instComprobante.EndProcess True
  
  Procesar = True
End Function

Public Sub SetReferencia(sRef As String)

    instComprobante.Referencia = sRef

End Sub

Public Sub StartComprobante(iFecha As Date, iReferencia As String, iDescripcion As String)
    
    instComprobante.Fecha = iFecha
    instComprobante.Referencia = iReferencia
    instComprobante.Descripcion = iDescripcion
    instComprobante.Autor = UsuarioActivo.Codigo

End Sub

Public Sub ClearDetalles()
  Do While colDetalles.Count > 0
    colDetalles.Remove 1
  Loop
End Sub

Public Function AddDetalle(iCuenta As String, iDescripcion As String, ByVal dDebitos As Currency, ByVal dCreditos As Currency) As Boolean
Dim bFound As Boolean, instDetalle As clsDetalles
    
  If Not Empresa.UsaContabilidad Then SetError
  
  If Me.isError Then
    AddDetalle = True
    Exit Function
  End If
  
  If dDebitos = 0 And dCreditos = 0 Then
    AddDetalle = True
    Exit Function
  End If
  
  If iCuenta = "" Then
    Me.SetError "Cuenta nula en AddDetalle: descripcion = " & iDescripcion
    AddDetalle = True
    Exit Function
  End If
  
  Dim instCuenta As clsCuenta
  Set instCuenta = New clsCuenta
  If Not instCuenta.Load(iCuenta) Then
    Me.SetError "Cuenta no registrada en AddDetalle: " & iCuenta
  End If
  Set instCuenta = Nothing
  
  If Me.isError Then
    AddDetalle = True
    Exit Function
  End If
  
  For Each instDetalle In colDetalles
    If instDetalle.Cuenta = iCuenta Then    ' Si es la misma cuenta
    
    If iDescripcion = "" Then           ' Si no hay una descripcin, se quiere "modificar" el valor.
      instDetalle.Debe = instDetalle.Debe + dDebitos
      instDetalle.Haber = instDetalle.Haber + dCreditos
      If instDetalle.Debe >= instDetalle.Haber Then
        instDetalle.Debe = instDetalle.Debe - instDetalle.Haber
        instDetalle.Haber = 0
      Else
        instDetalle.Haber = instDetalle.Haber - instDetalle.Debe
        instDetalle.Debe = 0
      End If
      AddDetalle = True                                                                         ' Di que qued bien...
      Exit Function                                                                             ' y sal.
    End If
    
    If (instDetalle.Debe <> 0 And dDebitos <> 0) Or (instDetalle.Haber <> 0 And dCreditos <> 0) Then  ' y va del mismo lado
      If instDetalle.Descripcion = iDescripcion Then                                                ' y tiene la misma descripcion
        instDetalle.Debe = instDetalle.Debe + dDebitos                                            ' Acumulalo aqu...
        instDetalle.Haber = instDetalle.Haber + dCreditos
        AddDetalle = True                                                                         ' Di que qued bien...
        Exit Function                                                                             ' y sal.
      End If
    End If
    End If
  Next
  
  Set instDetalle = New clsDetalles
  instDetalle.Cuenta = iCuenta
  instDetalle.Descripcion = iDescripcion
  If Len(instDetalle.Descripcion) > 50 Then
    instDetalle.Descripcion = left(instDetalle.Descripcion, 50)
  End If
  instDetalle.Debe = dDebitos
  instDetalle.Haber = dCreditos
  instDetalle.RefDetalle = Referencia
  colDetalles.Add instDetalle
  Set instDetalle = Nothing
  
  AddDetalle = True
  
End Function

Private Sub Class_Initialize()
    Set colDetalles = New Collection
    Set instComprobante = New clsComprobante
    isError = False
    If Not Empresa.UsaContabilidad Then Me.isError = True
End Sub

Private Sub Class_Terminate()
    Set colDetalles = Nothing
    Set instComprobante = Nothing
End Sub
