VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBancos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para cada una de las cuentas de banco almacenadas en el sistema."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"Contactos"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
' clsClassGenerator V1.0

Enum TipoCuentaBanco
    TCB_CORRIENTE = 1
    TCB_AHORROS
    TCB_FAL
    TCB_TARJETA
    TCB_OTROS
End Enum

Public Codigo As String
Public Cuenta As String
Public Nombre As String
Public Banco As String
Public TipoCuenta As TipoCuentaBanco
Public CuentaActivo As String
Public SaldoActual As Currency
Public DepositosDiferidos As Currency
Public ChequesPostdatados As Currency
Public UltimaActualizacion As Date
Public ProximoCheque As Long

Private lUltimoMovimiento As Long

Public Function Disponibilidad() As Currency
    Disponibilidad = Me.SaldoActual + Me.ChequesPostdatados - Me.DepositosDiferidos
End Function

Public Property Get NombreTabla() As String
  NombreTabla = "Bancos"
End Property

Public Property Get CGCuenta() As String
Dim stRetVal As String
    
    stRetVal = CuentaActivo
    If stRetVal = "" Then
        stRetVal = Empresa.CuentaGeneralBancos
    End If

    CGCuenta = stRetVal

End Property

Public Property Let CGCuenta(sCuenta As String)
    
    CuentaActivo = sCuenta

End Property

Public Function FactorNormal() As Currency
    
    FactorNormal = 1@   ' Cuenta Deudora

End Function

Public Function TipoEntidad() As String
    TipoEntidad = "BCO"
End Function

Public Function Contactos() As Collection
    Set Contactos = AlmacenContactos.Contactos(TipoEntidad, Me.Codigo)
End Function

Public Function EliminarContactos() As Boolean
    EliminarContactos = AlmacenContactos.EliminarContactos(Me.Codigo, TipoEntidad)
End Function

Public Function Eliminar() As Boolean
Dim bRetVal As Boolean, pAtributo As clsAtributoEntidad

    StartTransaction
    
    bRetVal = EliminarContactos
    If bRetVal Then bRetVal = AlmacenBancos.Eliminar(Me.Codigo)
    
    If bRetVal Then
      Set pAtributo = New clsAtributoEntidad
      pAtributo.DeleteAtributosEntidad Me.TipoEntidad, Me.Codigo
      Set pAtributo = Nothing
        CommitTransaction
    Else
        AbortTransaction
    End If
    
    Eliminar = bRetVal

End Function

Public Function ValidarCodigo(stiCodigo As String) As Boolean
    
    ValidarCodigo = AlmacenBancos.Validar(stiCodigo)

End Function

Private Sub ActualizarDiferidos()

    AlmacenBancos.ActualizarDiferidos Me

End Sub

Public Function Load(ByVal Codigo As String) As Boolean
Dim retVal As Boolean
    
    Me.Codigo = Codigo
    retVal = AlmacenBancos.Load(Codigo, Me)
    
    If retVal Then
        If Me.UltimaActualizacion < Date Then
            ActualizarDiferidos
        End If
    End If
    
    Load = retVal

End Function

Public Function CreateNew() As Boolean
    CreateNew = AlmacenBancos.Add(Me)
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenBancos.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenBancos.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim retVal As Boolean
    retVal = AlmacenBancos.Load(Me.Codigo, Me)
    Refresh = retVal
End Function

Public Function ActualizarDescriptivos(iCuenta As String, iNombre As String, iBanco As String, ByVal iTipoCuenta As TipoCuentaBanco, ByVal iCGCuenta As String, ByVal iProximoCheque As Long) As Boolean
    ActualizarDescriptivos = AlmacenBancos.ActualizarDescriptivos(Me, iCuenta, iNombre, iBanco, iTipoCuenta, iCGCuenta, iProximoCheque)
    Me.Nombre = iNombre
    Me.Banco = iBanco
    Me.Cuenta = iCuenta
    Me.TipoCuenta = iTipoCuenta
    Me.CuentaActivo = iCGCuenta
    Me.ProximoCheque = iProximoCheque
End Function

Public Function RegistrarVariacionSaldo(vmVariacion As Currency, stDescripcion As String, iComprobante As clsBufferComprobante) As Boolean
Dim bRetVal As Boolean, stCuenta As String, dDebitos As Currency, dCreditos As Currency
    bRetVal = AlmacenBancos.RegistrarVariacionSaldo(Me, vmVariacion)
    If bRetVal Then
        stCuenta = Me.CGCuenta
        If stCuenta = "" Then stCuenta = Empresa.CuentaGeneralBancos
        If stCuenta = "" Then
          If Not iComprobante Is Nothing Then
            iComprobante.SetError
          End If
        Else
            If vmVariacion < 0 Then
                dCreditos = -vmVariacion
                dDebitos = 0
            Else
                dCreditos = 0
                dDebitos = vmVariacion
            End If
            If Not iComprobante Is Nothing Then
              iComprobante.AddDetalle stCuenta, stDescripcion, dDebitos, dCreditos
            End If
        End If
    End If
    RegistrarVariacionSaldo = bRetVal
End Function

Public Function ImagenTipoCuenta() As String
    Select Case Me.TipoCuenta
    Case TCB_CORRIENTE
        ImagenTipoCuenta = "Corriente"
    Case TCB_AHORROS
        ImagenTipoCuenta = "Ahorros"
    Case TCB_FAL
        ImagenTipoCuenta = "FAL"
    Case TCB_TARJETA
        ImagenTipoCuenta = "Tarjeta"
    Case TCB_OTROS
        ImagenTipoCuenta = "Otros"
    Case Else
        ImagenTipoCuenta = "INVALIDO!"
    End Select
End Function

Public Function byteTipoCuenta(Imagen As String) As TipoCuentaBanco
    Select Case Imagen
    Case "Corriente"
        byteTipoCuenta = TCB_CORRIENTE
    Case "Ahorros"
        byteTipoCuenta = TCB_AHORROS
    Case "FAL"
        byteTipoCuenta = TCB_FAL
    Case "Tarjeta"
        byteTipoCuenta = TCB_TARJETA
    Case "Otros"
        byteTipoCuenta = TCB_OTROS
    Case Else
        byteTipoCuenta = 255
    End Select
End Function

Public Sub FillComboTiposCuenta(cbx As ComboBox)
    cbx.Clear
    cbx.AddItem "Corriente"
    cbx.AddItem "Ahorros"
    cbx.AddItem "FAL"
    cbx.AddItem "Tarjeta"
    cbx.AddItem "Otros"
End Sub

Public Function StartProcess() As Boolean
  StartProcess = True
End Function

Public Function RegistrarMovimiento( _
    nTipoMovimiento As Integer, _
    dtFechaMovimiento As Date, _
    stConcepto As String, _
    stBeneficiario As String, _
    ByVal vmMonto As Currency, _
    stRefBanco As String, _
    dtFechaEfectivo As Date, _
    pComprobante As clsBufferComprobante, _
    Optional colDetalles As Collection = Nothing, _
    Optional CargarIDB As Boolean = True) As Boolean
Dim pDetalleEntidad As clsDetalleCuentaEntidad, vmFactor As Currency
Dim bRetVal As Boolean, pMovimiento As clsMovimientoBanco, dtFechaPresentacion As Date
Dim vmMontoIDB As Currency, stDescIDB As String, pDetalle As CDocsMovCaja, sQuery As String

    If nTipoMovimiento = TMB_CHEQUE Or nTipoMovimiento = TMB_NDB Then
        vmFactor = -1
    Else
        vmFactor = 1
    End If
    
' Caso especial: anulacin de cheque: slo se anota en la lista de movimientos del banco
    If nTipoMovimiento = TMB_CHEQUE And vmMonto < 0.01 Then
        Set pMovimiento = New clsMovimientoBanco
        RegistrarMovimiento = pMovimiento.Registrar(Me.Codigo, UsuarioActivo.Codigo, nTipoMovimiento, dtFechaMovimiento, stConcepto, "ANULADO", 0, stRefBanco, dtFechaEfectivo, "", 0)
        Set pMovimiento = Nothing
        Exit Function
    End If

    Set pDetalleEntidad = New clsDetalleCuentaEntidad
    Set pMovimiento = New clsMovimientoBanco

    bRetVal = pDetalleEntidad.Add(0, Me.Codigo, Me.TipoEntidad, dtFechaMovimiento, stConcepto, vmFactor * vmMonto, pComprobante)
    If bRetVal Then bRetVal = pMovimiento.Registrar(Me.Codigo, UsuarioActivo.Codigo, nTipoMovimiento, dtFechaMovimiento, stConcepto, stBeneficiario, vmFactor * vmMonto, stRefBanco, dtFechaEfectivo, "", 0)
    If bRetVal Then
        lUltimoMovimiento = pMovimiento.Numero
    End If

    If Not colDetalles Is Nothing Then
      For Each pDetalle In colDetalles
        pMovimiento.AddConcepto pDetalle.Debitos, pDetalle.Creditos, pDetalle.TipoDoc, pDetalle.NumeroDoc
      Next
    End If

    If bRetVal And vmFactor < 0 Then    ' Proceso del IDB
        If nTipoMovimiento = TMB_NDB Then
            dtFechaPresentacion = dtFechaMovimiento
        Else
            dtFechaPresentacion = dtFechaEfectivo
        End If
        
        If dtFechaPresentacion >= Empresa.InicioVigenciaIDB And dtFechaPresentacion <= Empresa.FinVigenciaIDB And CargarIDB Then
            vmMontoIDB = vmMonto * vmFactor * Empresa.PorcentajeIDB / 100@
            stDescIDB = "Impuesto al debito bancario. " & IIf(nTipoMovimiento = 0, "cheque ", "NDB ") & stRefBanco
            bRetVal = pDetalleEntidad.Add(0, Me.Codigo, Me.TipoEntidad, dtFechaMovimiento, stDescIDB, vmMontoIDB, pComprobante)
            If bRetVal Then
                If Not pComprobante Is Nothing Then
                  pComprobante.AddDetalle Empresa.CuentaGastosIDB, stDescIDB, -vmMontoIDB, 0@
                End If
                bRetVal = pMovimiento.Registrar(Me.Codigo, cUsuario.Codigo, TMB_NDB, dtFechaMovimiento, stDescIDB, "", vmMontoIDB, stRefBanco, dtFechaPresentacion, "", 0)
            End If
        End If
    End If

    Set pDetalleEntidad = Nothing
    Set pMovimiento = Nothing
    
    RegistrarMovimiento = bRetVal

End Function

Public Sub EndProcess()
End Sub

Public Sub AbortProcess()
End Sub

Public Function ImagenTipoMovimiento(nTipoMov As Integer) As String
Dim sRetVal As String

    Select Case nTipoMov
    
    Case TMB_CHEQUE
        sRetVal = "CHQ"
    Case mMain.TMB_DEPOSITO
        sRetVal = "DEP"
    Case mMain.TMB_NCR
        sRetVal = "NCR"
    Case mMain.TMB_NDB
        sRetVal = "NDB"
    Case Else
        sRetVal = "INV!"
    
    End Select
    
    ImagenTipoMovimiento = sRetVal

End Function

Public Sub Show()
Dim f As FIEBancos

  If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_BANCOS) Then Exit Sub

  Set f = New FIEBancos
  f.SetCodigo Me.Codigo
  On Error Resume Next
  f.Show
  If Err.Number Then
    ReportarError False, Err.Number, Err.Description, "clsBancos::Show"
    Err.Clear
  Else
    f.SetContexto 1
    While f.Visible: DoEvents: Wend
  End If
  Unload f
  Set f = Nothing

End Sub

'Public Sub ImprimirMovimiento()
'Dim pMovimiento As clsMovimientoBanco
'
'    If lUltimoMovimiento Then
'        Set pMovimiento = New clsMovimientoBanco
'        If pMovimiento.Load(lUltimoMovimiento) Then
'            pMovimiento.Show
'        End If
'        Set pMovimiento = Nothing
'    End If
'
'End Sub

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub
