VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBalGenEmpresa"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Una clase que genera los Balances Generales (por empresa, NO consolidados). Debe tener conocimientos de las cuentas y de los almacenes."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const AnchoReporte = 116

Private mvarNivel As Integer
Private mvarPeriodo As Long
Private sResultados As Double, dTotPasivoCapital As Double
Private dValActivos As Double, dValPasivos As Double, dValCapital As Double

Public Property Let Periodo(ByVal vData As Long)
    mvarPeriodo = vData
    sResultados = SaldoResultados
End Property

Public Property Get Periodo() As Long
    Periodo = mvarPeriodo
End Property

Private Sub Encabezado(f As lfQuickView)
Dim stSubTitulo As String
    
    If f.Pagina > 1 Then f.PageBreak
    f.Add "": f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    stSubTitulo = "Balance General"
    f.Add stMidAlign(stSubTitulo, AnchoReporte)
    stSubTitulo = "Al" & Str(DiasMes(Empresa.MesPeriodo(Periodo), Empresa.AnhoCalendarioFromPeriodo(Periodo))) _
        & " de " & NombreMes(Empresa.MesPeriodo(Periodo)) & " de" & Str(Empresa.AnhoCalendarioFromPeriodo(Periodo))
    f.Add stMidAlign(stSubTitulo, AnchoReporte)
    stSubTitulo = "Pagina" & Str(f.Pagina)
    f.Add stRightAlign(stSubTitulo, AnchoReporte)
    f.Add ""
End Sub

Public Sub Show(ByVal Mode As Boolean)
Dim f As lfQuickView, n0 As Double, n1 As Double, n2 As Double, n3 As Double
Dim nextCodigo As String, NivelAnterior As Integer, EsteNivel As Integer, i As Integer
Dim stLineaSalida As String, dValor As Double
Dim rsHandle As Recordset
    
    Set rsHandle = dbHandle.Execute("SELECT * FROM " & UsuarioActivo.Codigo & "BalGenTMP ORDER BY CodigoCuenta", , adCmdText)
    Set f = New lfQuickView
    f.SetReportWidth AnchoReporte + 2
    f.Caption = Empresa.NombreEmpresa & ": Balance general para " & NombreMes(Empresa.MesPeriodo(Periodo)) & " de" & Str(AnhoPeriodo(Periodo))
    nextCodigo = ""
    Encabezado f
    
    f.Add String(AnchoReporte, "-")
    f.Add stMidAlign("ACTIVO", AnchoReporte)
    f.Add String(AnchoReporte, "-")
    dTotPasivoCapital = dValPasivos + dValCapital
    With rsHandle
    Do While Not .EOF
      If Left(Trim(nextCodigo), 1) <> Left(Trim(.Fields("CodigoCuenta")), 1) Then
        Select Case Left(Trim(nextCodigo), 1)
        Case "1"
          f.Add stFullLength("TOTAL ACTIVO", 53) & String(42, " ") & FormatNumero(dValActivos, "#,###,###,###,##0.00", 21)
          f.Add String(95, " ") & String(21, "=")
          f.Add ""
          f.Add String(AnchoReporte, "-")
          f.Add stMidAlign("PASIVO y CAPITAL", AnchoReporte)
          f.Add String(AnchoReporte, "-")
          f.Add "PASIVO"
          If Left(Trim(.Fields("CodigoCuenta")), 1) = "3" Then
            f.Add stFullLength("TOTAL PASIVO", 53) & String(42, " ") & FormatNumero(dValPasivos, "#,###,###,###,##0.00", 21)
            f.Add String(95, " ") & String(21, "=")
            f.Add ""
            f.Add "CAPITAL"
          End If
        Case "2"
          f.Add stFullLength("TOTAL PASIVO", 53) & String(42, " ") & FormatNumero(dValPasivos, "#,###,###,###,##0.00", 21)
          f.Add String(95, " ") & String(21, "=")
          f.Add "CAPITAL"
        End Select
        NivelAnterior = 0
      End If
      nextCodigo = .Fields("CodigoCuenta")

      n0 = .Fields("SaldoNivel0"): n1 = .Fields("SaldoNivel1"): n2 = .Fields("SaldoNivel2"): n3 = .Fields("SaldoNivel3")
      If n0 <> 0 Then
        EsteNivel = 1
        dValor = n0
      ElseIf n1 <> 0 Then
        EsteNivel = 2
        dValor = n1
      ElseIf n2 <> 0 Then
        EsteNivel = 3
        dValor = n2
      Else
        EsteNivel = 0
      End If

      If (EsteNivel) Then
        If (f.Linea >= f.LineasPagina - 2) Then
          Encabezado f
          f.Add "(...continuacion...)"
          f.Add String(AnchoReporte, "-")
        End If
        stLineaSalida = stFullLength(.Fields("Titulo"), 53)
        For i = 3 To EsteNivel + 1 Step -1
          stLineaSalida = stLineaSalida & String(21, " ")
        Next
        stLineaSalida = stLineaSalida & FormatNumero(dValor, "#,###,###,###,##0.00", 21)
        If NivelAnterior <> 0 And EsteNivel > NivelAnterior Then
          stLineaSalida = stLineaSalida & " " & String(20, "-")
        End If
        f.Add stLineaSalida
        
        NivelAnterior = EsteNivel
      End If
      .MoveNext
    Loop
    End With
    
    f.Add stFullLength("TOTAL CAPITAL", 53) & String(42, " ") & FormatNumero(dValCapital, "#,###,###,###,##0.00", 21)
    f.Add String(95, " ") & String(21, "-")
    f.Add stFullLength("TOTAL PASIVO Y CAPITAL", 53) & String(42, " ") & FormatNumero(dTotPasivoCapital, "#,###,###,###,##0.00", 21)
    f.Add String(95, " ") & String(21, "=")
    f.Show
    rsHandle.Close
    Set rsHandle = Nothing
    While f.Visible: DoEvents: Wend
    Unload f
    Set f = Nothing
End Sub

Public Property Let Nivel(ByVal vData As Integer)
    mvarNivel = vData
End Property

Public Property Get Nivel() As Integer
    Nivel = mvarNivel
End Property

Private Function SaldoResultados() As Double
Dim s As clsPrefijo, Cuenta As clsCuenta
Dim Saldo As Double
    
    Set Cuenta = New clsCuenta
    For Each s In AlmacenPrefijos
        If s.Funcion = 4 Or s.Funcion = 5 Then
            If Cuenta.Load(s.Codigo) Then
                Saldo = Saldo + Cuenta.SaldoPeriodo(AnhoPeriodo(Periodo), PeriodoPeriodo(Periodo))
            End If
        End If
    Next
    Set Cuenta = Nothing
    SaldoResultados = Saldo
End Function

Public Function AddCuenta(argCuenta As clsCuenta) As Boolean
Dim stNombreCuenta As String, uso As Integer
Dim Prefijo As clsPrefijo, sClave As String
Dim sFieldSelector As String, sQuery As String
Dim sNombreTabla As String, ra As Long, vmMonto As Currency

  If argCuenta.Nivel - 1 > Me.Nivel Then
    AddCuenta = True
    Exit Function
  End If
  
  Set Prefijo = AlmacenPrefijos.Item(Left(argCuenta.Codigo, 1))
  
  If Prefijo Is Nothing Then
    mAdvertencia "Prefijo (" & Left(argCuenta.Codigo, 1) & ") no identificado"
    AddCuenta = False
    Exit Function
  End If
  
  uso = Prefijo.Funcion
  If (uso > 3) Then
    AddCuenta = True
    Exit Function
  End If
      
  If argCuenta.Nivel = 1 Then
    Select Case uso
    Case 1
      dValActivos = dValActivos + argCuenta.SaldoPeriodo(AnhoPeriodo(Periodo), PeriodoPeriodo(Periodo))
    Case 2
      dValPasivos = dValPasivos - argCuenta.SaldoPeriodo(AnhoPeriodo(Periodo), PeriodoPeriodo(Periodo))
    Case 3
      dValCapital = dValCapital - argCuenta.SaldoPeriodo(AnhoPeriodo(Periodo), PeriodoPeriodo(Periodo)) - SaldoResultados
    End Select
    AddCuenta = True
    Exit Function
  End If

  sClave = Trim(Str(uso)) & argCuenta.Codigo
  
  sNombreTabla = UsuarioActivo.Codigo & "BalGenTMP"
  sFieldSelector = "SaldoNivel" & Trim(Str(argCuenta.Nivel - 2))
  vmMonto = argCuenta.SaldoPeriodo(AnhoPeriodo(Periodo), PeriodoPeriodo(Periodo)) * FactorLado(argCuenta.lado)
  If Left(Empresa.CuentaGanPer, Len(argCuenta.Codigo)) = argCuenta.Codigo Then
    vmMonto = vmMonto + SaldoResultados * -1#
  End If
  
  sQuery = "UPDATE " & sNombreTabla & " SET " & sFieldSelector & " = " & sFieldSelector & " + " & NumeroDB(vmMonto) & " WHERE CodigoCuenta = " & StringDB(sClave) & ";"
  dbHandle.Execute sQuery, ra
  If ra = 0 Then
    sQuery = "INSERT INTO " & sNombreTabla & " (CodigoCuenta, Titulo, SaldoNivel0, SaldoNivel1, SaldoNivel2, SaldoNivel3) VALUES ("
    sQuery = sQuery & StringDB(sClave) & ", " & StringDB(String(argCuenta.Nivel - 2, " ") & argCuenta.Titulo) & ", 0, 0, 0, 0);"
    dbHandle.Execute sQuery
    sQuery = "UPDATE " & sNombreTabla & " SET " & sFieldSelector & " = " & sFieldSelector & " + " & NumeroDB(vmMonto) & " WHERE CodigoCuenta = " & StringDB(sClave) & ";"
    dbHandle.Execute "UPDATE " & sNombreTabla & " SET " & sFieldSelector & " = " & sFieldSelector & " + " & NumeroDB(vmMonto) & " WHERE CodigoCuenta = " & StringDB(sClave) & ";", ra
  End If
  
  AddCuenta = True
End Function

Private Sub Class_Initialize()
Dim sNombreTabla As String
    Nivel = 3
    
    dTotPasivoCapital = 0
    dValActivos = 0: dValPasivos = 0: dValCapital = 0
    
    Periodo = mPeriodos.refPeriodo(Empresa.AnhoActual, Empresa.PeriodoActual)
    sResultados = SaldoResultados
    sNombreTabla = UsuarioActivo.Codigo & "BalGenTMP"
    lmTables.CopyTable dbHandle, sNombreTabla, "rpBalanceGeneral"
End Sub

Private Sub Class_Terminate()
Dim sNombreTabla As String
    sNombreTabla = UsuarioActivo.Codigo & "BalGenTMP"
    DeleteTable dbHandle, sNombreTabla
End Sub

Public Function DefinirParametros() As Boolean
Dim f As FSelPeriodo, bRetVal As Boolean
Dim lMes As Integer, lAnho As Integer

    Set f = New FSelPeriodo
    f.Caption = "Balance General: Defina el perodo"
    f.txAnho.Text = Trim(Str(Empresa.AnhoCalendarioActual))
    f.cbxMes.Text = NombreMes(Empresa.MesActual)
    f.Show
    While f.Visible: DoEvents: Wend
    If (f.txAnho.Text = "") Then
        bRetVal = False
    Else
        bRetVal = True
        lMes = NumeroMes(f.cbxMes.Text)
        lAnho = ValOf(f.txAnho.Text)
        Periodo = Empresa.AnhoMes2Periodo(lAnho, lMes)
    End If
    Unload f
    Set f = Nothing
    DefinirParametros = bRetVal
End Function
