VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsBalCompEmpresa"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Genera los balances de comprobacin para una empresa."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const AnchoReporte = 114
'local variable(s) to hold property value(s)
Private mvarPeriodo As Long 'local copy
Private WithEvents FormaView As lfQuickView
Private isFirstItem As Boolean
Private totCreditos As Double, totDebitos As Double


Public Sub Show()
    FormaView.Caption = Empresa.NombreEmpresa & ": Balance de comprobacin"
    FormaView.Add String(AnchoReporte, "-")
    FormaView.Add stFullLength("**TOTAL**", 72) & FormatNumero(totDebitos, "#,###,###,###,##0.00", 21) & FormatNumero(totCreditos, "#,###,###,###,##0.00", 21)
    FormaView.Add String(72, " ") & String(42, "=")
    FormaView.Show
    While FormaView.Visible: DoEvents: Wend
End Sub

Public Function DefinirParametros() As Boolean
Dim f As FSelPeriodo, bRetVal As Boolean
Dim lMes As Integer, lAnho As Integer

    Set f = New FSelPeriodo
    f.Caption = "Balance General: Defina el perodo"
    f.txAnho.Text = Trim(Str(Empresa.AnhoCalendarioActual))
    f.cbxMes.Text = NombreMes(Empresa.MesActual)
    f.Show
    While f.Visible: DoEvents: Wend
    If (f.txAnho.Text = "") Then
        bRetVal = False
    Else
        bRetVal = True
        lMes = NumeroMes(f.cbxMes.Text)
        lAnho = ValOf(f.txAnho.Text)
        periodo = Empresa.AnhoMes2Periodo(lAnho, lMes)
    End If
    Unload f
    Set f = Nothing
    DefinirParametros = bRetVal
End Function

'-----------------------------------------------------------------------------------------------------------------
'Codigo de la Cuenta  Titulo                                                             DEBE                HABER
'-----------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00

Private Sub Encabezado()
Dim stSubTitulo As String

    If FormaView.Pagina > 1 Then
        FormaView.Add String(AnchoReporte, "-")
        FormaView.Add stFullLength("*VAN*", 72) & FormatNumero(totDebitos, "#,###,###,###,##0.00", 21) & FormatNumero(totCreditos, "#,###,###,###,##0.00", 21)
        FormaView.PageBreak
    End If
    FormaView.Add "": FormaView.Add ""
    FormaView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    stSubTitulo = "Balance de comprobacion. "
    FormaView.Add stMidAlign(stSubTitulo, AnchoReporte)
    stSubTitulo = "Al" & Str(DiasMes(Empresa.Periodo2Mes(PeriodoPeriodo(periodo)), Empresa.AnhoCalendarioFromPeriodo(periodo))) & " de "
    stSubTitulo = stSubTitulo & NombreMes(Empresa.Periodo2Mes(PeriodoPeriodo(periodo))) & " de" & Str(Empresa.AnhoCalendarioFromPeriodo(periodo))
    FormaView.Add stMidAlign(stSubTitulo, AnchoReporte)
    FormaView.Add ""
    FormaView.Add String(AnchoReporte, "-")
    FormaView.Add "Codigo de la Cuenta  Titulo                                                             DEBE                 HABER"
    FormaView.Add String(AnchoReporte, "-")
    
    If (totDebitos >= 0.01) Then
        FormaView.Add stFullLength("*VIENEN*", 72) & FormatNumero(totDebitos, "#,###,###,###,##0.00", 21) & FormatNumero(totCreditos, "#,###,###,###,##0.00", 21)
    End If
End Sub

Public Function AddCuenta(instCuenta As clsCuenta) As Boolean
Dim dDebitos As Double, dCreditos As Double, dSaldo As Double
Dim stLineaSalida As String

    If instCuenta.Status <> 2 Then
        AddCuenta = True
        Exit Function
    End If

    If isFirstItem Then
        Encabezado
        isFirstItem = False
    End If

    If FormaView.Linea > FormaView.LineasPagina Then Encabezado
    dSaldo = instCuenta.SaldoPeriodo(AnhoPeriodo(periodo), PeriodoPeriodo(periodo))
    If Abs(dSaldo) >= 0.01 Then
        stLineaSalida = stFullLength(instCuenta.Codigo, 21) & _
                        stFullLength(instCuenta.Titulo, 51)
        If (dSaldo < 0) Then
            stLineaSalida = stLineaSalida & String(21, " ")
            dSaldo = Abs(dSaldo)
            totCreditos = totCreditos + dSaldo
        Else
            totDebitos = totDebitos + dSaldo
        End If
        stLineaSalida = stLineaSalida & FormatNumero(dSaldo, "#,###,###,###,##0.00", 21)
        FormaView.Add stLineaSalida
    End If
    AddCuenta = True
End Function

Public Property Let periodo(ByVal vData As Long)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Periodo = 5
    mvarPeriodo = vData
End Property

Public Property Get periodo() As Long
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Periodo
    periodo = mvarPeriodo
End Property

Private Sub Class_Initialize()
    periodo = mPeriodos.refPeriodo(Empresa.AnhoActual, Empresa.PeriodoActual)
    Set FormaView = New lfQuickView
    FormaView.SetReportWidth AnchoReporte
    FormaView.Visible = False
    isFirstItem = True
End Sub

Private Sub Class_Terminate()
'   While FormaView.Visible: DoEvents: Wend
    Unload FormaView
    Set FormaView = Nothing
End Sub

Private Sub FormaView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pCuenta As clsCuenta, sExtract As String

  bProcessed = True
  sExtract = Trim(Left(Trim(strReportLine), 20))
  Set pCuenta = AlmacenCuentas.Cuenta(sExtract)
  If Not pCuenta Is Nothing Then
    pCuenta.Show
    Set pCuenta = Nothing
  End If
End Sub
