VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAtributoEntidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Los atributos permiten al usuario definir propiedades adicionales para las entidades.

Public TipoEntidad As String
Public CodigoEntidad As String
Public CodigoAtributo As String
Public ValorAtributo As String  ' La BD no acepta objetos sin tipo.

Private rsIterador As Recordset

Public Sub AddAtributo(istrTipoEntidad, istrCodigoEntidad, istrCodigoAtributo, istrValorAtributo)
Dim sQuery As String

  sQuery = "INSERT INTO Atributos (TipoEntidad, CodigoEntidad, CodigoAtributo, ValorAtributo) "
  sQuery = sQuery & "SELECT " & StringDB(CStr(istrTipoEntidad)) & ", "
  sQuery = sQuery & StringDB(CStr(istrCodigoEntidad)) & ", "
  sQuery = sQuery & StringDB(CStr(istrCodigoAtributo)) & ", "
  sQuery = sQuery & StringDB(CStr(istrValorAtributo)) & ";"
  dbHandle.Execute sQuery

End Sub

Public Sub DeleteAtributosEntidad(istrTipoEntidad, istrCodigoEntidad)
Dim sQuery As String

  sQuery = "DELETE FROM Atributos WHERE TipoEntidad = " & StringDB(CStr(istrTipoEntidad)) & " AND CodigoEntidad = " & StringDB(CStr(istrCodigoEntidad)) & ";"
  dbHandle.Execute sQuery

End Sub

Public Function IniciarIteradorEntidad(istrTipoEntidad, istrCodigoEntidad) As Boolean
Dim sQuery As String

  If Not rsIterador Is Nothing Then
    IniciarIteradorEntidad = False
    Exit Function
  End If

  sQuery = "SELECT * FROM Atributos WHERE TipoEntidad = " & StringDB(CStr(istrTipoEntidad)) & " AND CodigoEntidad = " & StringDB(CStr(istrCodigoEntidad)) & " ORDER BY CodigoAtributo, ValorAtributo;"
  Set rsIterador = dbHandle.Execute(sQuery)
  If rsIterador.EOF Then
    rsIterador.Close
    Set rsIterador = Nothing
    IniciarIteradorEntidad = False
    Exit Function
  End If

  IniciarIteradorEntidad = True

End Function

Public Function NextAtributoEntidad() As clsAtributoEntidad
Dim pAtributo As clsAtributoEntidad

  If rsIterador Is Nothing Then
    Set NextAtributoEntidad = Nothing
    Exit Function
  End If
  
  If rsIterador.EOF Then
    rsIterador.Close
    Set rsIterador = Nothing
    Set NextAtributoEntidad = Nothing
    Exit Function
  End If

  Set pAtributo = New clsAtributoEntidad
  With pAtributo
  .CodigoAtributo = GetStringFromVariant(rsIterador!CodigoAtributo)
  .CodigoEntidad = GetStringFromVariant(rsIterador!CodigoEntidad)
  .TipoEntidad = GetStringFromVariant(rsIterador!TipoEntidad)
  .ValorAtributo = GetStringFromVariant(rsIterador!ValorAtributo)
  End With
  
  rsIterador.MoveNext
  
  Set NextAtributoEntidad = pAtributo

End Function

Private Sub Class_Terminate()

  If Not rsIterador Is Nothing Then
    rsIterador.Close
    Set rsIterador = Nothing
  End If

End Sub

Public Function TieneAtributo(sTipoEntidad As String, sCodigoEntidad As String, sAtributo As String, Optional vValor As Variant) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

  sQuery = "SELECT * FROM Atributos WHERE TipoEntidad = " & StringDB(sTipoEntidad) & " "
  sQuery = sQuery & "AND CodigoEntidad = " & StringDB(sCodigoEntidad) & " "
  sQuery = sQuery & "AND CodigoAtributo = " & StringDB(sAtributo)
  
  Set rs = dbHandle.Execute(sQuery)

  If IsMissing(vValor) Then
    bRetVal = Not rs.EOF
  Else
    bRetVal = False
    Do While Not rs.EOF And Not bRetVal
      If VBA.IsNumeric(vValor) Then
        If vValor = GetNumeroFromVariant(rs!ValorAtributo) Then
          bRetVal = True
        End If
      ElseIf isDate(vValor) And isDate(rs!ValorAtributo) Then
        If vValor = CDate(rs!ValorAtributo) Then
          bRetVal = True
        End If
      Else
        If vValor = rs!ValorAtributo Then
          bRetVal = True
        End If
      End If

      If Not bRetVal Then
        rs.MoveNext
      End If
    Loop
  End If
  
  rs.Close
  Set rs = Nothing
  TieneAtributo = bRetVal
  
End Function

Public Function ValAtributo(sTipoEntidad As String, sCodigoEntidad As String, sAtributo As String) As Variant
Dim rs As Recordset, sQuery As String, bRetVal As Boolean, vRetVal As Variant

  sAtributo = Trim(UCase(sAtributo))
  sQuery = "SELECT * FROM Atributos WHERE TipoEntidad = " & StringDB(sTipoEntidad) & " "
  sQuery = sQuery & "AND CodigoEntidad = " & StringDB(sCodigoEntidad) & " "
  sQuery = sQuery & "AND CodigoAtributo = " & StringDB(sAtributo)

  Set rs = dbHandle.Execute(sQuery)

  If Not rs.EOF Then
    vRetVal = rs.Fields("ValorAtributo")
  End If
  
  rs.Close
  Set rs = Nothing

  ValAtributo = vRetVal

End Function

Public Function Atributos(sTipoEntidad As String, sCodigoEntidad As String, Optional ByVal sCodigoAtributo As String = "") As Collection
Dim rs As Recordset, retCol As Collection, pAtributo As clsAtributoEntidad
Dim sQuery As String

  sQuery = "SELECT * FROM Atributos WHERE TipoEntidad = " & StringDB(sTipoEntidad) & " "
  sQuery = sQuery & "AND CodigoEntidad = " & StringDB(sCodigoEntidad)
  If sCodigoAtributo <> "" Then
    sQuery = sQuery & " AND CodigoAtributo = " & StringDB(UCase(sCodigoAtributo))
  End If
  sQuery = sQuery & " ORDER BY CodigoAtributo, ValorAtributo;"

  Set rs = dbHandle.Execute(sQuery)
  Set retCol = New Collection
  If Not rs.EOF Then
    Do
      Set pAtributo = New clsAtributoEntidad
      With pAtributo
      .CodigoAtributo = rs!CodigoAtributo
      .CodigoEntidad = rs!CodigoEntidad
      .TipoEntidad = rs!TipoEntidad
      .ValorAtributo = rs!ValorAtributo
      End With
      retCol.Add pAtributo
      rs.MoveNext
    Loop While Not rs.EOF
  End If
  rs.Close
  Set rs = Nothing
  
  Set Atributos = retCol

End Function

Public Sub SetValorAtributo(sTipoEntidad As String, sCodigoEntidad As String, sCodigoAtributo As String, vNewVal As Variant)
Dim sQuery As String, sArg As String, ra As Long, rs As Recordset

  On Error GoTo ErrHandler

  If VBA.IsNumeric(vNewVal) Then
    sArg = Str(vNewVal)
  ElseIf isDate(vNewVal) Then
    sArg = Format(vNewVal, "General Date")
  Else
    sArg = vNewVal
  End If
  
  sQuery = "SELECT COUNT(*) FROM Atributos WHERE  TipoEntidad = " & StringDB(sTipoEntidad) & " "
  sQuery = sQuery & "AND CodigoEntidad = " & StringDB(sCodigoEntidad) & " "
  sQuery = sQuery & "AND CodigoAtributo = " & StringDB(sCodigoAtributo)
  Set rs = dbHandle.Execute(sQuery)
  ra = rs(0)
  rs.Close: Set rs = Nothing
  
  If ra > 0 Then
    sQuery = "UPDATE Atributos SET ValorAtributo = " & StringDB(sArg) & " "
    sQuery = sQuery & "WHERE  TipoEntidad = " & StringDB(sTipoEntidad) & " "
    sQuery = sQuery & "AND CodigoEntidad = " & StringDB(sCodigoEntidad) & " "
    sQuery = sQuery & "AND CodigoAtributo = " & StringDB(sCodigoAtributo)
    dbHandle.Execute sQuery
  Else
    AddAtributo sTipoEntidad, sCodigoEntidad, sCodigoAtributo, vNewVal
  End If
  
  Exit Sub

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsAtributoEntidad::SetValorAtributo"
  Err.Clear

End Sub
