VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAmbiente"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
' clsClassGenerator V1.0
Public Codigo As String
Public Prefijo As String
Public Descripcion As String
Public AccountOffset As Long
Public PorcentajeServicio As Double
Public IndicePrecio As Integer
Public Escala As Double
Public BackColor As Long
Public ColorMesas As Long
Public ColorSillas As Long
Public FormaMesas As Integer
Public FormaSillas As Integer
Public SillasVisibles As Boolean

' Slo para evitar que la aplicacion TENGA que tener conciencia del Almacen
Public Function Ambientes() As Collection
    Set Ambientes = AlmacenAmbientes.Ambientes
End Function

' Rev. 4.1: Se complic la nomenclatura de las cuentas...
' Funciones para extraer referencias a partir del nmero de las cuentas y las propiedades de los componentes
Public Function ExtraerOffset(ByVal iNumero As Long) As Long
Dim i As Long, lNumero As Long
  lNumero = iNumero
  If lNumero >= 10000000 And lNumero <= 100000000 Then    ' Cuentas "de caja"
    ExtraerOffset = 0
    Exit Function
  End If
  If lNumero < 100000 Then        ' Cuentas "libres"
    ExtraerOffset = 0
    Exit Function
  End If                           ' ahora solo quedan las cuentas de ambiente
  If lNumero > 100000000 Then      ' Cuentas con sub-cuentas
    i = lNumero \ 100000000        ' ...ver clculo de i en la funcin siguiente
    i = i - 1
    lNumero = 100001 + i * 10000
    ExtraerOffset = lNumero
    Exit Function
  End If
  ExtraerOffset = (lNumero \ 10000) * 10000 + 1
End Function

Public Function NumeroCuenta(ByVal lNumero As Long) As Long
Dim lRetVal As Long
  If ExtraerOffset(lNumero) = 0 Then
    NumeroCuenta = 0
    Exit Function
  End If
  If lNumero > 100000000 Then
    lRetVal = (lNumero Mod 100000000) \ 100000
  Else
    lRetVal = lNumero Mod 1000
  End If
  NumeroCuenta = lRetVal
End Function

Public Function NumeroSubCuenta(ByVal lNumero As Long) As Long
  If lNumero < 100000000 Then
    NumeroSubCuenta = 0
  Else
    NumeroSubCuenta = lNumero Mod 100000
  End If
End Function

Public Function CalcularNumero(ByVal lNumCuenta As Long, lSubCuenta As Long) As Long
Dim i As Long, n As Long

  If lSubCuenta <> 0 Then
    i = ((Me.AccountOffset - 100001) \ 10000) + 1
    n = i * 100000000 + lNumCuenta * 100000 + lSubCuenta
  Else
    n = AccountOffset - 1 + lNumCuenta
  End If
  
  CalcularNumero = n
  
End Function

Public Function AceptaMesa(nMesa As Integer) As Boolean
Dim rs As Recordset, q As Integer, isOk As Boolean
  
  isOk = True
  
  Set rs = dbHandle.Execute("SELECT COUNT(idMesa) AS Q FROM mesasMesas WHERE Ambiente = " & StringDB(Me.Codigo))
  q = GetNumeroFromVariant(rs.Fields("Q"))
  Set rs = Nothing
  
  If q > 0 Then
    Set rs = dbHandle.Execute("SELECT idMesa FROM mesasMesas WHERE Ambiente = " & StringDB(Me.Codigo) & " AND idMesa = " & NumeroDB(nMesa))
    If rs.EOF Then
      isOk = False
    End If
    Set rs = Nothing
  End If
  
  AceptaMesa = isOk

End Function

Public Function Mesa(Numero As Long) As clsMesa
Dim pMesa As clsMesa

  If Me.LoadByNumero(Numero) Then
    Set pMesa = New clsMesa
    If Not pMesa.Load(Me.Codigo, NumeroCuenta(Numero)) Then
      Set pMesa = Nothing
    End If
  End If
  
  Set Mesa = pMesa

End Function

Public Function Load(isCodigo As String) As Boolean
  Load = Not AlmacenAmbientes.Load(isCodigo, Me) Is Nothing
End Function

Public Function LoadByDescripcion(sDescripcion As String) As Boolean
  LoadByDescripcion = Not AlmacenAmbientes.LoadByDescripcion(sDescripcion, Me) Is Nothing
End Function

Public Function LoadByPrefijo(isCodigo As String) As Boolean
  LoadByPrefijo = Not AlmacenAmbientes.LoadByPrefijo(isCodigo, Me) Is Nothing
End Function

Public Function SaveNew() As Boolean
  SaveNew = AlmacenAmbientes.Add(Me)
End Function

Public Function CreateNew() As Boolean
Dim f As frmAmbiente, sCodigo As String, bResult As Boolean

  Set f = New frmAmbiente
  f.Contexto = 3
  f.Show vbModal
  bResult = f.Result
  If bResult Then bResult = Load(f.txCodigo.Text)
  Unload f
  Set f = Nothing

  CreateNew = bResult

End Function

Public Function CargarMesa(IDMesa As Long) As clsMesa
Dim pMesa As clsMesa

  Set pMesa = New clsMesa
  If Not pMesa.Load(Me.Codigo, IDMesa) Then Set pMesa = Nothing
  Set CargarMesa = pMesa
  Set pMesa = Nothing

End Function

Public Function AgregarMesa(IDMesa As Long, lngX As Long, lngY As Long) As clsMesa
Dim pMesa As clsMesa, bResult As Boolean

  Set pMesa = New clsMesa
  With pMesa
  .Ambiente = Me.Codigo
  .IDMesa = IDMesa
  .X = lngX
  .Y = lngY
  bResult = .SaveNew
  End With
  If Not bResult Then Set pMesa = Nothing
  Set AgregarMesa = pMesa

End Function

Public Function Mesas() As Collection
Dim pMesa As clsMesa, retCol As Collection

  Set pMesa = New clsMesa
  Set retCol = pMesa.MesasAmbiente(Me.Codigo)
  Set pMesa = Nothing

  Set Mesas = retCol

End Function

Public Function UltimaMesa() As Long
Dim rs As Recordset, lRetVal As Long

  Set rs = dbHandle.Execute("SELECT MAX(IdMesa) AS Ultima FROM mesasMesas WHERE Ambiente = " & StringDB(Me.Codigo))
  If rs.EOF Then
      lRetVal = 0
  Else
      lRetVal = GetNumeroFromVariant(rs.Fields("Ultima"))
  End If
  Set rs = Nothing
  
  UltimaMesa = lRetVal
End Function

Public Sub SetEscala(dblEscala As Double)
  Me.Escala = dblEscala
  AlmacenAmbientes.UpdateEscala Me.Codigo, dblEscala
End Sub

Public Sub EliminarMesa(ByVal lIdMesa As Long)
Dim pMesa As clsMesa
  Set pMesa = New clsMesa
  pMesa.Eliminar Codigo, lIdMesa
  Set pMesa = Nothing
End Sub

Public Function LoadByNumero(ByVal lngNumero As Long) As Boolean
  If AlmacenAmbientes Is Nothing Then
    Set AlmacenAmbientes = New clsAlmacenAmbientes
  End If
  LoadByNumero = AlmacenAmbientes.LoadByNumero(Me.ExtraerOffset(lngNumero), Me)
End Function

Private Sub Class_Initialize()
  With Me
  .BackColor = vbWhite
  .ColorMesas = vbWhite
  .ColorSillas = vbWhite
  End With
End Sub
