VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenVendedores"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para cada una de las cuentas de banco almacenadas en el sistema."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' clsClassGenerator V1.0
Option Explicit

Public Function Eliminar(sCodigo As String) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE FROM Vendedores WHERE Codigo = " & StringDB(sCodigo)

ResumePoint:

    Eliminar = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "AlmacenVendedores:Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

Private Sub LoadInstance(pInstance As clsVendedores, rsHandle As Recordset)
    
    With rsHandle
    pInstance.Codigo = .Fields("Codigo")
    pInstance.Nombre = stGetStringFromVariant(.Fields("Nombre"))
    pInstance.ci = stGetStringFromVariant(.Fields("CI"))
    pInstance.Direccion = stGetStringFromVariant(.Fields("Direccion"))
    pInstance.Telefono = stGetStringFromVariant(.Fields("Telefono"))
    pInstance.NoCobraComision = .Fields("NoCobraComision")
    pInstance.TipoComisionVenta = .Fields("TipoComisionVenta")
    pInstance.TipoComisionCobranza = .Fields("TipoComisionCobranza")
    pInstance.SaldoActual = .Fields("SaldoActual")
    End With

End Sub

Public Function Load(Codigo As String, destino As clsVendedores) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute("SELECT * FROM Vendedores WHERE Codigo = " & StringDB(Codigo))
    If Not rs.EOF Then
        LoadInstance destino, rs
        bRetVal = True
    Else
        bRetVal = False
    End If

ResumePoint:
    If Not rs Is Nothing Then
        rs.Close
        Set rs = Nothing
    End If
    Load = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenVendedores.Load"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Vendedor(Codigo) As clsVendedores
Dim cInstance As clsVendedores
    Set cInstance = New clsVendedores
    If Not Load(CStr(Codigo), cInstance) Then
        Set cInstance = Nothing
    End If
    Set Vendedor = cInstance
End Function

Public Function LoadSiguiente(destino As clsVendedores) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Vendedores WHERE Codigo IN (Select Min(Codigo) FROM Vendedores WHERE Codigo > " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "AlmacenVendedores::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadAnterior(destino As clsVendedores) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Vendedores WHERE Codigo IN (Select Max(Codigo) FROM Vendedores WHERE Codigo < " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "AlmacenVendedores::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT Codigo FROM Vendedores WHERE Codigo = " & StringDB(arg)
    Set rs = dbHandle.Execute(sQuery)
    bRetVal = Not rs.EOF

ResumePoint:

    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "AlmacenVendedores::ExisteCodigo", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Crear(Clave As String) As Boolean
    If Not Confirmar("Crear nuevo Vendedor") Then
        Crear = False
        Exit Function
    End If
    OpenFIEVendedores Clave
    Crear = ExisteCodigo(Clave)
End Function

Public Function Validar(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    
    stTemp = Trim(Format(Codigo, ">"))
    Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo"
        bRetVal = False
    Else
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_VENDEDORES) Then
                    bRetVal = False
                Else
                    bRetVal = Crear(stTemp)
                End If
            End If
        End If
    End If
    Validar = bRetVal
End Function

Public Function Add(iItem As clsVendedores) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    sQuery = "INSERT INTO Vendedores (Codigo, Nombre, CI, Direccion, Telefono, NoCobraComision, TipoComisionVenta, TipoComisionCobranza, FechaCreacion) SELECT "
    sQuery = sQuery & StringDB(iItem.Codigo) & ", "
    sQuery = sQuery & StringDB(iItem.Nombre) & ", "
    sQuery = sQuery & StringDB(iItem.ci) & ", "
    sQuery = sQuery & StringDB(iItem.Direccion) & ", "
    sQuery = sQuery & StringDB(iItem.Telefono) & ", "
    sQuery = sQuery & BooleanDB(iItem.NoCobraComision) & ", "
    sQuery = sQuery & NumeroDB(iItem.TipoComisionVenta) & ", "
    sQuery = sQuery & NumeroDB(iItem.TipoComisionCobranza) & ", "
    sQuery = sQuery & TimeDateDB(Now) & ";"
    
    dbHandle.Execute sQuery

ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenVendedores.Add"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(instance As clsVendedores, iNombre As String, iCI As String, iDireccion As String, iTelefono As String, iNoCobraComision As Boolean, iTipoComisionVenta As Integer, iTipoComisionCobranza As Integer) As Boolean
Dim bRetVal As Boolean, sQuery As String
Dim ra As Long, rs As Recordset
    
  On Error GoTo ErrHandler
  bRetVal = True
  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM Vendedores WHERE Codigo = " & StringDB(instance.Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing
  If ra > 0 Then
    sQuery = "UPDATE Vendedores SET "
    sQuery = sQuery & "Nombre = " & StringDB(iNombre) & ", "
    sQuery = sQuery & "CI = " & StringDB(iCI) & ", "
    sQuery = sQuery & "Direccion = " & StringDB(iDireccion) & ", "
    sQuery = sQuery & "Telefono = " & StringDB(iTelefono) & ", "
    sQuery = sQuery & "NoCobraComision = " & BooleanDB(iNoCobraComision) & ", "
    sQuery = sQuery & "TipoComisionVenta = " & NumeroDB(iTipoComisionVenta) & ", "
    sQuery = sQuery & "TipoComisionCobranza = " & NumeroDB(iTipoComisionCobranza) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(instance.Codigo) & ";"
  Else
    sQuery = "INSERT INTO Vendedores (Codigo, Nombre, CI, Direccion, Telefono, NoCobraComision, TipoComisionVenta, TipoComisionCobranza) SELECT "
    sQuery = sQuery & StringDB(instance.Codigo) & ", "
    sQuery = sQuery & StringDB(iNombre) & ", "
    sQuery = sQuery & StringDB(iCI) & ", "
    sQuery = sQuery & StringDB(iDireccion) & ", "
    sQuery = sQuery & StringDB(iTelefono) & ", "
    sQuery = sQuery & BooleanDB(iNoCobraComision) & ", "
    sQuery = sQuery & NumeroDB(iTipoComisionVenta) & ", "
    sQuery = sQuery & NumeroDB(iTipoComisionCobranza) & " " & ";"
  End If
      
  dbHandle.Execute sQuery

ResumePoint:
  ActualizarDescriptivos = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenVendedores.ActualizarDescriptivos"
  bRetVal = False
  Resume ResumePoint

End Function

Public Function RegistrarVariacionSaldo(inst As clsVendedores, ByVal vmVariacion As Currency) As Boolean
Dim bRetVal As Boolean
    bRetVal = implementacionISPC.RegistrarVariacionSaldo("Vendedores", inst, vmVariacion)
    RegistrarVariacionSaldo = bRetVal
End Function


