VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenSaldosEntidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' ---------------------------------------------------------------------
' Revisada el 22-03-2003 para que devuelva el saldo inicial del primer
' periodo registrado cuando el perodo requerido es anterior a ese.
' ---------------------------------------------------------------------
Public Function LoadSaldoCuenta(CodigoEntidad As String, TipoEntidad As String, ByVal Periodo As Long) As clsSaldoEntidadPeriodo
Dim scpRetVal As clsSaldoEntidadPeriodo, rs As Recordset, sQuery As String

  sQuery = "SELECT * FROM SaldosEntidadPeriodo "
  sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
  sQuery = sQuery & "AND TipoEntidad = " & StringDB(TipoEntidad) & " "
  sQuery = sQuery & "AND NumeroPeriodo IN "
  sQuery = sQuery & "(SELECT MAX(NumeroPeriodo) FROM SaldosEntidadPeriodo "
  sQuery = sQuery & "   WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
  sQuery = sQuery & "   AND TipoEntidad = " & StringDB(TipoEntidad) & " "
  sQuery = sQuery & "   AND NumeroPeriodo <= " & NumeroDB(Periodo) & ");"
  
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    Set scpRetVal = Nothing
  Else
    Set scpRetVal = New clsSaldoEntidadPeriodo
    With scpRetVal
      .CodigoEntidad = GetStringFromVariant(rs.Fields("CodigoEntidad"))
      .TipoEntidad = GetStringFromVariant(rs.Fields("TipoEntidad"))
      .Creditos = GetNumeroFromVariant(rs.Fields("Creditos"))
      .Debitos = GetNumeroFromVariant(rs.Fields("Debitos"))
      .NumeroPeriodo = GetNumeroFromVariant(rs.Fields("NumeroPeriodo"))
      .SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial"))
    End With
  End If
  rs.Close
  Set rs = Nothing

  If scpRetVal Is Nothing Then    ' Ajustar si hay un SCP para la cuenta, para un perodo anterior:
    sQuery = "SELECT * FROM SaldosEntidadPeriodo "
    sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
    sQuery = sQuery & "AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "AND NumeroPeriodo IN "
    sQuery = sQuery & "(SELECT MIN(NumeroPeriodo) FROM SaldosEntidadPeriodo "
    sQuery = sQuery & "   WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
    sQuery = sQuery & "   AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "   AND NumeroPeriodo > " & NumeroDB(Periodo) & ");"

    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
      Set scpRetVal = Nothing
    Else
      Set scpRetVal = New clsSaldoEntidadPeriodo
      With scpRetVal
        .CodigoEntidad = GetStringFromVariant(rs.Fields("CodigoEntidad"))
        .TipoEntidad = GetStringFromVariant(rs.Fields("TipoEntidad"))
        .Creditos = 0
        .Debitos = 0
        .NumeroPeriodo = Periodo
        .SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial"))
      End With
    End If
    rs.Close
    Set rs = Nothing
  End If

  If scpRetVal Is Nothing Then
    Set scpRetVal = New clsSaldoEntidadPeriodo
    scpRetVal.TipoEntidad = TipoEntidad
    scpRetVal.CodigoEntidad = CodigoEntidad
    scpRetVal.SaldoInicial = 0
    scpRetVal.NumeroPeriodo = Periodo
    scpRetVal.Debitos = 0#
    scpRetVal.Creditos = 0#
  Else
    If scpRetVal.NumeroPeriodo < Periodo Then
      scpRetVal.SaldoInicial = scpRetVal.SaldoInicial + scpRetVal.Debitos - scpRetVal.Creditos
      scpRetVal.NumeroPeriodo = Periodo
      scpRetVal.Creditos = 0#
      scpRetVal.Debitos = 0#
    End If                          ' Se cre un control, cuyo saldo inicial es igual al "saldo final" del anterior, con DB y CR = 0
  End If
  Set LoadSaldoCuenta = scpRetVal

End Function

' clsAlmacenSaldos.RegistrarVariacion es llamada desde los metodos de cambio de
' estado de la categora controlada para cada Tipo de Entidad
' Si Reverse, en vez de sumar el valor al lado correspondiente, lo resta del lado contrario.
' -------------------------------------------------
Public Sub RegistrarVariacion(CodigoEntidad As String, TipoEntidad As String, Periodo As Long, ByVal Variacion As Double, Reverse As Boolean)
Dim PeriodoActual As Long, _
    ProximoPeriodo As Long
Dim SaldoInicial As Double, sDestField As String
Dim lPeriodo As Long, bExiste As Boolean
Dim rs As Recordset, sQuery As String

' 1.- Determinar si hay un registro de control para el perodo:
    sQuery = "SELECT * FROM SaldosEntidadPeriodo "
    sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
    sQuery = sQuery & "AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "AND NumeroPeriodo IN "
    sQuery = sQuery & "(SELECT MAX(NumeroPeriodo) FROM SaldosEntidadPeriodo "
    sQuery = sQuery & "   WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
    sQuery = sQuery & "   AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "   AND NumeroPeriodo <= " & NumeroDB(Periodo) & ");"
    
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then  ' Es el primer movimiento de la entidad
        bExiste = False
        SaldoInicial = 0
    ElseIf GetNumeroFromVariant(rs.Fields("NumeroPeriodo")) < Periodo Then  ' Es el primer movimiento en el periodo
        bExiste = False
        SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial")) + GetNumeroFromVariant(rs.Fields("Debitos")) - GetNumeroFromVariant(rs.Fields("Creditos"))
    Else
        bExiste = True
    End If
    rs.Close
    Set rs = Nothing

    If Not bExiste Then     ' Crear registro
        If Not CrearRegistro(CodigoEntidad, TipoEntidad, Periodo, SaldoInicial) Then
            Err.Raise 10001, "AlmacenSaldosEntidad::RegistrarVariacion", "Error en Creacion de Nuevo Registro"
            Exit Sub
        End If
    End If

    If Variacion < 0 Then
        sDestField = "Creditos"
    Else
        sDestField = "Debitos"
    End If

    sQuery = "UPDATE SaldosEntidadPeriodo SET " & sDestField & " = " & sDestField & " + " & NumeroDB(Abs(Variacion)) & " "
    sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
    sQuery = sQuery & "AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "AND NumeroPeriodo = " & NumeroDB(Periodo)
    
    dbHandle.Execute sQuery     ' Listo el primer periodo

    sQuery = "UPDATE SaldosEntidadPeriodo SET SaldoInicial = SaldoInicial + (" & NumeroDB(Variacion) & ") "
    sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " "
    sQuery = sQuery & "AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "AND NumeroPeriodo > " & NumeroDB(Periodo)
    
    dbHandle.Execute sQuery     ' Listos los periodos adicionales

End Sub

Public Function CrearRegistro(stCodigo As String, TipoEntidad As String, lPeriodo As Long, lfSaldoInicial As Double) As Boolean
' Crea un registro "en blanco", para el primer periodo de una cuenta de resultados...
' Es usado exclusivamente por clsEmpresa, durant eel proceso de cierre.
Dim bRetVal As Boolean, sQuery As String

    bRetVal = True
    sQuery = "INSERT INTO SaldosEntidadPeriodo (CodigoEntidad, TipoEntidad, NumeroPeriodo, SaldoInicial) SELECT "
    sQuery = sQuery & StringDB(stCodigo) & ", " & StringDB(TipoEntidad) & ", " & NumeroDB(lPeriodo) & ", "
    sQuery = sQuery & NumeroDB(lfSaldoInicial)
    
    dbHandle.Execute sQuery
    CrearRegistro = True

End Function

Public Sub LlenarSaldosEntidad(stEntidad As String, TipoEntidad As String, ByVal PeriodoInicial As Long, ByVal PeriodoFinal As Long, colDestino As Collection)
Dim nextPeriodo As Long, instSaldo As clsSaldoEntidadPeriodo
Dim sQuery As String, rs As Recordset

    sQuery = "SELECT * FROM SaldosEntidadPeriodo "
    sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(stEntidad) & " "
    sQuery = sQuery & "AND TipoEntidad = " & StringDB(TipoEntidad) & " "
    sQuery = sQuery & "AND NumeroPeriodo BETWEEN " & NumeroDB(PeriodoInicial) & " AND " & NumeroDB(PeriodoFinal) & ";"

    Set rs = dbHandle.Execute(sQuery)
    Do While Not rs.EOF
        Set instSaldo = New clsSaldoEntidadPeriodo
        instSaldo.CodigoEntidad = rs.Fields("CodigoEntidad")
        instSaldo.TipoEntidad = rs.Fields("TipoEntidad")
        instSaldo.NumeroPeriodo = rs.Fields("NumeroPeriodo")
        instSaldo.Debitos = rs.Fields("Debitos")
        instSaldo.Creditos = rs.Fields("Creditos")
        instSaldo.SaldoInicial = rs.Fields("SaldoInicial")
        colDestino.Add instSaldo
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing

End Sub

