VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenSaldos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Intefaz entre clsSaldoCuentaPeriodo y a BD"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' En principio, solamente la clase "cls<NombreEntidad>" debe tener
' conocimiento de la clase "clsAlmacen<NombreEntidad>". De momento
' me parece un poco artificial, rebuscado; pero la implementacion
' de los mtodos de almacenamiento debe estar tan alejada de la
' aplicacin como sea posible.

Option Explicit

Private cSCP As clsSaldoCuentaPeriodo

Public Function LoadSaldoCuenta(ByVal Cuenta As String, ByVal Periodo As Long) As clsSaldoCuentaPeriodo
Dim scpRetVal As clsSaldoCuentaPeriodo, rs As Recordset, sQuery As String

    sQuery = "SELECT * FROM SaldosPeriodo WHERE CodigoCuenta = " & StringDB(Cuenta)
    sQuery = sQuery & " AND NumeroPeriodo IN (SELECT MAX(NumeroPeriodo) FROM SaldosPeriodo WHERE NumeroPeriodo <= " & NumeroDB(Periodo) & " AND CodigoCuenta = " & StringDB(Cuenta) & ");"
    
    Set scpRetVal = New clsSaldoCuentaPeriodo
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        If GetNumeroFromVariant(rs.Fields("NumeroPeriodo")) = Periodo Then
            With scpRetVal
            .codigoCuenta = rs.Fields("CodigoCuenta")
            .Creditos = GetNumeroFromVariant(rs.Fields("Creditos"))
            .Debitos = GetNumeroFromVariant(rs.Fields("Debitos"))
            .NumeroPeriodo = GetNumeroFromVariant(rs.Fields("NumeroPeriodo"))
            .SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial"))
            End With
        Else
            With scpRetVal
            .codigoCuenta = rs.Fields("CodigoCuenta")
            .Creditos = 0
            .Debitos = 0
            .NumeroPeriodo = Periodo
            .SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial")) + GetNumeroFromVariant(rs.Fields("Debitos")) - GetNumeroFromVariant(rs.Fields("Creditos"))
            End With
        End If
    Else
        With scpRetVal
        .SaldoInicial = 0
        .NumeroPeriodo = Periodo
        .Debitos = 0#
        .Creditos = 0#
        End With
    End If
    
    rs.Close
    Set rs = Nothing

    Set LoadSaldoCuenta = scpRetVal

End Function

' clsAlmacenSaldos.RegistrarVariacion es llamada desde clsCuenta.RegistrarVariacion
' Si Reverse, en vez de sumar el valor al lado correspondiente, lo resta del lado contrario.
' -------------------------------------------------
' Si Cierre, no se registra EL MOVIMIENTO (i.e. no se alteran los DB y CR del perodo), y
' se permite el asiento a un perodo POSTERIOR al activo en la empresa seleccionada (dado
' que el cierre se ejecuta CONTRA un perodo posterior (generalmente el siguiente) al actual.
Public Sub RegistrarVariacion(Cuenta As String, Periodo As Long, ByVal Variacion As Double, Reverse As Boolean, Cierre As Boolean)
Attribute RegistrarVariacion.VB_Description = "Actualiza los debitos o creditos de una cuenta para el periodo en que se produjo el movimiento, y todos los saldo iniciales desde all en adelante"
Dim PeriodoActual As Long, ProximoPeriodo As Long
Dim bSeekRes As Boolean, bFound As Boolean
Dim SaldoInicial As Double
Dim lPeriodo As Long, lPeriodoLimite As Long, isResultado As Boolean
Dim instCuenta As clsCuenta, instSaldo As clsSaldoCuentaPeriodo
Dim rs As Recordset, sQuery As String, sFieldID As String, sExpression As String

    PeriodoActual = Empresa.refPeriodoActual

    If Not Cierre And (Periodo > PeriodoActual) Then   ' esto nunca debe pasar, pero...
        mAdvertencia "ERROR: Intento de registrar VarSaldo" & Chr(13) & "para un perodo no abierto:" & Str(Periodo)
        Exit Sub
    End If

    Set instCuenta = New clsCuenta
    If Not instCuenta.Load(Cuenta) Then
        Set instCuenta = Nothing
        Err.Raise 10001, "AlmacenSaldos", "Cuenta " & Cuenta & " no localizada en RegistrarVariacion"
        Exit Sub
    End If

    isResultado = (instCuenta.Funcion = 4) Or (instCuenta.Funcion = 5)

    Set rs = dbHandle.Execute("SELECT * FROM SaldosPeriodo WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND NumeroPeriodo = " & NumeroDB(Periodo))
    bFound = Not rs.EOF
    Set rs = Nothing

    If Not bFound Then      ' Hay que buscar un registro anterior, para determinar el Saldo Inicial
        sQuery = "SELECT * FROM SaldosPeriodo WHERE " & _
                    "CodigoCuenta = " & StringDB(Cuenta) & " " & _
                    "AND NumeroPeriodo IN " & _
                        "(SELECT Max(NumeroPeriodo) FROM SaldosPeriodo WHERE " & _
                            "CodigoCuenta = " & StringDB(Cuenta) & " " & _
                            "AND NumeroPeriodo < " & NumeroDB(Periodo) & ")"
        Set rs = dbHandle.Execute(sQuery)
        If rs.EOF Then
            SaldoInicial = 0
        Else
            SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial")) + GetNumeroFromVariant(rs.Fields("Debitos")) - GetNumeroFromVariant(rs.Fields("Creditos"))
        End If
        Set rs = Nothing

        sQuery = "INSERT INTO SaldosPeriodo (CodigoCuenta, NumeroPeriodo, SaldoInicial) SELECT "
        sQuery = sQuery & StringDB(Cuenta) & ", "
        sQuery = sQuery & NumeroDB(Periodo) & ", "
        sQuery = sQuery & NumeroDB(SaldoInicial)
        dbHandle.Execute sQuery     ' El nuevo registro ha sido agregado
    End If

    ' Actualizar primer registro:
    
    If Not Cierre Then  ' Registrar EL MOVIMIENTO (variacion en el periodo) slo si NO se trata de un cierre
        If Variacion < 0 Then
            If Not Reverse Then
                sExpression = "Creditos = Creditos - (" & NumeroDB(Variacion) & ")"
            Else
                sExpression = "Debitos = Debitos + " & NumeroDB(Variacion)
            End If
        Else
            If Not Reverse Then
                sExpression = "Debitos = Debitos + " & NumeroDB(Variacion)
            Else
                sExpression = "Creditos = Creditos - " & NumeroDB(Variacion)
            End If
        End If
        sQuery = "UPDATE SaldosPeriodo SET " & sExpression & " WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND NumeroPeriodo = " & NumeroDB(Periodo)
    Else
        sQuery = "UPDATE SaldosPeriodo SET SaldoInicial = SaldoInicial + (" & NumeroDB(Variacion) & ") WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND NumeroPeriodo = " & NumeroDB(Periodo)
    End If

    dbHandle.Execute sQuery
    ' ----- Actualizar primer registro
    ' Registros posteriores:
    ProximoPeriodo = nextPeriodo(Periodo)     ' Primer perodo a actualizar
    lPeriodoLimite = PeriodoActual

    If isResultado Then
        ' Si es una cuenta de resultado, slo se actualiza en ella hasta el ltimo
        ' periodo del ao. De lo contrario, se prosigue hasta el perodo actual
        If AnhoPeriodo(Periodo) < Empresa.AnhoActual Then
            lPeriodoLimite = mPeriodos.refPeriodo(mPeriodos.AnhoPeriodo(Periodo), 12)
        End If
    End If

    If lPeriodoLimite >= ProximoPeriodo Then    ' No vaya a ser que el servidor se queje...
        sQuery = "UPDATE SaldosPeriodo SET SaldoInicial = SaldoInicial + (" & NumeroDB(Variacion) & ") " & _
                    "WHERE CodigoCuenta = " & StringDB(Cuenta) & " " & _
                    "AND NumeroPeriodo BETWEEN " & NumeroDB(ProximoPeriodo) & " AND " & NumeroDB(lPeriodoLimite)
        dbHandle.Execute sQuery
    End If
        
    If lPeriodoLimite < PeriodoActual Then
    ' Era una cuenta de resultado, y pertenecia a algun ao anterior
    ' Si estamos aqu, es porque:
    '   isResultado = True
    '   mPeriodos.PeriodoPeriodo(lPeriodoLimite) == 12
        ProximoPeriodo = nextPeriodo(lPeriodoLimite) ' Debe ser el primer periodo del nuevo ao
        Set rs = dbHandle.Execute("SELECT * FROM SaldosPeriodo WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND NumeroPeriodo = " & NumeroDB(ProximoPeriodo))
        If rs.EOF Then
            CrearRegistro Cuenta, ProximoPeriodo, 0
        End If
        Set rs = Nothing
        
        If instCuenta.Status = 2 Then ' Slo para las cuentas de detalle
            If instCuenta.Load(Empresa.CuentaGanPer) Then
                instCuenta.RegistrarVariacion Variacion, ProximoPeriodo, Reverse, True
            End If
        End If
    End If
    Set instCuenta = Nothing

End Sub

Public Function CrearRegistro(stCodigo As String, lPeriodo As Long, lfSaldoInicial As Double) As Boolean
' Crea un registro "en blanco", para el primer periodo de una cuenta de resultados...
Dim sQuery As String, isOk As Boolean, CopiaCodigo As String

    On Error GoTo ErrHandler
    isOk = True
    sQuery = "INSERT INTO SaldosPeriodo (CodigoCuenta, NumeroPeriodo, SaldoInicial) SELECT "
    sQuery = sQuery & StringDB(stCodigo) & ", "
    sQuery = sQuery & NumeroDB(lPeriodo) & ", "
    sQuery = sQuery & NumeroDB(lfSaldoInicial)
    dbHandle.Execute sQuery

ResumePoint:
    CrearRegistro = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenSaldos::CrearRegistro"
    AbortTransaction
    isOk = False
    Resume ResumePoint
    
End Function

Public Sub LlenarSaldosCuenta(stCuenta As String, ByVal PeriodoInicial As Long, ByVal PeriodoFinal As Long, colDestino As Collection)
Dim nextPeriodo As Long, instSaldo As clsSaldoCuentaPeriodo, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM SaldosPeriodo WHERE CodigoCuenta = " & StringDB(stCuenta) & " AND NumeroPeriodo BETWEEN " & NumeroDB(PeriodoInicial) & " AND " & NumeroDB(PeriodoFinal) & ";")
    Do While Not rs.EOF
        Set instSaldo = New clsSaldoCuentaPeriodo
        instSaldo.codigoCuenta = rs.Fields("CodigoCuenta")
        instSaldo.NumeroPeriodo = rs.Fields("NumeroPeriodo")
        instSaldo.Creditos = rs.Fields("Creditos")
        instSaldo.Debitos = rs.Fields("Debitos")
        instSaldo.SaldoInicial = rs.Fields("SaldoInicial")
        colDestino.Add instSaldo
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing

End Sub

Public Function BalanceCuentaIntervalo(codigoCuenta As String, RefInicio As Long, RefFinal As Long) As Double
Dim rsHandle As Recordset, sqlQuery As String, Total As Double

    sqlQuery = "SELECT (Sum(Debitos) - Sum(Creditos)) AS Resultado "
    sqlQuery = sqlQuery & "From SaldosPeriodo "
    sqlQuery = sqlQuery & "WHERE CodigoCuenta = " & StringDB(codigoCuenta) & " "
    sqlQuery = sqlQuery & "and NumeroPeriodo BETWEEN " & NumeroDB(RefInicio) & " AND " & NumeroDB(RefFinal) & ";"
    Set rsHandle = dbHandle.Execute(sqlQuery)
    With rsHandle
    If .EOF Then
        Total = 0
    Else
        .MoveFirst
        Total = GetNumeroFromVariant(.Fields("Resultado"))
    End If
    .Close
    End With
    Set rsHandle = Nothing
    BalanceCuentaIntervalo = Total
End Function

Private Sub Class_Initialize()
    Set cSCP = New clsSaldoCuentaPeriodo    ' Crea la instancia de trabajo
End Sub

Private Sub Class_Terminate()
    Set cSCP = Nothing                      ' Destruye la instancia de trabajo
End Sub


