VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenProveedores"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para cada una de las cuentas de banco almacenadas en el sistema."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' clsClassGenerator V1.0
Option Explicit

Public Function Eliminar(sCodigo As String) As Boolean
Dim bRetVal As Boolean

  On Error GoTo ErrHandler
  bRetVal = True
  dbHandle.Execute "DELETE FROM Proveedores WHERE Codigo = " & StringDB(sCodigo)

ResumePoint:
  Eliminar = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenProveedores:Eliminar"
  bRetVal = False
  Resume ResumePoint

End Function

Private Sub LoadInstance(rsHandle As Recordset, Optional pDest As clsProveedores = Nothing)
Dim lpDest As clsProveedores

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With rsHandle
    lpDest.Codigo = stGetStringFromVariant(.Fields("Codigo"))
    lpDest.Nombre = stGetStringFromVariant(.Fields("Nombre"))
    lpDest.RIF = stGetStringFromVariant(.Fields("RIF"))
    lpDest.CuentaPasivo = stGetStringFromVariant(.Fields("CGCuenta"))
    lpDest.Condiciones = stGetStringFromVariant(.Fields("Condiciones"))
    lpDest.Direccion1 = stGetStringFromVariant(.Fields("Direccion1"))
    lpDest.Direccion2 = stGetStringFromVariant(.Fields("Direccion2"))
    lpDest.Direccion3 = stGetStringFromVariant(.Fields("Direccion3"))
    lpDest.Direccion4 = stGetStringFromVariant(.Fields("Direccion4"))
    lpDest.Telefono = stGetStringFromVariant(.Fields("Telefono"))
    lpDest.SaldoActual = GetNumeroFromVariant(.Fields("SaldoActual"))
    lpDest.LimiteCredito = GetNumeroFromVariant(.Fields("LimiteCredito"))
    lpDest.FechaUltimaCompra = GetDateFromVariant(.Fields("FechaUltimaCompra"))
    lpDest.Notas = stGetStringFromVariant(.Fields("Notas"))
    End With

End Sub

Public Function Load(Codigo As String, Optional destino As clsProveedores = Nothing) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT * FROM Proveedores WHERE Codigo = " & StringDB(Codigo)
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, destino
    End If

ResumePoint:

    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    
    Err.Raise Err.Number, "clsProveedores::Load", Err.Description
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function LoadAnterior(Optional destino As clsProveedores = Nothing) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
Dim pInstance As clsProveedores

    If destino Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = destino
    End If
    
    sQuery = "SELECT * FROM Proveedores WHERE Codigo IN (Select Max(Codigo) FROM Proveedores WHERE Codigo < " & StringDB(pInstance.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance rs, pInstance
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsProveedores::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadSiguiente(Optional destino As clsProveedores = Nothing) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
Dim pInstance As clsProveedores

    If destino Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = destino
    End If
    sQuery = "SELECT * FROM Proveedores WHERE Codigo IN (Select Min(Codigo) FROM Proveedores WHERE Codigo > " & StringDB(pInstance.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance rs, pInstance
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsProveedores::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function Proveedor(Codigo As String) As clsProveedores
Dim cInstance As clsProveedores
    Set cInstance = New clsProveedores
    If Not Load(Codigo, cInstance) Then
        Set cInstance = Nothing
    End If
    Set Proveedor = cInstance
End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT Codigo FROM Proveedores WHERE Codigo = " & StringDB(arg)
    Set rs = dbHandle.Execute(sQuery)
    bRetVal = Not rs.EOF

ResumePoint:

    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsProveedores::ExisteCodigo", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Crear(Clave As String) As Boolean
    If Not Confirmar("Crear nuevo Proveedor") Then
        Crear = False
        Exit Function
    End If
    OpenFIEProveedor Clave
    Crear = ExisteCodigo(Clave)
End Function

Public Function Validar(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    stTemp = Trim(Format(Codigo, ">"))
    Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo"
        bRetVal = False
    Else
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_PROVEEDORES) Then
                    bRetVal = False
                Else
                    bRetVal = Crear(stTemp)
                End If
            End If
        End If
    End If
    Validar = bRetVal
End Function

Public Function Add(iItem As clsProveedores) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "INSERT INTO Proveedores (Codigo, Nombre, RIF, CGCuenta, Condiciones, Direccion1, Direccion2, Direccion3, Direccion4, Telefono, LimiteCredito, FechaUltimaCompra, Notas, FechaCreacion) VALUES ("
    sQuery = sQuery & StringDB(iItem.Codigo)
    sQuery = sQuery & "," & StringDB(iItem.Nombre)
    sQuery = sQuery & "," & StringDB(iItem.RIF)
    sQuery = sQuery & "," & StringDB(iItem.CuentaPasivo)
    sQuery = sQuery & "," & StringDB(iItem.Condiciones)
    sQuery = sQuery & "," & StringDB(iItem.Direccion1)
    sQuery = sQuery & "," & StringDB(iItem.Direccion2)
    sQuery = sQuery & "," & StringDB(iItem.Direccion3)
    sQuery = sQuery & "," & StringDB(iItem.Direccion4)
    sQuery = sQuery & "," & StringDB(iItem.Telefono)
    sQuery = sQuery & "," & NumeroDB(iItem.LimiteCredito)
    sQuery = sQuery & "," & FechaDB(iItem.FechaUltimaCompra)
    sQuery = sQuery & "," & StringDB(iItem.Notas)
    sQuery = sQuery & "," & TimeDateDB(Now)
    sQuery = sQuery & ");"

    dbHandle.Execute sQuery

ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    bRetVal = False
    ReportarError False, Err.Number, Err.Description, "clsProveedores::Add"
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(instance As clsProveedores, iNombre As String, iRif As String, iCuentaPasivo As String, iCondiciones As String, iDireccion1 As String, iDireccion2 As String, iDireccion3 As String, iDireccion4 As String, iTelefono As String, iLimiteCredito As Double, iNotas As String) As Boolean
Dim sQuery As String, bRetVal As Boolean
Dim ra As Long, rs As Recordset

  On Error GoTo ErrHandler
  bRetVal = True
  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM Proveedores WHERE Codigo = " & StringDB(instance.Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing

  If ra > 0 Then
    sQuery = "UPDATE Proveedores SET "
    sQuery = sQuery & "Nombre = " & StringDB(iNombre)
    sQuery = sQuery & ", RIF = " & StringDB(iRif)
    sQuery = sQuery & ", CGCuenta = " & StringDB(iCuentaPasivo)
    sQuery = sQuery & ", Condiciones = " & StringDB(iCondiciones)
    sQuery = sQuery & ", Direccion1 = " & StringDB(iDireccion1)
    sQuery = sQuery & ", Direccion2 = " & StringDB(iDireccion2)
    sQuery = sQuery & ", Direccion3 = " & StringDB(iDireccion3)
    sQuery = sQuery & ", Direccion4 = " & StringDB(iDireccion4)
    sQuery = sQuery & ", Telefono = " & StringDB(iTelefono)
    sQuery = sQuery & ", LimiteCredito = " & NumeroDB(iLimiteCredito)
    sQuery = sQuery & ", Notas = " & StringDB(iNotas)
    sQuery = sQuery & " WHERE Codigo = " & StringDB(instance.Codigo)
  Else
    sQuery = "INSERT INTO Proveedores (Codigo, Nombre, RIF, CGCuenta, Condiciones, Direccion1, Direccion2, Direccion3, Direccion4, "
    sQuery = sQuery & "Telefono, LimiteCredito, Notas) SELECT "
    sQuery = sQuery & StringDB(instance.Codigo)
    sQuery = sQuery & "," & StringDB(iNombre)
    sQuery = sQuery & "," & StringDB(iRif)
    sQuery = sQuery & "," & StringDB(iCuentaPasivo)
    sQuery = sQuery & "," & StringDB(iCondiciones)
    sQuery = sQuery & "," & StringDB(iDireccion1)
    sQuery = sQuery & "," & StringDB(iDireccion2)
    sQuery = sQuery & "," & StringDB(iDireccion3)
    sQuery = sQuery & "," & StringDB(iDireccion4)
    sQuery = sQuery & "," & StringDB(iTelefono)
    sQuery = sQuery & "," & NumeroDB(iLimiteCredito)
    sQuery = sQuery & "," & StringDB(iNotas) & ";"
  End If
  
  dbHandle.Execute sQuery

ResumePoint:
  ActualizarDescriptivos = bRetVal
  Exit Function

ErrHandler:
  Err.Raise Err.Number, "clsProveedores::ActualizarDescriptivos", Err.Description
  bRetVal = False
  Resume ResumePoint

End Function

Public Function RegistrarVariacionSaldo(inst As clsProveedores, ByVal vmVariacion As Currency) As Boolean
Dim bRetVal As Boolean
    bRetVal = implementacionISPC.RegistrarVariacionSaldo("Proveedores", inst, vmVariacion)
    RegistrarVariacionSaldo = bRetVal
End Function


