VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenItemsVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private bExportRequired As Boolean

Public Sub LoadInstance(pInstance As clsItemVenta, rsHandle As Recordset)
    
    With rsHandle
    pInstance.Codigo = stGetStringFromVariant(.Fields("Codigo"))
    pInstance.Descripcion = stGetStringFromVariant(.Fields("Descripcion"))
    pInstance.Linea = stGetStringFromVariant(.Fields("Linea"))
    pInstance.CuentaIngreso = stGetStringFromVariant(.Fields("CuentaIngreso"))
    pInstance.CuentaDevolucion = stGetStringFromVariant(.Fields("CuentaDevolucion"))
    pInstance.CuentaCosto = stGetStringFromVariant(.Fields("CuentaCosto"))
    pInstance.Precio1 = GetNumeroFromVariant(.Fields("Precio1"))
    pInstance.Precio2 = GetNumeroFromVariant(.Fields("Precio2"))
    pInstance.Precio3 = GetNumeroFromVariant(.Fields("Precio3"))
    pInstance.Precio4 = GetNumeroFromVariant(.Fields("Precio4"))
    pInstance.TipoImpuesto1 = stGetStringFromVariant(.Fields("TipoImpuesto1"))
    pInstance.TipoImpuesto2 = stGetStringFromVariant(.Fields("TipoImpuesto2"))
    pInstance.CostoStandard = GetNumeroFromVariant(.Fields("CostoStandard"))
    pInstance.PComis1 = GetNumeroFromVariant(.Fields("pComis1"))
    pInstance.PComis2 = GetNumeroFromVariant(.Fields("pComis2"))
    pInstance.PComis3 = GetNumeroFromVariant(.Fields("pComis3"))
    pInstance.Presentacion = stGetStringFromVariant(.Fields("Presentacion"))
    pInstance.CantidadPresentacion = GetNumeroFromVariant(.Fields("CantidadPresentacion"))
    pInstance.Unidad = stGetStringFromVariant(.Fields("Unidad"))
    pInstance.NumeroPLU = GetNumeroFromVariant(.Fields("NumeroPLU"))
    pInstance.PrecioIndexado = GetNumeroFromVariant(.Fields("PrecioIndexado"))
    
    On Error Resume Next
    pInstance.Ubicacion = GetStringFromVariant(.Fields("Ubicacion"))
    If Err.Number <> 0 Then
      Err.Clear
      pInstance.Ubicacion = ""
    End If
    
    On Error Resume Next
    pInstance.ImageFile = GetStringFromVariant(.Fields("ImageFile"))
    If Err.Number <> 0 Then
      Err.Clear
      pInstance.ImageFile = ""
    End If
    
    On Error Resume Next
    pInstance.Grupo = GetStringFromVariant(.Fields("Grupo"))
    If Err.Number <> 0 Then
      Err.Clear
      pInstance.Grupo = ""
    End If

    End With

End Sub

Public Function Load(Codigo As String, destino As clsItemVenta) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute("SELECT * FROM itemsVenta WHERE Codigo = " & StringDB(Codigo))
    If rs.EOF Then
        bRetVal = False
    Else
        LoadInstance destino, rs
        bRetVal = True
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenItemsVenta.Load"
    Resume ResumePoint

End Function

Public Function ItemVenta(Codigo As String) As clsItemVenta
Static cInstance As clsItemVenta, lastRead As Single
  If cInstance Is Nothing Then Set cInstance = New clsItemVenta
  If cInstance.Codigo <> Codigo Or Timer - lastRead > 0.1 Then
    lastRead = Timer
    Set cInstance = New clsItemVenta
    ' Agregado el 15-12-2005, para no sobreescribir cualquier instancia previa
    If Not Load(Codigo, cInstance) Then
      Set cInstance = Nothing
    End If
  End If
  Set ItemVenta = cInstance
End Function

Public Function LoadAnterior(destino As clsItemVenta) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM itemsVenta WHERE Codigo IN (Select Max(Codigo) FROM ItemsVenta WHERE Codigo < " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsitemsVenta::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadSiguiente(destino As clsItemVenta) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM itemsVenta WHERE Codigo IN (Select MIN(Codigo) FROM ItemsVenta WHERE Codigo > " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsBancos::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute("SELECT Count(Codigo) AS q FROM ItemsVenta WHERE Codigo = " & StringDB(arg))
    If rs.Fields("q").value > 0 Then
        bRetVal = True
    Else
        bRetVal = False
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:
    bRetVal = False
    ReportarError False, Err.Number, Err.Description, "AlmacenItemsVenta::ExisteCodigo"
    Resume ResumePoint
End Function

Public Function CrearItemVenta(Clave As String) As Boolean
    
    If Not Confirmar("Crear nuevo producto", True) Then
        CrearItemVenta = False
        Exit Function
    End If
    OpenFIEItemsVenta Clave
    CrearItemVenta = ExisteCodigo(Clave)

End Function

Public Sub Exportar(sCodigo As String)
Dim pItem As clsItemVenta, pAlterno As clsAlternoItemVenta
Dim fHandle As Integer

  Set pItem = Me.ItemVenta(sCodigo)
  If pItem Is Nothing Then Exit Sub
  
  On Error GoTo ErrHandler

  If bExportRequired Then
  Dim v As Variant, sNext As String, i As Integer
    fHandle = FreeFile
    v = GetAllSettings("ClearLight", "Suscriptores")
    If Not VBA.IsEmpty(v) Then
      For i = LBound(v, 1) To UBound(v, 1)
        Open BuildDataPath(v(i, 0) & ".TXT", AppName) For Append As #fHandle
        Write #fHandle, "<ITEM"
        With pItem
        Write #fHandle, .Codigo, .Descripcion, .Linea, .TipoImpuesto1, .TipoImpuesto2, _
                        .Precio1, .Precio2, .Precio3, .Precio4, _
                        .CostoStandard, .CuentaIngreso, .CuentaDevolucion, .CuentaCosto, _
                        .PComis1, .PComis2, .PComis3, .Presentacion, _
                        .Unidad, .CantidadPresentacion, .NumeroPLU, .PrecioIndexado
        End With
        Write #fHandle, "<ALTERNOS"
        For Each pAlterno In pItem.Alternos
          Write #fHandle, pAlterno.CodigoAlterno
        Next
        Write #fHandle, "/ALTERNOS>"
        Write #fHandle, "/ITEM>"
        Close fHandle
      Next
    End If
  End If

  Exit Sub

ErrHandler:
  Err.Clear
End Sub

Public Function ActualizarDescriptivos(Codigo As String, _
                    Descripcion As String, _
                    Linea As String, _
                    Impuesto1 As String, _
                    Impuesto2 As String, _
                    ByVal Precio1 As Double, _
                    ByVal Precio2 As Double, _
                    ByVal Precio3 As Double, _
                    ByVal Precio4 As Double, _
                    ByVal CostoStandard As Double, _
                    CuentaIngreso As String, _
                    CuentaDevolucion As String, _
                    CuentaCosto As String, _
                    ByVal PComis1 As Double, _
                    ByVal PComis2 As Double, _
                    ByVal PComis3 As Double, _
                    Presentacion As String, _
                    Unidad As String, _
                    ByVal CantidadPresentacion As Double, _
                    ByVal lngNumeroPLU As Long, _
                    ByVal inPrecioIndexado As Integer, _
                    colAlternos As Collection, _
                    colComposicion As Collection, _
                    sImageFile As String, sUbicacion As String, sGrupo As String) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset, ra As Long

  On Error GoTo ErrHandler
  
  bRetVal = True
  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM itemsVenta WHERE Codigo = " & StringDB(Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing
  
  If ra > 0 Then
    sQuery = "UPDATE itemsVenta SET "
    sQuery = sQuery & "Descripcion = " & StringDB(Descripcion) & ", "
    sQuery = sQuery & "Linea = " & StringDB(Linea) & ", "
    sQuery = sQuery & "CuentaIngreso = " & StringDB(CuentaIngreso) & ", "
    sQuery = sQuery & "CuentaDevolucion = " & StringDB(CuentaDevolucion) & ", "
    sQuery = sQuery & "CuentaCosto = " & StringDB(CuentaCosto) & ", "
    sQuery = sQuery & "Precio1 = " & NumeroDB(Precio1) & ", "
    sQuery = sQuery & "Precio2 = " & NumeroDB(Precio2) & ", "
    sQuery = sQuery & "Precio3 = " & NumeroDB(Precio3) & ", "
    sQuery = sQuery & "Precio4 = " & NumeroDB(Precio4) & ", "
    sQuery = sQuery & "TipoImpuesto1 = " & StringDB(Impuesto1) & ", "
'    sQuery = sQuery & "TipoImpuesto2 = " & StringDB(Impuesto2) & ", "
' Si TipoImpuesto2 es objeto de algun cambio directo en la BD, lo mejor es no
' alterarlo en el programa. Temporalmente es una caracterstica no soportada.
    sQuery = sQuery & "CostoStandard = " & NumeroDB(CostoStandard) & ", "
    sQuery = sQuery & "PComis1 = " & NumeroDB(PComis1) & ", "
    sQuery = sQuery & "PComis2 = " & NumeroDB(PComis2) & ", "
    sQuery = sQuery & "PComis3 = " & NumeroDB(PComis3) & ", "
    sQuery = sQuery & "Presentacion = " & StringDB(Presentacion) & ", "
    sQuery = sQuery & "Unidad = " & StringDB(Unidad) & ", "
    sQuery = sQuery & "CantidadPresentacion = " & NumeroDB(CantidadPresentacion) & ", "
    sQuery = sQuery & "NumeroPLU = " & NumeroDB(lngNumeroPLU) & ", "
    sQuery = sQuery & "PrecioIndexado = " & NumeroDB(inPrecioIndexado) & ", "
    sQuery = sQuery & "ImageFile = " & StringDB(sImageFile) & ", "
    sQuery = sQuery & "Ubicacion = " & StringDB(sUbicacion) & ", "
    sQuery = sQuery & "Grupo = " & StringDB(sGrupo) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(Codigo) & ";"
  Else
    sQuery = "INSERT INTO itemsVenta (Codigo, Linea, Descripcion, CuentaIngreso, CuentaDevolucion, CuentaCosto, " & _
             "Precio1, Precio2, Precio3, Precio4, TipoImpuesto1, TipoImpuesto2, CostoStandard, PComis1, PComis2, " & _
             "PComis3, Presentacion, Unidad, CantidadPresentacion, NumeroPLU, PrecioIndexado, ImageFile, Ubicacion, Grupo, FechaCreacion) SELECT "
    sQuery = sQuery & StringDB(Codigo) & ", "
    sQuery = sQuery & StringDB(Linea) & ", "
    sQuery = sQuery & StringDB(Descripcion) & ", "
    sQuery = sQuery & StringDB(CuentaIngreso)
    sQuery = sQuery & "," & StringDB(CuentaDevolucion)
    sQuery = sQuery & "," & StringDB(CuentaCosto)
    sQuery = sQuery & "," & NumeroDB(Precio1)
    sQuery = sQuery & "," & NumeroDB(Precio2)
    sQuery = sQuery & "," & NumeroDB(Precio3)
    sQuery = sQuery & "," & NumeroDB(Precio4)
    sQuery = sQuery & "," & StringDB(Impuesto1)
    sQuery = sQuery & "," & StringDB(Impuesto2)
    sQuery = sQuery & "," & NumeroDB(CostoStandard)
    sQuery = sQuery & "," & NumeroDB(PComis1)
    sQuery = sQuery & "," & NumeroDB(PComis2)
    sQuery = sQuery & "," & NumeroDB(PComis3)
    sQuery = sQuery & "," & StringDB(Presentacion)
    sQuery = sQuery & "," & StringDB(Unidad)
    sQuery = sQuery & "," & NumeroDB(CantidadPresentacion)
    sQuery = sQuery & "," & NumeroDB(lngNumeroPLU)
    sQuery = sQuery & "," & NumeroDB(inPrecioIndexado)
    sQuery = sQuery & "," & StringDB(sImageFile)
    sQuery = sQuery & ", " & StringDB(sUbicacion)
    sQuery = sQuery & ", " & StringDB(sGrupo)
    sQuery = sQuery & ", " & TimeDateDB(Now) & ";"
  End If
    
  dbHandle.Execute sQuery
  Exportar Codigo

  bRetVal = AlmacenAlternos.ActualizarAlternos(Codigo, colAlternos)
  If bRetVal Then
    bRetVal = AlmacenComposiciones.ActualizarComposicion(Codigo, colComposicion)
  End If

ExitPoint:
  ActualizarDescriptivos = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "ItemsVenta.ActualizarDescriptivos"
  bRetVal = False
  Resume ExitPoint

End Function

Public Function ActualizarCosto(inst As clsItemVenta, indexar As Boolean) As Boolean
Dim bRetVal As Boolean, sQuery As String
    
    On Error GoTo ErrHandler
    sQuery = "UPDATE itemsVenta SET CostoStandard = " & NumeroDB(inst.CostoStandard) & " "
    If indexar Then
        sQuery = sQuery & ", Precio1 = " & NumeroDB(inst.Precio1) & ", "
        sQuery = sQuery & "Precio2 = " & NumeroDB(inst.Precio2) & ", "
        sQuery = sQuery & "Precio3 = " & NumeroDB(inst.Precio3) & ", "
        sQuery = sQuery & "Precio4 = " & NumeroDB(inst.Precio4) & " "
    End If
    sQuery = sQuery & "WHERE Codigo = " & StringDB(inst.Codigo) & ";"
    
    dbHandle.Execute sQuery
    bRetVal = True

ExitPoint:
    ActualizarCosto = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "ItemsVenta.ActualizarCosto"
    Resume ExitPoint

End Function

Public Function Add(iItem As clsItemVenta, colAlternos As Collection, colComposicion As Collection) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    
    bRetVal = True

    bRetVal = ActualizarDescriptivos( _
        iItem.Codigo, iItem.Descripcion, iItem.Linea, iItem.TipoImpuesto1, iItem.TipoImpuesto2, _
        iItem.Precio1, iItem.Precio2, iItem.Precio3, iItem.Precio4, iItem.CostoStandard, _
        iItem.CuentaIngreso, iItem.CuentaDevolucion, iItem.CuentaCosto, _
        iItem.PComis1, iItem.PComis2, iItem.PComis3, iItem.Presentacion, iItem.Unidad, _
        iItem.CantidadPresentacion, iItem.NumeroPLU, iItem.PrecioIndexado, _
        colAlternos, colComposicion, iItem.ImageFile, iItem.Ubicacion, iItem.Grupo)

ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    
    ReportarError False, Err.Number, Err.Description, "AlmacenItemsVenta.Add"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Validar(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    
    stTemp = Trim(Format(Codigo, ">"))
    Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo"
        bRetVal = False
    Else
        stTemp = AlmacenAlternos.Translate(stTemp)
        If stTemp = "" Then stTemp = Codigo Else Codigo = stTemp
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_PRODUCTOS) Then
                    bRetVal = False
                Else
                    bRetVal = CrearItemVenta(stTemp)
                End If
            End If
        End If
    End If
    Validar = bRetVal
End Function

Public Function Eliminar(sCodigo As String) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    StartTransaction
    bRetVal = AlmacenAlternos.EliminarAlternosItemVenta(sCodigo)
    If bRetVal Then
        bRetVal = AlmacenComposiciones.EliminarComponenteInventario(sCodigo)
    End If
    If bRetVal Then
        dbHandle.Execute "DELETE FROM itemsVenta WHERE Codigo = " & StringDB(sCodigo)
    End If
    CommitTransaction
    
ResumePoint:

    Eliminar = bRetVal
    Exit Function

ErrHandler:
    AbortTransaction
    ReportarError False, Err.Number, Err.Description, "AlmacenItemsVenta:Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

Public Sub FillUbicaciones(cbx As ComboBox)
Dim rs As Recordset

  cbx.Clear
  Set rs = dbHandle.Execute("Select Distinct Ubicacion FROM itemsVenta WHERE Ubicacion <> ''")
  Do While Not rs.EOF
    cbx.AddItem rs.Fields("Ubicacion")
    rs.MoveNext
  Loop
  rs.Close
  Set rs = Nothing

End Sub

Private Sub Class_Initialize()
  bExportRequired = CBool(GetSetting(AppName, "General", "ExportarItemsVenta", "0"))
End Sub
