VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenItemsInventario"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Function Eliminar(sCodigo As String) As Boolean
Dim bRetVal As Boolean

  On Error GoTo ErrHandler
  bRetVal = True
  dbHandle.Execute "DELETE FROM ItemsInventario WHERE Codigo = " & StringDB(sCodigo)

ResumePoint:

  Eliminar = bRetVal
  Exit Function

ErrHandler:

  ReportarError False, Err.Number, Err.Description, "AlmacenItemsInventario:Eliminar"
  bRetVal = False
  Resume ResumePoint

End Function

Private Sub LoadInstance(pInstance As clsItemInventario, rsHandle As Recordset)
  With rsHandle
  pInstance.Codigo = GetStringFromVariant(.Fields("Codigo"))
  pInstance.Descripcion = GetStringFromVariant(.Fields("Descripcion"))
  pInstance.Linea = GetStringFromVariant(.Fields("Linea"))
  pInstance.CostoPromedio = GetNumeroFromVariant(.Fields("CostoPromedio"))
  pInstance.UltimoCosto = GetNumeroFromVariant(.Fields("UltimoCosto"))
  pInstance.claseImpuesto1 = GetStringFromVariant(.Fields("ClaseImpuesto1"))
  pInstance.ClaseImpuesto2 = GetStringFromVariant(.Fields("ClaseImpuesto2"))
  pInstance.Existencia = GetNumeroFromVariant(.Fields("Existencia"))
  pInstance.Asignadas = GetNumeroFromVariant(.Fields("Asignadas"))
  pInstance.EnTransito = GetNumeroFromVariant(.Fields("EnTransito"))
  pInstance.FechaUltimaCompra = GetDateFromVariant(.Fields("FechaUltimaCompra"))
  pInstance.UltimoProveedor = stGetStringFromVariant(.Fields("UltimoProveedor"))
  pInstance.PrecioUltimaCompra = GetNumeroFromVariant(.Fields("PrecioUltimaCompra"))
  pInstance.CuentaActivo = stGetStringFromVariant(.Fields("CuentaActivo"))
  pInstance.CuentaCosto = stGetStringFromVariant(.Fields("CostoDeVentas"))
  pInstance.NombreUnidad = stGetStringFromVariant(.Fields("NombreUnidad"))
  pInstance.NombreEmpaque = stGetStringFromVariant(.Fields("NombreEmpaque"))
  pInstance.CantidadEmpaque = GetNumeroFromVariant(.Fields("CantidadEmpaque"))
  pInstance.ExistenciaMinima = GetNumeroFromVariant(.Fields("ExistenciaMinima"))
  pInstance.ExistenciaMaxima = GetNumeroFromVariant(.Fields("ExistenciaMaxima"))
  On Error Resume Next
  pInstance.UsaSeriales = GetNumeroFromVariant(.Fields("UsaSeriales"))
  pInstance.Grupo = GetStringFromVariant(.Fields("Grupo"))
  End With
End Sub

Public Function Load(Codigo As String, destino As clsItemInventario) As Boolean
Dim bRetVal As Boolean, rs As Recordset

  Set rs = dbHandle.Execute("SELECT * FROM itemsInventario WHERE Codigo = " & StringDB(Codigo) & ";")
  With rs
  If Not .EOF Then
    If Not destino Is Nothing Then LoadInstance destino, rs
    bRetVal = True
  Else
    bRetVal = False
  End If
  .Close
  End With
  
ResumePoint:
  Set rs = Nothing
  Load = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenItemsInventario.Load"
  bRetVal = False
  Resume ResumePoint

End Function

Public Function itemInventario(Codigo As String) As clsItemInventario
Static cInstance As clsItemInventario, lastRead As Single
  If cInstance Is Nothing Then Set cInstance = New clsItemInventario
  If cInstance.Codigo <> Codigo Or Timer - lastRead > 0.1 Then
    lastRead = Timer
    Set cInstance = New clsItemInventario
    If Not Load(Codigo, cInstance) Then
      Set cInstance = Nothing
    End If
  End If
  Set itemInventario = cInstance
End Function

Public Function LoadSiguiente(destino As clsItemInventario) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String

  sQuery = "SELECT * FROM itemsInventario WHERE Codigo IN (Select Min(Codigo) FROM itemsInventario WHERE Codigo > " & StringDB(destino.Codigo) & ")"
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute(sQuery)
  If Not rs.EOF Then
    bResult = True
    LoadInstance destino, rs
  Else
    bResult = False
  End If
  
ResumePoint:
  Set rs = Nothing
  LoadSiguiente = bResult
  Exit Function

ErrHandler:

  Err.Raise Err.Number, "AlmacenItemsInventario::LoadSiguiente", Err.Description
  bResult = False
  Resume ResumePoint

End Function

Public Function LoadAnterior(destino As clsItemInventario) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
  sQuery = "SELECT * FROM itemsInventario WHERE Codigo IN (Select Max(Codigo) FROM itemsInventario WHERE Codigo < " & StringDB(destino.Codigo) & ")"
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute(sQuery)
  If Not rs.EOF Then
    bResult = True
    LoadInstance destino, rs
  Else
    bResult = False
  End If

ResumePoint:
  Set rs = Nothing
  LoadAnterior = bResult
  Exit Function

ErrHandler:
  Err.Raise Err.Number, "AlmacenItemsInventario::LoadAnterior", Err.Description
  bResult = False
  Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

  On Error GoTo ErrHandler

  sQuery = "SELECT Codigo FROM itemsInventario WHERE Codigo = " & StringDB(arg)
  Set rs = dbHandle.Execute(sQuery)
  bRetVal = Not rs.EOF
  rs.Close

ResumePoint:

  Set rs = Nothing
  ExisteCodigo = bRetVal
  Exit Function

ErrHandler:

  Err.Raise Err.Number, "AlmacenItemsInventario::ExisteCodigo", Err.Description
  bRetVal = False
  Resume ResumePoint

End Function

Public Function Crear(Clave As String) As Boolean
  If Not Confirmar("Crear nuevo ItemInventario") Then
    Crear = False
    Exit Function
  End If
  OpenFIEItemInventario Clave
  Crear = ExisteCodigo(Clave)
End Function

Public Function Validar(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    
  stTemp = Trim(Format(Codigo, ">"))
  stTemp = lmWildCards.CheckForWildcards(stTemp, "itemsInventario", "Codigo")
  
  Codigo = stTemp
  If stTemp = "" Then
    mAdvertencia "Debe llenar el cdigo"
    bRetVal = False
  Else
    stTemp = AlmacenAlternos.Translate(stTemp)
    If stTemp = "" Then stTemp = Codigo Else Codigo = stTemp
    If Len(stTemp) > 20 Then
      mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
      bRetVal = False
    Else
      If ExisteCodigo(stTemp) Then
        bRetVal = True
      Else
        If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_INVENTARIO) Then
          bRetVal = False
        Else
          bRetVal = Crear(stTemp)
        End If
      End If
    End If
  End If
  Validar = bRetVal
End Function

Public Function Add(iItem As clsItemInventario) As Boolean
    
  With iItem
  Add = ActualizarDescriptivos(iItem, _
    .Descripcion, .Linea, .claseImpuesto1, .NombreUnidad, _
    .NombreEmpaque, .CantidadEmpaque, .CuentaActivo, _
    .ExistenciaMinima, .ExistenciaMaxima, .UsaSeriales, .Grupo)
  End With

End Function

Public Function ActualizarDescriptivos(instance As clsItemInventario, _
            Descripcion As String, _
            Linea As String, _
            claseImpuesto1 As String, _
            Unidad As String, _
            Empaque As String, _
            CantidadEmpaque As Double, _
            CuentaActivo As String, _
            ByVal ExMin As Double, _
            ByVal ExMax As Double, _
            ByVal inUsaSeriales As Integer, ByVal inGrupo As String) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset, ra As Long
    
  bRetVal = True
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM itemsInventario WHERE Codigo = " & StringDB(instance.Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing
  
  If ra > 0 Then
    sQuery = "UPDATE itemsInventario SET Descripcion = " & StringDB(Descripcion)
    sQuery = sQuery & ", Linea = " & StringDB(Linea)
    sQuery = sQuery & ", claseImpuesto1 = " & StringDB(claseImpuesto1)
    sQuery = sQuery & ", NombreEmpaque = " & StringDB(Empaque)
    sQuery = sQuery & ", NombreUnidad = " & StringDB(Unidad)
    sQuery = sQuery & ", CantidadEmpaque = " & NumeroDB(CantidadEmpaque)
    sQuery = sQuery & ", CuentaActivo = " & StringDB(CuentaActivo)
    sQuery = sQuery & ", ExistenciaMinima = " & NumeroDB(ExMin)
    sQuery = sQuery & ", ExistenciaMaxima = " & NumeroDB(ExMax)
    sQuery = sQuery & ", UsaSeriales = " & NumeroDB(inUsaSeriales) & " "
    sQuery = sQuery & ", Grupo = " & StringDB(inGrupo) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(instance.Codigo) & ";"
  Else
    sQuery = "INSERT INTO itemsInventario (Codigo, Descripcion, Linea, CostoPromedio, UltimoCosto, ClaseImpuesto1, ClaseImpuesto2, "
    sQuery = sQuery & "FechaUltimaCompra, UltimoProveedor, PrecioUltimaCompra, CuentaActivo, "
    sQuery = sQuery & "CostoDeVentas, NombreUnidad, NombreEmpaque, CantidadEmpaque, ExistenciaMinima, ExistenciaMaxima, UsaSeriales, Grupo, FechaCreacion) SELECT "
    sQuery = sQuery & StringDB(instance.Codigo)
    sQuery = sQuery & "," & StringDB(Descripcion)
    sQuery = sQuery & "," & StringDB(Linea)
    sQuery = sQuery & "," & NumeroDB(instance.CostoPromedio)
    sQuery = sQuery & "," & NumeroDB(instance.UltimoCosto)
    sQuery = sQuery & "," & StringDB(claseImpuesto1)
    sQuery = sQuery & "," & StringDB(instance.ClaseImpuesto2)
    sQuery = sQuery & "," & FechaDB(instance.FechaUltimaCompra)
    sQuery = sQuery & "," & StringDB(instance.UltimoProveedor)
    sQuery = sQuery & "," & NumeroDB(instance.PrecioUltimaCompra)
    sQuery = sQuery & "," & StringDB(CuentaActivo)
    sQuery = sQuery & "," & StringDB(instance.CuentaCosto)
    sQuery = sQuery & "," & StringDB(Unidad)
    sQuery = sQuery & "," & StringDB(Empaque)
    sQuery = sQuery & "," & NumeroDB(CantidadEmpaque)
    sQuery = sQuery & "," & NumeroDB(ExMin)
    sQuery = sQuery & "," & NumeroDB(ExMax)
    sQuery = sQuery & "," & NumeroDB(inUsaSeriales)
    sQuery = sQuery & "," & StringDB(inGrupo)
    sQuery = sQuery & "," & TimeDateDB(Now)
    sQuery = sQuery & ";"
  End If
  
  dbHandle.Execute sQuery
  
ResumePoint:
  ActualizarDescriptivos = bRetVal
  Exit Function
  
ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenItemsInventario.Load"
  bRetVal = False
  Resume ResumePoint

End Function

Private Sub RegistrarVariacionCostoComponente(Codigo As String, ByVal Contrapartida As String, ByVal indexarPrecios As Boolean, ByVal Redondeo As Double)
Dim rs As Recordset, col As Collection, s As String, v As Variant

  Set rs = dbHandle.Execute("SELECT CodigoItemVenta FROM ComposicionItemsInventario WHERE CodigoItemInventario = " & StringDB(Codigo))
  Set col = New Collection
  Do While Not rs.EOF
    col.Add rs.Fields(0).value
    rs.MoveNext
  Loop
  Set rs = Nothing
  For Each v In col
    Dim q As String
    q = "SELECT c.CodigoItemVenta, SUM(c.Cantidad * i.CostoPromedio) As NCP, SUM(c.Cantidad * i.UltimoCosto) As NUC " & _
        "FROM ComposicionItemsInventario c, ItemsInventario I " & _
        "WHERE c.CodigoItemInventario = " & StringDB(Codigo) & " AND " & _
        "i.Codigo = c.CodigoItemInventario GROUP BY c.CodigoItemVenta"
    Set rs = dbHandle.Execute(q)
    Dim iv As clsItemInventario
    Do While Not rs.EOF
      Set iv = AlmacenItemsInventario.itemInventario(CStr(rs(0)))
      If Not iv Is Nothing Then
        Me.ActualizarCostos iv, CDbl(rs(1)), CDbl(rs(2)), Contrapartida, indexarPrecios, Redondeo
      End If
      rs.MoveNext
    Loop
  Next
End Sub

Public Function ActualizarCostos(inst As clsItemInventario, ByVal NuevoCP As Double, ByVal nuevoUC As Double, ByVal Contrapartida As String, ByVal indexarPrecios As Boolean, ByVal Redondeo As Double) As Boolean
Dim bRetVal As Boolean
Dim dOrgCostoReferencia As Double, _
    dNuevoCostoReferencia As Double, _
    DifValor As Double
Dim dbInv As Double, _
    crInv As Double, _
    dbContra As Double, _
    crContra As Double
Dim Comprobante As clsComprobante
    
  If nuevoUC = 0 Then
    ActualizarCostos = True
    Exit Function
  End If
    
  If Load(inst.Codigo, inst) Then
    bRetVal = True
    AlmacenComposiciones.RegistrarVariacionCostoComponente inst, NuevoCP, nuevoUC, indexarPrecios, Redondeo
    If inst.CuentaActivo <> "" And Contrapartida <> "" Then
      If Empresa.valoracionInventario Then
        dOrgCostoReferencia = inst.UltimoCosto * inst.Existencia
        dNuevoCostoReferencia = nuevoUC * inst.Existencia
      Else
        dOrgCostoReferencia = inst.CostoPromedio * inst.Existencia
        dNuevoCostoReferencia = NuevoCP * inst.Existencia
      End If
  
      If dOrgCostoReferencia <> dNuevoCostoReferencia Then
        DifValor = dNuevoCostoReferencia - dOrgCostoReferencia
        If DifValor > 0 Then
            dbInv = DifValor
            crInv = 0
            dbContra = 0
            crContra = DifValor
        Else
            DifValor = -DifValor
            dbInv = 0
            crInv = DifValor
            dbContra = DifValor
            crContra = 0
        End If
      End If
    End If
    
    inst.CostoPromedio = NuevoCP
    inst.UltimoCosto = nuevoUC
   
    dbHandle.Execute _
      "UPDATE itemsInventario SET CostoPromedio = " & NumeroDB(inst.CostoPromedio) & ", " & _
      "UltimoCosto = " & NumeroDB(inst.UltimoCosto) & " " & _
      "WHERE Codigo = " & StringDB(inst.Codigo) & ";"
    RegistrarVariacionCostoComponente inst.Codigo, Contrapartida, indexarPrecios, Redondeo
    
  Else
    bRetVal = False
  End If

  ActualizarCostos = bRetVal
End Function

Public Function ActualizarUltimaCompra(inst As clsItemInventario) As Boolean
Dim bRetVal As Boolean, sQuery As String

  bRetVal = True
  sQuery = "UPDATE itemsInventario SET "
  sQuery = sQuery & "FechaUltimaCompra = " & FechaDB(inst.FechaUltimaCompra) & ", "
  sQuery = sQuery & "UltimoProveedor = " & StringDB(inst.UltimoProveedor) & ", "
  sQuery = sQuery & "PrecioUltimaCompra = " & NumeroDB(inst.PrecioUltimaCompra) & " "
  sQuery = sQuery & "WHERE Codigo = " & StringDB(inst.Codigo) & ";"

  ActualizarUltimaCompra = bRetVal
  Exit Function

End Function

Public Function RegistrarVariacionExistencia(inst As clsItemInventario, dblVariacion As Double, dblCosto As Double) As Boolean
Dim bRetVal As Boolean, dblNewCP As Double, sQuery As String
  If Not inst.Load(inst.Codigo) Then
    Err.Raise 10001, "AlmacenItemsInventario::RegistrarVariacionExistencia", "Articulo no localizado (" & inst.Codigo & ")"
  Else
    If dblVariacion > 0 Then
      If inst.CostoPromedio < 0 Then
        inst.CostoPromedio = dblCosto
      ElseIf (inst.Existencia + dblVariacion) > 0 Then
        inst.CostoPromedio = ((inst.Existencia * inst.CostoPromedio) + (dblVariacion * dblCosto)) / (inst.Existencia + dblVariacion)
      Else
        inst.CostoPromedio = dblCosto
      End If
    End If
    inst.Existencia = inst.Existencia + dblVariacion
    sQuery = "UPDATE itemsInventario SET "
    sQuery = sQuery & "CostoPromedio = " & NumeroDB(inst.CostoPromedio) & ", "
    sQuery = sQuery & "Existencia = Existencia + (" & NumeroDB(dblVariacion) & ") "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(inst.Codigo)
    dbHandle.Execute sQuery
    bRetVal = True
    If inst.Existencia < 0 Then
      Report "Existencia negativa: Item " & inst.Codigo
    ElseIf inst.Existencia < inst.Asignadas Then
      Report "Existencia < Asignadas: item " & inst.Codigo
    End If
  End If
  RegistrarVariacionExistencia = True
End Function



