VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenFacturas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Sub LoadInstance(pInstance As clsFacturas, rsHandle As Recordset)
    With rsHandle
    pInstance.Numero = .Fields("Numero")
    pInstance.FechaRegistro = GetDateFromVariant(.Fields("FechaRegistro"))
    pInstance.FechaTransaccion = GetDateFromVariant(.Fields("FechaTransaccion"))
    pInstance.Operador = GetStringFromVariant(.Fields("Operador"))
    pInstance.Serie = GetStringFromVariant(.Fields("Serie"))
    pInstance.Correlativo = GetNumeroFromVariant(.Fields("Correlativo"))
    pInstance.ExtRef = GetStringFromVariant(.Fields("ExtRef"))
    pInstance.CodigoCliente = GetStringFromVariant(.Fields("CodigoCliente"))
    pInstance.NombreCliente = GetStringFromVariant(.Fields("NombreCliente"))
    pInstance.CodigoVendedor = GetStringFromVariant(.Fields("CodigoVendedor"))
    pInstance.EstadoDespacho = GetNumeroFromVariant(.Fields("EstadoDespacho"))
    pInstance.PrecioLista = GetNumeroFromVariant(.Fields("PrecioLista"))
    pInstance.PrecioVenta = GetNumeroFromVariant(.Fields("PrecioVenta"))
    pInstance.PrecioEfectivo = GetNumeroFromVariant(.Fields("PrecioEfectivo"))
    pInstance.Impuesto1 = GetNumeroFromVariant(.Fields("Impuesto1"))
    pInstance.Impuesto2 = GetNumeroFromVariant(.Fields("Impuesto2"))
    pInstance.IndiceReferencia = GetNumeroFromVariant(.Fields("IndiceReferencia"))
    pInstance.IndiceVenta = GetNumeroFromVariant(.Fields("IndiceVenta"))
    pInstance.Descuento1 = GetNumeroFromVariant(.Fields("Descuento1"))
    pInstance.Descuento2 = GetNumeroFromVariant(.Fields("Descuento2"))
    pInstance.Costo = GetNumeroFromVariant(.Fields("Costo"))
    pInstance.SituacionAdministrativa = GetNumeroFromVariant(.Fields("SituacionAdministrativa"))
    pInstance.Condicion = GetStringFromVariant(.Fields("Condicion"))
    pInstance.DescuentosProntoPago = GetNumeroFromVariant(.Fields("DescuentosProntoPago"))
    pInstance.Comision = GetNumeroFromVariant(.Fields("Comision"))
    pInstance.ComisionAcreditada = GetNumeroFromVariant(.Fields("ComisionAcreditada"))
    pInstance.DireccionEntrega = GetStringFromVariant(.Fields("DireccionEntrega"))
    pInstance.Notas = GetStringFromVariant(.Fields("Notas"))
    pInstance.PrecioDevuelto = GetNumeroFromVariant(.Fields("PrecioDevuelto"))
    pInstance.CostoDevuelto = GetNumeroFromVariant(.Fields("CostoDevuelto"))
    pInstance.Saldo = GetNumeroFromVariant(.Fields("Saldo"))
    pInstance.Impuesto1Devuelto = GetNumeroFromVariant(.Fields("Impuesto1Devuelto"))
    pInstance.Impuesto2Devuelto = GetNumeroFromVariant(.Fields("Impuesto2Devuelto"))
    End With
End Sub

Public Function UltimoDocumento() As Long

    UltimoDocumento = DBProximoNumero("Facturas", "Numero") - 1

End Function

Public Function UltimaFacturaSerie(stSerie As String) As Long
Dim lRetVal As Long, rs As Recordset, sQuery As String

    sQuery = "SELECT Max(Correlativo) As Ultimo FROM Facturas WHERE Serie = " & StringDB(stSerie)
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        lRetVal = 0
    Else
        lRetVal = GetNumeroFromVariant(rs.Fields("Ultimo"))
    End If
    rs.Close
    Set rs = Nothing
    UltimaFacturaSerie = lRetVal

End Function

Public Function Load(inst As clsFacturas, Numero As Long) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Facturas WHERE Numero = " & NumeroDB(Numero))
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        If Not inst Is Nothing Then LoadInstance inst, rs
    End If
    rs.Close
    Set rs = Nothing
    
    Load = bRetVal

End Function

Public Function RegistrarVariacion(inst As clsFacturas, vmMonto As Currency) As Boolean
Dim l As Long, s As String, retVal As Boolean
  s = "UPDATE Facturas SET Saldo = Saldo + " & NumeroDB(vmMonto) & " WHERE Numero = " & NumeroDB(inst.Numero)
  dbHandle.Execute s
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT Saldo FROM FACTURAS WHERE  Numero = " & NumeroDB(inst.Numero))
  If Not rs.EOF Then
    If Abs(rs(0)) < 0.01 Then
      s = "UPDATE Facturas SET Saldo = 0, SituacionAdministrativa = 2 WHERE Numero = " & NumeroDB(inst.Numero)
      dbHandle.Execute s
    End If
  End If
  Set rs = Nothing
  retVal = True
ResumePoint:
  RegistrarVariacion = retVal
  Exit Function

ErrHandler:
  Err.Raise 10001, "AlmacenFacturas::RegistrarVariacion", Err.Description
  Err.Clear
  retVal = False
  Resume ResumePoint

End Function

Public Function SetAcreditada(Numero As Long) As Boolean
Dim bRetVal As Boolean

  bRetVal = True
  On Error GoTo ErrHandler

  dbHandle.Execute "UPDATE Facturas SET ComisionAcreditada = 1 WHERE Numero = " & NumeroDB(Numero)

ResumePoint:
  SetAcreditada = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenFacturas::SetAcreditada"
  bRetVal = False
  Resume ResumePoint

End Function

Public Function NotificarDescuento(Numero As Long, vmDescuento As Currency) As Boolean
Dim bRetVal As Boolean, lqRecords

    On Error GoTo ErrHandler
    dbHandle.Execute "UPDATE Facturas SET DescuentosProntoPago = DescuentosProntoPago + " & NumeroDB(vmDescuento) & " WHERE Numero = " & NumeroDB(Numero), lqRecords
    bRetVal = (lqRecords > 0)

ResumePoint:
    NotificarDescuento = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenFacturas::NotificarDescuento"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function LoadBySerie(inst As clsFacturas, Serie As String, Correlativo As Long) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Facturas WHERE Serie = " & StringDB(Serie) & " AND Correlativo = " & NumeroDB(Correlativo))
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        If Not inst Is Nothing Then LoadInstance inst, rs
    End If
    rs.Close
    Set rs = Nothing

    LoadBySerie = bRetVal

End Function

Public Function LoadByReferencia(inst As clsFacturas, Referencia As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    If Referencia = "" Then
        LoadByReferencia = False
        Exit Function
    End If
    
    Set rs = dbHandle.Execute("SELECT * FROM Facturas WHERE ExtRef = " & StringDB(Referencia))
    With rs
    If .EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance inst, rs
    End If
    .Close
    End With
    Set rs = Nothing

    LoadByReferencia = bRetVal
End Function

' *****************************************************************
' StartProcess: Inicia una transaccin, graba estado inicial de la
' factura, deja abierto AlmacenFacturas.
Public Function StartProcess(pInstance As clsFacturas) As Boolean
' pInstance.Numero = 0 -> FacturaNueva
' NO FacturaNueva -> NoHanVariado(pInstance.Serie, pInstance.Correlativo)
' FacturaNueva -> Correlativo = 0 || Unicos(pInstance.Serie, pInstance.Correlativo)  // Verificar esta condicion
Dim sQuery As String

  If pInstance.Numero = 0 Then    ' Si la factura no exista
    If pInstance.Correlativo <> 0 Then
      If LoadBySerie(Nothing, pInstance.Serie, pInstance.Correlativo) Then
        Err.Raise 10001, "AlmacenFacturas", "Correlativo duplicado"
        StartProcess = False
        Exit Function
      End If
    Else
      pInstance.Correlativo = Series.ProximaFacturaSerie(pInstance.Serie, True)
    End If
    
    pInstance.Numero = Contadores.NumeroProximoDocumento(pInstance.TipoEntidad, True)
    sQuery = "INSERT INTO Facturas (Numero, FechaTransaccion, FechaRegistro, Operador, Serie, Correlativo, ExtRef, CodigoCliente, NombreCliente, "
    sQuery = sQuery & "CodigoVendedor, EstadoDespacho, "
    sQuery = sQuery & "IndiceReferencia, IndiceVenta, Descuento1, Descuento2, Costo, SituacionAdministrativa, Condicion, "
    sQuery = sQuery & "DireccionEntrega, Notas) SELECT "
    sQuery = sQuery & NumeroDB(pInstance.Numero)
    sQuery = sQuery & "," & FechaDB(pInstance.FechaTransaccion)
    sQuery = sQuery & "," & TimeDateDB(Now)
    sQuery = sQuery & "," & StringDB(pInstance.Operador)
    sQuery = sQuery & "," & StringDB(pInstance.Serie)
    sQuery = sQuery & "," & NumeroDB(pInstance.Correlativo)
    sQuery = sQuery & "," & StringDB(pInstance.ExtRef)
    sQuery = sQuery & "," & StringDB(pInstance.CodigoCliente)
    sQuery = sQuery & "," & StringDB(pInstance.NombreCliente)
    sQuery = sQuery & "," & StringDB(pInstance.CodigoVendedor)
    sQuery = sQuery & "," & NumeroDB(pInstance.EstadoDespacho)
    sQuery = sQuery & "," & NumeroDB(pInstance.IndiceReferencia)
    sQuery = sQuery & "," & NumeroDB(pInstance.IndiceVenta)
    sQuery = sQuery & "," & NumeroDB(pInstance.Descuento1)
    sQuery = sQuery & "," & NumeroDB(pInstance.Descuento2)
    sQuery = sQuery & "," & NumeroDB(pInstance.Costo)
    sQuery = sQuery & "," & NumeroDB(pInstance.SituacionAdministrativa)
    sQuery = sQuery & "," & StringDB(pInstance.Condicion)
    sQuery = sQuery & "," & StringDB(pInstance.DireccionEntrega)
    sQuery = sQuery & "," & StringDB(pInstance.Notas)
    sQuery = sQuery & ";"
    dbHandle.Execute sQuery
  Else                            ' i.e. si era una factura preexistente
    If Not Load(Nothing, pInstance.Numero) Then
      Err.Raise 10001, "AlmacenFacturas", "La factura parece haber desaparecido"
      StartProcess = False
      Exit Function
    End If
    sQuery = "UPDATE Facturas SET "
    sQuery = sQuery & "FechaTransaccion = " & FechaDB(pInstance.FechaTransaccion) & ", "
    sQuery = sQuery & "Operador = " & StringDB(pInstance.Operador) & ", "
    sQuery = sQuery & "ExtRef = " & StringDB(pInstance.ExtRef) & ", "
    sQuery = sQuery & "CodigoCliente = " & StringDB(pInstance.CodigoCliente) & ", "
    sQuery = sQuery & "NombreCliente = " & StringDB(pInstance.NombreCliente) & ", "
    sQuery = sQuery & "CodigoVendedor = " & StringDB(pInstance.CodigoVendedor) & ", "
    sQuery = sQuery & "EstadoDespacho = " & NumeroDB(pInstance.EstadoDespacho) & ", "
    sQuery = sQuery & "IndiceReferencia = " & NumeroDB(pInstance.IndiceReferencia) & ", "
    sQuery = sQuery & "IndiceVenta = " & NumeroDB(pInstance.IndiceVenta) & ", "
    sQuery = sQuery & "Descuento1 = " & NumeroDB(pInstance.Descuento1) & ", "
    sQuery = sQuery & "Descuento2 = " & NumeroDB(pInstance.Descuento2) & ", "
    sQuery = sQuery & "Costo = " & NumeroDB(pInstance.Costo) & ", "
    sQuery = sQuery & "SituacionAdministrativa = " & NumeroDB(pInstance.SituacionAdministrativa) & ", "
    sQuery = sQuery & "Condicion = " & StringDB(pInstance.Condicion) & ", "
    sQuery = sQuery & "DireccionEntrega = " & StringDB(pInstance.DireccionEntrega) & ", "
    sQuery = sQuery & "Notas = " & StringDB(pInstance.Notas) & " "
    sQuery = sQuery & "WHERE Numero = " & NumeroDB(pInstance.Numero) & ";"
    dbHandle.Execute sQuery
  End If
  
  StartProcess = True

End Function

Public Sub EndProcess(pInstance As clsFacturas)
Dim sQuery As String

  sQuery = "UPDATE Facturas SET "
  sQuery = sQuery & "PrecioLista = " & NumeroDB(pInstance.PrecioLista) & ", "
  sQuery = sQuery & "PrecioVenta = " & NumeroDB(pInstance.PrecioVenta) & ", "
  sQuery = sQuery & "PrecioEfectivo = " & NumeroDB(pInstance.PrecioEfectivo) & ", "
  sQuery = sQuery & "Impuesto1 = " & NumeroDB(pInstance.Impuesto1) & ", "
  sQuery = sQuery & "Impuesto2 = " & NumeroDB(pInstance.Impuesto2) & ", "
  sQuery = sQuery & "Costo = " & NumeroDB(pInstance.Costo) & ", "
  sQuery = sQuery & "Comision = " & NumeroDB(pInstance.Comision) & ", "
  sQuery = sQuery & "ComisionAcreditada = " & IIf(pInstance.ComisionAcreditada, "1", "0") & ", "
  sQuery = sQuery & "SituacionAdministrativa = " & NumeroDB(pInstance.SituacionAdministrativa) & ", "
  sQuery = sQuery & "EstadoDespacho = " & NumeroDB(pInstance.EstadoDespacho) & " "
  sQuery = sQuery & "WHERE Numero = " & NumeroDB(pInstance.Numero) & ";"
  dbHandle.Execute sQuery

End Sub

Public Sub AbortProcess()
    
'    AbortTransaction
'    AbortTransaction

End Sub

