VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsAlmacenEmpresas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private rsHandle As Recordset
Private qAperturas As Integer

Public Sub Abrir()
    If qAperturas = 0 Then
        Set rsHandle = dbHandle.OpenRecordset("Empresas", dbOpenTable)
    End If
    rsHandle.Index = "PrimaryKey"
    qAperturas = qAperturas + 1
End Sub

Public Sub Cerrar()
    If qAperturas = 0 Then Exit Sub
    qAperturas = qAperturas - 1
    If qAperturas = 0 Then
        rsHandle.Close
        Set rsHandle = Nothing
    End If
End Sub

Public Function Load(inst As clsEmpresa, iCodigo As String) As Boolean
Dim bRetVal As Boolean
    Abrir
    With rsHandle
        .Seek "=", iCodigo
        If .NoMatch Then
            bRetVal = False
        Else
            inst.Codigo = .Fields("Codigo")
            inst.NombreEmpresa = .Fields("NombreEmpresa")
            inst.RIFEmpresa = stGetStringFromVariant(.Fields("RIFEmpresa"))
            inst.NITEmpresa = stGetStringFromVariant(.Fields("NITEmpresa"))
            inst.MesInicioAnho = .Fields("MesInicioAnho")
            inst.AnhoActual = .Fields("AnhoActual")
            inst.PeriodoActual = .Fields("PeriodoActual")
            inst.FormatoCodigos = .Fields("FormatoCodigos")
            inst.CuentaGanPer = .Fields("CuentaGanPer")
            bRetVal = True
        End If
    End With
    Cerrar
    Load = bRetVal
End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim bRetVal As Boolean
    Abrir
    With rsHandle
        .Index = "PrimaryKey"
        .Seek "=", arg
        bRetVal = Not .NoMatch
    End With
    Cerrar
    ExisteCodigo = bRetVal
End Function

Public Function LoadSiguiente(Destino As clsEmpresa) As Boolean
Dim bResult As Boolean
    Abrir
    With rsHandle
    .Index = "PrimaryKey"
    .Seek ">", Destino.Codigo
    If .NoMatch Then
        bResult = False
    Else
        bResult = True
        Destino.Codigo = .Fields("Codigo")
        Destino.NombreEmpresa = .Fields("NombreEmpresa")
        Destino.RIFEmpresa = .Fields("RIFEmpresa")
        Destino.NITEmpresa = .Fields("NITEmpresa")
        Destino.MesInicioAnho = .Fields("MesInicioAnho")
        Destino.AnhoActual = .Fields("AnhoActual")
        Destino.PeriodoActual = .Fields("PeriodoActual")
        Destino.FormatoCodigos = .Fields("FormatoCodigos")
        Destino.CuentaGanPer = .Fields("CuentaGanPer")
    End If
    End With
    Cerrar
    LoadSiguiente = bResult
End Function

Public Function LoadAnterior(Destino As clsEmpresa) As Boolean
Dim bResult As Boolean
    Abrir
    With rsHandle
    .Index = "PrimaryKey"
    .Seek "<", Destino.Codigo
    If .NoMatch Then
        bResult = False
    Else
        bResult = True
        Destino.Codigo = .Fields("Codigo")
        Destino.NombreEmpresa = .Fields("NombreEmpresa")
        Destino.RIFEmpresa = .Fields("RIFEmpresa")
        Destino.NITEmpresa = .Fields("NITEmpresa")
        Destino.MesInicioAnho = .Fields("MesInicioAnho")
        Destino.AnhoActual = .Fields("AnhoActual")
        Destino.PeriodoActual = .Fields("PeriodoActual")
        Destino.FormatoCodigos = .Fields("FormatoCodigos")
        Destino.CuentaGanPer = .Fields("CuentaGanPer")
    End If
    End With
    Cerrar
    LoadAnterior = bResult
End Function

Public Function CrearEmpresa(Clave As String) As Boolean
    If VerificarUsuario("Crear Empresa " & Clave) < 5 Then
        CrearEmpresa = False
        Exit Function
    End If
    
    OpenFIEEmpresas Clave
    CrearEmpresa = ExisteCodigo(Clave)
End Function

Public Function ValidarEmpresa(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    stTemp = Trim(Format(Codigo, ">"))
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo de la empresa"
        bRetVal = False
    Else
        If Len(stTemp) > 8 Then
            mAdvertencia "La maxima longitud del cdigo son 8 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                bRetVal = CrearEmpresa(stTemp)
            End If
        End If
    End If
    ValidarEmpresa = bRetVal
End Function

Public Function ModificarDescriptivos(instEmpresa As clsEmpresa, _
                                      stNuevoNombre As String, _
                                      stNuevoRIF As String, _
                                      stNuevoNIT As String, _
                                      stNuevoCodigoResult As String) As Boolean
Dim bRetVal As Boolean
    Abrir
    With rsHandle
    .Seek "=", instEmpresa.Codigo
    If .NoMatch Then
        bRetVal = False
    Else
        bRetVal = True
        .Edit
        .Fields("NombreEmpresa") = stNuevoNombre
        .Fields("RIFEmpresa") = stNuevoRIF
        .Fields("NITEmpresa") = stNuevoNIT
        .Fields("CuentaGanPer") = stNuevoCodigoResult
        .Update
    End If
    End With
    Cerrar
    ModificarDescriptivos = bRetVal
End Function

Public Function Add(arg As clsEmpresa) As Boolean
Dim bRetVal As Boolean
    bRetVal = True
    Abrir
    With rsHandle
        .AddNew
        .Fields("Codigo") = arg.Codigo
        .Fields("NombreEmpresa") = arg.NombreEmpresa
        .Fields("RIFEmpresa") = arg.RIFEmpresa
        .Fields("NITEmpresa") = arg.NITEmpresa
        .Fields("MesInicioAnho") = arg.MesInicioAnho
        .Fields("AnhoActual") = arg.AnhoActual
        .Fields("PeriodoActual") = arg.PeriodoActual
        .Fields("FormatoCodigos") = arg.FormatoCodigos
        .Fields("CuentaGanPer") = arg.CuentaGanPer
        .Update
    End With
    Cerrar
    If bRetVal Then bRetVal = CopyTable(dbHandle, "Comprobantes" & arg.Codigo, "MaestroComprobantes")
    If bRetVal Then bRetVal = CopyTable(dbHandle, "Cuentas" & arg.Codigo, "MaestroCuentas")
    If bRetVal Then bRetVal = CopyTable(dbHandle, "Detalles" & arg.Codigo, "MaestroDetalles")
    If bRetVal Then bRetVal = CopyTable(dbHandle, "Prefijos" & arg.Codigo, "MaestroPrefijos")
    If bRetVal Then bRetVal = CopyTable(dbHandle, "SaldosPeriodo" & arg.Codigo, "MaestroSaldosPeriodo")
    If bRetVal Then bRetVal = CopyTable(dbHandle, "Indicadores" & arg.Codigo, "MaestroIndicadores")
    Add = bRetVal
End Function

Public Function ImportarPlan(stOrigen As String, stDestino As String) As Boolean
Dim f As FStatusCopia, bRetVal As Boolean
Dim rsIn As Recordset, rsOut As Recordset
Dim inTableName As String, outTableName As String

    Set f = New FStatusCopia
    f.Show 0
    inTableName = "Prefijos" & stOrigen: outTableName = "Prefijos" & stDestino
    f.SetCuenta ("Prefijos")
    
    Workspaces(0).BeginTrans
    
    Set rsIn = dbHandle.OpenRecordset(inTableName, dbOpenTable)
    Set rsOut = dbHandle.OpenRecordset(outTableName, dbOpenTable)
    rsOut.Index = "PrimaryKey"
    If Not rsIn.BOF Then rsIn.MoveFirst
    Do While Not (rsIn.EOF Or rsIn.BOF) And (f.GetStatus = 0)
        DoEvents
        rsOut.Seek "=", rsIn.Fields("Prefijo")
        If rsOut.NoMatch Then
            rsOut.AddNew
            rsOut.Fields("Prefijo") = rsIn.Fields("Prefijo")
            rsOut.Fields("Uso") = rsIn.Fields("Uso")
            rsOut.Update
        End If
        rsIn.MoveNext
    Loop
    rsOut.Close: Set rsOut = Nothing
    rsIn.Close: Set rsIn = Nothing
    
    If (f.GetStatus = 0) Then
        inTableName = "Cuentas" & stOrigen
        outTableName = "Cuentas" & stDestino
        Set rsIn = dbHandle.OpenRecordset(inTableName, dbOpenTable)
        Set rsOut = dbHandle.OpenRecordset(outTableName, dbOpenTable)
        rsOut.Index = "PrimaryKey"
        If Not rsIn.BOF Then rsIn.MoveFirst
        Do While Not (rsIn.EOF Or rsIn.BOF) And (f.GetStatus = 0)
            DoEvents
            f.SetCuenta rsIn.Fields("Codigo")
            rsOut.Seek "=", rsIn.Fields("Codigo")
            If rsOut.NoMatch Then
                rsOut.AddNew
                rsOut.Fields("Codigo") = rsIn.Fields("Codigo")
                rsOut.Fields("Titulo") = rsIn.Fields("Titulo")
                rsOut.Fields("Lado") = rsIn.Fields("Lado")
                rsOut.Fields("Status") = rsIn.Fields("Status")
                rsOut.Fields("Saldo") = 0#
                rsOut.Update
            End If
            rsIn.MoveNext
        Loop
        rsOut.Close: Set rsOut = Nothing
        rsIn.Close: Set rsIn = Nothing
    End If
    
    If (f.GetStatus) Then
        Workspaces(0).Rollback
    Else
        Workspaces(0).CommitTrans
    End If
    
    bRetVal = (f.GetStatus = 0)
    f.Hide
    Unload f
    Set f = Nothing
    ImportarPlan = bRetVal
End Function

Public Function TieneCuentas(s As clsEmpresa) As Boolean
Dim sNombreTabla As String, rsCuentas As Recordset, bRetVal As Boolean
    sNombreTabla = "Cuentas" & s.Codigo
    Set rsCuentas = dbHandle.OpenRecordset(sNombreTabla, dbOpenTable)
    bRetVal = Not rsCuentas.BOF
    rsCuentas.Close
    Set rsCuentas = Nothing
    TieneCuentas = bRetVal
End Function

Public Sub ActualizarUltimoPeriodo(arg As clsEmpresa, nuevoPeriodo As Long)
Dim RetVal As Boolean
    Abrir
    With rsHandle
    .Seek "=", arg.Codigo
    If .NoMatch Then
        RetVal = False
    Else
        arg.AnhoActual = AnhoPeriodo(nuevoPeriodo)
        arg.PeriodoActual = PeriodoPeriodo(nuevoPeriodo)
        .Edit
        .Fields("AnhoActual") = arg.AnhoActual
        .Fields("PeriodoActual") = arg.PeriodoActual
        .Update
        RetVal = True
    End If
    End With
    Cerrar
'    ActualizarUltimoPeriodo = retVal
End Sub

Public Sub Kill(arg As clsEmpresa)
    Abrir
    With rsHandle
    .Seek "=", arg.Codigo
    If Not .NoMatch Then
        .Delete
        lmTables.DeleteTable dbHandle, "Detalles" & arg.Codigo
        lmTables.DeleteTable dbHandle, "Cuentas" & arg.Codigo
        lmTables.DeleteTable dbHandle, "Comprobantes" & arg.Codigo
        lmTables.DeleteTable dbHandle, "SaldosPeriodo" & arg.Codigo
        lmTables.DeleteTable dbHandle, "Prefijos" & arg.Codigo
        lmTables.DeleteTable dbHandle, "Indicadores" & arg.Codigo
    End If
    End With
    Cerrar
End Sub
