VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenDetallesItemInv"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Sub LoadInstance(pInstance As clsMINV, rsHandle As Recordset)
    With rsHandle
    pInstance.NumeroDocumento = .Fields("NumeroDocumento")
    pInstance.Renglon = .Fields("Renglon")
    pInstance.FechaOperacion = .Fields("FechaOperacion")
    pInstance.TipoMovimiento = .Fields("TipoMovimiento")
    pInstance.CodigoItem = .Fields("CodigoItem")
    pInstance.Cantidad = .Fields("Entradas")
    pInstance.Salidas = .Fields("Salidas")
    pInstance.Costo = .Fields("Costo")
    End With
End Sub

Public Function Add(NumeroDocumento As Long, Renglon As Integer, FechaOperacion As Date, TipoMovimiento As String, CodigoItem As String, Cantidad As Double, Costo As Double) As Boolean
Dim isOk As Boolean, itemInv As clsItemInventario, sQuery As String, iCostoU As Currency

    Set itemInv = New clsItemInventario
    isOk = itemInv.Load(CodigoItem)
    iCostoU = itemInv.CostoUnitario
    Set itemInv = Nothing

    If Not isOk Then
        ReportarError False, 1030, "ItemInv no localizado: " & CodigoItem, "AlmacenDetallesItemInv.Add"
        Add = False
        Exit Function
    End If
    
    sQuery = "INSERT INTO DetallesMINV (NumeroDocumento, Renglon, FechaOperacion, TipoMovimiento, CodigoItem, Entradas, Salidas, Costo) SELECT "
    sQuery = sQuery & NumeroDB(NumeroDocumento) & ", "
    sQuery = sQuery & NumeroDB(Renglon) & ", "
    sQuery = sQuery & FechaDB(FechaOperacion) & ", "
    sQuery = sQuery & StringDB(TipoMovimiento) & ", "
    sQuery = sQuery & StringDB(CodigoItem) & ", "
    If Cantidad < 0 Then
        sQuery = sQuery & "0, " & NumeroDB(Abs(Cantidad)) & ", "
    Else
        sQuery = sQuery & NumeroDB(Cantidad) & ", 0,"
    End If
    sQuery = sQuery & NumeroDB(iCostoU) & ";"

    dbHandle.Execute sQuery

    Add = isOk

End Function

Public Function ProcesarDetalles(Proceso As clsIteradorMINVS, Optional stExprSel As String, Optional stOrder As String) As Integer
Dim rs As Recordset, instance As clsMINV, RetVal As Integer
Dim sqlString As String

    sqlString = "SELECT * FROM DetallesMINV"
    If stExprSel <> "" Then sqlString = sqlString & " WHERE " & stExprSel
    If stOrder <> "" Then sqlString = sqlString & " ORDER BY " & stOrder
    
    On Error GoTo ErrHandler
    RetVal = 1

    Set instance = New clsMINV
    Set rs = dbHandle.Execute(sqlString)

    RetVal = 0

    With rs
    Do While Not .EOF And RetVal = 0
        LoadInstance instance, rs
        RetVal = Proceso.Procesar(instance)
        If RetVal <> 0 Then Exit Do
        .MoveNext
    Loop
    End With

Resume2:
    rs.Close

Resume1:
    ProcesarDetalles = RetVal
    Set instance = Nothing
    Set rs = Nothing
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenDetallesItemInv.ProcesarDetalles"
    If RetVal = 1 Then
        RetVal = Err.Number
        Resume Resume1
    End If
    RetVal = Err.Number
    Resume Resume2
End Function

Public Sub KillDetallesComprobante(lNum As Long)
Dim sqlCommand As String
    
    sqlCommand = "DELETE FROM DetallesMINV WHERE NumeroDocumento =" & Str(lNum)
    dbHandle.Execute sqlCommand

End Sub

