VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenDetallesFactura"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Acumuladores para los Detalles de Factura (u otros usos generales)
Private AcumPLista As Currency, _
        AcumPVenta As Currency, _
        AcumPFinal As Currency

Public Sub LoadInstance(pInstance As clsDetallesFactura, rsHandle As Recordset)
    With rsHandle
    pInstance.NumeroDocumento = .Fields("NumeroDocumento")
    pInstance.Renglon = .Fields("Renglon")
    pInstance.CodigoItem = .Fields("CodigoItem")
    pInstance.Descripcion = .Fields("Descripcion")
    pInstance.Presentacion = stGetStringFromVariant(.Fields("Presentacion"))
    pInstance.FactorEmpaque = .Fields("FactorEmpaque")
    pInstance.Cantidad = .Fields("Cantidad")
    pInstance.PrecioLista = .Fields("PrecioLista")
    pInstance.PrecioVenta = .Fields("PrecioVenta")
    pInstance.PrecioEfectivo = .Fields("PrecioEfectivo")
    pInstance.Impuesto1 = .Fields("Impuesto1")
    pInstance.Impuesto2 = .Fields("Impuesto2")
    pInstance.CostoUnitario = .Fields("CostoUnitario")
    pInstance.Entregadas = .Fields("Entregadas")
    pInstance.Asignadas = .Fields("Asignadas")
    pInstance.Transito = .Fields("Transito")
    pInstance.Devueltas = .Fields("Devueltas")
    End With
End Sub

Public Function Add(iItem As clsDetallesFactura) As Boolean
Dim bRetVal As Boolean, sQuery As String

    bRetVal = True
    On Error GoTo ErrHandler
    
    sQuery = "INSERT INTO DetallesFactura (NumeroDocumento, Renglon, CodigoItem, Descripcion, Presentacion, FactorEmpaque, Cantidad, "
    sQuery = sQuery & "PrecioLista, PrecioVenta, PrecioEfectivo, Impuesto1, Impuesto2, CostoUnitario, Entregadas, Asignadas, Transito) SELECT "
    sQuery = sQuery & NumeroDB(iItem.NumeroDocumento) & ", "
    sQuery = sQuery & NumeroDB(iItem.Renglon) & ", "
    sQuery = sQuery & StringDB(iItem.CodigoItem) & ", "
    sQuery = sQuery & StringDB(iItem.Descripcion) & ", "
    sQuery = sQuery & StringDB(iItem.Presentacion) & ", "
    sQuery = sQuery & NumeroDB(iItem.FactorEmpaque) & ", "
    sQuery = sQuery & NumeroDB(iItem.Cantidad) & ", "
    sQuery = sQuery & NumeroDB(iItem.PrecioLista) & ", "
    sQuery = sQuery & NumeroDB(iItem.PrecioVenta) & ", "
    sQuery = sQuery & NumeroDB(iItem.PrecioEfectivo) & ", "
    sQuery = sQuery & NumeroDB(iItem.Impuesto1) & ", "
    sQuery = sQuery & NumeroDB(iItem.Impuesto2) & ", "
    sQuery = sQuery & NumeroDB(iItem.CostoUnitario) & ", "
    sQuery = sQuery & NumeroDB(iItem.Entregadas) & ", "
    sQuery = sQuery & NumeroDB(iItem.Asignadas) & ", "
    sQuery = sQuery & NumeroDB(iItem.Transito) & ";"
    dbHandle.Execute sQuery
    
ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenDetallesFactura.Add"
    bRetVal = False
    Resume ResumePoint
End Function

Public Sub FillCollection(lNumFact As Long, DestCol As Collection)
Dim inst As clsDetallesFactura, rs As Recordset, sqlQuery As String
Dim NumeroProducto As Long
Dim AcumPLista As Currency, AcumPVenta As Currency, AcumPFinal As Currency
Dim pSeriales As CSerialesRenglon
Dim vSeriales As Variant, i As Integer

    NumeroProducto = 0
    AcumPLista = 0: AcumPVenta = 0: AcumPFinal = 0

    sqlQuery = "SELECT * FROM DetallesFactura WHERE NumeroDocumento =" & NumeroDB(lNumFact) & " ORDER BY Renglon"
    Set rs = dbHandle.Execute(sqlQuery)
    
    With rs
    Do While Not .EOF
        Set inst = New clsDetallesFactura
        LoadInstance inst, rs
        With inst
            .AcumPLista = AcumPLista
            AcumPLista = AcumPLista + .PrecioLista * .Cantidad
            .AcumPVenta = AcumPVenta
            AcumPVenta = AcumPVenta + .PrecioVenta * .Cantidad
            .AcumPFinal = AcumPFinal
            AcumPFinal = AcumPFinal + .PrecioEfectivo
            If .CodigoItem <> "" Then
                NumeroProducto = NumeroProducto + 1
                .NumeroProducto = NumeroProducto
            Else
                .NumeroProducto = 0
            End If
            .isSerial = False
        End With
        DestCol.Add inst
        
        Set pSeriales = New CSerialesRenglon
        pSeriales.Load "FCT", lNumFact, inst.Renglon
        If pSeriales.SerialesProducto.Count Then
            vSeriales = pSeriales.ToStrings(40)
            For i = 1 To UBound(vSeriales)
                Set inst = New clsDetallesFactura
                inst.Descripcion = vSeriales(i)
                inst.isSerial = True
                inst.Renglon = 1
                inst.FactorEmpaque = 1
                DestCol.Add inst
            Next
        End If
        Set pSeriales = Nothing
        
        Set inst = Nothing
        .MoveNext
    
    Loop
    .Close
    End With
    
    Set rs = Nothing
End Sub

Public Function KillDetallesFactura(lNumFact As Long) As Boolean
Dim bRetVal As Boolean, sqlQuery As String
    On Error GoTo ErrHandler
    bRetVal = True
    sqlQuery = "DELETE FROM DetallesFactura WHERE NumeroDocumento =" & NumeroDB(lNumFact)
    dbHandle.Execute sqlQuery

ResumePoint:
    KillDetallesFactura = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenDetallesFactura.KillDetallesFactura"
    bRetVal = False
    Resume ResumePoint
End Function



