VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenDetalles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Sub Load(Detalle As clsDetalles, rsHandle As Recordset)
    With rsHandle
    Detalle.NumeroComprobante = .Fields("NumeroComprobante")
    Detalle.NumeroLinea = .Fields("NumeroLinea")
    Detalle.Cuenta = .Fields("Cuenta")
    Detalle.Debe = .Fields("Debe")
    Detalle.Descripcion = .Fields("Descripcion")
    Detalle.Haber = .Fields("Haber")
    Detalle.RefDetalle = .Fields("RefDetalle")
    Detalle.refPeriodo = .Fields("RefPeriodo")
    End With
End Sub

Public Function GrabarNuevoDetalle(Detalle As clsDetalles) As Boolean
Dim isOK As Boolean, lCuenta As clsCuenta, sQuery As String

    On Error GoTo ErrHandler
    Set lCuenta = New clsCuenta
    isOK = lCuenta.Load(Detalle.Cuenta)
    If (isOK) Then
        If (lCuenta.Status = 1) Then ' Si se trata de una cuenta de control...
            isOK = False
            Report "Cuenta " & Detalle.Cuenta & " no localizada: AlmacenDetalles.GrabarNuevoDetalle"
        End If
        If lCuenta.Status = 0 Then  ' Si no tiene un status asignado
            lCuenta.SetStatus 2     ' forzar nuevos status = Detalle
        End If
    End If
    
    If isOK Then
        sQuery = "INSERT INTO Detalles (NumeroComprobante, NumeroLinea, RefPeriodo, Cuenta, RefDetalle, Descripcion, Debe, Haber) SELECT "
        sQuery = sQuery & NumeroDB(Detalle.NumeroComprobante) & ", "
        sQuery = sQuery & NumeroDB(Detalle.NumeroLinea) & ", "
        sQuery = sQuery & NumeroDB(Detalle.refPeriodo) & ", "
        sQuery = sQuery & StringDB(Detalle.Cuenta) & ", "
        sQuery = sQuery & StringDB(Detalle.RefDetalle) & ", "
        sQuery = sQuery & StringDB(Detalle.Descripcion) & ", "
        sQuery = sQuery & NumeroDB(Detalle.Debe) & ", "
        sQuery = sQuery & NumeroDB(Detalle.Haber) & ";"

        dbHandle.Execute sQuery
        
        lCuenta.RegistrarVariacion Detalle.Debe - Detalle.Haber, Detalle.refPeriodo, False, False
    End If
    Set lCuenta = Nothing
    
ResumePoint:
    GrabarNuevoDetalle = isOK
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenDetalles::GrabarNuevoDetalle"
    isOK = False
    Resume ResumePoint

End Function

Public Function IteradorCuentaPeriodo(codigoCuenta As String, _
                                      ByVal RefPeriodoI As Long, ByVal RefPeriodoF As Long, _
                                      Procesador As clsProcesadorDetalles) As Integer
Dim instDetalle As clsDetalles, _
    RetVal As Integer, _
    rs As Recordset

    RetVal = 0
    Set instDetalle = New clsDetalles
    Set rs = dbHandle.Execute("SELECT * FROM Detalles WHERE Cuenta LIKE '" & codigoCuenta & "%' AND refPeriodo BETWEEN " & NumeroDB(RefPeriodoI) & " AND " & NumeroDB(RefPeriodoF) & " ORDER BY refPeriodo, NumeroComprobante, NumeroLinea")
    Do While Not rs.EOF
        Load instDetalle, rs
        RetVal = Procesador.Accion(instDetalle)
        If RetVal <> 0 Then Exit Do
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing
    Set instDetalle = Nothing
    
    IteradorCuentaPeriodo = RetVal

End Function

Public Function IteradorMovimientosCuenta(stCuentaInicio As String, _
                                          stCuentaFin As String, _
                                          lRefPeriodoI As Long, _
                                          lRefPeriodoF As Long, _
                                          Procesador As clsProcesadorDetalles) As Integer
Dim sqlQuery As String, _
    instDetalle As clsDetalles, _
    rsHandle As Recordset, _
    RetVal As Integer

    sqlQuery = "SELECT * FROM " & "Detalles "
    sqlQuery = sqlQuery & "WHERE Cuenta BETWEEN " & StringDB(stCuentaInicio) & " AND " & StringDB(stCuentaFin & "ZZZZZZZZ") & " AND "
    sqlQuery = sqlQuery & "RefPeriodo BETWEEN " & NumeroDB(lRefPeriodoI) & " AND " & NumeroDB(lRefPeriodoF) & " "
    sqlQuery = sqlQuery & "ORDER BY Cuenta, RefPeriodo, NumeroComprobante, NumeroLinea"
    
    RetVal = 0
    Set rsHandle = dbHandle.Execute(sqlQuery)
    Set instDetalle = New clsDetalles
    With rsHandle
    Do While RetVal = 0 And Not .EOF
        Load instDetalle, rsHandle
        RetVal = Procesador.Accion(instDetalle)
        If RetVal = 0 Then .MoveNext
    Loop
    .Close
    End With
    Set rsHandle = Nothing
    Set instDetalle = Nothing
    
    IteradorMovimientosCuenta = RetVal

End Function

Public Function FillDetallesComprobante(NumeroComprobante As Long, DestCol As Collection) As Boolean
Dim rs As Recordset
Dim instDetalle As clsDetalles
    
    Set rs = dbHandle.Execute("SELECT * FROM Detalles WHERE NumeroCOmprobante = " & NumeroDB(NumeroComprobante) & " ORDER BY NumeroLinea;")
    Do While Not rs.EOF
        Set instDetalle = New clsDetalles
        Load instDetalle, rs
        DestCol.Add instDetalle
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing
    FillDetallesComprobante = True

End Function

Public Function EliminarDetallesComprobante(NumeroComprobante As Long)
    
    dbHandle.Execute "DELETE FROM Detalles WHERE NumeroComprobante = " & NumeroDB(NumeroComprobante)
    EliminarDetallesComprobante = True

End Function

Public Function TieneDetalles(inst As clsCuenta) As Boolean
Dim RetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT Count(NumeroComprobante) AS Q from Detalles WHERE Cuenta = " & StringDB(inst.Codigo) & ";")
    If rs.EOF Then
        RetVal = False
    ElseIf GetNumeroFromVariant(rs.Fields("Q").Value) > 0 Then
        RetVal = True
    Else
        RetVal = False
    End If
    rs.Close
    Set rs = Nothing
End Function


