VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenCuentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Implementa los mecanismos de acceso a disco y validacin de cuentas"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' En teora, debe existir slo una instancia de esta clase en
' cada aplicacin. Es una implementacin en forma de clase de
' un mdulo de acceso a datos para una entidad (Cuentas).

Option Explicit

Private Type tagCuenta
    Codigo As String
    Titulo As String
    lado As Byte
    Status As Byte
    Saldo As Double
End Type

Private rsHandle As Recordset
Private qAperturas As Integer
Private cCuenta As tagCuenta

Private Sub LoadCCuenta(rsHandle As Recordset)
    With rsHandle
    cCuenta.Codigo = .Fields("Codigo")
    cCuenta.Titulo = .Fields("Titulo")
    cCuenta.Status = .Fields("Status")
    cCuenta.lado = .Fields("Lado")
    cCuenta.Saldo = .Fields("Saldo")
    End With
End Sub

Public Sub Abrir()
End Sub

Public Sub Cerrar()
End Sub

Public Function LoadCuenta(Codigo As String, destino As clsCuenta) As Boolean
Dim bRetVal As Boolean, rsHandle As Recordset
    
  Set rsHandle = dbHandle.Execute("SELECT * FROM Cuentas WHERE Codigo = " & StringDB(Codigo))
  
  With rsHandle
  If Not .EOF Then
    LoadCCuenta rsHandle
    destino.Codigo = .Fields("Codigo")
    destino.Titulo = .Fields("Titulo")
    destino.Status = .Fields("Status")
    destino.lado = .Fields("Lado")
    destino.Saldo = .Fields("Saldo")
    bRetVal = True
  Else
    bRetVal = False
  End If
  .Close
  End With
  
  Set rsHandle = Nothing
  LoadCuenta = bRetVal
End Function

Public Function LoadSiguiente(destino As clsCuenta) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Cuentas WHERE Codigo IN (Select Min(Codigo) FROM Cuentas WHERE Codigo > " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        destino.Codigo = rs.Fields("Codigo")
        destino.Titulo = rs.Fields("Titulo")
        destino.Status = rs.Fields("Status")
        destino.lado = rs.Fields("Lado")
        destino.Saldo = rs.Fields("Saldo")
    Else
        bResult = False
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsAlmacenCuentas::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadAnterior(destino As clsCuenta) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Cuentas WHERE Codigo IN (Select Max(Codigo) FROM Cuentas WHERE Codigo < " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        destino.Codigo = rs.Fields("Codigo")
        destino.Titulo = rs.Fields("Titulo")
        destino.Status = rs.Fields("Status")
        destino.lado = rs.Fields("Lado")
        destino.Saldo = rs.Fields("Saldo")
    Else
        bResult = False
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsAlmacenCuentas::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT Codigo FROM Cuentas WHERE Codigo = " & StringDB(arg))
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
    End If
    rs.Close
    Set rs = Nothing
    
    ExisteCodigo = bRetVal
End Function
Public Function CrearCuenta(Clave As String) As Boolean
Dim stSubordinante As String, isCreated As Boolean

    If Not ValidarEstructuraCodigo(Clave, Empresa.FormatoCodigos) Then
        mAdvertencia "Error: Formato invalido" & Chr(13) & "Formato: " & Empresa.FormatoCodigos
        CrearCuenta = False
        Exit Function
    End If
    
    If Not Confirmar("Crear cuenta " & Clave) Then
        CrearCuenta = False
        Exit Function
    End If

    stSubordinante = mCodigos.CodigoSubordinante(Clave)
    If (stSubordinante <> "") Then
        If Not Me.ValidarCuenta(stSubordinante) Then
            CrearCuenta = False
            Exit Function
        End If
    End If

    OpenFIECuentas Clave
    isCreated = ExisteCodigo(Clave)
    
    CrearCuenta = isCreated

End Function

Public Function Add(iCuenta As clsCuenta) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    sQuery = "INSERT INTO Cuentas (Codigo, Titulo, Status, Lado) SELECT "
    sQuery = sQuery & StringDB(iCuenta.Codigo) & ", "
    sQuery = sQuery & StringDB(iCuenta.Titulo) & ", "
    sQuery = sQuery & StringDB(iCuenta.Status) & ", "
    sQuery = sQuery & StringDB(iCuenta.lado) & ";"
    bRetVal = True
    
    dbHandle.Execute sQuery
    
ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenCuentas::Add"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ValidarCuenta(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    
    stTemp = Trim(Format(Codigo, ">"))
    stTemp = mCodigos.MergeCodigoFormato(stTemp, Empresa.FormatoCodigos)
    If stTemp <> Codigo Then Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo de la cuenta"
        bRetVal = False
    Else
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_CUENTAS) Then
                    bRetVal = False
                Else
                    bRetVal = CrearCuenta(stTemp)
                End If
            End If
        End If
    End If
    ValidarCuenta = bRetVal
End Function

' Aqu no hace falta el parametro Reverse, pues slo afecta el saldo de la cuenta
Public Function RegistrarVariacion(instCuenta As clsCuenta, Monto As Double) As Boolean
Dim bRetVal As Boolean, sQuery As String

    bRetVal = True
    On Error GoTo ErrHandler
    sQuery = "UPDATE Cuentas SET Saldo = Saldo + " & NumeroDB(Monto) & " WHERE Codigo =  " & StringDB(instCuenta.Codigo) & ";"
    dbHandle.Execute sQuery

ResumePoint:
    RegistrarVariacion = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmcenCuentas::RegistrarVariacion"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function CambiarTitulo(instCuenta As clsCuenta, istTitulo As String)
Dim bRetVal As Boolean, sQuery As String

    bRetVal = True
    On Error GoTo ErrHandler
    sQuery = "UPDATE Cuentas SET Titulo = " & StringDB(istTitulo) & " WHERE Codigo = " & StringDB(instCuenta.Codigo) & ";"
    dbHandle.Execute sQuery
    instCuenta.Titulo = istTitulo

ResumePoint:
    CambiarTitulo = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmcenCuentas::CambiarTitulo"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function SetStatus(instCuenta As clsCuenta, inStatus As Integer)
Dim bRetVal As Boolean, sQuery As String

    bRetVal = True
    If instCuenta.Status = inStatus Then
        SetStatus = True
        Exit Function
    End If
    
    On Error GoTo ErrHandler
    sQuery = "UPDATE Cuentas SET Status = " & NumeroDB(inStatus) & " WHERE Codigo = " & StringDB(instCuenta.Codigo) & ";"
    dbHandle.Execute sQuery
    instCuenta.Status = inStatus

ResumePoint:
    SetStatus = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmcenCuentas::RegistrarVariacion"
    bRetVal = False
    Resume ResumePoint

End Function

Public Sub LlenarColeccionCuentas(DestCol As Collection)
Dim instCuenta As clsCuenta, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM CUentas ORDER BY Codigo;")
        
    Do While Not rs.EOF
        Set instCuenta = New clsCuenta
        instCuenta.Codigo = rs.Fields("Codigo")
        instCuenta.Titulo = rs.Fields("Titulo")
        instCuenta.Status = rs.Fields("Status")
        instCuenta.lado = rs.Fields("Lado")
        instCuenta.Saldo = rs.Fields("Saldo")
        DestCol.Add instCuenta, instCuenta.Codigo
        rs.MoveNext
    Loop
    
    rs.Close
    Set rs = Nothing

End Sub

Public Sub LlenarColeccionCuentasPrefijo(stPrefijo As String, DestCol As Collection)
Dim instCuenta As clsCuenta, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Cuentas WHERE Codigo LIKE '" & stPrefijo & "%' ORDER BY Codigo;")
    Do While Not rs.EOF
        Set instCuenta = New clsCuenta
        instCuenta.Codigo = rs.Fields("Codigo")
        instCuenta.Titulo = rs.Fields("Titulo")
        instCuenta.Status = rs.Fields("Status")
        instCuenta.lado = rs.Fields("Lado")
        instCuenta.Saldo = rs.Fields("Saldo")
        DestCol.Add instCuenta, instCuenta.Codigo
        rs.MoveNext
    Loop
    
    rs.Close
    Set rs = Nothing

End Sub

Private Sub Class_Terminate()
    If qAperturas Then
        rsHandle.Close
        mAdvertencia "Error interno: Open/Close mismatch en Cuentas"
    End If
    Set rsHandle = Nothing
End Sub

Public Function TieneSubordinadas(arg As clsCuenta) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean

    sQuery = "SELECT Codigo FROM Cuentas WHERE Codigo IN (Select Min(Codigo) FROM Cuentas WHERE Codigo > " & StringDB(arg.Codigo) & ")"

    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        bRetVal = False
    Else
        sQuery = GetStringFromVariant(rs.Fields("Codigo"))
        bRetVal = (arg.Codigo = Left(sQuery, Len(arg.Codigo)))
    End If

    TieneSubordinadas = bRetVal

End Function

Public Function Eliminar(arg As clsCuenta) As Boolean
Dim bRetVal As Boolean
Dim pAtributo As clsAtributoEntidad

    On Error GoTo ErrHandler
    bRetVal = True
    
    dbHandle.Execute "DELETE FROM Cuentas WHERE Codigo = " & StringDB(arg.Codigo)
  
ResumePoint:
    
    Eliminar = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "AlmacenCuentas:Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

