VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenCotsPP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Sub LoadInstance(inst As clsCotsProvProd, rs As Recordset)

    With inst
    .CodigoItem = rs.Fields("CodigoItem")
    .CodigoProveedor = rs.Fields("CodigoProveedor")
    .RefProductoProveedor = stGetStringFromVariant(rs.Fields("RefProductoProveedor"))
    .FechaOferta = GetDateFromVariant(rs.Fields("FechaOferta"))
    .FechaUltimaCompra = GetDateFromVariant(rs.Fields("FechaUltimaCompra"))
    .PrecioReferencia = GetNumeroFromVariant(rs.Fields("PrecioReferencia"))
    .PrecioUltimaCompra = GetNumeroFromVariant(rs.Fields("PrecioUltimaCompra"))
    .NombreDesc = GetStringFromVariant(rs.Fields("NombreDesc"))
    .Notas = GetStringFromVariant(rs.Fields("Notas"))
    End With

End Sub

Public Function CotizacionesProveedor(sProveedor As String) As Collection
Dim sQuery As String, rs As Recordset, retCol As Collection, inst As clsCotsProvProd

    sQuery = "SELECT I.Descripcion as NombreDesc, P.* FROM ProveedorProducto P, itemsInventario I WHERE P.CodigoProveedor = " & StringDB(sProveedor) & " AND I.Codigo = P.CodigoItem ORDER BY Descripcion"
    Set retCol = New Collection
    Set rs = dbHandle.Execute(sQuery, , adCmdText)
    Do While Not rs.EOF
        Set inst = New clsCotsProvProd
        LoadInstance inst, rs
        retCol.Add inst
        Set inst = Nothing
        rs.MoveNext
    Loop
    
    rs.Close
    Set rs = Nothing
    
    Set CotizacionesProveedor = retCol

End Function

Public Function CotizacionesArticulo(sArticulo As String) As Collection
Dim sQuery As String, rs As Recordset, retCol As Collection, inst As clsCotsProvProd

    sQuery = "SELECT V.Nombre As NombreDesc, P.* FROM ProveedorProducto P, Proveedores V WHERE P.CodigoItem = " & StringDB(sArticulo) & " AND V.Codigo = P.CodigoProveedor ORDER BY Nombre"
    Set retCol = New Collection
    Set rs = dbHandle.Execute(sQuery, , adCmdText)
    Do While Not rs.EOF
        Set inst = New clsCotsProvProd
        LoadInstance inst, rs
        retCol.Add inst
        Set inst = Nothing
        rs.MoveNext
    Loop
    
    rs.Close
    Set rs = Nothing
    
    Set CotizacionesArticulo = retCol

End Function

Public Function AgregarCotizacion(stProveedor As String, _
                                    stArticulo As String, _
                                    stRefProducto As String, _
                                    ByVal dtFecha As Date, _
                                    ByVal vmPrecio As Currency, _
                                    stNotas As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean
Dim sQuery As String

  bRetVal = True
  sQuery = "INSERT INTO ProveedorProducto (CodigoProveedor, CodigoItem, RefProductoProveedor, PrecioReferencia, FechaOferta, PrecioUltimaCompra, FechaUltimaCompra, Notas) VALUES ("
  sQuery = sQuery & StringDB(stProveedor) & ", "
  sQuery = sQuery & StringDB(stArticulo) & ", "
  sQuery = sQuery & StringDB(stRefProducto) & ", "
  sQuery = sQuery & NumeroDB(vmPrecio) & ", "
  sQuery = sQuery & FechaDB(dtFecha) & ", " & "0, "
  sQuery = sQuery & FechaDB(DateSerial(1900, 1, 1)) & ", "
  sQuery = sQuery & StringDB(stNotas) & ");"
  dbHandle.Execute sQuery
  AgregarCotizacion = bRetVal

End Function

Public Function GetInstance(stProveedor As String, stArticulo As String) As clsCotsProvProd
Dim inst As clsCotsProvProd, rs As Recordset, sQuery As String

    sQuery = "SELECT * FROM ProveedorProducto WHERE CodigoItem = " & StringDB(stArticulo) & " AND CodigoProveedor = " & StringDB(stProveedor)
    Set rs = dbHandle.Execute(sQuery)
    If rs.EOF Then
        Set inst = Nothing
    Else
        Set inst = New clsCotsProvProd
        With inst
        .CodigoItem = GetStringFromVariant(rs.Fields("CodigoItem"))
        .CodigoProveedor = GetStringFromVariant(rs.Fields("CodigoProveedor"))
        .RefProductoProveedor = GetStringFromVariant(rs.Fields("RefProductoProveedor"))
        .FechaOferta = GetDateFromVariant(rs.Fields("FechaOferta"))
        .FechaUltimaCompra = GetDateFromVariant(rs.Fields("FechaUltimaCompra"))
        .PrecioReferencia = GetNumeroFromVariant(rs.Fields("PrecioReferencia"))
        .PrecioUltimaCompra = GetNumeroFromVariant(rs.Fields("PrecioUltimaCompra"))
        .Notas = GetStringFromVariant(rs.Fields("Notas"))
        .NombreDesc = ""
        End With
    End If
    rs.Close
    Set rs = Nothing

    Set GetInstance = inst

End Function

Public Function UpdateCotizacion(stProveedor As String, _
                                 stArticulo As String, _
                                 stRefProveedor As String, _
                                 ByVal dtFecha As Date, _
                                 ByVal vmPrecio As Currency, _
                                 stNotas As String) As Boolean
Dim bRetVal As Boolean, sQuery As String, l As Long

  sQuery = "UPDATE ProveedorProducto " & _
    "SET RefProductoProveedor = " & StringDB(stRefProveedor) & ", " & _
    "PrecioReferencia = " & NumeroDB(vmPrecio) & ", " & _
    "FechaOferta = " & FechaDB(dtFecha) & ", " & _
    "Notas = " & StringDB(stNotas) & " WHERE CodigoItem = " & StringDB(stArticulo) & " And CodigoProveedor = " & StringDB(stProveedor)
  dbHandle.Execute sQuery, l
  bRetVal = l <> 0
  UpdateCotizacion = bRetVal

End Function

Public Function KillInstance(stProveedor As String, stArticulo As String) As Boolean
Dim sQuery As String

    sQuery = "DELETE FROM ProveedorProducto WHERE CodigoItem = " & StringDB(stArticulo) & " AND CodigoProveedor = " & StringDB(stProveedor)
    dbHandle.Execute sQuery
    
    KillInstance = True

End Function

Public Sub RegistrarCompra(stProveedor As String, stArticulo As String, dtFecha As Date, vmPrecio As Currency)
Dim inst As clsCotsProvProd
Dim sQuery As String, pItem As clsItemInventario

    Set inst = Me.GetInstance(stProveedor, stArticulo)
    If inst Is Nothing Then
        AgregarCotizacion stProveedor, stArticulo, "", dtFecha, vmPrecio, "Creada durante recepcion de compra"
        Set inst = GetInstance(stProveedor, stArticulo)
    End If
    If inst Is Nothing Then Exit Sub    ' hubo problemas...

    sQuery = "UPDATE ProveedorProducto SET FechaUltimaCompra = " & FechaDB(dtFecha) & ", PrecioUltimaCompra = " & Str(vmPrecio) & " WHERE CodigoProveedor = " & StringDB(stProveedor) & " AND CodigoItem = " & StringDB(stArticulo) & ";"
    dbHandle.Execute sQuery
    
    Set pItem = AlmacenItemsInventario.itemInventario(stArticulo)
    If Not pItem Is Nothing Then
      If pItem.FechaUltimaCompra <= dtFecha Then
        sQuery = "UPDATE itemsInventario SET FechaUltimaCompra = " & FechaDB(dtFecha) & ", UltimoProveedor = " & StringDB(stProveedor) & " WHERE Codigo = " & StringDB(stArticulo)
        dbHandle.Execute sQuery
      End If
      Set pItem = Nothing
    End If

End Sub

Public Function PrecioUnitario(sProveedor As String, sArticulo As String) As Currency
Dim inst As clsCotsProvProd, vmRetVal As Currency

    Set inst = Me.GetInstance(sProveedor, sArticulo)
    If inst Is Nothing Then
        PrecioUnitario = 0
        Exit Function
    End If
    
    If inst.FechaOferta > inst.FechaUltimaCompra Then
        vmRetVal = inst.PrecioReferencia
    Else
        vmRetVal = inst.PrecioUltimaCompra
    End If
    Set inst = Nothing

    PrecioUnitario = vmRetVal

End Function

Public Function RefProv2Codigo(sProv As String, sCodigo As String)
Dim inst As clsCotsProvProd, rs As Recordset, sRetVal As String

    Set rs = dbHandle.Execute("SELECT CodigoItem FROM ProveedorProducto WHERE CodigoProveedor = " & StringDB(sProv) & " AND RefProductoProveedor = " & StringDB(sCodigo), , adCmdText)
    
    If Not rs.EOF Then
        sRetVal = rs!CodigoItem
    Else
        sRetVal = sCodigo
    End If
    
    rs.Close
    Set rs = Nothing

    RefProv2Codigo = sRetVal

End Function

Public Function Codigo2RefProv(sProv As String, sCodigo As String) As String
Dim inst As clsCotsProvProd, rs As Recordset, sRetVal As String

    Set rs = dbHandle.Execute("SELECT RefProductoProveedor FROM ProveedorProducto WHERE CodigoProveedor = " & StringDB(sProv) & " AND CodigoItem = " & StringDB(sCodigo), , adCmdText)
    
    If Not rs.EOF Then
        sRetVal = GetStringFromVariant(rs!RefProductoProveedor)
    Else
        sRetVal = ""
    End If

    rs.Close
    Set rs = Nothing

    Codigo2RefProv = sRetVal

End Function

Public Function TranslateRefProv(sProv As String, sCodigo As String) As String
Dim sRetVal As String

    sRetVal = RefProv2Codigo(sProv, sCodigo)
    If sRetVal = sCodigo Then sRetVal = ""
    
    TranslateRefProv = sRetVal
End Function

Public Sub SetRefProv(sProv As String, sCodigo As String, sRef As String)
Dim sQuery As String, ra As Long

  sQuery = "SELECT COUNT(*) FROM ProveedorProducto  WHERE CodigoProveedor = " & StringDB(sProv) & " AND CodigoItem = " & StringDB(sCodigo)
  Dim rs As Recordset
  Set rs = dbHandle.Execute(sQuery)
  ra = rs(0)
  rs.Close: Set rs = Nothing
  
  If ra > 0 Then
    sQuery = "UPDATE ProveedorProducto SET RefProductoProveedor = " & StringDB(sRef) & " WHERE CodigoProveedor = " & StringDB(sProv) & " AND CodigoItem = " & StringDB(sCodigo)
  Else
    sQuery = "INSERT INTO ProveedorProducto (CodigoProveedor, CodigoItem, RefProductoProveedor, FechaUltimaCompra, FechaOferta) SELECT " & StringDB(sProv) & ", " & StringDB(sCodigo) & ", " & StringDB(sRef) & ", " & FechaDB(#1/1/1980#) & ", " & FechaDB(#1/1/1980#) & ";"
  End If
  
  dbHandle.Execute sQuery, ra

End Sub

