VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenContactos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para cada una de las cuentas de banco almacenadas en el sistema."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' clsClassGenerator V1.0

Option Explicit

Private Sub LoadInstance(pInstance As clsContactos, rsHandle As Recordset)
    
    With rsHandle
    pInstance.CodigoEntidad = .Fields("CodigoEntidad")
    pInstance.TipoEntidad = .Fields("TipoEntidad")
    pInstance.NombreContacto = .Fields("NombreContacto")
    pInstance.Departamento = .Fields("Departamento")
    pInstance.Cargo = .Fields("Cargo")
    pInstance.Direccion = .Fields("Direccion")
    pInstance.Telefono = .Fields("Telefono")
    pInstance.TelefonoCelular = .Fields("TelefonoCelular")
    pInstance.FAX = .Fields("FAX")
    pInstance.eMail = .Fields("eMail")
    pInstance.Notas = .Fields("Notas")
    End With

End Sub

Public Function Load(inst As clsContactos, iTipoEntidad As String, iCodigoEntidad As String, iNombre As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Contactos WHERE CodigoEntidad = " & StringDB(iCodigoEntidad) & " AND TipoEntidad = " & StringDB(iTipoEntidad) & " AND NombreContacto = " & StringDB(iNombre) & ";")
    If rs.EOF Then
        bRetVal = False
    Else
        LoadInstance inst, rs
        bRetVal = True
    End If
    
    Load = bRetVal
End Function

Public Function Delete(inst As clsContactos) As Boolean
Dim bRetVal As Boolean
    
    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE FROM Contactos WHERE CodigoEntidad = " & StringDB(inst.CodigoEntidad) & " AND TipoEntidad = " & StringDB(inst.TipoEntidad) & " AND NombreContacto = " & StringDB(inst.NombreContacto) & ";"
    
ResumePoint:
    Delete = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenContactos.Delete"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(iItem As clsContactos, orgNombre As String) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    bRetVal = True
    
    sQuery = "UPDATE Contactos SET "
    sQuery = sQuery & "NombreContacto = " & StringDB(iItem.NombreContacto) & ", "
    sQuery = sQuery & "Departamento = " & StringDB(iItem.Departamento) & ", "
    sQuery = sQuery & "Cargo = " & StringDB(iItem.Cargo) & ", "
    sQuery = sQuery & "Direccion = " & StringDB(iItem.Direccion) & ", "
    sQuery = sQuery & "Telefono = " & StringDB(iItem.Telefono) & ", "
    sQuery = sQuery & "TelefonoCelular = " & StringDB(iItem.TelefonoCelular) & ", "
    sQuery = sQuery & "FAX = " & StringDB(iItem.FAX) & ", "
    sQuery = sQuery & "eMail = " & StringDB(iItem.eMail) & ", "
    sQuery = sQuery & "Notas = " & StringDB(iItem.Notas) & " "
    sQuery = sQuery & "WHERE CodigoEntidad = " & StringDB(iItem.CodigoEntidad) & " AND TipoEntidad = " & StringDB(iItem.TipoEntidad) & " AND NombreContacto = " & StringDB(orgNombre) & ";"
    
    dbHandle.Execute sQuery
    
ResumePoint:
    ActualizarDescriptivos = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenContactos.ActualizarDescriptivos"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Contactos(stTipoEntidad As String, stCodigoEntidad As String) As Collection
Dim sQry As String, rs As Recordset, inst As clsContactos
Dim colContactos As Collection

    sQry = "SELECT * From Contactos Where CodigoEntidad = " & StringDB(stCodigoEntidad) & " And TipoEntidad = " & StringDB(stTipoEntidad) & " ORDER BY NombreContacto;"
    Set rs = dbHandle.Execute(sQry)
    
    Set colContactos = New Collection
    If Not rs.BOF Then
        Do While Not rs.EOF
            Set inst = New clsContactos
            LoadInstance inst, rs
            colContactos.Add inst
            rs.MoveNext
        Loop
    End If
    rs.Close
    Set rs = Nothing
    Set Contactos = colContactos

End Function

Public Function Add(inst As clsContactos) As Boolean
Dim bRetVal As Boolean, sQuery As String

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "INSERT INTO Contactos (CodigoEntidad, TipoEntidad, NombreContacto, Departamento, Cargo, Direccion, "
    sQuery = sQuery & "Telefono, TelefonoCelular, FAX, eMail, Notas) SELECT "
    sQuery = sQuery & StringDB(inst.CodigoEntidad) & ", "
    sQuery = sQuery & StringDB(inst.TipoEntidad) & ", "
    sQuery = sQuery & StringDB(inst.NombreContacto) & ", "
    sQuery = sQuery & StringDB(inst.Departamento) & ", "
    sQuery = sQuery & StringDB(inst.Cargo) & ", "
    sQuery = sQuery & StringDB(inst.Direccion) & ", "
    sQuery = sQuery & StringDB(inst.Telefono) & ", "
    sQuery = sQuery & StringDB(inst.TelefonoCelular) & ", "
    sQuery = sQuery & StringDB(inst.FAX) & ", "
    sQuery = sQuery & StringDB(inst.eMail) & ", "
    sQuery = sQuery & StringDB(inst.Notas) & ";"
    
    dbHandle.Execute sQuery

ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenContactos.Add"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function EliminarContactos(CodigoEntidad As String, TipoEntidad As String) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE FROM Contactos WHERE CodigoEntidad = " & StringDB(CodigoEntidad) & " AND TipoEntidad = " & StringDB(TipoEntidad)
    
ResumePoint:

    EliminarContactos = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "AlmacenContactos:EliminarContactos"
    bRetVal = False
    Resume ResumePoint

End Function

