VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenComprobantes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private qDetallesProcesados As Integer
Private inProcess As Boolean    ' Para impedir entradas concurrentes. (Los almacenes son casi estticos)
Private bAutoPrint As Boolean

'---------------------------------------------------------------------------------------
' Function AutoPrint
' Fecha/Hora: 13/04/03 13:55
' Funcin   : Determina si los comprobantes se deben generar automticamente con el re-
'             gistro de cada operacion que pueda generarlos.
'---------------------------------------------------------------------------------------
'
Public Function AutoPrint() As Boolean
Static isInit As Boolean

  If Not isInit Then
    bAutoPrint = (GetSetting("ClearLight", "General", "PrintComprobantes", "1") = "2")
    isInit = True
  End If
  AutoPrint = bAutoPrint

End Function

'---------------------------------------------------------------------------------------
' Function ActualizarDescriptivos
' Fecha/Hora: 13/04/03 13:56
' Funcin   : Actualiza los datos descriptivos de un comprobante
'---------------------------------------------------------------------------------------
'
Public Function ActualizarDescriptivos(inst As clsComprobante) As Boolean
Dim bRetVal As Boolean, sQuery As String

  bRetVal = True
  On Error GoTo ErrHandler
  
  sQuery = "UPDATE Comprobantes SET Fecha = " & FechaDB(inst.Fecha) & ", "
  sQuery = sQuery & "Referencia = " & StringDB(inst.Referencia) & ", "
  sQuery = sQuery & "Descripcion = " & StringDB(inst.Descripcion) & ", "
  sQuery = sQuery & "Autor = " & StringDB(UsuarioActivo.Codigo) & ", "
  sQuery = sQuery & "Modificado = " & TimeDateDB(Now)
  sQuery = sQuery & " WHERE NumeroComprobante = " & NumeroDB(inst.NumeroComprobante) & ";"

  dbHandle.Execute sQuery

ResumePoint:
  ActualizarDescriptivos = bRetVal
  Exit Function

ErrHandler:
  ReportarError True, Err.Number, Err.Description, "AlmacenComprobantes::ActualizarDescriptivos"
  bRetVal = False
  Resume ResumePoint

End Function

Public Function StartProcess() As Boolean
    
    While inProcess: DoEvents: Wend
    inProcess = True
    qDetallesProcesados = 1
    StartProcess = True

End Function

Public Function AbortProcess() As Boolean
    inProcess = False
    AbortProcess = True
End Function

Public Function EndProcess(arg As clsComprobante) As Boolean
Dim bRetVal As Boolean
    bRetVal = True
    dbHandle.Execute "UPDATE Comprobantes SET Debitos = " & NumeroDB(arg.Debitos) & ", Creditos = " & NumeroDB(arg.Creditos) & " WHERE NumeroComprobante = " & NumeroDB(arg.NumeroComprobante) & ";"
    On Error GoTo 0
    inProcess = False
    EndProcess = bRetVal
End Function

Function ProximoNumero() As Long
Dim lPeriodo As Long, rs As Recordset

    Set rs = dbHandle.Execute("SELECT Max(NumeroComprobante) As Ultimo FROM Comprobantes", , adCmdText)
    If rs.EOF Then
        lPeriodo = 1
    Else
        lPeriodo = GetNumeroFromVariant(rs.Fields("Ultimo")) + 1
    End If
    rs.Close
    Set rs = Nothing
    
    ProximoNumero = lPeriodo

End Function

Function ProximoComprobantePeriodo(ByVal ilPeriodo As Long) As Long
Dim lPeriodo As Long, rs As Recordset

    Set rs = dbHandle.Execute("SELECT MAX(CorrelativoPeriodo) AS ULTIMO FROM Comprobantes WHERE Periodo = " & NumeroDB(ilPeriodo), , adCmdText)
    If rs.EOF Then
        lPeriodo = 0
    Else
        lPeriodo = GetNumeroFromVariant(rs.Fields("ULTIMO"))
    End If
    rs.Close
    Set rs = Nothing
    
    ProximoComprobantePeriodo = lPeriodo + 1

End Function

Public Function SaveNew(arg As clsComprobante) As Boolean
Dim lPeriodo As Long, lrefPeriodo As Long, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    bRetVal = True
    lrefPeriodo = Empresa.Fecha2RefPeriodo(arg.Fecha)

    arg.CorrelativoPeriodo = ProximoComprobantePeriodo(lrefPeriodo)
    arg.NumeroComprobante = Me.ProximoNumero
    arg.Debitos = 0: arg.Creditos = 0
    arg.Periodo = lrefPeriodo

    sQuery = "INSERT INTO comprobantes (NumeroComprobante, Periodo, CorrelativoPeriodo, Referencia, Descripcion, Autor, Modificado, Fecha) SELECT "
    sQuery = sQuery & NumeroDB(arg.NumeroComprobante) & ", "
    sQuery = sQuery & NumeroDB(arg.Periodo) & ", "
    sQuery = sQuery & NumeroDB(arg.CorrelativoPeriodo) & ", "
    sQuery = sQuery & StringDB(arg.Referencia) & ", "
    sQuery = sQuery & StringDB(arg.Descripcion) & ", "
    sQuery = sQuery & StringDB(arg.Autor) & ", "
    sQuery = sQuery & TimeDateDB(Now) & ", "
    sQuery = sQuery & FechaDB(arg.Fecha) & ";"

    dbHandle.Execute sQuery

ResumePoint:
    SaveNew = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenComprobantes::SaveNew"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function AddDetalle(arg As clsComprobante, _
                            codigoCuenta As String, _
                            Descripcion As String, _
                            Referencia As String, _
                            ByVal Debitos As Double, _
                            ByVal Creditos As Double) As Boolean
Dim lDetalle As clsDetalles

    arg.Creditos = arg.Creditos + Creditos
    arg.Debitos = arg.Debitos + Debitos
    
    Set lDetalle = New clsDetalles
    
    lDetalle.Cuenta = codigoCuenta
    lDetalle.Descripcion = Descripcion
    lDetalle.RefDetalle = Referencia
    lDetalle.Debe = Debitos
    lDetalle.Haber = Creditos
    lDetalle.NumeroComprobante = arg.NumeroComprobante
    lDetalle.refPeriodo = arg.Periodo
    lDetalle.NumeroLinea = qDetallesProcesados
    AddDetalle = AlmacenDetalles.GrabarNuevoDetalle(lDetalle)
    
    qDetallesProcesados = qDetallesProcesados + 1
    Set lDetalle = Nothing
    AddDetalle = True

End Function

Function Load(Numero As Long, Dest As clsComprobante) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Comprobantes WHERE NumeroComprobante = " & NumeroDB(Numero), , adCmdText)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        With rs
        Dest.Autor = GetStringFromVariant(.Fields("Autor"))
        Dest.CorrelativoPeriodo = GetNumeroFromVariant(.Fields("CorrelativoPeriodo"))
        Dest.Creditos = GetNumeroFromVariant(.Fields("Creditos"))
        Dest.Debitos = GetNumeroFromVariant(.Fields("Debitos"))
        Dest.Descripcion = GetStringFromVariant(.Fields("Descripcion"))
        Dest.Fecha = GetDateFromVariant(.Fields("Fecha"))
        Dest.Modificado = GetDateFromVariant(.Fields("Modificado"))
        Dest.NumeroComprobante = GetNumeroFromVariant(.Fields("NumeroComprobante"))
        Dest.Periodo = GetNumeroFromVariant(.Fields("Periodo"))
        Dest.Referencia = GetStringFromVariant(.Fields("Referencia"))
        End With
    End If

    Load = bRetVal

End Function

Function LoadByRefPeriodo(ByVal Periodo As Long, ByVal Numero As Long, Dest As clsComprobante)
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Comprobantes WHERE Periodo = " & NumeroDB(Periodo) & " AND CorrelativoPeriodo = " & NumeroDB(Numero), , adCmdText)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        With rs
        Dest.Autor = .Fields("Autor")
        Dest.CorrelativoPeriodo = .Fields("CorrelativoPeriodo")
        Dest.Creditos = .Fields("Creditos")
        Dest.Debitos = .Fields("Debitos")
        Dest.Descripcion = .Fields("Descripcion")
        Dest.Fecha = .Fields("Fecha")
        Dest.Modificado = .Fields("Modificado")
        Dest.NumeroComprobante = .Fields("NumeroComprobante")
        Dest.Periodo = .Fields("Periodo")
        Dest.Referencia = .Fields("Referencia")
        End With
    End If
    
    LoadByRefPeriodo = bRetVal

End Function

Private Sub EliminarComprobante(Numero As Long) ' Es llamada exclusivamente de "Reverse"

    dbHandle.Execute "DELETE FROM Comprobantes WHERE NumeroComprobante = " & NumeroDB(Numero)

End Sub

Private Sub RenumerarComprobantesPeriodo(ByVal Periodo As Long, ByVal Correlativo As Long)

    dbHandle.Execute "UPDATE Comprobantes SET CorrelativoPeriodo = CorrelativoPeriodo - 1 WHERE Periodo = " & NumeroDB(Periodo) & " AND CorrelativoPeriodo > " & NumeroDB(Correlativo)

End Sub

Public Function Insertar(arg As clsComprobante) As Boolean
Dim ProximoNumero As Long, esteNumero As Long, estePeriodo As Long, sQuery As String

    StartTransaction
    esteNumero = Me.ProximoComprobantePeriodo(arg.Periodo)
    If (arg.CorrelativoPeriodo > esteNumero) Then
        arg.CorrelativoPeriodo = esteNumero
    Else    ' Insertar espacio en la secuencia de nmeros
        sQuery = "UPDATE Comprobantes SET CorrelativoPeriodo = CorrelativoPeriodo + 10000001 WHERE Periodo = " & NumeroDB(arg.Periodo) & " AND CorrelativoPeriodo >= " & NumeroDB(arg.CorrelativoPeriodo)
        dbHandle.Execute sQuery
        sQuery = "UPDATE Comprobantes SET  CorrelativoPeriodo = CorrelativoPeriodo - 10000000 WHERE Periodo = " & NumeroDB(arg.Periodo) & " AND CorrelativoPeriodo > 10000000"
        dbHandle.Execute sQuery
    End If

    sQuery = "INSERT INTO Comprobantes (NumeroComprobante, Periodo, CorrelativoPeriodo, Referencia, Descripcion, Autor, Fecha, Creditos, Debitos) SELECT "
    sQuery = sQuery & NumeroDB(arg.NumeroComprobante) & ", "
    sQuery = sQuery & NumeroDB(arg.Periodo) & ", "
    sQuery = sQuery & NumeroDB(arg.CorrelativoPeriodo) & ", "
    sQuery = sQuery & StringDB(arg.Referencia) & ", "
    sQuery = sQuery & StringDB(arg.Descripcion) & ", "
    sQuery = sQuery & StringDB(arg.Autor) & ", "
    sQuery = sQuery & FechaDB(arg.Fecha) & ", "
    sQuery = sQuery & NumeroDB(arg.Debitos) & ", "
    sQuery = sQuery & NumeroDB(arg.Creditos) & ";"
    dbHandle.Execute sQuery
    CommitTransaction

End Function

Public Sub Reverse(inst As clsComprobante, Kill As Boolean)
Dim colDetalles As Collection, instDetalle As clsDetalles, instCuenta As clsCuenta
    
    Set colDetalles = New Collection
    AlmacenDetalles.FillDetallesComprobante inst.NumeroComprobante, colDetalles
    Set instCuenta = New clsCuenta
    For Each instDetalle In colDetalles ' Revertir efecto de los movimientos
        instCuenta.Load instDetalle.Cuenta
        instCuenta.RegistrarVariacion instDetalle.Haber - instDetalle.Debe, instDetalle.refPeriodo, True, False
    Next
    Set instCuenta = Nothing
    Set colDetalles = Nothing
    
    AlmacenDetalles.EliminarDetallesComprobante inst.NumeroComprobante
    
    If Kill Then
        EliminarComprobante inst.NumeroComprobante
        RenumerarComprobantesPeriodo inst.Periodo, inst.CorrelativoPeriodo
    End If
End Sub

Public Sub FillByRefPeriodo(Dest As Collection, ByVal lpInicial As Currency, ByVal nInicial As Long, ByVal lpFinal As Currency, ByVal nFinal As Long)
Dim lNextPeriodo As Long, nNextNumero As Integer
Dim instComprobante As clsComprobante, rs As Recordset
Dim sQuery As String
    
    sQuery = "SELECT * FROM Comprobantes WHERE (Periodo * 100000 + CorrelativoPeriodo) BETWEEN " & NumeroDB(lpInicial * 100000@ + nInicial) & " AND " & NumeroDB(lpInicial * 100000@ + nFinal) & ";"
    Set rs = dbHandle.Execute(sQuery, , adCmdText)
    Do While Not rs.EOF
        Set instComprobante = New clsComprobante
        With rs
        instComprobante.Autor = .Fields("Autor")
        instComprobante.CorrelativoPeriodo = .Fields("CorrelativoPeriodo")
        instComprobante.Creditos = .Fields("Creditos")
        instComprobante.Debitos = .Fields("Debitos")
        instComprobante.Descripcion = .Fields("Descripcion")
        instComprobante.Fecha = .Fields("Fecha")
        instComprobante.Modificado = .Fields("Modificado")
        instComprobante.NumeroComprobante = .Fields("NumeroComprobante")
        instComprobante.Periodo = .Fields("Periodo")
        instComprobante.Referencia = .Fields("Referencia")
        If instComprobante.Periodo > lpFinal Then Exit Do
        If instComprobante.Periodo = lpFinal And instComprobante.CorrelativoPeriodo > nFinal Then Exit Do
        Dest.Add instComprobante
        .MoveNext
        End With
    Loop
    rs.Close
    Set rs = Nothing

End Sub


