VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenCompras"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Sub LoadInstance(pInstance As clsReciboMercancia, rsHandle As Recordset)
    With rsHandle
    pInstance.Numero = .Fields("Numero")
    pInstance.FechaRegistro = .Fields("FechaRegistro")
    pInstance.FechaTransaccion = .Fields("FechaTransaccion")
    pInstance.Operador = .Fields("Operador")
    pInstance.CodigoProveedor = .Fields("CodigoProveedor")
    pInstance.RefProveedor = .Fields("RefProveedor")
    pInstance.NombreProveedor = .Fields("NombreProveedor")
    pInstance.EstadoRecepcion = .Fields("EstadoRecepcion")
    pInstance.CostoMercancia = .Fields("CostoMercancia")
    pInstance.Descuento1 = .Fields("Descuento1")
    pInstance.Descuento2 = .Fields("Descuento2")
    pInstance.Impuesto1 = .Fields("Impuesto1")
    pInstance.Impuesto2 = .Fields("Impuesto2")
    pInstance.EstadoAdministrativo = .Fields("EstadoAdministrativo")
    pInstance.Condicion = .Fields("Condicion")
    pInstance.Notas = .Fields("Notas")
    pInstance.Saldo = .Fields("Saldo")
    pInstance.Almacen = .Fields("Almacen")
    End With
End Sub

Public Function UltimoDocumento() As Long
Dim lRetVal As Long, rs As Recordset
    
    Set rs = dbHandle.Execute("SELECT Max(Numero) AS Ultimo FROM Compras")
    If rs.EOF Then
        lRetVal = 0
    Else
        lRetVal = GetNumeroFromVariant(rs.Fields("Ultimo"))
    End If
    rs.Close
    
    UltimoDocumento = lRetVal
    
End Function

Public Function Load(inst As clsReciboMercancia, Numero As Long) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Compras WHERE Numero = " & NumeroDB(Numero))
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        If Not inst Is Nothing Then LoadInstance inst, rs
    End If
    rs.Close
    Set rs = Nothing

    Load = bRetVal

End Function

Public Function LoadByReferencia(inst As clsReciboMercancia, Proveedor As String, RefProv As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Compras WHERE CodigoProveedor = " & StringDB(Proveedor) & " AND refProveedor = " & StringDB(RefProv))
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        If Not inst Is Nothing Then LoadInstance inst, rs
    End If
    
    LoadByReferencia = bRetVal

End Function

' *****************************************************************
' StartProcess: Inicia una transaccin, graba estado inicial de la
' compra, deja abierto AlmacenCompras
Public Sub StartProcess(pInstance As clsReciboMercancia)
' pInstance.Numero = 0 -> Compra nueva
' NO CompraNueva -> NoHanVariado(pInstance.CodigoProveedor, pInstance.RefProveedor)
' FacturaNueva -> Correlativo = 0 && Unicos(pInstance.CodigoProveedor, pInstance.RefProveedor)  // Verificar esta condicion
Dim rs As Recordset, sQuery As String, bRetVal As Boolean
Dim nNumero As Long
' 11-08-2003: Un cliente comenz a generar referencias duplicadas
' en teora, la interfaz no lo permite, pero ya ves.
' este segmento se asegura de que una referencia duplicada se convierta
' en un nuevo recibo.
  If pInstance.Numero = 0 Then
    Set rs = dbHandle.Execute("SELECT Numero FROM Compras WHERE CodigoProveedor = " & StringDB(pInstance.CodigoProveedor) & " AND RefProveedor = " & StringDB(pInstance.RefProveedor))
    If rs.EOF Then
      nNumero = 0
    Else
      nNumero = GetNumeroFromVariant(rs.Fields("Numero"))
    End If
    rs.Close
    Set rs = Nothing

    If nNumero <> 0 Then
      ReportarError False, 10001, "RefProveedor duplicada en compra supuestamente nueva: original sobreescrito", "clsAlmacenCompras::StartProcess"
      pInstance.Numero = nNumero
    End If
  End If
' ******************** Fin segmento 11-08-2003 *************************
  bRetVal = True
  
  If pInstance.Numero = 0 Then    ' Si la factura no exista
    pInstance.Numero = Contadores.NumeroProximoDocumento(pInstance.TipoEntidad, True)
    dbHandle.Execute "INSERT INTO compras (Numero) SELECT " & NumeroDB(pInstance.Numero)
  Else                            ' i.e. si era una factura preexistente
    If Not Load(Nothing, pInstance.Numero) Then
      Err.Raise 10001, "StartProcess", "La factura DESAPARECIO"
    End If
  End If
  
  sQuery = "UPDATE Compras SET "
  sQuery = sQuery & "FechaRegistro = " & TimeDateDB(pInstance.FechaRegistro) & ", "
  sQuery = sQuery & "FechaTransaccion = " & FechaDB(pInstance.FechaTransaccion) & ", "
  sQuery = sQuery & "Operador = " & StringDB(pInstance.Operador) & ", "
  sQuery = sQuery & "CodigoProveedor = " & StringDB(pInstance.CodigoProveedor) & ", "
  sQuery = sQuery & "RefProveedor = " & StringDB(pInstance.RefProveedor) & ", "
  sQuery = sQuery & "CostoMercancia = " & NumeroDB(pInstance.CostoMercancia) & ", "
  sQuery = sQuery & "Impuesto1 = " & NumeroDB(pInstance.Impuesto1) & ", "
  sQuery = sQuery & "Impuesto2 = " & NumeroDB(pInstance.Impuesto2) & ", "
  sQuery = sQuery & "NombreProveedor = " & StringDB(pInstance.NombreProveedor) & ", "
  sQuery = sQuery & "Descuento1 = " & NumeroDB(pInstance.Descuento1) & ", "
  sQuery = sQuery & "Descuento2 = " & NumeroDB(pInstance.Descuento2) & ", "
  sQuery = sQuery & "Almacen = " & StringDB(pInstance.Almacen) & ", "
  sQuery = sQuery & "EstadoRecepcion = " & NumeroDB(pInstance.EstadoRecepcion) & ", "
  sQuery = sQuery & "EstadoAdministrativo = " & NumeroDB(pInstance.EstadoAdministrativo) & ", "
  sQuery = sQuery & "Condicion = " & StringDB(pInstance.Condicion) & ", "
  sQuery = sQuery & "Notas = " & StringDB(pInstance.Notas) & ", "
  sQuery = sQuery & "NumeroControl = " & NumeroDB(pInstance.NumeroControl) & ", "
  sQuery = sQuery & "Saldo = " & NumeroDB(pInstance.Saldo) & " "
  sQuery = sQuery & "WHERE Numero = " & NumeroDB(pInstance.Numero)
 
  dbHandle.Execute sQuery
    
End Sub

Public Sub EndProcess(pInstance As clsReciboMercancia)
Dim sQuery As String

    sQuery = "UPDATE Compras SET CostoMercancia = " & NumeroDB(pInstance.CostoMercancia) & ", "
    sQuery = sQuery & "Impuesto1 = " & NumeroDB(pInstance.Impuesto1) & ", "
    sQuery = sQuery & "Impuesto2 = " & NumeroDB(pInstance.Impuesto2) & ", "
    sQuery = sQuery & "EstadoRecepcion = " & NumeroDB(pInstance.EstadoRecepcion) & ", "
    sQuery = sQuery & "EstadoAdministrativo = " & NumeroDB(pInstance.EstadoAdministrativo) & ", "
    sQuery = sQuery & "Saldo = " & NumeroDB(pInstance.Saldo) & " "
    sQuery = sQuery & "WHERE Numero = " & NumeroDB(pInstance.Numero)
    
    dbHandle.Execute sQuery
    
'    CommitTransaction

End Sub

Public Sub AbortProcess()
'    AbortTransaction
End Sub

Public Function RegistrarVariacion(obj As clsReciboMercancia, vmMonto As Currency) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    bRetVal = True
    dbHandle.Execute "UPDATE Compras SET Saldo = Saldo - (" & NumeroDB(vmMonto) & ") WHERE Numero = " & NumeroDB(obj.Numero)
    dbHandle.Execute "UPDATE Compras SET Saldo = 0, EstadoAdministrativo = 2 WHERE Numero = " & NumeroDB(obj.Numero) & " AND Saldo <= 0"
    obj.Saldo = obj.Saldo - vmMonto
    If obj.Saldo <= 0 Then
        obj.Saldo = 0
        obj.EstadoAdministrativo = 2
    End If

    RegistrarVariacion = bRetVal

End Function
