VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenCompItemsVnt"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Function EliminarComponenteInventario(sCodigo As String) As Boolean
Dim isOk As Boolean, sQuery As String

    isOk = True
    On Error GoTo ErrHandler
    
    sQuery = "DELETE FROM ComposicionItemsVenta WHERE CodigoItemInventario = " & StringDB(sCodigo)
    dbHandle.Execute sQuery

ResumePoint:
    EliminarComponenteInventario = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenComposicionItemsVenta.EliminarComposicionItemVenta"
    isOk = False
    Resume ResumePoint

End Function

Public Function EliminarComposicionItemVenta(stCodigo As String) As Boolean
Dim isOk As Boolean
    
    On Error GoTo ErrHandler
    isOk = True
    dbHandle.Execute "DELETE FROM ComposicionItemsVenta WHERE CodigoItemVenta = " & StringDB(stCodigo)
    
ResumePoint:
    EliminarComposicionItemVenta = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenComposicionItemsVenta.EliminarComposicionItemVenta"
    isOk = False
    Resume ResumePoint
End Function

Public Function ActualizarComposicion(stCodigo As String, colComponentes As Collection) As Boolean
Dim bRetVal As Boolean, inst As clsComponenteItemVenta, sQuery As String
    
    On Error GoTo ErrHandler
    bRetVal = EliminarComposicionItemVenta(stCodigo)
    If bRetVal Then
        For Each inst In colComponentes
            sQuery = "INSERT INTO ComposicionItemsVenta (CodigoItemVenta, CodigoItemInventario, Cantidad) SELECT "
            sQuery = sQuery & StringDB(stCodigo) & ", "
            sQuery = sQuery & StringDB(inst.CodigoItemInventario) & ", "
            sQuery = sQuery & NumeroDB(inst.Cantidad) & ";"
            
            dbHandle.Execute sQuery
        Next
    End If

ResumePoint:
    ActualizarComposicion = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenComposicionItemsVenta::ActualizarComposicion"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ComponentesItem(stCodigo As String) As Collection
Dim stCopia As String, retCol As Collection
Dim inst As clsComponenteItemVenta, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM ComposicionItemsVenta WHERE CodigoItemVenta = " & StringDB(stCodigo))

    Set retCol = New Collection
    Do While Not rs.EOF
        Set inst = New clsComponenteItemVenta
        inst.CodigoItemInventario = rs.Fields("CodigoItemInventario")
        inst.CodigoItemVenta = rs.Fields("CodigoItemVenta")
        inst.Cantidad = rs.Fields("Cantidad")
        retCol.Add inst, inst.CodigoItemInventario
        rs.MoveNext
    Loop
    
    rs.Close
    Set rs = Nothing

    Set ComponentesItem = retCol
End Function

' El costo standard de los itemsVenta compuestos por
' varios itemsInv son la suma de los costos * cantidad de los itemsInv
' componentes.

Public Function RegistrarVariacionCostoComponente( _
    itemInv As clsItemInventario, _
    NuevoCP As Double, _
    nuevoUC As Double, _
    indexarPrecios As Boolean, _
    Redondeo As Double) As Boolean
Dim litemVenta As clsItemVenta, lComponente As clsComponenteItemVenta
Dim lrs As Recordset
Dim NuevoCostoItemV As Double, newCostoReferencia As Currency, orgCostoReferencia As Currency

  If Redondeo = 0 Then Redondeo = 0.01
  Set lrs = dbHandle.Execute("SELECT * From ComposicionItemsVenta WHERE CodigoItemInventario = " & StringDB(itemInv.Codigo))
  Set lComponente = New clsComponenteItemVenta
  
  Do While Not lrs.EOF
    With lComponente
    .CodigoItemInventario = lrs.Fields("CodigoItemInventario")
    .CodigoItemVenta = lrs.Fields("CodigoItemVenta")
    .Cantidad = lrs.Fields("Cantidad")
    End With
    
    Set litemVenta = AlmacenItemsVenta.ItemVenta(lComponente.CodigoItemVenta)
    If Not litemVenta Is Nothing Then
      Select Case Empresa.valoracionInventario
      Case 0
        orgCostoReferencia = itemInv.CostoPromedio
        newCostoReferencia = NuevoCP
      Case 1
        orgCostoReferencia = itemInv.UltimoCosto
        newCostoReferencia = nuevoUC
      End Select
      
      NuevoCostoItemV = litemVenta.CostoStandard - (orgCostoReferencia * lComponente.Cantidad) + (newCostoReferencia * lComponente.Cantidad)
      
      If indexarPrecios Then
        If litemVenta.CostoStandard > 0 Then
          litemVenta.Precio1 = litemVenta.Precio1 * NuevoCostoItemV / litemVenta.CostoStandard
          If (litemVenta.Precio1 >= Redondeo) Then litemVenta.Precio1 = (Int(litemVenta.Precio1 * (1# + litemVenta.PorcentajeImpuesto(1) / 100) / Redondeo + 0.5) * Redondeo) / (1# + litemVenta.PorcentajeImpuesto(1) / 100)
          
          litemVenta.Precio2 = litemVenta.Precio2 * NuevoCostoItemV / litemVenta.CostoStandard
          If (litemVenta.Precio2 >= Redondeo) Then litemVenta.Precio2 = (Int(litemVenta.Precio2 * (1# + litemVenta.PorcentajeImpuesto(1) / 100) / Redondeo + 0.5) * Redondeo) / (1# + litemVenta.PorcentajeImpuesto(1) / 100)
          
          litemVenta.Precio3 = litemVenta.Precio3 * NuevoCostoItemV / litemVenta.CostoStandard
          If (litemVenta.Precio3 >= Redondeo) Then litemVenta.Precio3 = (Int(litemVenta.Precio3 * (1# + litemVenta.PorcentajeImpuesto(1) / 100) / Redondeo + 0.5) * Redondeo) / (1# + litemVenta.PorcentajeImpuesto(1) / 100)
          
          litemVenta.Precio4 = litemVenta.Precio4 * NuevoCostoItemV / litemVenta.CostoStandard
          If (litemVenta.Precio4 >= Redondeo) Then litemVenta.Precio4 = (Int(litemVenta.Precio4 * (1# + litemVenta.PorcentajeImpuesto(1) / 100) / Redondeo + 0.5) * Redondeo) / (1# + litemVenta.PorcentajeImpuesto(1) / 100)
        End If
      End If
      
      litemVenta.CostoStandard = NuevoCostoItemV
      
      litemVenta.ActualizarCosto indexarPrecios
          
      Set litemVenta = Nothing
  
    Else
        
      Report "ItemVenta " & lComponente.CodigoItemVenta & " no localizado en RegistrarVariacionCostoComponente:" & itemInv.Codigo
    
    End If
    lrs.MoveNext
  Loop
  
  Set lComponente = Nothing

  lrs.Close
  Set lrs = Nothing

End Function

