VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenClientes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para cada una de las cuentas de banco almacenadas en el sistema."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' clsClassGenerator V1.0
Option Explicit

Public Function Eliminar(sCodigo As String) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE FROM Clientes WHERE Codigo = " & StringDB(sCodigo)

ResumePoint:

    Eliminar = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "AlmacenClientes:Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

Private Sub LoadInstance(pInstance As clsClientes, rsHandle As Recordset)
    
    With rsHandle
    pInstance.Codigo = GetStringFromVariant(.Fields("Codigo"))
    pInstance.Nombre = GetStringFromVariant(.Fields("Nombre"))
    pInstance.Tipo = GetStringFromVariant(.Fields("Tipo"))
    pInstance.RIF = GetStringFromVariant(.Fields("RIF"))
    pInstance.NIT = GetStringFromVariant(.Fields("NIT"))
    pInstance.CuentaActivo = GetStringFromVariant(.Fields("CGCuenta"))
    pInstance.CuentaIngresos = GetStringFromVariant(.Fields("CuentaIngresos"))
    pInstance.Direccion = GetStringFromVariant(.Fields("Direccion"))
    pInstance.Telefono = GetStringFromVariant(.Fields("Telefono"))
    pInstance.Zona = GetStringFromVariant(.Fields("Zona"))
    pInstance.Ruta = GetStringFromVariant(.Fields("Ruta"))
    pInstance.Estado = GetStringFromVariant(.Fields("Estado"))
    pInstance.Municipio = GetStringFromVariant(.Fields("Municipio"))
    pInstance.VendedorAsignado = GetStringFromVariant(.Fields("VendedorAsignado"))
    pInstance.CondicionStandard = GetStringFromVariant(.Fields("CondicionStandard"))
    pInstance.PrecioStandard = GetStringFromVariant(.Fields("PrecioStandard"))
    pInstance.SaldoActual = GetNumeroFromVariant(.Fields("SaldoActual"))
    pInstance.LimiteCredito = GetNumeroFromVariant(.Fields("LimiteCredito"))
    pInstance.Status = GetNumeroFromVariant(.Fields("Status"))
    pInstance.FechaUltimaVenta = GetDateFromVariant(.Fields("FechaUltimaVenta"))
    pInstance.Notas = GetStringFromVariant(.Fields("Notas"))
    End With

End Sub

Public Function Load(Codigo As String, Optional destino As clsClientes = Nothing) As Boolean
Dim bRetVal As Boolean, rs As Recordset, lpDest As clsClientes

    Set lpDest = destino
    If lpDest Is Nothing Then Set lpDest = Me

    Set rs = dbHandle.Execute("SELECT * FROM Clientes WHERE Codigo = " & StringDB(Codigo))
    If rs.EOF Then
        bRetVal = False
    Else
        LoadInstance destino, rs
        bRetVal = True
    End If
    rs.Close
    
ResumePoint:
    Set rs = Nothing
    Load = bRetVal

End Function

Public Function Cliente(Codigo As String) As clsClientes
Dim cInstance As clsClientes
    Set cInstance = New clsClientes
    If Not Load(Codigo, cInstance) Then
        Set cInstance = Nothing
    End If
    Set Cliente = cInstance
End Function

Public Function LoadSiguiente(destino As clsClientes) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Clientes WHERE Codigo IN (Select Min(Codigo) FROM Clientes WHERE Codigo > " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsClientes::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadAnterior(destino As clsClientes) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Clientes WHERE Codigo IN (Select Max(Codigo) FROM Clientes WHERE Codigo < " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsClientes::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT Codigo FROM Clientes WHERE Codigo = " & StringDB(arg)
    Set rs = dbHandle.Execute(sQuery)
    bRetVal = Not rs.EOF

ResumePoint:

    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsClientes::ExisteCodigo", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Crear(Clave As String) As Boolean
    If Not Confirmar("Crear nuevo Cliente") Then
        Crear = False
        Exit Function
    End If
    OpenFIEClientes Clave
    Crear = ExisteCodigo(Clave)
End Function

Public Function Validar(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    stTemp = Trim(Format(Codigo, ">"))
    Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo"
        bRetVal = False
    Else
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_CLIENTES) Then
                    bRetVal = False
                Else
                    bRetVal = Crear(stTemp)
                End If
            End If
        End If
    End If
    Validar = bRetVal
End Function

Public Function Add(iItem As clsClientes) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    sQuery = "INSERT INTO clientes (Codigo, Nombre, Tipo, RIF, NIT, CGCuenta, CuentaIngresos, Direccion, Telefono, "
    sQuery = sQuery & "Zona, Estado, Municipio, VendedorAsignado, "
    sQuery = sQuery & "CondicionStandard, PrecioStandard, LimiteCredito, Status, FechaUltimaVenta, FechaCreacion, Notas) SELECT "
    
    With iItem
    sQuery = sQuery & StringDB(.Codigo) & ", "
    sQuery = sQuery & StringDB(.Nombre) & ", "
    sQuery = sQuery & StringDB(.Tipo) & ", "
    sQuery = sQuery & StringDB(.RIF) & ", "
    sQuery = sQuery & StringDB(.NIT) & ", "
    sQuery = sQuery & StringDB(.CuentaActivo) & ", "
    sQuery = sQuery & StringDB(.CuentaIngresos) & ", "
    sQuery = sQuery & StringDB(.Direccion) & ", "
    sQuery = sQuery & StringDB(.Telefono) & ", "
    sQuery = sQuery & StringDB(.Zona) & ", "
    sQuery = sQuery & StringDB(.Estado) & ", "
    sQuery = sQuery & StringDB(.Municipio) & ", "
    sQuery = sQuery & StringDB(.VendedorAsignado) & ", "
    sQuery = sQuery & StringDB(.CondicionStandard) & ", "
    sQuery = sQuery & StringDB(.PrecioStandard) & ", "
    sQuery = sQuery & NumeroDB(.LimiteCredito) & ", "
    sQuery = sQuery & NumeroDB(.Status) & ", "
    sQuery = sQuery & FechaDB(.FechaUltimaVenta) & ", "
    sQuery = sQuery & TimeDateDB(Now) & ", "
    sQuery = sQuery & StringDB(.Notas) & ";"
    End With

    dbHandle.Execute sQuery
    
    bRetVal = True

ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenClientes.Add"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(instance As clsClientes, _
        iNombre As String, _
        iTipo As String, _
        iRif As String, _
        istNIT As String, _
        iCGCuenta As String, _
        iCuentaIngreso As String, _
        iDireccion As String, _
        iTelefono As String, _
        iZona As String, _
        iRuta As String, _
        iEstado As String, _
        iMunicipio As String, _
        iVendedorAsignado As String, _
        iCondicionStandard As String, _
        iPrecioStandard As String, _
        iLimiteCredito As Double, _
        iStatus As Byte, _
        iNotas As String) As Boolean
Dim bRetVal As Boolean, sQuery As String
Dim ra As Long, rs As Recordset

  On Error GoTo ErrHandler
    
  bRetVal = True
  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM Clientes WHERE Codigo = " & StringDB(instance.Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing

  If ra > 0 Then
    sQuery = "UPDATE clientes SET "
    sQuery = sQuery & "Nombre = " & StringDB(iNombre)
    sQuery = sQuery & ", Tipo = " & StringDB(iTipo)
    sQuery = sQuery & ", RIF = " & StringDB(iRif)
    sQuery = sQuery & ", NIT = " & StringDB(istNIT)
    sQuery = sQuery & ", CGCuenta = " & StringDB(iCGCuenta)
    sQuery = sQuery & ", CuentaIngresos = " & StringDB(iCuentaIngreso)
    sQuery = sQuery & ", Direccion = " & StringDB(iDireccion)
    sQuery = sQuery & ", Telefono = " & StringDB(iTelefono)
    sQuery = sQuery & ", Zona = " & StringDB(iZona)
    sQuery = sQuery & ", Ruta = " & StringDB(iRuta)
    sQuery = sQuery & ", Estado = " & StringDB(iEstado)
    sQuery = sQuery & ", Municipio = " & StringDB(iMunicipio)
    sQuery = sQuery & ", VendedorAsignado = " & StringDB(iVendedorAsignado)
    sQuery = sQuery & ", CondicionStandard = " & StringDB(iCondicionStandard)
    sQuery = sQuery & ", PrecioStandard = " & StringDB(iPrecioStandard)
    sQuery = sQuery & ", LimiteCredito = " & NumeroDB(iLimiteCredito)
    sQuery = sQuery & ", Status = " & NumeroDB(iStatus)
    sQuery = sQuery & ", Notas = " & StringDB(iNotas)
    sQuery = sQuery & " WHERE Codigo = " & StringDB(instance.Codigo)
  Else
    sQuery = "INSERT INTO clientes (Codigo, Nombre, Tipo, RIF, NIT, CgCuenta, CuentaIngresos, Direccion, Telefono, Zona, Ruta, Estado,"
    sQuery = sQuery & " Municipio, VendedorAsignado, CondicionStandard, PrecioStandard, LimiteCredito, Status, FechaCreacion, Notas) SELECT "
    sQuery = sQuery & StringDB(instance.Codigo)
    sQuery = sQuery & ", " & StringDB(iNombre)
    sQuery = sQuery & ", " & StringDB(iTipo)
    sQuery = sQuery & ", " & StringDB(iRif)
    sQuery = sQuery & ", " & StringDB(istNIT)
    sQuery = sQuery & ", " & StringDB(iCGCuenta)
    sQuery = sQuery & ", " & StringDB(iCuentaIngreso)
    sQuery = sQuery & ", " & StringDB(iDireccion)
    sQuery = sQuery & ", " & StringDB(iTelefono)
    sQuery = sQuery & ", " & StringDB(iZona)
    sQuery = sQuery & ", " & StringDB(iRuta)
    sQuery = sQuery & ", " & StringDB(iEstado)
    sQuery = sQuery & ", " & StringDB(iMunicipio)
    sQuery = sQuery & ", " & StringDB(iVendedorAsignado)
    sQuery = sQuery & ", " & StringDB(iCondicionStandard)
    sQuery = sQuery & ", " & StringDB(iPrecioStandard)
    sQuery = sQuery & ", " & NumeroDB(iLimiteCredito)
    sQuery = sQuery & ", " & NumeroDB(iStatus)
    sQuery = sQuery & ", " & TimeDateDB(Now)
    sQuery = sQuery & ", " & StringDB(iNotas) & ";"
  End If
  dbHandle.Execute sQuery
  
ResumePoint:
  ActualizarDescriptivos = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenClientes.ActualizarDescriptivos"
  bRetVal = False
  Resume ResumePoint
End Function

Public Function RegistrarVariacionSaldo(inst As clsClientes, vmVariacion As Currency) As Boolean
Dim bRetVal As Boolean, rsHandle As Recordset
    
    bRetVal = implementacionISPC.RegistrarVariacionSaldo("Clientes", inst, vmVariacion)
    RegistrarVariacionSaldo = bRetVal

End Function

Public Sub SetFechaVenta(inst As clsClientes, dt As Date)

    dbHandle.Execute "UPDATE Clientes SET FechaUltimaVenta = " & FechaDB(dt) & " WHERE Codigo = " & StringDB(inst.Codigo)
    inst.FechaUltimaVenta = dt

End Sub


