VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenBancos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' clsClassGenerator V1.0

Public Function Eliminar(sCodigo As String) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE FROM Bancos WHERE Codigo = " & StringDB(sCodigo)

ResumePoint:

    Eliminar = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "AlmacenBancos:Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

Private Sub LoadInstance(pInstance As clsBancos, rsHandle As Recordset)
    With rsHandle
    pInstance.Codigo = .Fields("Codigo")
    pInstance.Cuenta = stGetStringFromVariant(.Fields("Cuenta"))
    pInstance.Nombre = stGetStringFromVariant(.Fields("Nombre"))
    pInstance.Banco = stGetStringFromVariant(.Fields("Banco"))
    pInstance.TipoCuenta = stGetStringFromVariant(.Fields("TipoCuenta"))
    pInstance.CuentaActivo = stGetStringFromVariant(.Fields("CGCuenta"))
    pInstance.SaldoActual = GetNumeroFromVariant(.Fields("SaldoActual"))
    pInstance.DepositosDiferidos = GetNumeroFromVariant(.Fields("DepositosDiferidos"))
    pInstance.ChequesPostdatados = GetNumeroFromVariant(.Fields("ChequesPostdatados"))
    pInstance.UltimaActualizacion = GetNumeroFromVariant(.Fields("UltimaActualizacion"))
    pInstance.ProximoCheque = GetNumeroFromVariant(.Fields("ProximoCheque"))
    End With
End Sub

Public Function Load(Codigo As String, destino As clsBancos) As Boolean
Dim bRetVal As Boolean, sQuery As String, rsHandle As Recordset

    Set rsHandle = dbHandle.Execute("SELECT * FROM Bancos WHERE Codigo = " & StringDB(Codigo))
    If rsHandle.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance destino, rsHandle
    End If
    rsHandle.Close
    
ResumePoint:
    Set rsHandle = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenBancos.Load"
    Resume ResumePoint
End Function

Public Function Banco(Codigo As String) As clsBancos
Dim cInstance As clsBancos
    Set cInstance = New clsBancos
    If Not Load(Codigo, cInstance) Then
        Set cInstance = Nothing
    End If
    Set Banco = cInstance
End Function

Public Function LoadAnterior(destino As clsBancos) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Bancos WHERE Codigo IN (Select Max(Codigo) FROM Bancos WHERE Codigo < " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadAnterior = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsBancos::LoadAnterior", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function LoadSiguiente(destino As clsBancos) As Boolean
Dim bResult As Boolean, rs As Recordset, sQuery As String
    
    sQuery = "SELECT * FROM Bancos WHERE Codigo IN (Select Min(Codigo) FROM Bancos WHERE Codigo > " & StringDB(destino.Codigo) & ")"
    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        bResult = True
        LoadInstance destino, rs
    Else
        bResult = False
    End If

ResumePoint:
    Set rs = Nothing
    LoadSiguiente = bResult
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsBancos::LoadSiguiente", Err.Description
    bResult = False
    Resume ResumePoint

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT Codigo FROM Bancos WHERE Codigo = " & StringDB(arg)
    Set rs = dbHandle.Execute(sQuery)
    bRetVal = Not rs.EOF

ResumePoint:

    Set rs = Nothing
    ExisteCodigo = bRetVal
    Exit Function

ErrHandler:

    Err.Raise Err.Number, "clsBancos::ExisteCodigo", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Crear(Clave As String) As Boolean
    If Not Confirmar("Crear nuevo Banco") Then
        Crear = False
        Exit Function
    End If
    OpenFIEBancos Clave
    Crear = ExisteCodigo(Clave)
End Function

Public Function Validar(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    
    stTemp = Trim(Format(Codigo, ">"))
    Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo"
        bRetVal = False
    Else
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_BANCOS) Then
                    bRetVal = False
                Else
                    bRetVal = Crear(stTemp)
                End If
            End If
        End If
    End If
    Validar = bRetVal
End Function

Public Function Add(iItem As clsBancos) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    sQuery = "INSERT INTO bancos (Codigo, Cuenta, Nombre, Banco, TipoCuenta, CGCuenta, FechaCreacion, UltimaActualizacion, ProximoCheque) SELECT "
    sQuery = sQuery & StringDB(iItem.Codigo) & ", "
    sQuery = sQuery & StringDB(iItem.Cuenta) & ", "
    sQuery = sQuery & StringDB(iItem.Nombre) & ", "
    sQuery = sQuery & StringDB(iItem.Banco) & ", "
    sQuery = sQuery & NumeroDB(iItem.TipoCuenta) & ", "
    sQuery = sQuery & StringDB(iItem.CGCuenta) & ", "
    sQuery = sQuery & TimeDateDB(Now) & ", "
    sQuery = sQuery & FechaDB(Date) & ", "
    sQuery = sQuery & NumeroDB(iItem.ProximoCheque) & ";"
    
    bRetVal = True
    dbHandle.Execute sQuery
    
ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsAlmacenBancos.Add"
    bRetVal = False
    Resume ResumePoint
End Function

Public Function ActualizarDescriptivos(instance As clsBancos, _
    iCuenta As String, _
    iNombre As String, _
    iBanco As String, _
    iTipoCuenta As TipoCuentaBanco, _
    iCGCuenta As String, _
    ByVal iProximoCheque As Long) As Boolean
Dim bRetVal As Boolean, sQuery As String, lqRecords As Long
Dim ra As Long, rs As Recordset

  bRetVal = True
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM Bancos WHERE Codigo = " & StringDB(instance.Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing
  If ra > 0 Then
    sQuery = "UPDATE Bancos SET Cuenta = " & StringDB(iCuenta) & ", "
    sQuery = sQuery & "Nombre = " & StringDB(iNombre) & ", "
    sQuery = sQuery & "Banco = " & StringDB(iBanco) & ", "
    sQuery = sQuery & "TipoCuenta = " & NumeroDB(iTipoCuenta) & ", "
    sQuery = sQuery & "CGCuenta = " & StringDB(iCGCuenta) & ", "
    sQuery = sQuery & "ProximoCheque = " & NumeroDB(iProximoCheque) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(instance.Codigo)
  Else
    sQuery = "INSERT INTO Bancos (Codigo, Cuenta, Nombre, Banco, TipoCuenta, CGCuenta, ProximoCheque) SELECT "
    sQuery = sQuery & StringDB(instance.Codigo) & ", "
    sQuery = sQuery & StringDB(iCuenta) & ", "
    sQuery = sQuery & StringDB(iNombre) & ", "
    sQuery = sQuery & StringDB(iBanco) & ", "
    sQuery = sQuery & NumeroDB(iTipoCuenta) & ", "
    sQuery = sQuery & StringDB(iCGCuenta) & ", "
    sQuery = sQuery & NumeroDB(iProximoCheque) & ";"
  End If
  dbHandle.Execute sQuery

ResumePoint:
  ActualizarDescriptivos = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "AlmacenBancos.ActualizarDescriptivos"
  bRetVal = False
  On Error GoTo 0
  Resume ResumePoint
End Function

Public Function SetProximoCheque(stBanco As String, lNumeroCheque As Long) As Boolean
Dim sQuery As String, bRetVal As Boolean

    sQuery = "UPDATE Bancos SET ProximoCheque =" & Str(lNumeroCheque) & " WHERE Codigo = " & StringDB(stBanco)
    On Error GoTo ErrHandler
    
    bRetVal = True
    dbHandle.Execute sQuery
    
ResumePoint:

    SetProximoCheque = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenBancos.SetProximoCheque"
    Err.Clear
    Resume ResumePoint

End Function

Public Function RegistrarVariacionSaldo(inst As clsBancos, vmVariacion As Currency) As Boolean
Dim bRetVal As Boolean
    
    bRetVal = implementacionISPC.RegistrarVariacionSaldo("Bancos", inst, vmVariacion)
    RegistrarVariacionSaldo = bRetVal

End Function

Public Sub ActualizarDiferidos(pBanco As clsBancos)
Dim rs As Recordset, stQuery As String, vmDiff As Currency, vmCheques As Currency, vmDepositos As Currency
Dim TipoMov As Integer

    On Error GoTo ErrHandler

    StartTransaction
    
    Load pBanco.Codigo, pBanco
    
    stQuery = "SELECT * FROM DiferidosBanco WHERE CodigoBanco = " & StringDB(pBanco.Codigo) & " AND FechaPresentacion <= " & FechaDB(Date)

    Set rs = dbHandle.Execute(stQuery)
    
    Do While Not rs.EOF
        vmDiff = rs.Fields("MontoDiferido")
        TipoMov = rs.Fields("TipoMovimiento")
        If TipoMov = TMB_CHEQUE Or TipoMov = TMB_NDB Then
            vmCheques = vmCheques + vmDiff
        Else
            vmDepositos = vmDepositos + vmDiff
        End If
        rs.MoveNext
    Loop

    rs.Close
    Set rs = Nothing

    stQuery = "DELETE FROM DiferidosBanco WHERE CodigoBanco = " & StringDB(pBanco.Codigo) & " AND FechaPresentacion < " & FechaDB(Date + 1)
    dbHandle.Execute stQuery
    
    stQuery = "UPDATE Bancos SET DepositosDiferidos = DepositosDiferidos -" & NumeroDB(vmDepositos) & ", ChequesPostdatados = ChequesPostdatados -" & NumeroDB(vmCheques) & ", UltimaActualizacion = " & FechaDB(Date) & " WHERE Codigo = " & StringDB(pBanco.Codigo)
    dbHandle.Execute stQuery
    
    Load pBanco.Codigo, pBanco
    
    lmdbHandle.CommitTransaction

ResumePoint:
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenBancos.ActualizarDiferidos"
    Err.Clear
    lmdbHandle.AbortTransaction
    Resume ResumePoint

End Sub

Public Function RegistrarDiferido(stBanco As String, _
            dtFechaPresentacion As Date, _
            nTipoMovimiento As Integer, _
            stConcepto As String, _
            stRefBanco As String, _
            vmMonto As Currency) As Boolean
Dim bRetVal As Boolean, stDestField As String, sqlQuery As String
Dim rs As Recordset

    On Error GoTo ErrHandler

    If dtFechaPresentacion <= Date Then
        RegistrarDiferido = True
        Exit Function
    End If
    
    If Abs(vmMonto) < 1@ Then
        RegistrarDiferido = True
        Exit Function
    End If

    If vmMonto < 0 Then
        vmMonto = -vmMonto
        stDestField = "ChequesPostdatados"
    Else
        stDestField = "DepositosDiferidos"
    End If
    
    bRetVal = True
    sqlQuery = "UPDATE Bancos SET " & stDestField & " = " & stDestField & " + " & NumeroDB(vmMonto) & " WHERE Codigo = " & StringDB(stBanco)
    dbHandle.Execute sqlQuery

    sqlQuery = "INSERT INTO DiferidosBanco (CodigoBanco, FechaPresentacion, MontoDiferido, TipoMovimiento, Descripcion, RefBanco) SELECT "
    sqlQuery = sqlQuery & StringDB(stBanco) & ", " & FechaDB(dtFechaPresentacion) & ", "
    sqlQuery = sqlQuery & NumeroDB(vmMonto) & ", " & NumeroDB(nTipoMovimiento) & ", "
    sqlQuery = sqlQuery & StringDB(stConcepto) & ", " & StringDB(stRefBanco)

    dbHandle.Execute sqlQuery

ResumePoint:

    If Not rs Is Nothing Then
        On Error Resume Next
        rs.Close
        On Error GoTo 0
        Set rs = Nothing
    End If

    RegistrarDiferido = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenBancos.RegistrarDiferido"
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function



