VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacenAmbientes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para cada una de las cuentas de banco almacenadas en el sistema."
' clsClassGenerator V1.0
Option Explicit

Private Sub LoadInstance(pInstance As clsAmbiente, rsHandle As Recordset)

    With rsHandle
    pInstance.Codigo = .Fields("Codigo")
    pInstance.Prefijo = .Fields("Prefijo")
    pInstance.Descripcion = .Fields("Descripcion")
    pInstance.AccountOffset = .Fields("AccountOffset")
    pInstance.PorcentajeServicio = .Fields("PorcentajeServicio")
    pInstance.IndicePrecio = .Fields("IndicePrecio")
    pInstance.Escala = .Fields("Escala")
    pInstance.ColorMesas = .Fields("ColorMesas")
    pInstance.ColorSillas = .Fields("ColorSillas")
    pInstance.BackColor = .Fields("BackColor")
    pInstance.FormaSillas = .Fields("FormaSillas")
    pInstance.FormaMesas = .Fields("FormaMesas")
    pInstance.SillasVisibles = .Fields("SillasVisibles")
    If pInstance.IndicePrecio < 1 Or pInstance.IndicePrecio > 4 Then
      pInstance.IndicePrecio = 1
    End If
    End With

End Sub


Public Function Load(istCodigo As String, Optional opAmbiente As clsAmbiente = Nothing) As clsAmbiente
Attribute Load.VB_Description = "Si existe el ambiente con cdigo <istCodigo>, devuelve un apuntador a una instancia cargada con los datos correspondientes. Si el argumento opcional opAmbiente no es Nothing, carga los datos en la instancia referida por el, y devuelve el apuntado a la mi"
' OJO: La funcion Load recibe como argumento el codigo de una instancia, y puede recibir
'      opcionalmente un apuntador de dnde debern ser cargados los datos.
'      Devuelve Nothing si no lo localiza, o un apuntador a la instancia que contiene
'      los datos ledos. Puede ser el buffer pasado o uno creado internamente.
Dim pAmbiente As clsAmbiente, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM mesasAmbientes WHERE Codigo = " & StringDB(istCodigo))
    
    If rs.EOF Then
        
        Set pAmbiente = Nothing
    
    Else
        
        If Not opAmbiente Is Nothing Then
            Set pAmbiente = opAmbiente
        Else
            Set pAmbiente = New clsAmbiente
        End If
        
        LoadInstance pAmbiente, rs
    
    End If
    
    Set rs = Nothing
    
    Set Load = pAmbiente
    
End Function

Public Function LoadByDescripcion(istPrefijo As String, Optional opAmbiente As clsAmbiente = Nothing) As clsAmbiente
Dim pAmbiente As clsAmbiente, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM mesasAmbientes WHERE Descripcion = " & StringDB(istPrefijo))
    
    If rs.EOF Then
        
        Set pAmbiente = Nothing
    
    Else
        
        If Not opAmbiente Is Nothing Then
            Set pAmbiente = opAmbiente
        Else
            Set pAmbiente = New clsAmbiente
        End If
        
        LoadInstance pAmbiente, rs
    
    End If
    
    Set rs = Nothing
    
    Set LoadByDescripcion = pAmbiente
    
End Function

Public Function LoadByPrefijo(istPrefijo As String, Optional opAmbiente As clsAmbiente = Nothing) As clsAmbiente
Dim pAmbiente As clsAmbiente, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM mesasAmbientes WHERE Prefijo = " & StringDB(istPrefijo))
    
    If rs.EOF Then
        
        Set pAmbiente = Nothing
    
    Else
        
        If Not opAmbiente Is Nothing Then
            Set pAmbiente = opAmbiente
        Else
            Set pAmbiente = New clsAmbiente
        End If
        
        LoadInstance pAmbiente, rs
    
    End If
    
    Set rs = Nothing
    
    Set LoadByPrefijo = pAmbiente
    
End Function

Public Function pAmbiente(Codigo As String) As clsAmbiente
    
    Set pAmbiente = Load(Codigo)

End Function

Public Function LoadSiguiente(destino As clsAmbiente) As Boolean
Dim bResult As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM mesasAmbientes AS m WHERE m.Codigo IN (SELECT MIN(Codigo) FROM mesasAmbientes WHERE Codigo >  " & StringDB(destino.Codigo))
    
    If rs.EOF Then
        
        bResult = False
    
    Else
        
        bResult = True
        LoadInstance destino, rs
    
    End If
    
    Set rs = Nothing
    
    LoadSiguiente = bResult
    
End Function

Public Function LoadAnterior(destino As clsAmbiente) As Boolean
Dim bResult As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM mesasAmbientes AS m WHERE m.Codigo IN (SELECT MAX(Codigo) FROM mesasAmbientes WHERE Codigo <  " & StringDB(destino.Codigo))
    
    If rs.EOF Then
        
        bResult = False
    
    Else
        
        bResult = True
        LoadInstance destino, rs
    
    End If
    
    Set rs = Nothing
    
    LoadAnterior = bResult

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT COUNT(Codigo) AS qty FROM mesasAmbientes WHERE Codigo = " & StringDB(arg))
    
    If GetNumeroFromVariant(rs!qty) > 0 Then
        bRetVal = True
    Else
        bRetVal = False
    End If
    
    Set rs = Nothing

    ExisteCodigo = bRetVal

End Function

Public Function Add(iItem As clsAmbiente) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset
Dim n As Long, lngDue As Long
  If iItem.Escala = 0 Then iItem.Escala = 1
  iItem.AccountOffset = 0
  sQuery = "INSERT INTO mesasAmbientes (Codigo, Prefijo, Descripcion, AccountOffset, PorcentajeServicio, IndicePrecio, Escala, SillasVisibles) "
  sQuery = sQuery & "VALUES (" & StringDB(iItem.Codigo) & ", " & StringDB(iItem.Prefijo) & ", " & StringDB(iItem.Descripcion) & ","
  sQuery = sQuery & Str(iItem.AccountOffset) & "," & Str(iItem.PorcentajeServicio) & "," & Str(iItem.IndicePrecio) & "," & Str(iItem.Escala) & ", " & BooleanDB(iItem.SillasVisibles) & ")"
  
  bRetVal = True
  
  dbHandle.Execute sQuery

  n = 1
  Set rs = dbHandle.Execute("SELECT AccountOffset FROM mesasAmbientes WHERE AccountOffset > 100000 ORDER BY AccountOffset")
  Do While Not rs.EOF
    lngDue = 100001 + 10000 * (n - 1)
    If rs!AccountOffset <> lngDue Then Exit Do
    n = n + 1
    rs.MoveNext
  Loop
  lngDue = 100001 + 10000 * (n - 1)
  rs.Close

  sQuery = "UPDATE mesasAmbientes SET AccountOffset =" & Str(lngDue) & " WHERE Codigo =" & StringDB(iItem.Codigo)
  dbHandle.Execute sQuery
  Add = bRetVal
End Function

Public Function ActualizarDescriptivos(instance As clsAmbiente, _
                                       iPrefijo As String, _
                                       iDescripcion As String, _
                                       iAccountOffset As Long, _
                                       iPorcentajeServicio As Double, _
                                       iIndicePrecio As Integer, _
                                       iEscala As Double, _
                                       iSillasVisibles As Boolean) As Boolean
Dim bRetVal As Boolean, sQuery As String
    sQuery = "UPDATE mesasAmbientes SET "
    sQuery = sQuery & "Prefijo = " & StringDB(iPrefijo) & ", "
    sQuery = sQuery & "Descripcion = " & StringDB(iDescripcion) & ", "
    sQuery = sQuery & "AccountOffset =" & Str(iAccountOffset) & ", "
    sQuery = sQuery & "PorcentajeServicio =" & Str(iPorcentajeServicio) & ", "
    sQuery = sQuery & "IndicePrecio = " & Str(iIndicePrecio) & ", "
    sQuery = sQuery & "Escala =" & Str(iEscala) & ", "
    sQuery = sQuery & IIf(iSillasVisibles, "TRUE", "FALSE") & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(instance.Codigo)
    
    bRetVal = True
    dbHandle.Execute sQuery
    ActualizarDescriptivos = bRetVal
End Function

Public Function Ambientes() As Collection
Dim rs As Recordset, colRet As Collection, pAmbiente As clsAmbiente

    Set colRet = New Collection
    Set rs = dbHandle.Execute("SELECT * FROM mesasAmbientes ORDER BY Codigo")
    
    If Not rs.EOF Then
    Do
        If rs!Codigo <> "*" Then
            Set pAmbiente = New clsAmbiente
            LoadInstance pAmbiente, rs
            colRet.Add pAmbiente, pAmbiente.Codigo
            Set pAmbiente = Nothing
        End If
        rs.MoveNext
    Loop While Not rs.EOF
    End If
    
    Set rs = Nothing
    
    Set Ambientes = colRet

End Function

Public Sub UpdateEscala(isCodigo As String, dblEscala As Double)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET Escala = " & Str(dblEscala) & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Sub UpdateBackColor(isCodigo As String, lbkColor As Long)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET BackColor = " & Str(lbkColor) & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Sub UpdateColorMesas(isCodigo As String, lbkColor As Long)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET ColorMesas = " & Str(lbkColor) & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Sub UpdateFormaMesas(isCodigo As String, nForma As Integer)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET FormaMesas = " & Str(nForma) & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Sub UpdateFormaSillas(isCodigo As String, nForma As Integer)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET FormaSillas = " & Str(nForma) & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Sub UpdateColorSillas(isCodigo As String, lbkColor As Long)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET ColorSillas = " & Str(lbkColor) & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Sub UpdateSillasVisibles(isCodigo As String, isVisible As Boolean)
Dim sQuery As String
  sQuery = "UPDATE mesasAmbientes SET SillasVisibles = " & IIf(isVisible, "TRUE", "FALSE") & " WHERE Codigo = " & StringDB(isCodigo)
  dbHandle.Execute sQuery
End Sub

Public Function LoadByNumero(lngNumero As Long, dest As clsAmbiente) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean
Dim lOffset As Long
  
  lOffset = lngNumero
  
  sQuery = "SELECT * FROM mesasAmbientes WHERE AccountOffset  = " & Str(lOffset) & ";"
  Set rs = dbHandle.Execute(sQuery)
  If Not rs.EOF Then
    LoadInstance dest, rs
    bRetVal = True
  Else
    bRetVal = False
  End If
  Set rs = Nothing
  
  LoadByNumero = bRetVal
  
End Function

Public Function EliminarAmbiente(sID As String) As Boolean
Dim bRetVal As Boolean
  bRetVal = True
  lmdbHandle.StartTransaction
  dbHandle.Execute "DELETE FROM mesasAmbientes WHERE Codigo =" & StringDB(sID)
  dbHandle.Execute "DELETE FROM mesasMesas WHERE Ambiente = " & StringDB(sID)
  lmdbHandle.CommitTransaction
  EliminarAmbiente = bRetVal
End Function
