VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAlmacen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Centros de Almacenamiento"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Codigo As String
Public Descripcion As String
Public CuentaActivo As String

Public TipoUbicacion As Integer
Public TipoEntidad As String

Public NumeroRenglon As Integer

Private instComprobante As clsComprobanteAlmacen
Private lBuffer As clsBufferComprobante

Public Function StartComprobante(Fecha As Date, TipoEntidad As String, NumeroDocumento As Long, NumeroOrden As Long, Descripcion As String) As Boolean
Dim isOk As Boolean
  Set instComprobante = New clsComprobanteAlmacen
  Set lBuffer = New clsBufferComprobante
  lBuffer.StartComprobante Date, "", ""
  isOk = instComprobante.StartProcess(Me, Fecha, TipoEntidad, NumeroDocumento, NumeroOrden, Descripcion)
  If Not isOk Then Set instComprobante = Nothing
  StartComprobante = isOk
End Function

Public Function NumeroComprobante() As Long
    If instComprobante Is Nothing Then
        ReportarError False, ERR_WILD_OPERATION, "Operacin fuera de contexto", "Almacen.NumeroComprobante"
        NumeroComprobante = 0
        Exit Function
    End If
    NumeroComprobante = instComprobante.Numero
End Function

Public Function RegistrarMINV(CodigoItem As String, Cantidad As Double, Costo As Double) As Boolean
Dim Item As clsItemInventario, codigoCuenta As String, dDebitos As Double, dCreditos As Double, isOk As Boolean

    If instComprobante Is Nothing Then
        Err.Raise ERR_WILD_OPERATION, "clsAlmace::RegistrarMINV", "Operacin fuera de contexto"
        RegistrarMINV = False
        Exit Function
    End If

    Set Item = New clsItemInventario
    If Not Item.Load(CodigoItem) Then
      Err.Raise ERR_ITEM_NOT_FOUND, "clsAlmace::RegistrarMINV", "Articulo no localizado: " & CodigoItem
      RegistrarMINV = False
      Exit Function
    End If

    codigoCuenta = Item.CuentaActivo                                            ' Primero: Articulo
    If codigoCuenta = "" Then codigoCuenta = Me.CuentaActivo                    ' Segundo: Almacen
    If codigoCuenta = "" Then codigoCuenta = Empresa.CuentaGeneralInventario    ' Tercero: Inventario General

    If Costo = 0 Then Costo = Item.CostoUnitario
'   If Cantidad < 0 Then Costo = Item.CostoUnitario

    isOk = instComprobante.RegistrarMINV(CodigoItem, Cantidad, Costo)

    If isOk Then
    
        NumeroRenglon = instComprobante.NumeroRenglon
    
        If codigoCuenta = "" Then
            lBuffer.SetError
        Else
            If Cantidad < 0 Then
                dDebitos = 0
                dCreditos = Abs(Cantidad) * Costo
            Else
                dDebitos = Cantidad * Costo
                dCreditos = 0
            End If
            lBuffer.AddDetalle codigoCuenta, instComprobante.Descripcion, dDebitos, dCreditos
        End If
    End If

    RegistrarMINV = isOk

End Function

Public Function CerrarComprobante(destAsiento As clsBufferComprobante) As Boolean
Dim isOk As Boolean
  If instComprobante Is Nothing Then
    Err.Raise ERR_WILD_OPERATION, "clsAlmacen.CerrarComprobante", "Operacin fuera de contexto"
    CerrarComprobante = False
    Exit Function
  End If

  isOk = instComprobante.EndProcess
  
  If isOk Then lBuffer.Transferir destAsiento
  Set instComprobante = Nothing
  Set lBuffer = Nothing
  CerrarComprobante = isOk
End Function

Public Sub AbortarComprobante()
  If Not instComprobante Is Nothing Then
    instComprobante.AbortProcess
  End If
  Set instComprobante = Nothing
  Set lBuffer = Nothing
End Sub

Public Function RegistrarMovimientoProducto(CodigoItem As String, Variacion As Double) As Boolean
Dim instExUbic As clsExistenciaUbicacion, isOk As Boolean
    Set instExUbic = New clsExistenciaUbicacion
    isOk = instExUbic.RegistrarVariacion(CodigoItem, Me.Codigo, Me.TipoUbicacion, Variacion)
    Set instExUbic = Nothing
    RegistrarMovimientoProducto = isOk
End Function

Private Sub Class_Initialize()
    Me.TipoUbicacion = 0
    Me.TipoEntidad = "ALM"
End Sub
