VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAjuste"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long
Public refAjuste As String
Public Tipo As Boolean          ' True = Salida, False = Entrada
'Public Descripcion As String   ... Movida abajo para "explicitar" dependencia ISDOC
Public Notas As String
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public Operador As String
Public Contrapartida As String
Public Almacen As String
Public Status As Boolean
Public Valor As Currency

' Las siguientes variables deben hacerse PRIVADAS al terminar el desarrollo...
Public instComprobante As clsBufferComprobante
Public instAlmacen As clsAlmacen
Public NumeroRenglon As Integer
' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************

Public Saldo As Currency
Public TipoEntidad As String                ' Idntificacin para ISDOC
Public Descripcion As String                ' ISDOC...

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Load(Numero As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    On Error GoTo ErrHandler

    Set rs = dbHandle.Execute("SELECT * FROM Ajustes WHERE Numero =" & Str(Numero))
    If rs.EOF Then
        bRetVal = False
    Else
        LoadInstance rs
        bRetVal = True
    End If

ResumePoint:
    
    If Not rs Is Nothing Then
        rs.Close
        Set rs = Nothing
    End If
    
    Load = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Ajustes.ISDOC.Load"
    Err.Clear
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Referencia() As String
    
    If refAjuste = "" Then
        Referencia = Format(Numero, "000000")
    Else
        Referencia = refAjuste
    End If

End Function

Public Function Concepto() As String
    
    Concepto = Descripcion

End Function

Public Function NombreArchivoFormato() As String
    
  NombreArchivoFormato = DeterminarFormato("FormatoAjuste", "FormatosAjuste", BuildDataPath("FormatoAjuste.txt", AppName), Me)

End Function

Public Function Detalles() As Collection
Dim retCol As Collection, compAlmacen As clsComprobanteAlmacen
    
    Set compAlmacen = New clsComprobanteAlmacen
    Set Detalles = compAlmacen.DetallesComprobante(Me.TipoEntidad, Me.Numero)
    Set compAlmacen = Nothing

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evAjuste.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean

    bRetVal = True
    
    Select Case sVarId

    Case "NUMERO"
        vRetBuffer = Me.Referencia
        sRetString = Me.Referencia
    
    Case "FECHA_REGISTRO"
        vRetBuffer = FechaRegistro
        sRetString = Format(FechaRegistro, "Short Date")
    
    Case "FECHA", "FECHA_AJUSTE", "FECHA_EMISION"
        vRetBuffer = Me.FechaTransaccion
        sRetString = Format(FechaTransaccion, "Short Date")
    
    Case "OPERADOR"
        vRetBuffer = Operador
        sRetString = Operador
    
    Case "DESCRIPCION"
        vRetBuffer = Descripcion
        sRetString = Descripcion

    Case "REFERENCIA", "REFAJUSTE"
        vRetBuffer = refAjuste
        sRetString = refAjuste

    Case "TIPO"
        sRetString = IIf(Me.Tipo, "SALIDA", "ENTRADA")
        vRetBuffer = sRetString
    
    Case "NOTAS"
        sRetString = Notas
        vRetBuffer = Notas
    
    Case "CONTRAPARTIDA"
        sRetString = Contrapartida
        vRetBuffer = Contrapartida

    Case "ALMACEN"
        sRetString = Almacen
        vRetBuffer = Almacen

    Case "NOMBRE_ALMACEN"
        sRetString = Almacenes.NombreAlmacen(Almacen)
        vRetBuffer = sRetString

    Case "VALOR"
        vRetBuffer = Valor
        sRetString = FormatNumero(Valor, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case Else
        bRetVal = False
    
    End Select
    
    If Not bRetVal Then
        bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sRetString)
    End If
    
    If Not bRetVal Then
        bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
    End If

    EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lNumero As Long, sQuery As String, rs As Recordset, bRetVal As Boolean
    
    On Error GoTo ErrHandler

    lNumero = Val(sRef)
    If lNumero = 0 Then
        LoadByReferenciaISDOC = False
        Exit Function
    End If

    sQuery = "SELECT * FROM Ajustes WHERE Numero =" & Str(lNumero)
    Set rs = dbHandle.Execute(sQuery)

    If Not rs.EOF Then
        LoadInstance rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    
ResumePoint:
    If Not rs Is Nothing Then
        rs.Close
        Set rs = Nothing
    End If
    
    LoadByReferenciaISDOC = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Ajustes: LoadByRefISDOC"
    Err.Clear
    bRetVal = False
    Resume ResumePoint

End Function

Public Sub Show()
Dim f As frmViewAjuste

    Set f = New frmViewAjuste
    f.ShowAjuste Me
    
    ShowNonModal f
    
    Unload f
    Set f = Nothing

End Sub

Public Sub UpdateNotas(istr As String)
  If Me.Numero <> 0 Then
    Me.Notas = istr
    dbHandle.Execute "UPDATE Ajustes SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
  End If
End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

' **************************************************************
' ************ END ISDOC
' **************************************************************

Private Sub Class_Initialize()
    
    TipoEntidad = "AJU"

End Sub

Private Sub LoadInstance(rs As Recordset)
    
    With Me
    .Numero = rs.Fields("Numero")
    .refAjuste = stGetStringFromVariant(rs.Fields("refAjuste"))
    .Tipo = rs.Fields("Tipo")
    .Descripcion = rs.Fields("Descripcion")
    .Notas = stGetStringFromVariant(rs.Fields("Notas"))
    .FechaRegistro = rs.Fields("FechaRegistro")
    .FechaTransaccion = rs.Fields("FechaTransaccion")
    .Operador = rs.Fields("Operador")
    .Contrapartida = stGetStringFromVariant(rs.Fields("Contrapartida"))
    .Almacen = stGetStringFromVariant(rs.Fields("Almacen"))
    .Status = rs.Fields("Status")
    .Valor = rs.Fields("Valor")
    .Saldo = .Valor
    End With
    
End Sub

Public Function LoadByRef(refAjuste As String) As Boolean
Dim rs As Recordset, isOk As Boolean, SQL As String

    isOk = True
    On Error GoTo ErrHandler

    SQL = "SELECT * FROM Ajustes WHERE refAjuste = " & StringDB(refAjuste)
    Set rs = dbHandle.Execute(SQL)

    If rs.EOF Then
        isOk = False
    Else
        LoadInstance rs
    End If
    
ResumePoint:
    If Not rs Is Nothing Then rs.Close
    Set rs = Nothing
    LoadByRef = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Ajustes.LoadByRef"
    Err.Clear
    isOk = False
    Resume ResumePoint

End Function

Public Function NumeroProximoAjuste() As Long
  NumeroProximoAjuste = Contadores.NumeroProximoDocumento(Me.TipoEntidad, False)
End Function

' ----------------------------------------------------------
' Proceso del ajuste...

Public Function StartProcess() As Boolean
Dim sQuery As String, isOk As Boolean

  On Error GoTo ErrHandler

  StartTransaction
  Set instAlmacen = Almacenes.Item(Me.Almacen)
  If instAlmacen Is Nothing Then
    ReportarError False, ERR_ITEM_NOT_FOUND, "Almacen no localizado: " & Me.Almacen, "Ajuste.StartProcess"
    AbortTransaction
    StartProcess = False
    Exit Function
  End If
  
  Me.Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
  sQuery = "INSERT INTO Ajustes (Numero, refAjuste, Tipo, Descripcion, Notas, FechaTransaccion, FechaRegistro, Operador, Contrapartida, Almacen) SELECT "
  sQuery = sQuery & NumeroDB(Me.Numero) & ", "
  sQuery = sQuery & StringDB(Me.refAjuste) & ", "
  sQuery = sQuery & NumeroDB(Me.Tipo) & ", "
  sQuery = sQuery & StringDB(Me.Descripcion) & ", "
  sQuery = sQuery & StringDB(Me.Notas) & ", "
  sQuery = sQuery & FechaDB(Me.FechaTransaccion) & ", "
  sQuery = sQuery & TimeDateDB(Now) & ", "
  sQuery = sQuery & StringDB(Me.Operador) & ", "
  sQuery = sQuery & StringDB(Me.Contrapartida) & ", "
  sQuery = sQuery & StringDB(Me.Almacen) & ";"
  
  dbHandle.Execute sQuery
  
  Set instComprobante = New clsBufferComprobante
  
  instComprobante.StartComprobante Me.FechaTransaccion, Me.TipoEntidad & Me.Referencia, Me.Descripcion
  Me.Valor = 0
  isOk = instAlmacen.StartComprobante(Me.FechaTransaccion, Me.TipoEntidad, Me.Numero, 0, "Ajuste de inventario" & Str(Me.Numero))

  StartProcess = isOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
'  On Error GoTo 0
  Set instComprobante = Nothing
  instAlmacen.AbortarComprobante
  Set instAlmacen = Nothing
  AbortTransaction
  Err.Raise nErrN, "clsAjuste:StartProcess", sErrD
End Function

Public Function AddDetalle(stCodigo As String, ByVal dblCantidad As Double) As Boolean
Dim Cantidad As Double, itemInv As clsItemInventario, isOk As Boolean
    
  Cantidad = dblCantidad
  If Me.Tipo Then Cantidad = -Cantidad    ' Hazla negativa si es un ajuste de salida
  Set itemInv = AlmacenItemsInventario.itemInventario(stCodigo)
  isOk = instAlmacen.RegistrarMINV(stCodigo, Cantidad, itemInv.CostoUnitario)
  Me.Valor = Me.Valor + (Cantidad * itemInv.CostoUnitario)
  Set itemInv = Nothing
  
  If isOk Then
      NumeroRenglon = instAlmacen.NumeroRenglon
  End If
  AddDetalle = isOk

End Function

Private Sub CleanProcessEnvironment()
    Set instAlmacen = Nothing
    Set instComprobante = Nothing
End Sub

Public Sub Commit()
Dim stsql As String, dblDebitos As Currency, dblCreditos As Currency, isOk As Boolean

    On Error GoTo ErrHandler

    stsql = "UPDATE Ajustes SET Valor =" & Str(Valor) & " WHERE Numero=" & Str(Numero)
    dbHandle.Execute stsql
    
    If Me.Valor > 0 Then
        dblCreditos = Me.Valor
        dblDebitos = 0
    Else
        dblCreditos = 0
        dblDebitos = -Me.Valor
    End If
    
    instComprobante.AddDetalle Me.Contrapartida, Me.Descripcion, dblDebitos, dblCreditos
    isOk = instAlmacen.CerrarComprobante(instComprobante)
    
ResumePoint:
    If isOk Then
        instComprobante.Procesar
        CommitTransaction
        If Me.Load(Me.Numero) Then ExecuteScript "postAjuste.vbs", Me
        SubmitDoc Me
    Else
        AbortTransaction
    End If

    CleanProcessEnvironment
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Ajustes.Commit"
    isOk = False
    Err.Clear
    Resume ResumePoint
End Sub

Public Sub Abort()
    AbortTransaction
    CleanProcessEnvironment
End Sub

