VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAcumuladorDetallesSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public idSesion As Long
Public CodigoProducto As String
Public Precio As Currency
Public Cantidad As Double
Public PorcentajeImpuesto As Double

Public iterador As Recordset


Public Function AcumularRenglon(ByVal Sesion As Long, Codigo As String, ByVal Precio As Currency, ByVal Cantidad As Double, ByVal Impuesto As Double) As Boolean
Dim sQuery As String

'  Intenta insertar:
    On Error GoTo ErrHandler    ' Debe producirse un error 3022 (DAO/Access) si ya existe un renglon con Sesion y Codigo iguales
    sQuery = "INSERT INTO AcumularSesionPOS ( SesionID, CodigoProducto, Precio, Cantidad, PorcentajeImpuesto ) "
    sQuery = sQuery & "SELECT " & NumeroDB(Sesion) & ", "
    sQuery = sQuery & StringDB(Codigo) & ", "
    sQuery = sQuery & NumeroDB(Precio) & ", "
    sQuery = sQuery & NumeroDB(Cantidad) & ", "
    sQuery = sQuery & NumeroDB(Impuesto) & "; "
    dbHandle.Execute sQuery
    AcumularRenglon = True
    Exit Function

' Intenta acumular sobre renglon preexistente
TestAcumular:
    On Error GoTo ErrHandler
    sQuery = "UPDATE AcumularSesionPos SET Cantidad = Cantidad + " & NumeroDB(Cantidad) & ", "
    sQuery = sQuery & "WHERE SesionID = " & NumeroDB(Sesion) & " "
    sQuery = sQuery & "AND CodigoProducto = " & StringDB(Codigo) & " "
    sQuery = sQuery & "AND Precio = " & NumeroDB(Precio) & ";"
    dbHandle.Execute sQuery
    AcumularRenglon = True
    Exit Function
    
ErrHandler:
    If Err.Number = 3022 Then
        Err.Clear
        Resume TestAcumular
    End If
    
    ReportarError False, Err.Number, Err.Description, "AcumuladorDetallesSesion.AcumularRenglon"
    Err.Clear
    AcumularRenglon = False
    Exit Function

End Function

Sub StartIterador(SesionID As Long)
    On Error GoTo ErrHandler
    Set iterador = dbHandle.Execute("SELECT * FROM AcumularSesionPOS WHERE SessionID =" & Str(SesionID))
    Exit Sub

ErrHandler:
    ReportarError True, Err.Number, Err.Description, "AcumuladorDetallesSesion.StsrtIterador"
    If Not iterador Is Nothing Then Set iterador = Nothing
    Err.Clear
End Sub

Public Function NextDetalle() As clsAcumuladorDetallesSesion
Dim pRetVal As clsAcumuladorDetallesSesion
    
    If iterador Is Nothing Then
        ReportarError False, 1, "Llamada a Iterador NO iniciado", "AcumuladorDetallesSesion.NextDetalleIterador"
        Set NextDetalle = Nothing
        Exit Function
    End If
    
    If iterador.EOF Then
        iterador.Close
        Set iterador = Nothing
        Set NextDetalle = Nothing
        Exit Function
    End If

    Set pRetVal = New clsAcumuladorDetallesSesion
    pRetVal.idSesion = iterador.Fields("SesionID")
    pRetVal.CodigoProducto = iterador.Fields("CodigoProducto")
    pRetVal.Precio = iterador.Fields("Precio")
    pRetVal.Cantidad = iterador.Fields("Cantidad")
    pRetVal.PorcentajeImpuesto = iterador.Fields("PorcentajeImpuesto")
    iterador.MoveNext
    
    Set NextDetalle = pRetVal
    Set pRetVal = Nothing

End Function

Private Function CerrarSesion(idSesion As Long) As Boolean
Dim bRetVal As Boolean
    
    bRetVal = True
    On Error GoTo ErrHandler
    dbHandle.Execute "DELETE FROM AcumularSesionPOS WHERE SesionID =" & Str(idSesion)

ResumePoint:
    CerrarSesion = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AcumuladorDetallesSesion.CerrarSesion"
    Err.Clear
    bRetVal = False
    Resume ResumePoint

End Function

Private Sub Class_Initialize()
    Set iterador = Nothing
End Sub

