Function stRightAlign(starg, l)
    If (Len(starg) > l) Then
        starg = Right(starg, l)
    Else
        starg = String(l - Len(starg), " ") & starg
    End If
    stRightAlign = starg
End Function

Function FormatNumero(numero, Formato, Length)
    If Abs(numero) < 0.001 Then
        sLocal = String(Length, " ")
    Else
        sLocal = stRightAlign(Impresora.Formatear(numero, Formato), Length)
    End If
    FormatNumero = sLocal
End Function

Function stFullLength(arg, l)

	starg = arg
    If (Len(starg) > l) Then
        starg = Left(starg, l)
    Else
        starg = starg + String(l - Len(starg), " ")
    End If
    stFullLength = starg

End Function

Function stMidAlign(starg, l)
    missing = l - Len(starg)
    If (missing <= 0) Then
        stMidAlign = stFullLength(starg, l)
        Exit Function
    End If
    missing = missing / 2
    sRetVal = String(missing, " ") & starg
    stMidAlign = sRetVal
End Function

' -------------------------------------
Sub ImprimirTicket

	stOut = "": MontoImpuesto = 0: Total = 0: PrecioTotal = 0: sParte2 = ""
    if Not Factura.EvalVar("Nombre_Empresa", vRetBuffer, sParte1) then
		Exit Sub
	End If

    If Len(sParte1) > 39 Then
        n = 20
        Do While Mid(sParte1, n, 1) <> " " And n < Len(sParte1)
            n = n + 1
        Loop
        If (n = Len(sParte1)) Then n = 20
        sParte2 = Trim(Right(sParte1, Len(sParte1) - n))
        sParte1 = Trim(Left(sParte1, n))
    End If

    MontoImpuesto = Factura.Impuesto

    Total = Factura.MontoVenta + MontoImpuesto + Factura.Servicio

    Impresora.OpenLinePrinter
    Impresora.LPrint ""
        
    Impresora.LPrint stMidAlign(sParte1, 39)
    If sParte2 <> "" Then Impresora.LPrint stMidAlign(sParte2, 39)

	Factura.EvalVar "RIF", vRetBuffer, sParte2
    Impresora.LPrint "RIF " & sParte2
    Impresora.LPrint "                  Factura: " & Impresora.Formatear(Factura.NumeroTicket, "000000")
	Factura.EvalVar "Ciudad", vRetBuffer, sParte2
    Impresora.LPrint "                  " & sParte2 & ", " & Impresora.Formatear(Factura.Hora, "Short Date")
    Impresora.LPrint "CAJA " & Impresora.Formatear(Factura.machID, "00000")
    Impresora.LPrint "---------------------------------------"
    Impresora.LPrint "Descripcion              Cant.    Total"
    Impresora.LPrint "---------------------------------------"
           '        XXXXXXXXXXXXXXXXXXXXXXXXX 999 99.999,99

    Set colDetalles = Factura.Detalles
    For Each pDetalle In colDetalles
		pDetalle.EvalVar "DESCRIPCION", vRetBuffer, sParte2
  	    stOut = stFullLength(sParte2, 25)

 		pDetalle.EvalVar "CANTIDAD", vRetBuffer, sParte2
        stOut = stOut & FormatNumero(vRetBuffer, "##0", 3) & " "

  		pDetalle.EvalVar "TOTAL_RENGLON", vRetBuffer, sParte2
        stOut = stOut & FormatNumero(vRetBuffer, "##,##0.00", 9)

	    Impresora.LPrint stOut
    Next

    Impresora.LPrint "--------------------------------------"
    Impresora.LPrint "              TOTAL         " & FormatNumero(Factura.MontoVenta, "###,##0.00", 10)
    If Factura.Impuesto > 0 Then
	   Impresora.LPrint "              I.V.A.        " & FormatNumero(Factura.Impuesto, "###,##0.00", 10)
    End If
    
    If Factura.Servicio > 0 Then
 	    Impresora.LPrint "              Servicio      " & FormatNumero(Factura.Servicio, "###,##0.00", 10)
    End If
    
    Impresora.LPrint "               A pagar      " & FormatNumero(Total, "###,##0.00", 10)

    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint "-"
    
    Impresora.CloseLinePrinter

End Sub
