' ***********************************************
' ** ADVERTENCIA:                              **
' ** Este cdigo no forma parte del sistema    **
' ** ClearLight, y se entrega "como est", sin **
' ** ningn tipo de garanta de correccin,    **
' ** utilidad o conveniencia.                  **
' ***********************************************

Public Sub Dump(s)
  dim t
  t = s & " = " & eval(s)
End Sub

Dim OutDev

Const PRINTER_NAME = "FRM:LPT1"
' LPT1 accede directamente al puerto. Otras opciones son COM1, LPT2, etctera.
' Si se necesita imprimir hacia una impresora de Windows, se puede escribir "LPT:<NombreImpresora>",
' por ejemplo "LPT:PrinterCaja"
' Si se desea hacer una "vista previa" del documento antes de la impresin, se puede asignar
' "FRM:Titulo de la Foma" (ejemplo: "FRM:Vista previa de la factura"). En este caso, habra que eliminar
' el salto de lnea que se agrega al argumento de la rutina LPrint.

Const IMPRESION_CONDICIONAL = True
' Si se coloca a True, el script pedir confirmacin antes de imprimir la factura

Const CONSOLIDAR_PRODUCTOS = True
' Determina si dos detalles con la misma descripcin y precio unitario debern acumularse en 
' una sola lnea de salida.

Const PEDIR_DATOS_CLIENTE = False
' Si se coloca a true, se abrirn dos inputBox, pidiendo el nombre y RIF del cliente

Const MOSTRAR_DESCUENTOS = 2
' 0: No mostrar descuentos
' 1: Especificar descuentos por renglon
' 2: Especificar descuentos al final

Const INDICE_REFERENCIA = 1
' Indice del precio de referencia para determinar descuentos

Const LIMITE_PORCENTAJE_DESCUENTO = 2
' Cualquier porcentaje de dscuento inferior a este valor, ser tratado como NO-descuento

' ------------------------------------------------
Class Linea
	Public Descripcion
	Public Precio
	Public Cantidad
	Public Total
	Public COdigoImpuesto
	Public PrecioReferencia

  Public Function PorcentajeDescuento()
    Dim dif
    dif = PrecioReferencia - Precio
    dif = dif / Precioreferencia * 100
    If dif <= LIMITE_PORCENTAJE_DESCUENTO Then
      dif = 0
    End If
    PorcentajeDescuento = Dif
  End Function

  Public Function MontoDescuento()
    If PorcentajeDescuento = 0 Then
      MontoDescuento = 0
      Exit Function
    End If
    MontoDescuento = (PrecioReferencia - Precio) * Cantidad
  End Function

End Class

Dim Lineas(), nDetalles

' -------------------------------------------------
' PasarDetalle: Acumula el producto en una de las 
' lineas de salida. 
' -------------------------------------------------
Sub PasarDetalle(sDescripcion, vmPrecio, dCantidad, cImpuesto, vmPrecioLista)
Dim i, pLinea

  If CONSOLIDAR_PRODUCTOS Then
    For i = 1 To nDetalles
      Set pLinea = Lineas(i)
      If pLinea.Descripcion = sDescripcion And pLinea.Precio = vmPrecio Then
	    pLinea.Cantidad = pLinea.Cantidad + dCantidad
	Exit Sub
      End If
    Next
  End If

  Set pLinea = New Linea
  With pLinea
  .Descripcion = sDescripcion
  .Precio = vmPrecio
  .Cantidad = dCantidad
  .CodigoImpuesto = cImpuesto
  .PrecioReferencia = vmPrecioLista
  End With

  nDetalles = nDetalles + 1
  Redim Preserve Lineas(nDetalles)
  Set Lineas(nDetalles) = pLinea
End Sub

' ------------------------------------------------------
' Transmite el argumento hacia el dispositivo de salida,
' agregndole un salto de lnea al final.
' NOTA: Si se utiliza un dispositivo de vista previa
' (FRM:xxx), se debe eliminar la terminacin "& vbCrLf"
' (es decir, dejar slo "OutDev.Send s"
' ------------------------------------------------------
Sub LPrint(s)
	OutDev.Send s & vbCrlf
End Sub



' ------------------------------------------------------
' Rutina principal...
' ------------------------------------------------------
Sub ImprimirTicket
Dim pOutDev, isPorAbajo, i, pLib, pEmpresa
Dim dbHandle, rs, sDescripcion, vmPrecio, dCantidad

    If IMPRESION_CONDICIONAL Then
      If msgbox("Imprimir Ticket?",  vbYesno) = vbNo Then
        Exit Sub
      End If
    End If
  
    stOut = "": PrecioTotal = 0: sParte2 = ""
    MontoImpuesto = Factura.Impuesto
    Total = Factura.MontoVenta + MontoImpuesto + Factura.Servicio

    Set pLib = Factoria.CrearObjeto("VSLIB")
    Set OutDev = CreateObject("OutDevice.COutDev")
    OutDev.DeviceName = PRINTER_NAME

    Set pEmpresa = Factoria.CrearObjeto("EMPRESA")

    sParte1 = pEmpresa.NombreEmpresa
    ' Si la longitud del nombre de la empresa es superior a 39 caracteres (uno menos que el ancho del papel)
    ' la parte en dos segmentos.
    If Len(sParte1) > 39 Then
      n = 20
      Do While Mid(sParte1, n, 1) <> " " And n < Len(sParte1)
        n = n + 1
      Loop
      If (n = Len(sParte1)) Then n = 20
      sParte2 = Trim(Right(sParte1, Len(sParte1) - n))
      sParte1 = Trim(Left(sParte1, n))
    End If

    nDetalles = 0	' Inicialmente, la matriz de Lineas() est vaca
  
    ' Comienzo del encabezado

    lPrint ""
    lPrint pLib.stMidAlign(sParte1, 39)
    If sParte2 <> "" Then lPrint pLib.stMidAlign(sParte2, 39)
    lPrint "RIF " & pEmpresa.RIF
    lPrint "                  Factura: " & Impresora.Formatear(Factura.NumeroTicket, "000000")
    lPrint "                  " & pEmpresa.Ciudad & ", " & Impresora.Formatear(Factura.Hora, "Short Date")
    Dim sNombreCliente, sRifCliente
    sNombreCliente = "": sRifCliente = ""
    If Factura.CodigoCliente <> "" Then
      Set rs = Factoria.CrearObjeto("DATABASE").OpenRecordset("SELECT Nombre, Rif FROM Clientes WHERE Codigo = '" & Factura.CodigoCliente & "';")
      If Not rs.EOF Then
        sNombreCliente = rs.Fields("Nombre")
        sRifCliente = rs.Fields("RIF")
      End If
      rs.Close
      Set rs = Nothing
    End If

    If PEDIR_DATOS_CLIENTE Then
      If sNombreCliente = "" Then
        sNombreCliente = InputBox("Nombre", "DATOS DEL CLIENTE")
        If sNombreCLiente <> "" Then
          sRifCliente = InputBox("RIF", "DATOS DEL CLIENTE")
        End If
      End If
    End If
    
    If sNombreCliente <> "" Then
      lprint "Cliente: " & sNombreCliente
      If sRifCliente <> "" THen
        lprint "RIF: " & sRifCliente
      End If
    End If

' --------------
    On Error Resume Next
    Dim codigoV, shObj
    set shObj = CreateObject("WScript.Shell")
    codigoV = shObj.RegRead("HKCU\Software\VB And VBA Program Settings\ClearLight\Cochinadas\Mesonero")
    If Err.Number <> 0 Then
      codigoV = "N/A"
    End If
    On Error goto 0
    
    If Trim(codigoV) = "" Then CodigoV = "N/A"
    if CodigoV <> "N/A" Then
      lPrint "MESA:" & stFullLength(shObj.RegRead("HKCU\Software\VB And VBA Program Settings\ClearLight\Cochinadas\Mesa"), 8) &  ". Mesonero: " & codigoV
      shObj.RegDelete("HKCU\Software\VB And VBA Program Settings\ClearLight\Cochinadas\Mesonero")
    End If
    Set shObj = Nothing
' --------------

    lPrint "---------------------------------------"    
    lPrint "Descripcion             Cant.    Total"
    lPrint "---------------------------------------"
'           XXXXXXXXXXXXXXXXXXXXXXXX 999 99.999,99E

    Set colDetalles = Factura.Detalles
    For Each pDetalle In colDetalles
      Dim sti
      sDescripcion = pDetalle.Descripcion
      dCantidad = pDetalle.Cantidad
      vmPrecio = pDetalle.PrecioTotal
      vmPrecio = vmPrecio / dCantidad
      If pDetalle.PorcentajeImpuesto < 0.1 Then
        sti = "E"
      Else
        sti = "G"
      End If
      PasarDetalle sDescripcion, vmPrecio, dCantidad, sti, pDetalle.ItemVenta.Precio(INDICE_REFERENCIA)
    Next

    Dim TotalPrecioLista
    TotalPrecioLista = 0
    For i = 1 To nDetalles
      stOut = pLib.stFullLength(Lineas(i).Descripcion, 24)
      stOut = stOut & pLib.FormatNumero(Lineas(i).Cantidad, "##0", 3) & " "
      If MostrarDescuentos = 2 Then
        Lineas(i).Total = Lineas(i).Cantidad * Lineas(i).Precio
      Else
        Lineas(i).Total = Lineas(i).Cantidad * Lineas(i).PrecioReferencia
      End If
      stOut = stOut & pLib.FormatNumero(Lineas(i).Total, "##,##0.00", 9)
      stOut = stOut & " " & Lineas(i).CodigoImpuesto
      TotalPrecioLista = TotalPrecioLista + Lineas(i).PrecioReferencia * Lineas(i).Cantidad
      lPrint stOut

      If MOSTRAR_DESCUENTOS = 1 Then
        If Lineas(i).PorcentajeDescuento > 0 Then
          stOut = stFullLength("P.V.P.", 15) & FormatNumero(Lineas(i).PrecioReferencia, "##,##0.00", 9)
          lPrint stOut
          stOut = "Ud. se ahorra Bs. " & Trim(FormatNumero(Lineas(i).MontoDescuento, "##,##0.00", 9)) & " (" & Trim(FormatNumero(Lineas(i).PorcentajeDescuento, "#0.00", 5)) & "%)"
          lPrint stOut 
        End If
      End If
    Next

    lPrint    "---------------------------------------"
    
    If Total > 0 Then
      If MOSTRAR_DESCUENTOS = 2 Then
        Dim lpDesc
        lpDesc = (TotalPrecioLista - Factura.MontoVenta) / TotalPrecioLista * 100
dump lpDesc 
        If lpDesc > LIMITE_PORCENTAJE_DESCUENTO Then
          lPrint "              SUB-TOTAL     " & FormatNumero(TotalPrecioLista, "###,##0.00", 10)
          lPrint stFullLength("          DESCUENTO (" & Trim(FormatNumero(lpDesc, "#0.00", 5)) & "%)", 28) & FormatNumero(TotalPrecioLista - Factura.MontoVenta, "###,##0.00", 10)
        End If
      End If
      lPrint   "              TOTAL         " & pLib.FormatNumero(Factura.MontoVenta, "###,##0.00", 10)
      If Factura.Impuesto > 0 Then
        lPrint "              I.V.A.        " & pLib.FormatNumero(Factura.Impuesto, "###,##0.00", 10)
      End If
  
      If Factura.Servicio > 0 Then
        lPrint  "              Servicio      " & pLib.FormatNumero(Factura.Servicio, "###,##0.00", 10)
      End If
    
      lPrint    "              A pagar       " & pLib.FormatNumero(Total, "###,##0.00", 10)

      Set rs = Factoria.CrearObjeto("DATABASE").OpenRecordset("SELECT * FROM DetallesIngresoCaja WHERE TransID IN (SELECT TransID FROM MovimientosCaja WHERE Descripcion = 'Fac.POS ' & Format(" & Factura.machID & ", '00') & '-' & Format(" & Factura.NumeroTicket & ", '0000000'))")
      Dim Recibido, Cambio
      Factura.EvalVar "RECIBIDO", Recibido, sParte1
      If rs.EOF Then
        Cambio = 0
        Lprint ""
        LPrint "Firma:"
        lPrint ""
        lprint ""
        lprint ""
        lprint String(30, "-")
      Else   
        Do While Not rs.EOF
          If rs.Fields("Medio") = "EFE" Or rs.Fields("Medio") = "TCR" Then
            lprint pLib.stFullLength(rs.Fields("Medio"), 4) & pLib.stFullLength(rs.Fields("EMISOR"), 8) & String(14, " ") & pLib.FormatNumero(rs.Fields("Monto"), pEmpresa.MascaraMonetarios, 12)
          Else
            lprint pLib.stFullLength(rs.Fields("Medio"), 4) & String(22, " ") & pLib.FormatNumero(rs.Fields("Monto"), pEmpresa.MascaraMonetarios, 12)
          End If
          rs.MoveNext
        Loop
      End If
      rs.Close: Set rs = Nothing
      Vuelto = Recibido - Total
      If Vuelto <> 0 Then
        lPrint    "                     Vuelto " & pLib.FormatNumero(Vuelto, "###,##0.00", 10)
      End If
    Else
      lprint "       R.P. Autorizado por"
      lPrint ""
      lPrint ""
      lPrint ""
      lPrint "       -------------------------------"
    End If
    lPrint ""
    lPrint ""
    lPrint ""
    lPrint ""
    lPrint ""
    lPrint ""
    lPrint "-"
 
    OutDev.Cerrar
    Set pEmpresa = Nothing
    Set pOutDev = Nothing
    Set pLib = Nothing

End Sub
