Function stRightAlign(starg, l)
    If (Len(starg) > l) Then
        starg = Right(starg, l)
    Else
        starg = String(l - Len(starg), " ") & starg
    End If
    stRightAlign = starg
End Function

Function FormatNumero(numero, Formato, Length)
    If Abs(numero) < 0.001 Then
        sLocal = String(Length, " ")
    Else
        sLocal = stRightAlign(Impresora.Formatear(numero, Formato), Length)
    End If
    FormatNumero = sLocal
End Function

Function stFullLength(arg, l)

	starg = arg
    If (Len(starg) > l) Then
        starg = Left(starg, l)
    Else
        starg = starg + String(l - Len(starg), " ")
    End If
    stFullLength = starg

End Function

Function stMidAlign(starg, l)
    missing = l - Len(starg)
    If (missing <= 0) Then
        stMidAlign = stFullLength(starg, l)
        Exit Function
    End If
    missing = missing / 2
    sRetVal = String(missing, " ") & starg
    stMidAlign = sRetVal
End Function

Sub ImprimirCuenta

	stOut = "": MontoImpuesto = 0: Total = 0: PrecioTotal = 0: sParte2 = ""
	sParte1 = Empresa.NombreEmpresa

    If Len(sParte1) > 39 Then
        n = 20
        Do While Mid(sParte1, n, 1) <> " " And n < Len(sParte1)
            n = n + 1
        Loop
        If (n = Len(sParte1)) Then n = 20
        sParte2 = Trim(Right(sParte1, Len(sParte1) - n))
        sParte1 = Trim(Left(sParte1, n))
    End If

    MontoImpuesto = Cuenta.Impuesto(Cuenta.IDCuenta)
	MontoConsumo = Cuenta.MontoConsumo(Cuenta.IDCuenta)
	MontoServicio = Cuenta.MontoServicio(Cuenta.IDCuenta)
    Total = MontoConsumo + MontoImpuesto + MontoServicio

    Impresora.OpenLinePrinter
    Impresora.LPrint ""
        
    Impresora.LPrint stMidAlign(sParte1, 39)
    If sParte2 <> "" Then Impresora.LPrint stMidAlign(sParte2, 39)

    Impresora.LPrint "RIF " & Empresa.RIF
    Impresora.LPrint "                  Cuenta: " & Cuenta.imagen(Cuenta.idCuenta)
    Impresora.LPrint "                  " & Empresa.Ciudad & ", " & Impresora.Formatear(Now, "Short Date")
    Impresora.LPrint "CAJA " & Impresora.Formatear(Cuenta.MachineID, "00000")
    Impresora.LPrint "---------------------------------------"
    Impresora.LPrint "Descripcion              Cant.    Total"
    Impresora.LPrint "---------------------------------------"
           '        XXXXXXXXXXXXXXXXXXXXXXXXX 999 99.999,99

    Set colDetalles = Cuenta.Detalles(Cuenta.idCuenta, 0)
    For Each pDetalle In colDetalles
		sParte2 = pDetalle.Descripcion
  	    stOut = stFullLength(sParte2, 25)

 		vRetBuffer = pDetalle.Cantidad
        stOut = stOut & FormatNumero(vRetBuffer, "##0", 3) & " "

  		vRetBuffer = pDetalle.PrecioTotal
        stOut = stOut & FormatNumero(vRetBuffer, "##,##0.00", 9)

	    Impresora.LPrint stOut
    Next

    Impresora.LPrint "--------------------------------------"
    Impresora.LPrint "              TOTAL         " & FormatNumero(MontoConsumo, "###,##0.00", 10)
    If MontoImpuesto > 0 Then
	   Impresora.LPrint "              I.V.A.        " & FormatNumero(MontoImpuesto, "###,##0.00", 10)
    End If
    
    If MontoServicio > 0 Then
 	    Impresora.LPrint "              Servicio      " & FormatNumero(MontoServicio, "###,##0.00", 10)
    End If
    
    Impresora.LPrint "               A pagar      " & FormatNumero(MontoConsumo + MontoImpuesto + MontoServicio, "###,##0.00", 10)
        
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint ""
    Impresora.LPrint "-"
    
    Impresora.CloseLinePrinter

End Sub

