CREATE TABLE AcumularSesionPOS (
  SesionID INT NULL default 0, 
  CodigoProducto VARCHAR (20) NOT NULL, 
  Precio DECIMAL(18,4) NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PorcentajeImpuesto FLOAT NULL default 0,
PRIMARY KEY (SesionID, CodigoProducto, Precio), 
  KEY ix_SesionID(SesionID)
);

CREATE TABLE Beneficiarios (
  Nombre VARCHAR (50),
  PRIMARY KEY (Nombre)
);

CREATE TABLE Ajustes (
  Numero INT NULL default 0, 
  refAjuste VARCHAR (20) NULL default '', 
  Tipo TINYINT(1) NULL default 1, 
  Descripcion VARCHAR (50) NULL default '', 
  Notas VARCHAR (255) NULL default '', 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL default '', 
  Contrapartida VARCHAR (20) NULL default '', 
  Almacen VARCHAR (8) NOT NULL default '', 
  Status TINYINT(1) NULL default 1, 
  Valor DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_Referencia(refAjuste)
);

CREATE TABLE Almacenes (
  Codigo VARCHAR (8) NOT NULL, 
  Nombre VARCHAR (50) NOT NULL, 
  CuentaActivo VARCHAR (20) NULL,
PRIMARY KEY (Codigo), 
  KEY ix_Descripcion(Nombre)
);

CREATE TABLE AlternosItemVenta (
  CodigoAlterno VARCHAR (20) NULL, 
  CodigoItemVenta VARCHAR (20) NOT NULL,
PRIMARY KEY (CodigoAlterno), 
  KEY ix_ItemsVentaAlternosItemVenta(CodigoItemVenta), 
  KEY ix_ItemVenta(CodigoItemVenta,CodigoAlterno)
);

CREATE TABLE AnulacionesPOS (
  SessionID INT NULL default 0, 
  Hora DATETIME NULL, 
  NumeroTicket INT NULL default 0, 
  MontoVenta DECIMAL(18,4) NULL default 0, 
  Impuesto DECIMAL(18,4) NULL default 0, 
  Servicio DECIMAL(18,4) NULL default 0, 
  KEY ix_PrimaryKey(SessionID,Hora)
);

CREATE TABLE Atributos (
  TipoEntidad VARCHAR (3) NOT NULL, 
  CodigoEntidad VARCHAR (20) NOT NULL, 
  CodigoAtributo VARCHAR (20) NOT NULL, 
  ValorAtributo VARCHAR (255) NULL default '',
PRIMARY KEY (TipoEntidad, CodigoEntidad, CodigoAtributo, ValorAtributo), 
  KEY ix_PorAtributo(CodigoAtributo,ValorAtributo,TipoEntidad,CodigoEntidad)
);

CREATE TABLE Bancos (
  Codigo VARCHAR (20) NOT NULL, 
  Cuenta VARCHAR (18) NOT NULL, 
  Nombre VARCHAR (40) NOT NULL, 
  Banco VARCHAR (40) NOT NULL, 
  TipoCuenta TINYINT NULL default 0, 
  CGCuenta VARCHAR (20) NULL, 
  SaldoActual DECIMAL(18,4) NULL default 0, 
  DepositosDiferidos DECIMAL(18,4) NULL default 0, 
  ChequesPostdatados DECIMAL(18,4) NULL default 0, 
  UltimaActualizacion DATETIME NULL, 
  ProximoCheque INT NULL default 0, 
  FechaCreacion DATETIME NULL, 
PRIMARY KEY (Codigo), 
  KEY ix_IndiceNombre(Nombre)
);

CREATE TABLE BarraItemsPagina (
  Pagina SMALLINT NULL default 0, 
  Posicion SMALLINT NULL default 0, 
  Codigo VARCHAR (20) NOT NULL,
PRIMARY KEY (Pagina, Posicion), 
  KEY ix_BarraPaginasBarraItemsPagina(Pagina), 
  KEY ix_iCodigo(Codigo), 
  KEY ix_ItemsVentaBarraItemsPagina(Codigo)
);

CREATE TABLE BarraPaginas (
  Numero SMALLINT NULL default 0, 
  Descripcion VARCHAR (32) NOT NULL,
PRIMARY KEY (Numero)
);

CREATE TABLE CierresZ (
  idTerminal INT NULL default 0, 
  Numero INT NULL default 0, 
  NumeroUnico INT NULL default 0, 
  Apertura DATETIME NULL, 
  HoraUltimaOperacion DATETIME NULL, 
  qFacturas INT NULL default 0, 
  PrimeraFactura INT NULL default 0, 
  UltimaFactura INT NULL default 0, 
  Turnos SMALLINT NULL default 0, 
  Gravable1 DECIMAL(18,4) NULL default 0, 
  Gravable2 DECIMAL(18,4) NULL default 0, 
  Exento DECIMAL(18,4) NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0,
  Servicio DECIMAL(18,4) NULL default 0,
PRIMARY KEY (idTerminal, Numero), 
  KEY ix_IFecha(Apertura), 
  KEY ix_NumeroUnico(NumeroUnico)
);

CREATE TABLE Clientes (
  Codigo VARCHAR (20) NOT NULL, 
  Nombre VARCHAR (50) NOT NULL, 
  Tipo VARCHAR (8) NULL, 
  RIF VARCHAR (12) NULL, 
  NIT VARCHAR (12) NULL, 
  CGCuenta VARCHAR (20) NULL, 
  CuentaIngresos VARCHAR (20) NULL, 
  Direccion VARCHAR (160) NULL, 
  Telefono VARCHAR (30) NULL, 
  Zona VARCHAR (8) NULL, 
  Ruta VARCHAR (8) NULL, 
  Estado VARCHAR (8) NULL, 
  Municipio VARCHAR (8) NULL, 
  VendedorAsignado VARCHAR (20) NULL, 
  CondicionStandard VARCHAR (8) NULL, 
  PrecioStandard VARCHAR (50) NOT NULL, 
  SaldoActual DECIMAL(18,4) NULL default 0, 
  LimiteCredito DECIMAL(18,4) NULL default 0, 
  Status TINYINT NULL default 0, 
  FechaUltimaVenta DATETIME NULL, 
  Notas VARCHAR (255) NULL, 
  FechaCreacion DATETIME NULL,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceNombre(Nombre), 
  KEY ix_RIF(RIF), 
  KEY ix_Ruta(Ruta), 
  KEY ix_Zona(Zona)
);

CREATE TABLE CobrosPOS (
  SessionID INT NULL default 0, 
  Hora DATETIME NULL, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  Descripcion VARCHAR (50) NULL, 
  Monto DECIMAL(18,4) NULL default 0, 
  KEY ix_PrimaryKey(SessionID,Hora), 
  KEY ix_SesionesPOSCobrosPOS(SessionID)
);

CREATE TABLE Comandas (
  Cuenta INT NULL default 0, 
  NumeroComanda INT NULL default 0, 
  KEY ix_NUmeroSesion(Cuenta,NumeroComanda)
);

CREATE TABLE Competencia (
  CodigoItem VARCHAR (20) NOT NULL, 
  Establecimiento VARCHAR (50) NOT NULL, 
  Precio DECIMAL(18,4) NULL default 0,
PRIMARY KEY (CodigoItem, Establecimiento)
);

CREATE TABLE ComposicionItemsInventario (
  CodigoItemVenta VARCHAR (20) NOT NULL, 
  CodigoItemInventario VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0,
PRIMARY KEY (CodigoItemVenta, CodigoItemInventario), 
  KEY ix_IndiceItemInv(CodigoItemInventario)
);

CREATE TABLE ComposicionItemsVenta (
  CodigoItemVenta VARCHAR (20) NOT NULL, 
  CodigoItemInventario VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0,
PRIMARY KEY (CodigoItemVenta, CodigoItemInventario), 
  KEY ix_IndiceItemInv(CodigoItemInventario), 
  KEY ix_itemsInventarioComposicionItemsVenta(CodigoItemInventario), 
  KEY ix_ItemsVentaComposicionItemsVenta(CodigoItemVenta)
);

CREATE TABLE Compras (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  CodigoProveedor VARCHAR (20) NOT NULL, 
  RefProveedor VARCHAR (20) NOT NULL, 
  NombreProveedor VARCHAR (50) NULL, 
  CostoMercancia DECIMAL(18,4) NULL default 0, 
  Descuento1 FLOAT NULL default 0, 
  Descuento2 FLOAT NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  Almacen VARCHAR (8) NULL, 
  EstadoRecepcion SMALLINT NULL default 0, 
  EstadoAdministrativo SMALLINT NULL default 0, 
  Condicion VARCHAR (12) NOT NULL, 
  Notas VARCHAR (255) NULL, 
  Saldo DECIMAL(18,4) NULL default 0,
  NumeroControl INTEGER(8) NOT NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_ProveedoresCompras(CodigoProveedor), 
  KEY ix_RefProveedor(CodigoProveedor,RefProveedor), 
  KEY ix_SecuencialProveedor(CodigoProveedor,FechaTransaccion,Numero)
);

CREATE TABLE Comprobantes (
  NumeroComprobante INT NULL default 0, 
  Periodo INT NULL default 0, 
  CorrelativoPeriodo INT NULL default 0, 
  Referencia VARCHAR (30) NULL, 
  Descripcion VARCHAR (50) NULL, 
  Autor VARCHAR (8) NULL, 
  Fecha DATETIME NULL, 
  Debitos FLOAT NULL default 0, 
  Creditos FLOAT NULL default 0, 
  Modificado DATETIME NULL, 
  numeroReferencia VARCHAR (50) NOT NULL,
PRIMARY KEY (NumeroComprobante), 
  KEY ix_CorrPeriodo(Periodo,CorrelativoPeriodo), 
  KEY ix_Referencia(Referencia)
);

CREATE TABLE ComprobantesAlmacen (
  Numero INT NULL default 0, 
  Almacen VARCHAR (8) NOT NULL, 
  Operador VARCHAR (8) NOT NULL, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  TipoEntidadOrigen VARCHAR (3) NOT NULL, 
  NumeroDocumentoOrigen INT NULL default 0, 
  OrdenDespacho INT NULL default 0, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Numero), 
  KEY ix_AlmacenesComprobantesAlmacen(Almacen), 
  KEY ix_IndiceFecha(FechaRegistro), 
  KEY ix_IndiceOrigen(TipoEntidadOrigen,NumeroDocumentoOrigen), 
  KEY ix_OrdenDespacho(OrdenDespacho)
);

CREATE TABLE Condiciones (
  Codigo VARCHAR (12) NOT NULL, 
  Descripcion VARCHAR (40) NOT NULL, 
  Modo TINYINT NULL default 0, 
  CuentaIngresos VARCHAR (20) NULL, 
  nCuotas SMALLINT NULL default 0,
PRIMARY KEY (Codigo)
);

CREATE TABLE CondicVen (
  CodigoCondicion VARCHAR (12) NOT NULL, 
  Correlativo SMALLINT NULL default 0, 
  Plazo SMALLINT NULL default 0, 
  Porcentaje FLOAT NULL default 0,
PRIMARY KEY (CodigoCondicion, Correlativo)
);

CREATE TABLE Contactos (
  CodigoEntidad VARCHAR (20) NOT NULL, 
  TipoEntidad VARCHAR (3) NOT NULL, 
  NombreContacto VARCHAR (50) NOT NULL, 
  Departamento VARCHAR (30) NULL, 
  Cargo VARCHAR (30) NULL, 
  Direccion VARCHAR (160) NULL, 
  Telefono VARCHAR (30) NULL, 
  TelefonoCelular VARCHAR (20) NULL, 
  FAX VARCHAR (20) NULL, 
  eMail VARCHAR (30) NULL, 
  Notas VARCHAR (255) NULL,
PRIMARY KEY (CodigoEntidad, TipoEntidad, NombreContacto)
);

CREATE TABLE Contadores (
  Factura INT NULL default '1', 
  NotaEntrega INT NULL default '1', 
  Cotizacion INT NULL default '1', 
  DevolucionVenta INT NULL default '1', 
  Compra INT NULL default '1', 
  OrdenCompra INT NULL default '1', 
  DevolucionCompra INT NULL default '1', 
  Ajuste INT NULL default '1', 
  Transferencia INT NULL default '1', 
  NotaDBCR INT NULL default '1', 
  Apertura DATETIME NULL, 
  Clave INT NULL, 
  Status DECIMAL(18,4) NULL, 
  Operacion INT NULL default 0
);

CREATE TABLE CorrelativosMaquina (
  Maquina INT NULL default 0, 
  ProximaFactura INT NULL default 0,
PRIMARY KEY (Maquina)
);

CREATE TABLE Cotizaciones (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  NombreCliente VARCHAR (50) NOT NULL, 
  CodigoVendedor VARCHAR (15) NULL, 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  IndiceReferencia SMALLINT NULL default 0, 
  IndiceVenta SMALLINT NULL default 0, 
  Descuento1 FLOAT NULL default 0, 
  Descuento2 FLOAT NULL default 0, 
  Condicion VARCHAR (8) NULL, 
  Notas VARCHAR (255) NULL, 
  Estado SMALLINT NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_Cliente(CodigoCliente,FechaTransaccion), 
  KEY ix_ClientesCotizaciones(CodigoCliente), 
  KEY ix_Fecha(FechaTransaccion), 
  KEY ix_Vendedor(CodigoVendedor,FechaTransaccion)
);

CREATE TABLE CotizacionesDetalles (
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (15) NULL, 
  Descripcion VARCHAR (50) NULL, 
  Presentacion VARCHAR (12) NULL, 
  FactorEmpaque FLOAT NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 FLOAT NULL default 0, 
  Impuesto2 FLOAT NULL default 0, 
  CostoUnitario DECIMAL(18,4) NULL default 0, 
  CantidadFacturada FLOAT NULL default 0, 
  Ancho FLOAT NULL default 0, 
  Alto FLOAT NULL default 0, 
  Largo FLOAT NULL default 0, 
  Descuentos VARCHAR (10) NULL default '0-0-0',
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_CotizacionesCotizacionesDetalles(NumeroDocumento), 
  KEY ix_IndiceItem(CodigoItem), 
  KEY ix_ItemFactura(NumeroDocumento,CodigoItem)
);

CREATE TABLE CotizacionesEntregas (
  NumeroCotizacion INT NULL default 0, 
  NumeroRenglon SMALLINT NULL default 0, 
  Fecha DATETIME NULL, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0, 
  PrecioUnitario DECIMAL(18,4) NULL default 0, 
  Unidad VARCHAR (12) NOT NULL, 
  Factor FLOAT NULL default 0, 
  TipoDocumento VARCHAR (5) NOT NULL, 
  NumeroDocumento INT NULL default 0, 
  KEY ix_CotizacionesDetallesCotizacionesEntregas(NumeroCotizacion,NumeroRenglon), 
  KEY ix_CotizacionesEntregasNumeroDocumento(NumeroDocumento), 
  KEY ix_NumeroCotizacion(NumeroCotizacion,NumeroRenglon,Fecha)
);

CREATE TABLE CuentaMedios (
  Sesion INT NULL default 0, 
  qEfectivo INT NULL default 0, 
  qCheques INT NULL default 0, 
  qVisa INT NULL default 0, 
  qMaster INT NULL default 0, 
  qOtrasTC INT NULL default 0, 
  qTDebito INT NULL default 0, 
  qCreditos INT NULL default 0, 
  qAmex INT NULL default 0, 
  qOtrosMedios INT NULL default 0,
PRIMARY KEY (Sesion)
);

CREATE TABLE Cuentas (
  Codigo VARCHAR (20) NOT NULL, 
  Titulo VARCHAR (50) NOT NULL, 
  Status TINYINT NULL default 0, 
  Lado TINYINT NULL default 0, 
  Saldo FLOAT NULL default 0,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceTitulo(Titulo)
);

CREATE TABLE CuentasPOS (
  IDCuenta INT NULL default 0, 
  Vendedor VARCHAR (20) NULL, 
  HoraApertura DATETIME NULL, 
  HoraUltimaTransaccion DATETIME NULL, 
  Estado SMALLINT NULL default '1', 
  Personas INT NULL default '1', 
  Cliente VARCHAR (20) NULL default '', 
  CodigoCuenta VARCHAR (20) NULL default '', 
  Ambiente VARCHAR (16) NULL default '', 
  idMesa INT NULL default 0, 
  Condiciones VARCHAR (12) NULL, 
  Extra VARCHAR (12) NULL,
PRIMARY KEY (IDCuenta), 
  KEY ix_IDCuenta(IDCuenta)
);

CREATE TABLE Despachos (
  Usuario VARCHAR (20) NOT NULL, 
  Fecha DATETIME NULL, 
  Puntos VARCHAR (50) NOT NULL default '1',
PRIMARY KEY (Usuario, Fecha)
);

CREATE TABLE DestinoComandasItem (
  CodigoItem VARCHAR (20) NOT NULL, 
  PrinterName VARCHAR (50) NOT NULL,
PRIMARY KEY (CodigoItem), 
  UNIQUE KEY ix_ItemsVentaDestinoComandasItem(CodigoItem)
);

CREATE TABLE Detalles (
  NumeroComprobante INT NULL default 0, 
  NumeroLinea SMALLINT NULL default 0, 
  RefPeriodo INT NULL default 0, 
  Cuenta VARCHAR (20) NOT NULL, 
  RefDetalle VARCHAR (20) NULL, 
  Descripcion VARCHAR (50) NULL, 
  Debe FLOAT NULL default 0, 
  Haber FLOAT NULL default 0,
PRIMARY KEY (NumeroComprobante, NumeroLinea), 
  KEY ix_ComprobantesDetalles(NumeroComprobante), 
  KEY ix_CuentasDetalles(Cuenta), 
  KEY ix_IndicePorCuenta(Cuenta,RefPeriodo,NumeroComprobante,NumeroLinea)
);

CREATE TABLE DetallesCompra (
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Descripcion VARCHAR (50) NULL, 
  Presentacion VARCHAR (12) NOT NULL, 
  FactorEmpaque FLOAT NULL default 0, 
  CantidadFacturada FLOAT NULL default 0, 
  CantidadPromocion FLOAT NULL default 0, 
  PrecioNominal DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 FLOAT NULL default 0, 
  Impuesto2 FLOAT NULL default 0, 
  CostoUnitario DECIMAL(18,4) NULL default 0, 
  Recibidas FLOAT NULL default 0, 
  Almacen VARCHAR (8) NULL, 
  Devueltas FLOAT NULL default 0,
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_ComprasDetallesCompra(NumeroDocumento), 
  KEY ix_iCodigoItem(CodigoItem,NumeroDocumento)
);

CREATE TABLE DetallesCuentaEntidad (
  CodigoEntidad VARCHAR (20) NOT NULL, 
  TipoEntidad VARCHAR (3) NOT NULL, 
  Correlativo INT NULL default 0, 
  Documento INT NULL default 0, 
  Fecha DATETIME NULL, 
  RefPeriodo INT NULL default 0, 
  Descripcion VARCHAR (60) NULL, 
  Debe DECIMAL(18,4) NULL default 0, 
  Haber DECIMAL(18,4) NULL default 0,
PRIMARY KEY (CodigoEntidad, TipoEntidad, Correlativo), 
  KEY ix_SecuenciaDocumento(Documento,Fecha,Correlativo), 
  KEY ix_SecuenciaEntidad(CodigoEntidad,TipoEntidad,Fecha,Correlativo), 
  KEY ix_SecuenciaPeriodo(CodigoEntidad,TipoEntidad,RefPeriodo,Correlativo)
);

CREATE TABLE DetallesDevolucionCompra (
  NumeroDevolucion INT NULL default 0, 
  NumeroRenglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  CantidadDevuelta FLOAT NULL default 0, 
  Presentacion VARCHAR (12) NOT NULL, 
  FactorEmpaque FLOAT NULL default 0, 
  DescripcionItem VARCHAR (50) NOT NULL, 
  Costo DECIMAL(18,4) NULL default 0, 
  Danhada TINYINT(1) NULL,
PRIMARY KEY (NumeroDevolucion, NumeroRenglon), 
  KEY ix_DevolucionesCompraDetallesDevolucionCompra(NumeroDevolucion), 
  KEY ix_Item(CodigoItem,NumeroDevolucion)
);

CREATE TABLE DetallesDevolucionVenta (
  NumeroDevolucion INT NULL default 0, 
  NumeroRenglon SMALLINT NULL default 0, 
  CodigoItemVenta VARCHAR (20) NOT NULL, 
  CantidadDevuelta FLOAT NULL default 0, 
  Presentacion VARCHAR (12) NOT NULL, 
  FactorEmpaque FLOAT NULL default 0, 
  DescripcionItem VARCHAR (50) NOT NULL, 
  Valor DECIMAL(18,4) NULL default 0, 
  Costo DECIMAL(18,4) NULL default 0, 
  Danhada TINYINT(1) NULL,
PRIMARY KEY (NumeroDevolucion, NumeroRenglon), 
  KEY ix_DevolucionesVentaDetallesDevolucionVenta(NumeroDevolucion), 
  KEY ix_Item(CodigoItemVenta,NumeroDevolucion)
);

CREATE TABLE DetallesFactura (
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NULL default '', 
  Descripcion VARCHAR (50) NULL default '', 
  Presentacion VARCHAR (12) NULL default '', 
  FactorEmpaque FLOAT NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 FLOAT NULL default 0, 
  Impuesto2 FLOAT NULL default 0, 
  CostoUnitario DECIMAL(18,4) NULL default 0, 
  Entregadas FLOAT NULL default 0, 
  Asignadas FLOAT NULL default 0, 
  Transito FLOAT NULL default 0, 
  Devueltas FLOAT NULL default 0,
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_FacturasDetallesFactura(NumeroDocumento), 
  KEY ix_IndiceItem(CodigoItem), 
  KEY ix_ItemFactura(NumeroDocumento,CodigoItem)
);

CREATE TABLE DetallesIngresoCaja (
  Id INT auto_increment PRIMARY KEY NOT NULL,
  TransID INT NULL default 0, 
  Medio VARCHAR (8) NOT NULL, 
  Emisor VARCHAR (20) NULL default '', 
  NumeroDocumento VARCHAR (20) NULL default '', 
  ClaveAutorizacion VARCHAR (6) NULL default '', 
  Monto DECIMAL(18,4) NULL default 0, 
  MontoNominal DECIMAL (14, 8) NOT NULL default 0,
  NumeroCuenta VARCHAR(20) NOT NULL default '',
  idTitular varchar(20) NOT NULL DEFAULT '',
  KEY ix_MovimientosCajaDetallesIngresoCaja(TransID), 
  KEY ix_ndxDocumento(Medio,Emisor,NumeroDocumento), 
  KEY ix_TransID(TransID, id)
);

CREATE TABLE DetallesItemVenta (
  NumeroDocumento INT NULL default 0, 
  TipoDocumento VARCHAR (3) NOT NULL, 
  Serie VARCHAR (3) NULL, 
  FechaOperacion DATETIME NULL, 
  CodigoItem VARCHAR (20) NOT NULL, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  CodigoVendedor VARCHAR (20) NULL, 
  PrecioReferencia DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  CostoStandard DECIMAL(18,4) NULL default 0, 
  KEY ix_Cliente(CodigoCliente,FechaOperacion), 
  KEY ix_IndiceDocumento(TipoDocumento,NumeroDocumento,CodigoItem,PrecioVenta), 
  KEY ix_Item(CodigoItem,FechaOperacion), 
  KEY ix_ItemCliente(CodigoCliente,CodigoItem,FechaOperacion), 
  KEY ix_ItemsVentaDetallesItemVenta(CodigoItem), 
  KEY ix_ItemVendedor(CodigoVendedor,CodigoItem,FechaOperacion), 
  KEY ix_Vendedor(CodigoVendedor,CodigoItem)
);

CREATE Table DetallesDenominacion (
  Id INT auto_increment PRIMARY KEY NOT NULL,
  IdDetalle INT NOT NULL,
  Denominacion DECIMAL (18, 2),
  CantidadRecibida Integer(4));

CREATE UNIQUE INDEX idxDetallesDenominacionDetalle
ON DetallesDenominacion (IdDetalle, Id);

CREATE TABLE DetallesMINV (
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  FechaOperacion DATETIME NULL, 
  TipoMovimiento VARCHAR (3) NOT NULL, 
  CodigoItem VARCHAR (20) NULL, 
  Entradas FLOAT NULL default 0, 
  Salidas FLOAT NULL default 0, 
  Costo DECIMAL(18,4) NULL default 0,
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_ComprobantesAlmacenDetallesMINV(NumeroDocumento), 
  KEY ix_IndiceFecha(FechaOperacion,CodigoItem), 
  KEY ix_IndiceItem(CodigoItem,FechaOperacion), 
  KEY ix_ItemDocumento(NumeroDocumento,CodigoItem), 
  KEY ix_itemsInventarioDetallesMINV(CodigoItem)
);

CREATE TABLE DetallesTA (
  NumeroAjuste INT NULL default 0, 
  NumeroRenglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0, 
  Unidad VARCHAR (12) NOT NULL,
PRIMARY KEY (NumeroAjuste, NumeroRenglon)
);

CREATE TABLE DevolucionesCompra (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  CodigoProveedor VARCHAR (20) NOT NULL, 
  Factura INT NULL default 0, 
  ValorMercancia DECIMAL(18,4) NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  Notas VARCHAR (255) NULL,
  NumeroControl INTEGER (8) NULL,
  RefProveedor VARCHAR (20) NULL,
PRIMARY KEY (Numero), 
  UNIQUE KEY ix_Numero(Numero), 
  KEY ix_ProveedoresDevolucionesCompra(CodigoProveedor)
);

CREATE TABLE DevolucionesVenta (
  Numero INT NULL default 0, 
  Serie VARCHAR (3) NOT NULL, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  NumeroFactura INT NULL default 0, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  NombreCliente VARCHAR (50) NOT NULL, 
  Valor DECIMAL(18,4) NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  Costo DECIMAL(18,4) NULL default 0, 
  Notas VARCHAR (255) NULL, 
  CodigoVendedor VARCHAR (20) NULL, 
  ComisionAnulada DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_ClientesDevolucionesVenta(CodigoCliente), 
  KEY ix_iCliente(CodigoCliente,FechaTransaccion,Numero)
);

CREATE TABLE DiferidosBanco (
  CodigoBanco VARCHAR (20) NOT NULL, 
  FechaPresentacion DATETIME NULL, 
  MontoDiferido DECIMAL(18,4) NULL default 0, 
  TipoMovimiento SMALLINT NULL default 0, 
  Descripcion VARCHAR (50) NOT NULL, 
  RefBanco VARCHAR (12) NOT NULL, 
  KEY ix_IndiceBanco(CodigoBanco,FechaPresentacion), 
  KEY ix_IndiceFecha(FechaPresentacion)
);

CREATE TABLE DocumentosISPC (
  Numero INT NULL default 0, 
  TipoEntidad VARCHAR (3) NOT NULL default 'nil', 
  CodigoEntidad VARCHAR (20) NOT NULL default '<nil>', 
  NumDoc INT NULL default 0, 
  TipoDoc VARCHAR (3) NOT NULL default 'nil', 
  FechaDoc DATETIME NULL, 
  Monto DECIMAL(18,4) NULL default 0, 
  Saldo DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_IndiceDoc(NumDoc,TipoDoc), 
  UNIQUE KEY ix_IndiceEntidad(CodigoEntidad,TipoEntidad,Numero)
);

CREATE TABLE Empaques (
  Codigo VARCHAR (12) NOT NULL, 
  Factor FLOAT NULL default 0,
PRIMARY KEY (Codigo)
);

CREATE TABLE ExistenciaUbicacion (
  CodigoItem VARCHAR (20) NOT NULL, 
  TipoUbicacion SMALLINT NULL default 0, 
  Almacen VARCHAR (8) NOT NULL, 
  Existencia FLOAT NULL default 0, 
  Asignadas FLOAT NULL default 0,
PRIMARY KEY (CodigoItem, TipoUbicacion, Almacen), 
  KEY ix_AlmacenesExistenciaUbicacion(Almacen), 
  KEY ix_IndiceAlmacen(Almacen,TipoUbicacion,CodigoItem), 
  KEY ix_itemsInventarioExistenciaUbicacion(CodigoItem)
);

CREATE TABLE Facturas (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  Serie VARCHAR (3) NOT NULL, 
  Correlativo INT NULL default 0, 
  ExtRef VARCHAR (15) NULL, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  NombreCliente VARCHAR (50) NOT NULL, 
  CodigoVendedor VARCHAR (15) NOT NULL, 
  EstadoDespacho SMALLINT NULL default 0, 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  IndiceReferencia SMALLINT NULL default 0, 
  IndiceVenta SMALLINT NULL default 0, 
  Descuento1 FLOAT NULL default 0, 
  Descuento2 FLOAT NULL default 0, 
  Costo INT NULL default 0, 
  SituacionAdministrativa SMALLINT NULL default 0, 
  Condicion VARCHAR (8) NOT NULL, 
  DescuentosProntoPago FLOAT NULL default 0, 
  Comision FLOAT NULL default 0, 
  ComisionAcreditada TINYINT(1) NULL, 
  DireccionEntrega VARCHAR (160) NULL, 
  Notas VARCHAR (255) NULL, 
  OrdenDespacho INT NULL default 0, 
  ComprobanteInventario INT NULL default 0, 
  PrecioDevuelto INT NULL default 0, 
  CostoDevuelto INT NULL default 0, 
  Saldo FLOAT NULL default 0, 
  Impuesto1Devuelto DECIMAL(18,4) NULL default 0, 
  Impuesto2Devuelto DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_Cliente(CodigoCliente,FechaTransaccion), 
  KEY ix_ClientesFacturas(CodigoCliente), 
  KEY ix_Correlativo(Serie,Correlativo), 
  KEY ix_Fecha(FechaTransaccion), 
  KEY ix_Referencia(ExtRef), 
  KEY ix_Vendedor(CodigoVendedor,FechaTransaccion)
);

CREATE TABLE FacturasPOS (
  idMaquina INT NULL default 0, 
  NumeroTicket INT NULL default 0, 
  idSesion INT NULL default 0, 
  idUsuario VARCHAR (8) NOT NULL, 
  Hora DATETIME NULL, 
  MontoVenta DECIMAL(18,4) NULL default 0, 
  Impuesto DECIMAL(18,4) NULL default 0, 
  Servicio DECIMAL(18,4) NULL default 0, 
  Vendedor VARCHAR (20) NULL, 
  Personas SMALLINT NULL default 0, 
  Cuenta INT NULL default 0, 
  Cliente VARCHAR (20) NULL default '', 
  Propina DECIMAL(18,4) NULL default 0, 
  Numero INT NULL auto_increment, 
  NombreHuesped VARCHAR (40) NULL default '', 
  IT DECIMAL(18,4) NULL default 0, 
PRIMARY KEY (idMaquina, NumeroTicket), 
  KEY ix_idSesion(idSesion,NumeroTicket), 
  KEY ix_nTicket(NumeroTicket, idMaquina), 
  KEY ix_tkSesion(NumeroTicket, idSesion),
	UNIQUE KEY ix_Numero(Numero)
);

CREATE TABLE generalEmisores (
  TipoDocumento VARCHAR (3) NOT NULL, 
  CodigoEmisor VARCHAR (8) NOT NULL
);

CREATE TABLE HotKeys (
  Tecla VARCHAR (1) NOT NULL, 
  Normal VARCHAR (20) NULL, 
  KEY ix_iKey(Tecla), 
  KEY ix_ItemsVentaHotKeys(Normal)
);

CREATE TABLE Indicadores (
  Codigo VARCHAR (16) NOT NULL, 
  Formula VARCHAR (50) NOT NULL, 
  Modificado DATETIME NULL, 
  Autor VARCHAR (8) NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE itemsComanda (
  Codigo VARCHAR (20) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL, 
  Precio1 DECIMAL(18,4) NULL default 0, 
  UsaExtras TINYINT NULL default 0, 
  UsaRemovibles TINYINT NULL default 0, 
  UsaContornos TINYINT NULL default 0, 
  ExtrasGratis SMALLINT NULL default 0, 
  TipoImpuesto1 VARCHAR (3) NULL default 'IV1',
PRIMARY KEY (Codigo), 
  KEY ix_Descripcion(Descripcion)
);

CREATE TABLE itemsInventario (
  Codigo VARCHAR (20) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL, 
  Linea VARCHAR (8) NULL, 
  CostoPromedio DECIMAL(18,4) NULL default 0, 
  UltimoCosto DECIMAL(18,4) NULL default 0, 
  ClaseImpuesto1 VARCHAR (8) NULL, 
  ClaseImpuesto2 VARCHAR (50) NULL, 
  Existencia FLOAT NULL default 0, 
  Asignadas FLOAT NULL default 0, 
  EnTransito FLOAT NULL default 0, 
  FechaUltimaCompra DATETIME NULL, 
  UltimoProveedor VARCHAR (15) NULL, 
  PrecioUltimaCompra DECIMAL(18,4) NULL default 0, 
  CuentaActivo VARCHAR (20) NULL, 
  CostoDeVentas VARCHAR (50) NULL, 
  NombreUnidad VARCHAR (12) NOT NULL, 
  NombreEmpaque VARCHAR (12) NULL, 
  CantidadEmpaque FLOAT NULL default 0, 
  ExistenciaMinima FLOAT NULL default 0, 
  ExistenciaMaxima FLOAT NULL default 0, 
  UsaSeriales SMALLINT NULL default 0, 
  FechaCreacion DATETIME NULL, 
  Grupo VARCHAR (50) NULL,
PRIMARY KEY (Codigo), 
  KEY ix_Descripcion(Descripcion), 
  KEY ix_Grupo(Grupo,Codigo), 
  KEY ix_LineaCodigo(Linea,Codigo), 
  KEY ix_LineaDescripcion(Linea,Descripcion), 
  KEY ix_LineaGrupo(Linea,Grupo,Codigo)
);

CREATE TABLE ItemsVenta (
  Codigo VARCHAR (20) NOT NULL, 
  Linea VARCHAR (15) NULL, 
  Descripcion VARCHAR (50) NOT NULL, 
  CuentaIngreso VARCHAR (20) NULL, 
  CuentaDevolucion VARCHAR (20) NULL, 
  CuentaCosto VARCHAR (20) NULL, 
  Precio1 DECIMAL(18,4) NULL default 0, 
  Precio2 DECIMAL(18,4) NULL default 0, 
  Precio3 DECIMAL(18,4) NULL default 0, 
  Precio4 DECIMAL(18,4) NULL default 0, 
  TipoImpuesto1 VARCHAR (8) NOT NULL, 
  TipoImpuesto2 VARCHAR (8) NULL, 
  CostoStandard DECIMAL(18,4) NULL default 0, 
  PComis1 FLOAT NULL default 0, 
  PComis2 FLOAT NULL default 0, 
  PComis3 FLOAT NULL default 0, 
  Presentacion VARCHAR (12) NOT NULL, 
  Unidad VARCHAR (12) NOT NULL, 
  CantidadPresentacion FLOAT NULL default 0, 
  NumeroPLU INT NULL default 0, 
  PrecioIndexado SMALLINT NULL default 0, 
  FechaCreacion DATETIME NULL, 
  ImageFile VARCHAR (80) NULL, 
  Ubicacion VARCHAR (12) NULL, 
  Grupo VARCHAR (15) NULL, 
  Descuento VARCHAR (12) NULL, 
  Regulado TINYINT NULL default 0, 
  Marcado TINYINT NULL default 0,
PRIMARY KEY (Codigo), 
  KEY ix_Descripcion(Descripcion), 
  KEY ix_Grupo(Grupo,Codigo), 
  UNIQUE KEY ix_Linea(Linea,Codigo), 
  KEY ix_LineaDesc(Linea,Descripcion), 
  KEY ix_LineaGrupo(Linea,Grupo,Codigo), 
  KEY ix_NumeroPLU(NumeroPLU), 
  KEY ix_Ubicacion(Ubicacion)
);

CREATE TABLE IVARetenido (
  Id INT auto_increment, 
  CodigoProveedor VARCHAR (20) NULL, 
  RifProveedor VARCHAR (14) NULL, 
  NombreProveedor VARCHAR (50) NOT NULL, 
  NumeroFactura VARCHAR (12) NULL, 
  FechaCobro DATETIME NULL, 
  MontoExento DECIMAL(18,4) NULL default 0, 
  MontoGravable1 DECIMAL(18,4) NULL default 0, 
  MontoGravable2 DECIMAL(18,4) NULL default 0, 
  MontoRetencion DECIMAL(18,4) NULL default 0,
  TipoDoc VARCHAR (3) NOT NULL,
  NumeroDoc INTEGER (8) NOT NULL, 
  NumeroControl INTEGER (8) NOT NULL default 0,
  Cancelado INTEGER (2) NOT NULL default 0,
  Relacionado INTEGER (2) NOT NULL default 0,
  Impuesto1 DECIMAL(18, 4) NULL,
  Impuesto2 DECIMAL(18, 4) NULL,
  IVATotal DECIMAL(18, 4) NULL,
  IvaRetenido DECIMAL(18, 4) NULL,
PRIMARY KEY (Id), 
  KEY ix_idxProveedor(CodigoProveedor),
  KEY ix_idxDocumento(TipoDoc, NumeroDoc),
  KEY ix_idxNombreProv(NombreProveedor),
  KEY ix_idRIFProv(RifProveedor)
);

CREATE TABLE LibroCompras (
  Fecha DATETIME NULL, 
  Factura VARCHAR (20) NOT NULL, 
  Proveedor VARCHAR (20) NULL, 
  NombreProveedor VARCHAR (50) NOT NULL, 
  RIF VARCHAR (12) NOT NULL, 
  MontoBruto DECIMAL(18,4) NULL default 0, 
  Exento DECIMAL(18,4) NULL default 0, 
  Gravable1 DECIMAL(18,4) NULL default 0, 
  Porcentaje1 FLOAT NULL default 0, 
  MontoRetencion1 DECIMAL(18,4) NULL default 0, 
  Gravable2 DECIMAL(18,4) NULL default 0, 
  Porcentaje2 FLOAT NULL default 0, 
  MontoRetencion2 DECIMAL(18,4) NULL default 0, 
  NumeroControl INTEGER(8),
  KEY ix_Cronologico(Fecha,Factura), 
  KEY ix_Fatura(Factura), 
  KEY ix_Proveedor(Proveedor,Factura), 
  KEY ix_ProveedoresLibroCompras(Proveedor)
);

CREATE TABLE LibroVentas (
  Fecha DATETIME NULL, 
  Factura VARCHAR (20) NOT NULL, 
  Documento VARCHAR (24) NULL, 
  Cliente VARCHAR (20) NOT NULL, 
  RIF VARCHAR (12) NULL, 
  MontoBruto DECIMAL(18,4) NULL default 0, 
  Exento DECIMAL(18,4) NULL default 0, 
  Gravable1 DECIMAL(18,4) NULL default 0, 
  Porcentaje1 FLOAT NULL default 0, 
  MontoRetencion1 DECIMAL(18,4) NULL default 0, 
  Gravable2 DECIMAL(18,4) NULL, 
  Porcentaje2 FLOAT NULL, 
  MontoRetencion2 DECIMAL(18,4) NULL, 
  KEY ix_Cliente(Cliente,Factura), 
  KEY ix_ClientesLibroVentas(Cliente), 
  KEY ix_Cronologico(Fecha,Factura), 
  KEY ix_Factura(Factura)
);

CREATE TABLE Lineas (
  Codigo VARCHAR (8) NOT NULL, 
  Descripcion VARCHAR (30) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceDescripcion(Descripcion)
);

CREATE TABLE mesasAmbientes (
  Codigo VARCHAR (16) NOT NULL, 
  Prefijo VARCHAR (3) NULL, 
  Descripcion VARCHAR (32) NOT NULL, 
  AccountOffset INT NULL default 0, 
  PorcentajeServicio FLOAT NULL default 0, 
  IndicePrecio SMALLINT NULL default 0, 
  Escala FLOAT NULL default 0, 
  BackColor INT NULL default 0, 
  ColorSillas INT NULL default 0, 
  ColorMesas INT NULL default 0, 
  FormaMesas SMALLINT NULL default 0, 
  FormaSillas SMALLINT NULL default 0, 
  SillasVisibles TINYINT(1) NULL,
PRIMARY KEY (Codigo), 
  UNIQUE KEY ix_Account(AccountOffset), 
  UNIQUE KEY ix_Prefijo(Prefijo)
);

CREATE TABLE mesasItems (
  Codigo VARCHAR (20) NOT NULL, 
  Precio DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Codigo)
);

CREATE TABLE mesasMesas (
  Ambiente VARCHAR (16) NOT NULL, 
  IDMesa INT NULL default 0, 
  x INT NULL default 0, 
  y INT NULL default 0, 
  enmStat SMALLINT NULL default 0, 
  nPersonas SMALLINT NULL default 0, 
  cMesonero VARCHAR (20) NULL default '', 
  MontoDespachado DECIMAL(18,4) NULL default 0, 
  Apertura DATETIME NULL, 
  Cuenta INT NULL default 0,
PRIMARY KEY (Ambiente, IDMesa)
);

CREATE TABLE mnuDeclares (
  ownerMenu VARCHAR (10) NOT NULL, 
  Descripcion VARCHAR (50) NULL
);

CREATE TABLE mnuItems (
  ownerMenu VARCHAR (10) NOT NULL, 
  Posicion SMALLINT NULL default 0, 
  isTerminal SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Imagen VARCHAR (64) NULL default 'imageNA', 
  Descripcion VARCHAR (40) NOT NULL, 
  Color INT NULL,
PRIMARY KEY (ownerMenu, Posicion), 
  KEY ix_item(CodigoItem)
);

CREATE TABLE MovimientosBanco (
  Numero INT NULL auto_increment, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  CodigoBanco VARCHAR (20) NOT NULL, 
  Tipo SMALLINT NULL default 0, 
  Concepto VARCHAR (50) NULL, 
  Beneficiario VARCHAR (50) NULL, 
  Monto DECIMAL(18,4) NULL default 0, 
  ReferenciaBanco VARCHAR (12) NOT NULL, 
  Conciliado TINYINT(1) NULL default 0, 
  FechaEfectivo DATETIME NULL, 
  TipoDocRel VARCHAR (3) NULL default 'NIL', 
  NumeroDocRel INT NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_BancoFecha(CodigoBanco,FechaTransaccion,Numero), 
  KEY ix_BancoNumero(CodigoBanco,Numero), 
  KEY ix_BancosMovimientosBanco(CodigoBanco), 
  KEY ix_FechaTransaccion(FechaTransaccion)
);

CREATE TABLE MovimientosCaja (
  TransID INT NULL auto_increment, 
  Sesion INT NULL default 0, 
  Operador VARCHAR (8) NOT NULL, 
  Debitos DECIMAL(18,4) NULL default 0, 
  Creditos DECIMAL(18,4) NULL default 0, 
  TipoEntidad VARCHAR (3) NULL default '', 
  CodigoEntidad VARCHAR (20) NULL default '', 
  TipoDocumento VARCHAR (3) NULL default '', 
  NumeroDocumento INT NULL default 0, 
  Fecha DATETIME NULL, 
  Descripcion VARCHAR (50) NULL,
  Hora DATETIME NULL,
PRIMARY KEY (TransID), 
  KEY ix_Documento(TipoDocumento,NumeroDocumento)
);

CREATE TABLE NNEE (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  NombreCliente VARCHAR (50) NOT NULL, 
  CodigoVendedor VARCHAR (15) NOT NULL, 
  Estado SMALLINT NULL default 0, 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  IndiceReferencia SMALLINT NULL default 0, 
  IndiceVenta SMALLINT NULL default 0, 
  Descuento1 FLOAT NULL default 0, 
  Descuento2 FLOAT NULL default 0, 
  Condicion VARCHAR (8) NOT NULL, 
  DireccionEntrega VARCHAR (160) NULL, 
  Notas VARCHAR (255) NULL, 
  ComprobanteAlmacen INT NULL default 0, 
  NumeroFacturaOrigen INT NULL default 0, 
  SaldoActual DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_Cliente(CodigoCliente,FechaTransaccion,Numero), 
  KEY ix_ClientesNNEE(CodigoCliente)
);

CREATE TABLE NNEEDetalles (
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NULL default '', 
  Descripcion VARCHAR (50) NULL default '', 
  Presentacion VARCHAR (12) NULL default '', 
  FactorEmpaque FLOAT NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  PrecioVenta DECIMAL(18,4) NULL default 0, 
  PrecioEfectivo DECIMAL(18,4) NULL default 0, 
  Impuesto1 FLOAT NULL default 0, 
  Impuesto2 FLOAT NULL default 0, 
  CostoUnitario DECIMAL(18,4) NULL default 0, 
  SaldoCantidad FLOAT NULL default 0, 
  Descuentos VARCHAR (10) NULL default '0-0-0',
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_CodigoItem(CodigoItem,NumeroDocumento), 
  KEY ix_NNEENNEEDetalles(NumeroDocumento)
);

CREATE TABLE NNEEDetalleSuplemento (
  NumeroDocumento INT NULL default 0, 
  Renglon INT NULL default 0, 
  NumeroRenglonOrigen INT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0, 
  Presentacion VARCHAR (12) NOT NULL, 
  FactorPresentacion FLOAT NULL default 0, 
  PrecioNeto DECIMAL(18,4) NULL default 0, 
  Impuesto1 FLOAT NULL default 0, 
  Impuesto2 FLOAT NULL default 0,
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_NNEESuplementoNNEEDetalleSuplemento(NumeroDocumento)
);

CREATE TABLE NNEESuplemento (
  Numero INT NULL auto_increment, 
  NumeroNota INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  FechaTransaccion DATETIME NULL, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  Descripcion VARCHAR (50) NULL default '', 
  Impuesto1 DECIMAL(18,4) NULL default 0, 
  Impuesto2 DECIMAL(18,4) NULL default 0, 
  Valor DECIMAL(18,4) NULL default 0, 
  TipoDocRel VARCHAR (3) NULL default '', 
  NumeroDocRel INT NULL default 0,
PRIMARY KEY (Numero), 
  KEY ix_IndiceDocumento(TipoDocRel,NumeroDocRel), 
  KEY ix_IndiceNota(NumeroNota,FechaTransaccion), 
  KEY ix_NNEENNEESuplemento(NumeroNota)
);

CREATE TABLE nomAsigDedScript (
  CodigoScript VARCHAR (20) NOT NULL, 
  codigoAsigDed VARCHAR (24) NOT NULL, 
  Orden SMALLINT NULL default 0,
PRIMARY KEY (CodigoScript, codigoAsigDed)
);

CREATE TABLE nomAtribTrabajador (
  CodTrab VARCHAR (20) NOT NULL, 
  CodAttrib VARCHAR (24) NOT NULL, 
  ValAttrib FLOAT NULL default 0,
PRIMARY KEY (CodTrab, CodAttrib), 
  KEY ix_CodAttrib(CodAttrib)
);

CREATE TABLE nomCategoriasLaborales (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomCodigosRecibo (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomCodigosReporte (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomDefAsigDed (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL, 
  Tipo INT NULL default 0, 
  ClaseLaboral VARCHAR (16) NOT NULL, 
  CodigoReporte VARCHAR (20) NOT NULL, 
  CodigoCuenta VARCHAR (20) NULL, 
  CodigoContrapartida VARCHAR (20) NULL, 
  Formula TEXT NULL, 
  CodigoRecibo VARCHAR (20) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_I1(Descripcion)
);

CREATE TABLE nomDepartamentos (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (40) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomDescCargos (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (40) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomDescHabilidad (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (40) NOT NULL, 
  MinRango SMALLINT NULL default 0, 
  MaxRango SMALLINT NULL default 0,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomDetallesProceso (
  ProcessID INT NULL default 0, 
  Trabajador VARCHAR (20) NOT NULL, 
  Departamento VARCHAR (24) NOT NULL, 
  Cargo VARCHAR (24) NOT NULL, 
  Tipo SMALLINT NULL default 0, 
  FechaCierre DATETIME NULL, 
  ClaseLaboral VARCHAR (24) NOT NULL, 
  CodigoReporte VARCHAR (24) NOT NULL, 
  CodigoCuenta VARCHAR (20) NULL, 
  CodigoContrapartida VARCHAR (20) NULL, 
  CodigoRecibo VARCHAR (24) NULL, 
  CodigoAsigDed VARCHAR (24) NOT NULL, 
  Valor DECIMAL(18,4) NULL default 0, 
  KEY ix_I1(Trabajador,ClaseLaboral,FechaCierre), 
  KEY ix_I2(Trabajador,CodigoReporte,FechaCierre), 
  KEY ix_I3(Trabajador,ProcessID), 
  KEY ix_I4(ProcessID,Trabajador)
);

CREATE TABLE nomDetallesRecibo (
  numeroProceso INT NULL default 0, 
  codigoTrabajador VARCHAR (20) NOT NULL, 
  varID VARCHAR (40) NOT NULL, 
  varType INT NULL default 0, 
  Value TEXT NULL,
PRIMARY KEY (numeroProceso, codigoTrabajador, varID), 
  KEY ix_varID(varID)
);

CREATE TABLE nomEnumHabilidades (
  CodigoHabilidad VARCHAR (24) NOT NULL, 
  Enumerador VARCHAR (12) NOT NULL, 
  Valor INT NULL default 0,
PRIMARY KEY (CodigoHabilidad, Valor), 
  KEY ix_Enumerador(Enumerador)
);

CREATE TABLE nomExcepciones (
  NumeroId INT NULL default 0, 
  CodTrabajador VARCHAR (20) NOT NULL, 
  CodExcepcion VARCHAR (24) NOT NULL, 
  Fecha DATETIME NULL, 
  Valor FLOAT NULL default 0, 
  Notas VARCHAR (255) NULL, 
  TipoRecurrencia SMALLINT NULL default 0, 
  Recurrencia FLOAT NULL default 0, 
  Operador VARCHAR (20) NULL, 
  FechaRegistro DATETIME NULL,
PRIMARY KEY (NumeroId), 
  KEY ix_CodTrabajador(CodTrabajador,Fecha,NumeroId)
);

CREATE TABLE nomFiltros (
  Codigo VARCHAR (24) NOT NULL, 
  codigoAtributo VARCHAR (24) NOT NULL, 
  valorDesde VARCHAR (40) NOT NULL default '', 
  valorHasta VARCHAR (40) NOT NULL default '',
PRIMARY KEY (Codigo)
);

CREATE TABLE nomFiltrosScript (
  CodigoScript VARCHAR (20) NOT NULL, 
  codigoFiltro VARCHAR (24) NOT NULL,
PRIMARY KEY (CodigoScript, codigoFiltro)
);

CREATE TABLE nomHabilidadesTrabajador (
  CodigoTrabajador VARCHAR (20) NOT NULL, 
  CodigoHabilidad VARCHAR (24) NOT NULL, 
  Grado SMALLINT NULL default 0, 
  Notas VARCHAR (160) NULL,
PRIMARY KEY (CodigoTrabajador, CodigoHabilidad), 
  KEY ix_CodigoHabilidad(CodigoHabilidad), 
  KEY ix_TrabHabil(CodigoHabilidad,CodigoTrabajador)
);

CREATE TABLE nomHistTrab (
  CodigoTrabajador VARCHAR (20) NOT NULL, 
  Desde DATETIME NULL, 
  Departamento VARCHAR (24) NOT NULL, 
  Cargo VARCHAR (24) NOT NULL, 
  Sueldo DECIMAL(18,4) NULL default 0, 
  Base SMALLINT NULL default 0,
PRIMARY KEY (CodigoTrabajador, Desde)
);

CREATE TABLE nomObservaciones (
  Numero INT NULL default 0, 
  CodigoTrabajador VARCHAR (20) NOT NULL, 
  Fecha DATETIME NULL, 
  Operador VARCHAR (20) NOT NULL, 
  TipoObservacion VARCHAR (24) NOT NULL, 
  Observacion TEXT NULL, 
  KEY ix_CodTrabFecha(CodigoTrabajador,Fecha,Numero)
);

CREATE TABLE nomPagosProceso (
  ProcessID INT NULL default 0, 
  Trabajador VARCHAR (20) NOT NULL, 
  Fecha DATETIME NULL, 
  Departamento VARCHAR (24) NOT NULL, 
  Cargo VARCHAR (24) NOT NULL, 
  MontoPagado DECIMAL(18,4) NULL default 0, 
  Medio VARCHAR (20) NOT NULL, 
  CodigoBanco VARCHAR (20) NULL, 
  NumeroDocumento VARCHAR (12) NULL,
PRIMARY KEY (ProcessID, Trabajador), 
  KEY ix_ProcessID(ProcessID)
);

CREATE TABLE nomProcesos (
  Numero INT NULL default 0, 
  Operador VARCHAR (8) NULL, 
  CodigoScript VARCHAR (12) NOT NULL, 
  FechaInicioPeriodo DATETIME NULL, 
  FechaFinPeriodo DATETIME NULL, 
  FechaCierre DATETIME NULL,
PRIMARY KEY (Numero), 
  KEY ix_I1(CodigoScript,FechaInicioPeriodo), 
  KEY ix_I2(CodigoScript,FechaFinPeriodo), 
  KEY ix_I3(CodigoScript,FechaCierre), 
  KEY ix_I4(FechaCierre)
);

CREATE TABLE nomRecibosScript (
  CodigoScript VARCHAR (12) NOT NULL, 
  FileName VARCHAR (64) NOT NULL, 
  PrinterName VARCHAR (64) NOT NULL, 
  KEY ix_I1(CodigoScript,FileName)
);

CREATE TABLE nomScripts (
  Codigo VARCHAR (20) NOT NULL, 
  descripcionScript VARCHAR (60) NOT NULL, 
  codePostTrabajador TEXT NULL, 
  codeVerificarRestricciones TEXT NULL, 
  codeBaseScript TEXT NULL, 
  codeTrabajadorElegible TEXT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomTiposAtributo (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomTiposExcepcion (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL, 
  Visible SMALLINT NULL default '-1',
PRIMARY KEY (Codigo)
);

CREATE TABLE nomTiposObservacion (
  Codigo VARCHAR (24) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE nomTMPListaExcepciones (
  NumeroId INT NULL default 0, 
  CodTrabajador VARCHAR (20) NOT NULL, 
  CodExcepcion VARCHAR (24) NOT NULL, 
  Fecha DATETIME NULL, 
  Valor FLOAT NULL default 0, 
  Notas VARCHAR (255) NULL, 
  TipoRecurrencia SMALLINT NULL default 0, 
  Recurrencia FLOAT NULL default 0, 
  Operador VARCHAR (20) NULL, 
  KEY ix_CodExcepcion(NumeroId,CodExcepcion,Fecha), 
  KEY ix_CodTrabajador(NumeroId,CodTrabajador,CodExcepcion,Fecha)
);

CREATE TABLE nomTMPResumenProceso (
  sUserID VARCHAR (8) NOT NULL, 
  sCodTrab VARCHAR (20) NOT NULL, 
  sCodDept VARCHAR (24) NOT NULL, 
  sCodGrup VARCHAR (24) NOT NULL, 
  nTipo SMALLINT NULL default 0, 
  vmValor DECIMAL(18,4) NULL default 0, 
  KEY ix_I1(sUserID,sCodDept,sCodTrab,nTipo,sCodGrup), 
  KEY ix_sUserID(sUserID)
);

CREATE TABLE nomTrabajadores (
  Codigo VARCHAR (20) NOT NULL, 
  Nombre VARCHAR (40) NOT NULL, 
  CI VARCHAR (12) NOT NULL, 
  Departamento VARCHAR (16) NOT NULL, 
  Cargo VARCHAR (16) NOT NULL, 
  FechaIngreso DATETIME NULL, 
  FechaAsignacion DATETIME NULL default '1980-01-01', 
  Sueldo DECIMAL(18,4) NULL default 0, 
  BaseSueldo SMALLINT NULL default 0, 
  Direccion VARCHAR (160) NULL, 
  Telefono VARCHAR (30) NULL, 
  Sexo SMALLINT NULL default 0, 
  EstadoCivil SMALLINT NULL default 0, 
  FechaNacimiento DATETIME NULL, 
  LugarNacimiento VARCHAR (20) NULL, 
  NombreConyuge VARCHAR (40) NULL, 
  NumeroDeHijos SMALLINT NULL default 0, 
  Activo TINYINT(1) NULL default 0, 
  ImageFile VARCHAR (80) NULL, 
  EstadoAcceso TINYINT NULL default 0,
PRIMARY KEY (Codigo), 
  KEY ix_CI(CI), 
  KEY ix_Nombre(Nombre)
);

CREATE TABLE NotasDCCP (
  Numero INT NULL default 0, 
  TipoEntidad VARCHAR (3) NOT NULL, 
  CodigoEntidad VARCHAR (20) NOT NULL, 
  FechaDoc DATETIME NULL, 
  Descripcion VARCHAR (40) NOT NULL, 
  Monto DECIMAL(18,4) NULL default 0, 
  Saldo DECIMAL(18,4) NULL default 0, 
  Operador VARCHAR (8) NOT NULL,
PRIMARY KEY (Numero), 
  KEY ix_Entidad(TipoEntidad,CodigoEntidad,FechaDoc,Numero)
);

CREATE TABLE ocDetalles (
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NULL, 
  Descripcion VARCHAR (50) NULL, 
  Presentacion VARCHAR (12) NULL, 
  FactorEmpaque FLOAT NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PrecioRequerido DECIMAL(18,4) NULL default 0, 
  Recibidas FLOAT NULL default 0, 
  PrecioMedio DECIMAL(18,4) NULL default 0, 
  CantPaga FLOAT NULL default 0, 
  CantPromo FLOAT NULL default 0, 
  PVP DECIMAL(18,4) NULL default 0, 
  Descuentos VARCHAR (15) NULL,
PRIMARY KEY (NumeroDocumento, Renglon), 
  KEY ix_CodigoItem(CodigoItem)
);

CREATE TABLE ocOrdenes (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransaccion DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  CodigoProveedor VARCHAR (20) NOT NULL, 
  NombreProveedor VARCHAR (50) NULL, 
  FechaRequerido DATETIME NULL, 
  Estado SMALLINT NULL default 0, 
  ValorNominal DECIMAL(18,4) NULL default 0, 
  Descuento1 FLOAT NULL default 0, 
  Descuento2 FLOAT NULL default 0, 
  Notas VARCHAR (255) NULL,
PRIMARY KEY (Numero), 
  KEY ix_Proveedor(CodigoProveedor,FechaTransaccion,Numero)
);

CREATE TABLE ocRecibidas (
  NumeroOrden INT NULL default 0, 
  NumeroRenglon SMALLINT NULL default 0, 
  Fecha DATETIME NULL, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0, 
  PrecioUnitario DECIMAL(18,4) NULL default 0, 
  Unidad VARCHAR (12) NOT NULL, 
  Factor FLOAT NULL default 0, 
  TipoDocumento VARCHAR (5) NOT NULL, 
  NumeroDocumento INT NULL default 0, 
  KEY ix_Renglon(NumeroOrden,NumeroRenglon,Fecha)
);

CREATE TABLE Opciones (
  TipoOpcion VARCHAR (1) NOT NULL, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL, 
  Pedido VARCHAR (2) NOT NULL
);

CREATE TABLE ParametrosEmpresa (
  NombreEmpresa VARCHAR (50) NOT NULL, 
  RIF VARCHAR (12) NULL, 
  NIT VARCHAR (12) NULL, 
  Direccion VARCHAR (160) NULL, 
  Telefono VARCHAR (30) NULL, 
  MascaraPrecios VARCHAR (20) NOT NULL, 
  MascaraMonetarios VARCHAR (20) NOT NULL, 
  MascaraInventario VARCHAR (20) NOT NULL, 
  MascaraCantidades VARCHAR (50) NOT NULL, 
  FormatoSaldos VARCHAR (20) NOT NULL, 
  FactorRedondeoPrecios FLOAT NULL default 0, 
  DefaultImpuesto1 VARCHAR (3) NOT NULL, 
  DefaultImpuesto2 VARCHAR (3) NULL, 
  PrecioIncluyeImpuesto1 TINYINT(1) NULL, 
  PrecioIncluyeImpuesto2 TINYINT(1) NULL, 
  CodigoClienteMostrador VARCHAR (15) NOT NULL, 
  MesInicioAnho SMALLINT NULL default 0, 
  AnhoActual SMALLINT NULL default 0, 
  PeriodoActual SMALLINT NULL default 0, 
  FormatoCodigos VARCHAR (20) NOT NULL, 
  CuentaGanPer VARCHAR (20) NULL, 
  Separador VARCHAR (1) NOT NULL, 
  AcreditarComision TINYINT(1) NULL, 
  PComisVenta1 FLOAT NULL default 0, 
  PComisVenta2 FLOAT NULL default 0, 
  PComisVenta3 FLOAT NULL default 0, 
  PComisCobranza1 FLOAT NULL default 0, 
  PComisCobranza2 FLOAT NULL default 0, 
  PComisCobranza3 FLOAT NULL default 0, 
  indexarPrecios SMALLINT NULL default 0, 
  valoracionInventario SMALLINT NULL default 0, 
  TituloPrecio1 VARCHAR (20) NOT NULL, 
  TituloPrecio2 VARCHAR (20) NOT NULL, 
  TituloPrecio3 VARCHAR (20) NOT NULL, 
  TituloPrecio4 VARCHAR (20) NOT NULL, 
  NombreImpuesto1 VARCHAR (12) NOT NULL, 
  NombreImpuesto2 VARCHAR (12) NULL, 
  CuentaGeneralVentas VARCHAR (20) NULL, 
  CuentaGeneralInventario VARCHAR (20) NULL, 
  CuentaGeneralDeudas VARCHAR (20) NULL, 
  CuentaGeneralAcreencias VARCHAR (20) NULL, 
  CuentaGeneralBancos VARCHAR (20) NULL, 
  CuentaGeneralCosto VARCHAR (20) NULL, 
  CuentaGeneralDevoluciones VARCHAR (20) NULL, 
  CuentaPasivoComisiones VARCHAR (20) NULL, 
  CuentaGastosComisiones VARCHAR (20) NULL, 
  CuentaImpuesto1 VARCHAR (20) NULL, 
  CuentaImpuesto2 VARCHAR (20) NULL, 
  CuentaCaja VARCHAR (20) NULL, 
  ProximaMaquina INT NULL default '1', 
  InicioVigenciaIDB DATETIME NULL, 
  FinVigenciaIDB DATETIME NULL, 
  PorcentajeIDB FLOAT NULL default 0, 
  CuentaGastosIDB VARCHAR (20) NULL, 
  CuentaISLRAnticipado VARCHAR (20) NULL, 
  CuentaEgresosComisionTC VARCHAR (50) NULL, 
  TipoInventarioEnCurso SMALLINT NULL default 0, 
  AlmacenInventarioFisico VARCHAR (8) NULL, 
  CuentaDescuentosCobranza VARCHAR (20) NULL default '', 
  CuentaDescuentosPagos VARCHAR (20) NULL, 
  CuentaMercanciaDanhada VARCHAR (20) NULL, 
  CuentaISLRRetenido VARCHAR (20) NULL, 
  Ciudad VARCHAR (20) NULL, 
  CuentaServicio VARCHAR (20) NULL, 
  ClaveActivacion INT NULL default 0, 
  TipoCambio DECIMAL(18,4) NULL default '1', 
  CuentaMercanciaTransito VARCHAR (20) NULL,
  Contribuyente INTEGER (2) NOT NULL default 0,
  PorcentajeRetencionIVACE DECIMAL (6, 2) NOT NULL default '75',
  ValorActualUT DECIMAL(18, 2) NOT NULL default '29400'
);

CREATE TABLE perfilDescripcion (
  CodigoPerfil VARCHAR (12) NOT NULL, 
  DescripcionPerfil VARCHAR (36) NOT NULL,
PRIMARY KEY (CodigoPerfil)
);

CREATE TABLE perfilElementos (
  Valor SMALLINT NULL default 0, 
  Descripcion VARCHAR (48) NOT NULL, 
  Posicion SMALLINT NULL default 0,
PRIMARY KEY (Valor), 
  KEY ix_Posicion(Posicion)
);

CREATE TABLE perfilesPermisos (
  CodigoPerfil VARCHAR (12) NOT NULL, 
  Permiso SMALLINT NULL default 0,
PRIMARY KEY (CodigoPerfil, Permiso)
);

CREATE TABLE Prefijos (
  Prefijo VARCHAR (1) NOT NULL, 
  Uso TINYINT NULL default 0,
PRIMARY KEY (Prefijo)
);

CREATE TABLE Proveedores (
  Codigo VARCHAR (20) NOT NULL, 
  Nombre VARCHAR (50) NOT NULL, 
  RIF VARCHAR (12) NULL, 
  CGCuenta VARCHAR (20) NULL, 
  Condiciones VARCHAR (50) NOT NULL, 
  Direccion1 VARCHAR (40) NULL, 
  Direccion2 VARCHAR (40) NULL, 
  Direccion3 VARCHAR (40) NULL, 
  Direccion4 VARCHAR (40) NULL, 
  Telefono VARCHAR (30) NULL, 
  SaldoActual DECIMAL(18,4) NULL default 0, 
  LimiteCredito DECIMAL(18,4) NULL default 0, 
  FechaUltimaCompra DATETIME NULL, 
  Notas VARCHAR (255) NULL, 
  FechaCreacion DATETIME NULL, 
PRIMARY KEY (Codigo), 
  KEY ix_IndiceNombre(Nombre)
);

CREATE TABLE ProveedorProducto (
  CodigoProveedor VARCHAR (20) NOT NULL, 
  CodigoItem VARCHAR (20) NOT NULL, 
  RefProductoProveedor VARCHAR (20) NULL, 
  PrecioReferencia DECIMAL(18,4) NULL default 0, 
  FechaOferta DATETIME NOT NULL, 
  PrecioUltimaCompra DECIMAL(18,4) NULL default 0, 
  FechaUltimaCompra DATETIME NULL, 
  Notas VARCHAR (255) NOT NULL, 
  UNIQUE KEY ix_iItem(CodigoItem,CodigoProveedor), 
  UNIQUE KEY ix_iProveedor(CodigoProveedor,CodigoItem), 
  KEY ix_itemsInventarioProveedorProducto(CodigoItem), 
  KEY ix_ProveedoresProveedorProducto(CodigoProveedor), 
  KEY ix_refProveedor(CodigoProveedor,RefProductoProveedor)
);

CREATE TABLE RenglonesConsumoSesion (
  OwnerID INT NULL default 0, 
  Renglon INT NULL default 0, 
  Descripcion VARCHAR (255) NOT NULL, 
  KEY ix_OwnerID(OwnerID), 
  KEY ix_PrimaryKey(OwnerID,Renglon)
);

CREATE TABLE RenglonesCuentaPOS (
  IDCuenta INT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  PrecioUnitario DECIMAL(18,4) NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  NumeroRenglon INT NULL default 0, 
  Usuario VARCHAR (20) NULL default '', 
  Precio DECIMAL(18,4) NULL default 0, 
  KEY ix_CuentasPOSRenglonesCuentaPOS(IDCuenta), 
  KEY ix_PrimaryKey(IDCuenta,CodigoItem,PrecioUnitario)
);

CREATE TABLE RenglonesFacturaPOS (
  idMaquina INT NULL default 0, 
  numeroTicket INT NULL default 0, 
  numeroLinea SMALLINT NULL default 0, 
  Producto VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0, 
  PrecioUnitario DECIMAL(18,4) NULL default 0, 
  PorcentajeImpuesto FLOAT NULL default 0, 
  Usuario VARCHAR (20) NULL default '',
PRIMARY KEY (idMaquina, numeroTicket, numeroLinea), 
  KEY ix_FacturasPOSRenglonesFacturaPOS(idMaquina,numeroTicket), 
  KEY ix_ndxUsuario(Usuario)
);

CREATE TABLE RenglonesSesion (
  SessionID INT NULL default 0, 
  NumeroRenglon SMALLINT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  PrecioUnitario DECIMAL(18,4) NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PorcentajeImpuesto FLOAT NULL default 0, 
  TipoImpuesto VARCHAR (3) NOT NULL default '', 
  PrecioLista DECIMAL(18,4) NULL default 0, 
  Usuario VARCHAR (20) NULL default '',
PRIMARY KEY (SessionID, NumeroRenglon)
);

CREATE TABLE RenglonesTransferencia (
  NumeroTransferencia INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  CodigoProducto VARCHAR (20) NOT NULL, 
  Cantidad FLOAT NULL default 0, 
  CostoUnitario DECIMAL(18,4) NULL default 0,
PRIMARY KEY (NumeroTransferencia, Renglon), 
  KEY ix_NumeroTransferencia(NumeroTransferencia)
);

CREATE TABLE RetencionesISLR (
  CodigoProveedor VARCHAR (20) NOT NULL, 
  Fecha DATETIME NULL, 
  RefDocumento VARCHAR (20) NOT NULL, 
  MontoPagado DECIMAL(18,4) NULL default 0, 
  MontoRetenido DECIMAL(18,4) NULL default 0, 
  KEY ix_FechaProv(Fecha,CodigoProveedor), 
  KEY ix_ProvFecha(CodigoProveedor,Fecha)
);

CREATE TABLE RetencionesIVA (
  Id INT auto_increment, 
  CodigoCliente VARCHAR (20) NOT NULL, 
  NumFactura INT NULL default 0, 
  FechaCobro DATETIME NULL, 
  MontoRetencion DECIMAL(18,4) NULL default 0,
PRIMARY KEY (Id)
);

CREATE TABLE RetirosPOS (
  idSesion INT NULL default 0, 
  Hora DATETIME NULL, 
  Tipo SMALLINT NULL default 0, 
  Descripcion VARCHAR (50) NOT NULL, 
  Monto DECIMAL(18,4) NULL default 0, 
  KEY ix_SesionesPOSRetirosPOS(idSesion), 
  KEY ix_tmSesion(idSesion,Hora)
);

CREATE TABLE rpBalanceGeneral (
  CodigoCuenta VARCHAR (24) NOT NULL, 
  Titulo VARCHAR (70) NOT NULL, 
  SaldoNivel0 FLOAT NULL default 0, 
  SaldoNivel1 FLOAT NULL default 0, 
  SaldoNivel2 FLOAT NULL default 0, 
  SaldoNivel3 FLOAT NULL default 0,
PRIMARY KEY (CodigoCuenta)
);

CREATE TABLE SaldosEntidadPeriodo (
  TipoEntidad VARCHAR (3) NOT NULL, 
  CodigoEntidad VARCHAR (20) NOT NULL, 
  NumeroPeriodo INT NULL, 
  SaldoInicial DECIMAL(18,4) NULL default 0, 
  Debitos DECIMAL(18,4) NULL default 0, 
  Creditos DECIMAL(18,4) NULL default 0,
PRIMARY KEY (TipoEntidad, CodigoEntidad, NumeroPeriodo)
);

CREATE TABLE SaldosPeriodo (
  CodigoCuenta VARCHAR (20) NOT NULL, 
  NumeroPeriodo INT NULL default 0, 
  SaldoInicial FLOAT NULL default 0, 
  Debitos FLOAT NULL default 0, 
  Creditos FLOAT NULL default 0,
PRIMARY KEY (CodigoCuenta, NumeroPeriodo), 
  KEY ix_CuentasSaldosPeriodo(CodigoCuenta)
);

CREATE TABLE Seriales (
  CodigoItem VARCHAR (20) NOT NULL, 
  Serial VARCHAR (20) NOT NULL, 
  EnStock SMALLINT NULL default 0, 
  Locked SMALLINT NULL default 0,
PRIMARY KEY (CodigoItem, Serial),
KEY ndxSeriale(Serial)
);

CREATE TABLE SerialesDetalles (
  NumeroDetalle INT NULL default 0, 
  CodigoItem VARCHAR (20) NOT NULL, 
  Serial VARCHAR (20) NOT NULL, 
  TipoDocumento VARCHAR (5) NOT NULL, 
  NumeroDocumento INT NULL default 0, 
  Renglon SMALLINT NULL default 0, 
  Tipo INT NULL default 0, 
  FechaTransaccion DATETIME NULL, 
  isTemporal INT NULL default 0, 
  prevStatus SMALLINT NULL default 0,
PRIMARY KEY (NumeroDetalle), 
  KEY ix_iDocLinea(NumeroDocumento,TipoDocumento,Renglon), 
  KEY ix_iItem(CodigoItem,Serial,FechaTransaccion), 
  KEY ix_iSerial(Serial)
);

CREATE TABLE Series (
  CodigoSerie VARCHAR (3) NOT NULL, 
  Descripcion VARCHAR (24) NOT NULL, 
  CuentaIngreso VARCHAR (50) NULL, 
  ProximaFactura INT NULL default 0, 
  CuentaImpuesto1 VARCHAR (20) NULL, 
  CuentaImpuesto2 VARCHAR (50) NULL, 
  CuentaCosto VARCHAR (50) NULL, 
  Nivel TINYINT(1) NOT NULL,
PRIMARY KEY (CodigoSerie), 
  KEY ix_Descripcion(Descripcion)
);

CREATE TABLE SesionesCerradas (
  SessionID INT NULL default 0, 
  MachineID INT NULL, 
  Cerrada SMALLINT NULL, 
  usrID VARCHAR (8) NOT NULL, 
  Fecha DATETIME NULL, 
  StartTime DATETIME NULL, 
  ComprobanteAlmacen INT NULL, 
  CurrentAccount INT NULL, 
  CurrentAmount DECIMAL(18,4) NULL, 
  FacturasRealizadas INT NULL, 
  MontoFacturado DECIMAL(18,4) NULL, 
  ImpuestoCobrado DECIMAL(18,4) NULL, 
  EfectivoEnCaja DECIMAL(18,4) NULL, 
  TTCVisa DECIMAL(18,4) NULL, 
  TTCMaster DECIMAL(18,4) NULL, 
  TTCOtras DECIMAL(18,4) NULL, 
  TDebito DECIMAL(18,4) NULL, 
  ChequesEnCaja DECIMAL(18,4) NULL, 
  Anulaciones SMALLINT NULL, 
  MontoAnulaciones DECIMAL(18,4) NULL, 
  ImpuestoAnulado DECIMAL(18,4) NULL, 
  Retiros INT NULL, 
  MontoRetirado DECIMAL(18,4) NULL, 
  CobrosRealizados SMALLINT NULL, 
  MontoCobrado DECIMAL(18,4) NULL, 
  ServicioCobrado DECIMAL(18,4) NULL, 
  ServicioAnulado DECIMAL(18,4) NULL, 
  VentasACredito DECIMAL(18,4) NULL, 
  MontoEnCaja DECIMAL(18,4) NULL, 
  TTCAmex DECIMAL(18,4) NULL default 0, 
  OtrosMedios DECIMAL(18,4) NULL default 0, 
  Propinas DECIMAL(18,4) NULL default 0,
PRIMARY KEY (SessionID), 
  KEY ix_MachineID(MachineID), 
  KEY ix_usrID(usrID)
);

CREATE TABLE SesionesPOS (
  SessionID INT auto_increment, 
  MachineID INT default 0, 
  Cerrada SMALLINT NULL default 0, 
  usrID VARCHAR (8) NOT NULL, 
  Fecha DATETIME NULL, 
  StartTime DATETIME NULL, 
  ComprobanteAlmacen INT NULL default 0, 
  CurrentAccount INT NULL default 0, 
  CurrentAmount DECIMAL(18,4) NULL default 0, 
  FacturasRealizadas INT NULL default 0, 
  MontoFacturado DECIMAL(18,4) NULL default 0, 
  ImpuestoCobrado DECIMAL(18,4) NULL default 0, 
  EfectivoEnCaja DECIMAL(18,4) NULL default 0, 
  TTCVisa DECIMAL(18,4) NULL default 0, 
  TTCMaster DECIMAL(18,4) NULL default 0, 
  TTCOtras DECIMAL(18,4) NULL default 0, 
  TDebito DECIMAL(18,4) NULL default 0, 
  ChequesEnCaja DECIMAL(18,4) NULL default 0, 
  Anulaciones SMALLINT NULL default 0, 
  MontoAnulaciones DECIMAL(18,4) NULL default 0, 
  ImpuestoAnulado DECIMAL(18,4) NULL default 0, 
  Retiros INT NULL default 0, 
  MontoRetirado DECIMAL(18,4) NULL default 0, 
  CobrosRealizados SMALLINT NULL default 0, 
  MontoCobrado DECIMAL(18,4) NULL default 0, 
  ServicioCobrado DECIMAL(18,4) NULL default 0, 
  ServicioAnulado DECIMAL(18,4) NULL default 0, 
  VentasACredito DECIMAL(18,4) NULL default 0, 
  MontoEnCaja DECIMAL(18,4) NULL default 0, 
  TTCAmex DECIMAL(18,4) NULL default 0, 
  OtrosMedios DECIMAL(18,4) NULL default 0, 
  Propinas DECIMAL(18,4) NULL default 0,
PRIMARY KEY (SessionID), 
  KEY ix_MachineID(MachineID), 
  KEY ix_usrID(usrID)
);

CREATE TABLE subDocsMB (
  ID INT auto_increment, 
  TransID INT NULL default 0, 
  TipoDoc VARCHAR (3) NOT NULL, 
  NumDoc INT NULL default 0, 
  Debitos DECIMAL(18,4) NULL default 0, 
  Creditos DECIMAL(18,4) NULL default 0,
PRIMARY KEY (ID), 
  KEY ix_MovimientosCajasubDocsMC(TransID), 
  KEY ix_TransID(TransID)
);

CREATE TABLE subDocsMC (
  ID INT NULL auto_increment, 
  TransID INT NULL default 0, 
  TipoDoc VARCHAR (3) NOT NULL, 
  NumDoc INT NULL default 0, 
  Debitos DECIMAL(18,4) NULL default 0, 
  Creditos DECIMAL(18,4) NULL default 0,
PRIMARY KEY (ID), 
  KEY ix_MovimientosCajasubDocsMC(TransID), 
  KEY ix_TransID(TransID)
);

CREATE TABLE SubLineas (
  Codigo VARCHAR (8) NOT NULL, 
  Descripcion VARCHAR (30) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceDescripcion(Descripcion)
);

CREATE TABLE TarjetasCredito (
  Codigo VARCHAR (8) NOT NULL, 
  Nombre VARCHAR (16) NOT NULL, 
  Banco VARCHAR (20) NOT NULL, 
  PorcentajeComision FLOAT NULL default 0, 
  PorcentajeISLR FLOAT NULL default 0, 
  CuentaComision VARCHAR (20) NULL, 
  CuentaISLR VARCHAR (50) NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE TempAjustes (
  Numero INT auto_increment, 
  Fecha DATETIME NULL, 
  refAjuste VARCHAR (20) NULL, 
  Tipo TINYINT(1) NULL, 
  Descripcion VARCHAR (50) NULL, 
  Notas VARCHAR (255) NULL, 
  Contrapartida VARCHAR (20) NULL, 
  Almacen VARCHAR (8) NOT NULL,
PRIMARY KEY (Numero)
);

CREATE TABLE TiposCliente (
  Codigo VARCHAR (8) NOT NULL, 
  Descripcion VARCHAR (50) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceDescripcion(Descripcion)
);

CREATE TABLE TiposCuentaPOS (
  Prefijo VARCHAR (3) NOT NULL, 
  Base INT NULL default 0, 
  Porcentaje FLOAT NULL default 0, 
  IndicePrecio SMALLINT NULL default '1'
);

CREATE TABLE TiposImpuesto (
  Codigo VARCHAR (3) NOT NULL, 
  Descripcion VARCHAR (30) NOT NULL, 
  Porcentaje FLOAT NULL default 0, 
  VigenteDesde DATETIME NULL, 
  VigenteHasta DATETIME NULL, 
  Cuenta VARCHAR (20) NULL,
PRIMARY KEY (Codigo)
);

CREATE TABLE tmpResumenPOS (
  Sesion INT NULL default 0, 
  Producto VARCHAR (20) NOT NULL, 
  Precio DECIMAL(18,4) NULL default 0, 
  Cantidad FLOAT NULL default 0, 
  PorcentajeImpuesto FLOAT NULL default 0, 
  Fecha DATETIME NULL,
PRIMARY KEY (Sesion, Producto, Precio), 
  KEY ix_Producto(Producto,Sesion)
);

CREATE TABLE tmpSaldos (
  TipoEntidad VARCHAR (3) NOT NULL, 
  CodigoEntidad VARCHAR (20) NOT NULL, 
  NumeroPeriodo INT NULL, 
  SaldoInicial DECIMAL(18,4) NULL default 0, 
  Debitos DECIMAL(18,4) NULL default 0, 
  Creditos DECIMAL(18,4) NULL default 0,
PRIMARY KEY (TipoEntidad, CodigoEntidad, NumeroPeriodo)
);

CREATE TABLE Transferencias (
  Numero INT NULL default 0, 
  FechaRegistro DATETIME NULL, 
  FechaTransferencia DATETIME NULL, 
  Operador VARCHAR (8) NOT NULL, 
  AlmacenOrigen VARCHAR (8) NOT NULL, 
  AlmacenDestino VARCHAR (8) NOT NULL, 
  Descripcion VARCHAR (50) NULL, 
  Notas VARCHAR (255) NULL,
PRIMARY KEY (Numero)
);

CREATE TABLE Unidades (
  Codigo VARCHAR (12) NOT NULL, 
  Unidad VARCHAR (20) NOT NULL, 
  Equivalencia VARCHAR (20) NOT NULL, 
  Factor FLOAT NULL default 0,
PRIMARY KEY (Codigo)
);

CREATE TABLE UnidadesFuncionales (
  Codigo VARCHAR (8) NOT NULL, 
  Descripcion VARCHAR (30) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceDescripcion(Descripcion)
);

CREATE TABLE Usuarios (
  Codigo VARCHAR (8) NOT NULL, 
  Clave INT NULL default 0, 
  Nivel TINYINT NULL default 0, 
  Nombre VARCHAR (40) NOT NULL, 
  Perfil VARCHAR (12) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_ClaveUsuario(Clave)
);

CREATE TABLE valoresCaja (
  Numero INT auto_increment, 
  nSesion INT NULL, 
  MachineID INT NULL, 
  TipoDoc VARCHAR (3) NOT NULL, 
  NumDoc INT NULL, 
  MedioPago SMALLINT NULL, 
  Emisor VARCHAR (20) NOT NULL, 
  NumCuenta VARCHAR (20) NOT NULL, 
  RefDocumento VARCHAR (20) NOT NULL, 
  ClaveAut VARCHAR (8) NOT NULL, 
  Fecha DATETIME NULL, 
  Monto DECIMAL(18,4) NULL,
PRIMARY KEY (Numero), 
  KEY ix_iFactura(MachineID,NumDoc,Numero)
);

CREATE TABLE VencimientosISPC (
  NumeroDocumento INT NULL default 0, 
  FechaVencimiento DATETIME NULL, 
  Monto DECIMAL(18,4) NULL default 0,
PRIMARY KEY (NumeroDocumento, FechaVencimiento), 
  KEY ix_DocumentosISPCVencimientosISPC(NumeroDocumento), 
  KEY ix_FechaVencimiento(FechaVencimiento)
);

CREATE TABLE Vendedores (
  Codigo VARCHAR (15) NOT NULL, 
  Nombre VARCHAR (50) NOT NULL, 
  CI VARCHAR (12) NULL, 
  Direccion VARCHAR (160) NULL, 
  Telefono VARCHAR (30) NULL, 
  NoCobraComision TINYINT(1) NULL, 
  TipoComisionVenta SMALLINT NULL default 0, 
  TipoComisionCobranza SMALLINT NULL default 0, 
  SaldoActual DECIMAL(18,4) NULL default 0, 
  FechaCreacion DATETIME NULL,
PRIMARY KEY (Codigo), 
  KEY ix_Nombre(Nombre)
);

CREATE TABLE Zonas (
  Codigo VARCHAR (8) NOT NULL, 
  Descripcion VARCHAR (30) NOT NULL,
PRIMARY KEY (Codigo), 
  KEY ix_IndiceDescripcion(Descripcion)
);

CREATE TABLE clientespos (
  Codigo varchar(15) NOT NULL default '',
  Nombre varchar(40) NOT NULL default '',
  RIF varchar(14) default NULL,
  NIT varchar(12) default NULL,
  Direccion varchar(120) default NULL,
  Tipo tinyint(4) default NULL,
PRIMARY KEY  (Codigo),
  KEY ix_Nombre (Nombre)
);

	INSERT INTO Condiciones (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C00', 'Contado contra entrega', 0, '', 1);

	INSERT INTO Condiciones (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C07', 'Credito a siete dias', 0, '', 1);

	INSERT INTO Condiciones (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C15', 'Credito a quince dias', 0, '', 1);

	INSERT INTO Condiciones (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C30', 'Credito a treinta dias', 0, '', 1);

	INSERT INTO Condiciones (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C3060', 'Credito a 30 y 60 dias', 0, '', 2);

	INSERT INTO Condiciones (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C306090', 'Credito a 30, 60 y 90 dias', 0, '', 3);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C00', 1, 0, 100);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C07', 1, 7, 100);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C15', 1, 15, 100);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C30', 1, 30, 100);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C3060', 1, 30, 50);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C3060', 2, 60, 50);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C306090', 1, 30, 33.3);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C306090', 2, 60, 33.3);

	INSERT INTO CondicVen (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C306090', 3, 90, 33.4);



	INSERT INTO TiposImpuesto (Codigo, Descripcion, Porcentaje, VigenteDesde, VigenteHasta, CUenta)
		VALUES ('EXE', 'EXENTO', 0, '1980-1-1', '2079-12-31', '');

	INSERT INTO TiposImpuesto (Codigo, Descripcion, Porcentaje, VigenteDesde, VigenteHasta, CUenta)
		VALUES ('IV1', 'TASA GENERAL', 14, '1980-1-1', '2079-12-31', '');

	INSERT INTO TiposImpuesto (Codigo, Descripcion, Porcentaje, VigenteDesde, VigenteHasta, CUenta)
		VALUES ('IV2', 'TASA PREFERENCIAL', 8, '1980-1-1', '2079-12-31', '');




	INSERT INTO Usuarios (Codigo, Clave, Nivel, Nombre, Perfil) 
		VALUES ('ADMIN', 14933, 5, 'Administrador del sistema', 'SUPER');




	INSERT INTO Almacenes (Codigo, Nombre, CUentaActivo)
		VALUES ('GENERAL', 'ALMACEN GENERAL', '');



	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 0 , 'Cambiar empresa seleccionada',  0 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 17 , 'Cambiar impresora seleccionada',  100 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 1 , 'Operar fichas de inventario',  200 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 2 , 'Operar fichas de bancos',  300 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 3 , 'Operar fichas de Clientes',  400 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 4 , 'Operar fichas de cuentas',  500 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 5 , 'Operar fichas de Productos',  600 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 56 , 'Definir Teclas Programables',  610 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 6 , 'Operar fichas de proveedores',  700 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 45 , 'Operar Fichas de Trabajadores',  710 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 51 , 'Registrar Nuevos Trabajadores',  720 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 52 , 'Eliminar Trabajadores',  721 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 53 , 'Modificar fichas de trabajadores',  722 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 16 , 'Operar fichas de vendedores',  800 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 15 , 'Abrir fichas de usuarios (!!!)',  900 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 43 , 'Editar perfiles de usuario (!!)',  950 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 18 , 'Registrar cobranzas',  1000 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 19 , 'Registrar egresos de caja',  1100 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 20 , 'Anotar cheques emitidos',  1200 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 21 , 'Registrar pagos a proveedores',  1300 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 22 , 'Registrar depsitos bancarios',  1400 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 23 , 'Emitir notas de credito o debito',  1500 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 24 , 'Cerrar sesiones de caja',  1600 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 25 , 'Pasar facturas de compra',  1700 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 26 , 'Registrar devoluciones de compras',  1800 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 27 , 'Registrar crditos fiscales',  1900 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 28 , 'Transcribir comprobantes contables',  2000 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 29 , 'Eliminar comprobantres contables',  2100 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 30 , 'Modificar comprobantes contables',  2200 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 31 , 'Registrar ajustes de inventario',  2300 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 32 , 'Registrar transferencias de mercancia',  2400 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 33 , 'Realizar facturas',  2500 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 44 , 'Elaborar Cotizaciones',  2510 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 34 , 'Devolucion de ventas',  2600 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 35 , 'Ver reportes de compras',  2700 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 36 , 'Ver reportes contables',  2800 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 37 , 'Ver reportes de CxC',  2900 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 38 , 'Ver reportes de CxP',  3000 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 39 , 'Ver reportes de inventario',  3100 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 40 , 'Ver reportes de ventas',  3200 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 41 , 'Ver estados de cuenta generales',  3300 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 42 , 'Ver reportes de usuario',  3400 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 7 , 'Abrir forma de almacenes',  3600 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 8 , 'Mantener lineas de inventario',  3700 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 9 , 'Mantener condiciones de crdito',  3800 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 10 , 'Mantener definiciones de impuestos',  3900 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 11 , 'Mantener lineas de productos',  4000 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 12 , 'Modificar definiciones de Tarjetas de Credito',  4100 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 13 , 'Mantener tipos de clientes',  4200 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 14 , 'Mantener zonas',  4300 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 48 , 'Cargar Excepciones (Nomina)',  4400 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 47 , 'Definir Categoras Laborales',  4405 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 49 , 'Definir Cargos (Nomina)',  4410 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 55 , 'Modificar Tabla de Departamentos',  4420 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 46 , 'Definir ADAP (Nomina)',  4500 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 50 , 'Definir Procesos de Nomina',  4510 );
	INSERT INTO perfilElementos (Valor, Descripcion, Posicion) VALUES ( 54 , 'Definir Filtros',  4520 );

CREATE TABLE MediosPago (
  Codigo VarChar (8) PRIMARY KEY NOT NULL,
  Descripcion VarChar(24) NOT NULL,
  Atributos INT NOT NULL DEFAULT 0,
  PorcentajeRetencionEmisor float NOT NULL default 0,
  PorcentajeISLR float NOT NULL default 0,
  CuentaActivo Varchar(20) NOT NULL DEFAULT '',
  CuentaComisiones VARCHAR(20) NOT NULL DEFAULT '',
  BancoRelacionado VARCHAR(20) NOT NULL DEFAULT '',
  Clase SMALLINT NOT NULL DEFAULT 0
);

CREATE TABLE RelacionesIVARetenido (
 NumeroRetencion decimal (14, 0) PRIMARY KEY NOT NULL ,
 Fecha datetime NOT NULL ,
 Operador varchar (20) NOT NULL ,
 AnhoFiscal int (4) NOT NULL ,
 Mes int (2) NOT NULL ,
 RifProveedor varchar (13) NOT NULL ,
 NombreProveedor nvarchar (50) NOT NULL ,
 Numero bigint(20) NOT NULL auto_increment,
 KEY IDX_Numero (Numero)
);

CREATE TABLE documentosfiscales (
  Id bigint(20) NOT NULL auto_increment,
  Fecha date NOT NULL default '0000-00-00',
  TipoDoc varchar(3) NOT NULL default '',
  NumeroDoc bigint(9) NOT NULL default 0,
  TipoEntidad varchar(3) NOT NULL default '',
  CodigoEntidad varchar(20) NOT NULL default '',
  Referencia varchar(20) NOT NULL default '',
  NumeroControlInicial bigint(20) NOT NULL default 0,
  NumeroControlFinal bigint(20) NOT NULL default 0,  
  FacturaRelacionada varchar(20) NOT NULL default '',
  Exento decimal(18,2) NOT NULL default 0,
  Gravable1 decimal(18,2) NOT NULL default 0,
  Tasa1 double(6,2) NOT NULL default 0,
  Gravable2 decimal(18,2) NOT NULL default 0,
  Tasa2 double(6,2) NOT NULL default 0,
  Impuesto1 decimal(18,2) NOT NULL default 0,
  Impuesto2 decimal(18,2) NOT NULL default 0,
  Retencion decimal(18,2) NOT NULL default 0,
  TipoDocFiscal varchar(3) NOT NULL, 
  RifEntidad varchar(14) NOT NULL default '',
  NombreEntidad varchar(50) NOT NULL default '',
  Relacionado bigint(14) NOT NULL default 0,
  PRIMARY KEY  (Id),
  KEY DocumentosEntidad (TipoEntidad,CodigoEntidad,Fecha,Id),
  KEY Documentos (TipoDoc,NumeroDoc),
  KEY DocumentosDocumento(TipoEntidad, CodigoEntidad, TipoDoc, Referencia)
);

CREATE INDEX Documentos_Fiscales_DocumentosEntidad  ON DocumentosFiscales (TipoEntidad, CodigoEntidad, Fecha, Id);
CREATE INDEX DocumentosFIscales_Documentos ON DocumentosFiscales (TipoDoc, NumeroDoc);
CREATE INDEX DocumentosFiscales_Relacion ON DocumentosFiscales (Relacionado, NumeroDoc);

CREATE TABLE mesasZonas (
	CodigoZona varchar (8) PRIMARY KEY NOT NULL,
	Rangos varchar (36) NOT NULL 
);
