CREATE TABLE [dbo].[AcumularSesionPOS] (
	[SesionID] [int] NOT NULL ,
	[CodigoProducto] [nvarchar] (20) NOT NULL ,
	[Precio] [money] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PorcentajeImpuesto] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Ajustes] (
	[Numero] [int] NOT NULL ,
	[refAjuste] [nvarchar] (20) NULL ,
	[Tipo] [smallint] NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[Contrapartida] [nvarchar] (20) NULL ,
	[Almacen] [nvarchar] (8) NOT NULL ,
	[Status] [smallint] NOT NULL ,
	[Valor] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Almacenes] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Nombre] [nvarchar] (50) NOT NULL ,
	[CuentaActivo] [nvarchar] (20) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[AlternosItemVenta] (
	[CodigoAlterno] [nvarchar] (20) NULL ,
	[CodigoItemVenta] [nvarchar] (20) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[AnulacionesPOS] (
	[SessionID] [int] NOT NULL ,
	[Hora] [datetime] NOT NULL ,
	[NumeroTicket] [int] NOT NULL ,
	[MontoVenta] [money] NOT NULL ,
	[Impuesto] [money] NOT NULL ,
	[Servicio] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Atributos] (
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[CodigoAtributo] [nvarchar] (20) NOT NULL ,
	[ValorAtributo] [nvarchar] (255) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Bancos] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Cuenta] [nvarchar] (18) NOT NULL ,
	[Nombre] [nvarchar] (40) NOT NULL ,
	[Banco] [nvarchar] (40) NOT NULL ,
	[TipoCuenta] [tinyint] NOT NULL ,
	[CGCuenta] [nvarchar] (20) NULL ,
	[SaldoActual] [money] NOT NULL ,
	[DepositosDiferidos] [money] NOT NULL ,
	[ChequesPostdatados] [money] NOT NULL ,
	[UltimaActualizacion] [datetime] NOT NULL ,
	[ProximoCheque] [int] NOT NULL ,
	[FechaCreacion] [datetime] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[BarraItemsPagina] (
	[Pagina] [smallint] NOT NULL ,
	[Posicion] [smallint] NOT NULL ,
	[Codigo] [nvarchar] (20) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[BarraPaginas] (
	[Numero] [smallint] NOT NULL ,
	[Descripcion] [nvarchar] (32) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[CierresZ] (
	[idTerminal] [int] NULL ,
	[Numero] [int] NULL ,
	[NumeroUnico] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Apertura] [datetime] NULL ,
	[HoraUltimaOperacion] [datetime] NULL ,
	[qFacturas] [int] NULL ,
	[PrimeraFactura] [int] NULL ,
	[UltimaFactura] [int] NULL ,
	[Turnos] [smallint] NULL ,
	[Exento] [money] NULL ,
	[Servicio] [money] NULL ,
	[Gravable1] [money] NULL ,
	[Gravable2] [money] NULL ,
	[Impuesto1] [money] NULL ,
	[Impuesto2] [money] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Clientes] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Nombre] [nvarchar] (50) NOT NULL ,
	[Tipo] [nvarchar] (8) NULL ,
	[RIF] [nvarchar] (12) NULL ,
	[NIT] [nvarchar] (12) NULL ,
	[CGCuenta] [nvarchar] (20) NULL ,
	[CuentaIngresos] [nvarchar] (20) NULL ,
	[Direccion] [nvarchar] (160) NULL ,
	[Telefono] [nvarchar] (30) NULL ,
	[Zona] [nvarchar] (8) NULL ,
	[Ruta] [nvarchar] (8) NULL ,
	[Estado] [nvarchar] (8) NULL ,
	[Municipio] [nvarchar] (8) NULL ,
	[VendedorAsignado] [nvarchar] (20) NULL ,
	[CondicionStandard] [nvarchar] (8) NULL ,
	[PrecioStandard] [nvarchar] (50) NOT NULL ,
	[SaldoActual] [money] NOT NULL ,
	[LimiteCredito] [money] NOT NULL ,
	[Status] [tinyint] NOT NULL ,
	[FechaUltimaVenta] [datetime] NOT NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[FechaCreacion] [datetime] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[CobrosPOS] (
	[SessionID] [int] NOT NULL ,
	[Hora] [datetime] NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Monto] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Comandas] (
	[Cuenta] [int] NOT NULL ,
	[NumeroComanda] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Comentarios] (
	[Texto] [nvarchar] (50) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Competencia] (
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Establecimiento] [nvarchar] (50) NOT NULL ,
	[Precio] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ComposicionItemsInventario] (
	[CodigoItemVenta] [nvarchar] (20) NOT NULL ,
	[CodigoItemInventario] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ComposicionItemsVenta] (
	[CodigoItemVenta] [nvarchar] (20) NOT NULL ,
	[CodigoItemInventario] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Compras] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NULL ,
	[Operador] [nvarchar] (8) NULL ,
	[CodigoProveedor] [nvarchar] (20) NULL ,
	[RefProveedor] [nvarchar] (20) NULL ,
	[NombreProveedor] [nvarchar] (50) NULL ,
	[CostoMercancia] [money] NOT NULL ,
	[Descuento1] [float] NOT NULL ,
	[Descuento2] [float] NOT NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[Almacen] [nvarchar] (8) NULL ,
	[EstadoRecepcion] [smallint] NOT NULL ,
	[EstadoAdministrativo] [smallint] NOT NULL ,
	[Condicion] [nvarchar] (12) NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[Saldo] [money] NOT NULL, 
  [NumeroControl] [integer] NOT NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[Comprobantes] (
	[NumeroComprobante] [int] NOT NULL ,
	[Periodo] [bigint] NOT NULL ,
	[CorrelativoPeriodo] [bigint] NOT NULL ,
	[Referencia] [nvarchar] (30) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Autor] [nvarchar] (8) NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Debitos] [float] NOT NULL ,
	[Creditos] [float] NOT NULL ,
	[Modificado] [datetime] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ComprobantesAlmacen] (
	[Numero] [int] NOT NULL ,
	[Almacen] [nvarchar] (8) NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[TipoEntidadOrigen] [nvarchar] (3) NOT NULL ,
	[NumeroDocumentoOrigen] [int] NOT NULL ,
	[OrdenDespacho] [int] NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[CondicVen] (
	[CodigoCondicion] [nvarchar] (12) NOT NULL ,
	[Correlativo] [smallint] NOT NULL ,
	[Plazo] [smallint] NOT NULL ,
	[Porcentaje] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Condiciones] (
	[Codigo] [nvarchar] (12) NOT NULL ,
	[Descripcion] [nvarchar] (40) NOT NULL ,
	[Modo] [tinyint] NOT NULL ,
	[CuentaIngresos] [nvarchar] (20) NULL ,
	[nCuotas] [smallint] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Contactos] (
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[NombreContacto] [nvarchar] (50) NOT NULL ,
	[Departamento] [nvarchar] (30) NULL ,
	[Cargo] [nvarchar] (30) NULL ,
	[Direccion] [nvarchar] (160) NULL ,
	[Telefono] [nvarchar] (30) NULL ,
	[TelefonoCelular] [nvarchar] (20) NULL ,
	[FAX] [nvarchar] (20) NULL ,
	[eMail] [nvarchar] (30) NULL ,
	[Notas] [nvarchar] (255) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Contadores] (
	[Factura] [int] NOT NULL ,
	[NotaEntrega] [int] NOT NULL ,
	[Cotizacion] [int] NOT NULL ,
	[DevolucionVenta] [int] NOT NULL ,
	[Compra] [int] NOT NULL ,
	[OrdenCompra] [int] NOT NULL ,
	[DevolucionCompra] [int] NOT NULL ,
	[Ajuste] [int] NOT NULL ,
	[Transferencia] [int] NOT NULL ,
	[NotaDBCR] [int] NOT NULL ,
	[Apertura] [datetime] NOT NULL ,
	[Clave] [int] NOT NULL ,
	[Status] [money] NOT NULL,
	[Operacion] [int] NOT NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[CorrelativosMaquina] (
	[Maquina] [int] NOT NULL ,
	[ProximaFactura] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Cotizaciones] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[NombreCliente] [nvarchar] (50) NOT NULL ,
	[CodigoVendedor] [nvarchar] (15) NULL ,
	[PrecioLista] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[IndiceReferencia] [smallint] NOT NULL ,
	[IndiceVenta] [smallint] NOT NULL ,
	[Descuento1] [float] NOT NULL ,
	[Descuento2] [float] NOT NULL ,
	[Condicion] [nvarchar] (8) NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[Estado] [smallint] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[CotizacionesDetalles] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (15) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Presentacion] [nvarchar] (12) NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioLista] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [float] NOT NULL ,
	[Impuesto2] [float] NOT NULL ,
	[CostoUnitario] [money] NOT NULL ,
	[CantidadFacturada] [float] NOT NULL ,
	[Ancho] [float] NOT NULL ,
	[Alto] [float] NOT NULL ,
	[Largo] [float] NOT NULL ,
	[Descuentos] [nvarchar] (10) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[CotizacionesEntregas] (
	[NumeroCotizacion] [int] NOT NULL ,
	[NumeroRenglon] [smallint] NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioUnitario] [money] NOT NULL ,
	[Unidad] [nvarchar] (12) NOT NULL ,
	[Factor] [float] NOT NULL ,
	[TipoDocumento] [nvarchar] (5) NOT NULL ,
	[NumeroDocumento] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[CuentaMedios] (
	[Sesion] [int] NOT NULL ,
	[qEfectivo] [int] NOT NULL ,
	[qCheques] [int] NOT NULL ,
	[qVisa] [int] NOT NULL ,
	[qMaster] [int] NOT NULL ,
	[qOtrasTC] [int] NOT NULL ,
	[qTDebito] [int] NOT NULL ,
	[qCreditos] [int] NOT NULL ,
	[qAmex] [int] NOT NULL ,
	[qOtrosMedios] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Cuentas] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Titulo] [nvarchar] (50) NOT NULL ,
	[Status] [tinyint] NOT NULL ,
	[Lado] [tinyint] NOT NULL ,
	[Saldo] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[CuentasPOS] (
	[IDCuenta] [int] NOT NULL ,
	[Vendedor] [nvarchar] (20) NULL ,
	[HoraApertura] [datetime] NOT NULL ,
	[HoraUltimaTransaccion] [datetime] NOT NULL ,
	[Estado] [smallint] NOT NULL ,
	[Personas] [int] NOT NULL ,
	[Cliente] [nvarchar] (20) NULL ,
	[CodigoCuenta] [nvarchar] (20) NULL ,
	[Ambiente] [nvarchar] (16) NULL ,
	[idMesa] [int] NOT NULL ,
	[Condiciones] [nvarchar] (12) NULL ,
	[Extra] [nvarchar] (12) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Despachos] (
	[Usuario] [nvarchar] (20) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Puntos] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DestinoComandasItem] (
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[PrinterName] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Detalles] (
	[NumeroComprobante] [int] NOT NULL ,
	[NumeroLinea] [smallint] NOT NULL ,
	[RefPeriodo] [int] NOT NULL ,
	[Cuenta] [nvarchar] (20) NOT NULL ,
	[RefDetalle] [nvarchar] (20) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Debe] [float] NOT NULL ,
	[Haber] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesCompra] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Presentacion] [nvarchar] (12) NOT NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[CantidadFacturada] [float] NOT NULL ,
	[CantidadPromocion] [float] NOT NULL ,
	[PrecioNominal] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [float] NOT NULL ,
	[Impuesto2] [float] NOT NULL ,
	[CostoUnitario] [money] NOT NULL ,
	[Recibidas] [float] NOT NULL ,
	[Almacen] [nvarchar] (8) NULL ,
	[Devueltas] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesCuentaEntidad] (
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[Correlativo] [int] NOT NULL ,
	[Documento] [int] NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[RefPeriodo] [int] NOT NULL ,
	[Descripcion] [nvarchar] (60) NULL ,
	[Debe] [money] NOT NULL ,
	[Haber] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesDevolucionCompra] (
	[NumeroDevolucion] [int] NOT NULL ,
	[NumeroRenglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[CantidadDevuelta] [float] NOT NULL ,
	[Presentacion] [nvarchar] (12) NOT NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[DescripcionItem] [nvarchar] (50) NOT NULL ,
	[Costo] [money] NOT NULL ,
	[Danhada] [smallint] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesDevolucionVenta] (
	[NumeroDevolucion] [int] NOT NULL ,
	[NumeroRenglon] [smallint] NOT NULL ,
	[CodigoItemVenta] [nvarchar] (20) NOT NULL ,
	[CantidadDevuelta] [float] NOT NULL ,
	[Presentacion] [nvarchar] (12) NOT NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[DescripcionItem] [nvarchar] (50) NOT NULL ,
	[Valor] [money] NOT NULL ,
	[Costo] [money] NOT NULL ,
	[Danhada] [smallint] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesFactura] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Presentacion] [nvarchar] (12) NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioLista] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [float] NOT NULL ,
	[Impuesto2] [float] NOT NULL ,
	[CostoUnitario] [money] NOT NULL ,
	[Entregadas] [float] NOT NULL ,
	[Asignadas] [float] NOT NULL ,
	[Transito] [float] NOT NULL ,
	[Devueltas] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesIngresoCaja] (
  id INT IDENTITY (1, 1) PRIMARY KEY NOT NULL,
	[TransID] [int] NOT NULL ,
	[Medio] [nvarchar] (8) NOT NULL ,
	[Emisor] [nvarchar] (20) NULL ,
	[NumeroDocumento] [nvarchar] (20) NULL ,
	[ClaveAutorizacion] [nvarchar] (6) NULL DEFAULT '',
	[Monto] [money] NOT NULL,
  NumeroCuenta nVarChar (20) NOT NULL DEFAULT '', 
  idTitular nVarChar(20) NOT NULL DEFAULT '',
  MontoNominal money NOT NULL DEFAULT 0
) ON [PRIMARY]

CREATE UNIQUE INDEX idxDetallesIngresoCajaTransID
ON DetallesIngresoCaja (TransID, Id);

CREATE INDEX idxDetallesIngresoCajaMedioEmisor
ON DetallesIngresoCaja (Medio, Emisor);

CREATE Table DetallesDenominacion (
  Id INT IDENTITY (1, 1) PRIMARY KEY NOT NULL,
  IdDetalle INT NOT NULL,
  Denominacion Money,
  CantidadRecibida SmallInt);

CREATE UNIQUE INDEX idxDetallesDenominacionID 
ON DetallesDenominacion (Id);

CREATE INDEX idxDetallesDenominacionDetalle
ON DetallesDenominacion (IdDetalle, Id);

CREATE TABLE [dbo].[DetallesItemVenta] (
	[NumeroDocumento] [int] NOT NULL ,
	[TipoDocumento] [nvarchar] (3) NOT NULL ,
	[Serie] [nvarchar] (3) NULL ,
	[FechaOperacion] [datetime] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[CodigoVendedor] [nvarchar] (20) NULL ,
	[PrecioReferencia] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[CostoStandard] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesMINV] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[FechaOperacion] [datetime] NOT NULL ,
	[TipoMovimiento] [nvarchar] (3) NOT NULL ,
	[CodigoItem] [nvarchar] (20) NULL ,
	[Entradas] [float] NOT NULL ,
	[Salidas] [float] NOT NULL ,
	[Costo] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DevolucionesCompra] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[CodigoProveedor] [nvarchar] (20) NOT NULL ,
	[Factura] [int] NOT NULL ,
	[ValorMercancia] [money] NOT NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[Notas] [nvarchar] (255) NULL,
  	[RefProveedor] [nvarchar] (20) NOT NULL Default ('')
) ON [PRIMARY]

CREATE TABLE [dbo].[DevolucionesVenta] (
	[Numero] [int] NOT NULL ,
	[Serie] [nvarchar] (3) NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[NumeroFactura] [int] NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[NombreCliente] [nvarchar] (50) NOT NULL ,
	[Valor] [money] NOT NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[Costo] [money] NOT NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[CodigoVendedor] [nvarchar] (20) NULL ,
	[ComisionAnulada] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DiferidosBanco] (
	[CodigoBanco] [nvarchar] (20) NOT NULL ,
	[FechaPresentacion] [datetime] NOT NULL ,
	[MontoDiferido] [money] NOT NULL ,
	[TipoMovimiento] [smallint] NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[RefBanco] [nvarchar] (12) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DocumentosISPC] (
	[Numero] [int] NOT NULL ,
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[NumDoc] [int] NOT NULL ,
	[TipoDoc] [nvarchar] (3) NOT NULL ,
	[FechaDoc] [datetime] NOT NULL ,
	[Monto] [money] NOT NULL ,
	[Saldo] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Empaques] (
	[Codigo] [nvarchar] (12) NOT NULL ,
	[Factor] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ExistenciaUbicacion] (
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[TipoUbicacion] [smallint] NOT NULL ,
	[Almacen] [nvarchar] (8) NOT NULL ,
	[Existencia] [float] NOT NULL ,
	[Asignadas] [float] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Facturas] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[Serie] [nvarchar] (3) NOT NULL ,
	[Correlativo] [int] NOT NULL ,
	[ExtRef] [nvarchar] (15) NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[NombreCliente] [nvarchar] (50) NOT NULL ,
	[CodigoVendedor] [nvarchar] (15) NOT NULL ,
	[EstadoDespacho] [smallint] NOT NULL ,
	[PrecioLista] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[IndiceReferencia] [smallint] NOT NULL ,
	[IndiceVenta] [smallint] NOT NULL ,
	[Descuento1] [float] NOT NULL ,
	[Descuento2] [float] NOT NULL ,
	[Costo] [int] NOT NULL ,
	[SituacionAdministrativa] [smallint] NOT NULL ,
	[Condicion] [nvarchar] (8) NOT NULL ,
	[DescuentosProntoPago] [float] NOT NULL ,
	[Comision] [float] NOT NULL ,
	[ComisionAcreditada] [smallint] NOT NULL ,
	[DireccionEntrega] [nvarchar] (160) NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[OrdenDespacho] [int] NOT NULL ,
	[ComprobanteInventario] [int] NOT NULL ,
	[PrecioDevuelto] [int] NOT NULL ,
	[CostoDevuelto] [int] NOT NULL ,
	[Saldo] [float] NOT NULL ,
	[Impuesto1Devuelto] [money] NOT NULL ,
	[Impuesto2Devuelto] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[FacturasPOS] (
	[idMaquina] [int] NOT NULL ,
	[NumeroTicket] [int] NOT NULL ,
	[idSesion] [int] NOT NULL ,
	[idUsuario] [nvarchar] (8) NOT NULL ,
	[Hora] [datetime] NOT NULL ,
	[MontoVenta] [money] NOT NULL ,
	[Impuesto] [money] NOT NULL ,
	[Servicio] [money] NOT NULL ,
	[Vendedor] [nvarchar] (20) NULL ,
	[Personas] [smallint] NOT NULL ,
	[Cuenta] [int] NOT NULL ,
	[Cliente] [nvarchar] (20) NULL ,
	[Propina] [money] NOT NULL ,
	[Numero] [int] IDENTITY (1, 1) NOT NULL ,
	[NombreHuesped] [nvarchar] (40) NULL ,
	[IT] [money] NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[HotKeys] (
	[Tecla] [nvarchar] (1) NOT NULL ,
	[Normal] [nvarchar] (20) NULL 
) ON [PRIMARY]

CREATE TABLE [IVARetenido] (
	[Id] [int] IDENTITY (1, 1) PRIMARY KEY,
	[CodigoProveedor] [nvarchar] (20) NULL ,
	[RifProveedor] [nvarchar] (14) NULL ,
	[NombreProveedor] [nvarchar] (50) NOT NULL ,
	[NumeroFactura] [nvarchar] (12) NULL ,
	[FechaCobro] [datetime] NOT NULL ,
	[MontoExento] [money] NOT NULL CONSTRAINT [DF_IVARetenido_MontoBruto] DEFAULT (0),
	[MontoGravable1] [money] NOT NULL CONSTRAINT [DF_IVARetenido_MontoIVA] DEFAULT (0),
	[MontoGravable2] [money] NOT NULL CONSTRAINT [DF_IVARetenido_MontoRetencion] DEFAULT (0),
	[TipoDoc] [nvarchar] (3) NULL ,
	[NumeroDoc] [int] NULL ,
	[NumeroControl] [int] NULL ,
	[Cancelado] [int] NULL ,
	[Relacionado] [bigint] NULL ,
	[Impuesto1] [float] NULL ,
	[Impuesto2] [float] NULL ,
	[IvaTotal] [money] NULL ,
	[IvaRetenido] [money] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Indeseables] (
	[ID] [int] NOT NULL ,
	[Nombre] [nvarchar] (24) NULL ,
	[Motivo] [nvarchar] (50) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Indicadores] (
	[Codigo] [nvarchar] (16) NOT NULL ,
	[Formula] [nvarchar] (50) NOT NULL ,
	[Modificado] [datetime] NOT NULL ,
	[Autor] [nvarchar] (8) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[IngresoCaja] (
	[Sesion] [int] NULL ,
	[Medio] [nvarchar] (20) NULL ,
	[Monto] [money] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ItemsVenta] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Linea] [nvarchar] (15) NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[CuentaIngreso] [nvarchar] (20) NULL ,
	[CuentaDevolucion] [nvarchar] (20) NULL ,
	[CuentaCosto] [nvarchar] (20) NULL ,
	[Precio1] [money] NOT NULL ,
	[Precio2] [money] NOT NULL ,
	[Precio3] [money] NOT NULL ,
	[Precio4] [money] NOT NULL ,
	[TipoImpuesto1] [nvarchar] (8) NOT NULL ,
	[TipoImpuesto2] [nvarchar] (8) NULL ,
	[CostoStandard] [money] NOT NULL ,
	[PComis1] [float] NOT NULL ,
	[PComis2] [float] NOT NULL ,
	[PComis3] [float] NOT NULL ,
	[Presentacion] [nvarchar] (12) NOT NULL ,
	[Unidad] [nvarchar] (12) NOT NULL ,
	[CantidadPresentacion] [float] NOT NULL ,
	[NumeroPLU] [int] NULL ,
	[PrecioIndexado] [smallint] NOT NULL ,
	[FechaCreacion] [datetime] NOT NULL ,
	[ImageFile] [nvarchar] (80) NULL ,
	[Ubicacion] [nvarchar] (12) NULL ,
	[Grupo] [nvarchar] (15) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[LibroCompras] (
	[Fecha] [datetime] NOT NULL ,
	[Factura] [nvarchar] (20) NOT NULL ,
	[Proveedor] [nvarchar] (20) NULL ,
	[NombreProveedor] [nvarchar] (50) NOT NULL ,
	[RIF] [nvarchar] (12) NOT NULL ,
	[MontoBruto] [money] NOT NULL ,
	[Exento] [money] NOT NULL ,
	[Gravable1] [money] NOT NULL ,
	[Porcentaje1] [float] NOT NULL ,
	[MontoRetencion1] [money] NOT NULL ,
	[Gravable2] [money] NOT NULL ,
	[Porcentaje2] [float] NOT NULL ,
	[MontoRetencion2] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[LibroVentas] (
	[Fecha] [datetime] NOT NULL ,
	[Factura] [nvarchar] (20) NOT NULL ,
	[Documento] [nvarchar] (24) NULL ,
	[Cliente] [nvarchar] (20) NOT NULL ,
	[RIF] [nvarchar] (12) NULL ,
	[MontoBruto] [money] NOT NULL ,
	[Exento] [money] NOT NULL ,
	[Gravable1] [money] NOT NULL ,
	[Porcentaje1] [float] NOT NULL ,
	[MontoRetencion1] [money] NOT NULL ,
	[Gravable2] [money] NOT NULL ,
	[Porcentaje2] [float] NOT NULL ,
	[MontoRetencion2] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Lineas] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Descripcion] [nvarchar] (30) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Lotes] (
	[CodigoItem] [nvarchar] (20) NULL ,
	[ID] [int] NOT NULL ,
	[Precio] [money] NULL ,
	[DL] [float] NULL ,
	[DA] [float] NULL ,
	[DX] [float] NULL ,
	[Existencia] [float] NULL ,
	[DescuentosCompra] [nvarchar] (15) NULL ,
	[DescuentosVenta] [nvarchar] (15) NULL ,
	[idLote] [nvarchar] (12) NULL ,
	[Asignadas] [int] NULL ,
	[FechaVenc] [smalldatetime] NULL ,
	[CostoNeto] [money] NULL ,
	[NumDocumento] [int] NULL ,
	[TipoDocumento] [nvarchar] (3) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[MovimientosBanco] (
	[Numero] [int] IDENTITY (1, 1) NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[CodigoBanco] [nvarchar] (20) NOT NULL ,
	[Tipo] [smallint] NOT NULL ,
	[Concepto] [nvarchar] (50) NULL ,
	[Beneficiario] [nvarchar] (50) NULL ,
	[Monto] [money] NOT NULL ,
	[ReferenciaBanco] [nvarchar] (12) NOT NULL ,
	[Conciliado] [smallint] NOT NULL ,
	[FechaEfectivo] [datetime] NOT NULL ,
	[TipoDocRel] [nvarchar] (3) NULL ,
	[NumeroDocRel] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[MovimientosCaja] (
	[TransID] [int] IDENTITY (1, 1) NOT NULL ,
	[Sesion] [int] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[Debitos] [money] NOT NULL ,
	[Creditos] [money] NOT NULL ,
	[TipoEntidad] [nvarchar] (3) NULL ,
	[CodigoEntidad] [nvarchar] (20) NULL ,
	[TipoDocumento] [nvarchar] (3) NULL ,
	[NumeroDocumento] [int] NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL,
  Hora smalldatetime NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[NNEE] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[NombreCliente] [nvarchar] (50) NOT NULL ,
	[CodigoVendedor] [nvarchar] (15) NOT NULL ,
	[Estado] [smallint] NOT NULL ,
	[PrecioLista] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[IndiceReferencia] [smallint] NOT NULL ,
	[IndiceVenta] [smallint] NOT NULL ,
	[Descuento1] [float] NOT NULL ,
	[Descuento2] [float] NOT NULL ,
	[Condicion] [nvarchar] (8) NOT NULL ,
	[DireccionEntrega] [nvarchar] (160) NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[ComprobanteAlmacen] [int] NOT NULL ,
	[NumeroFacturaOrigen] [int] NOT NULL ,
	[SaldoActual] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[NNEEDetalleSuplemento] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [int] NOT NULL ,
	[NumeroRenglonOrigen] [int] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[Presentacion] [nvarchar] (12) NOT NULL ,
	[FactorPresentacion] [float] NOT NULL ,
	[PrecioNeto] [money] NOT NULL ,
	[Impuesto1] [float] NOT NULL ,
	[Impuesto2] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[NNEEDetalles] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Presentacion] [nvarchar] (12) NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioLista] [money] NOT NULL ,
	[PrecioVenta] [money] NOT NULL ,
	[PrecioEfectivo] [money] NOT NULL ,
	[Impuesto1] [float] NOT NULL ,
	[Impuesto2] [float] NOT NULL ,
	[CostoUnitario] [money] NOT NULL ,
	[SaldoCantidad] [float] NOT NULL ,
	[Descuentos] [nvarchar] (10) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[NNEESuplemento] (
	[Numero] [int] IDENTITY (1, 1) NOT NULL ,
	[NumeroNota] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Impuesto1] [money] NOT NULL ,
	[Impuesto2] [money] NOT NULL ,
	[Valor] [money] NOT NULL ,
	[TipoDocRel] [nvarchar] (3) NULL ,
	[NumeroDocRel] [int] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[NotasDCCP] (
	[Numero] [int] NOT NULL ,
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[FechaDoc] [datetime] NOT NULL ,
	[Descripcion] [nvarchar] (40) NOT NULL ,
	[Monto] [money] NOT NULL ,
	[Saldo] [money] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Opciones] (
	[TipoOpcion] [nvarchar] (1) NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[Pedido] [nvarchar] (2) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ParametrosEmpresa] (
	[NombreEmpresa] [nvarchar] (50) NOT NULL ,
	[RIF] [nvarchar] (12) NULL ,
	[NIT] [nvarchar] (12) NULL ,
	[Direccion] [nvarchar] (160) NULL ,
	[Telefono] [nvarchar] (30) NULL ,
	[MascaraPrecios] [nvarchar] (20) NOT NULL ,
	[MascaraMonetarios] [nvarchar] (20) NOT NULL ,
	[MascaraInventario] [nvarchar] (20) NOT NULL ,
	[MascaraCantidades] [nvarchar] (50) NOT NULL ,
	[FormatoSaldos] [nvarchar] (20) NOT NULL ,
	[FactorRedondeoPrecios] [float] NOT NULL ,
	[DefaultImpuesto1] [nvarchar] (3) NOT NULL ,
	[DefaultImpuesto2] [nvarchar] (3) NULL ,
	[PrecioIncluyeImpuesto1] [smallint] NOT NULL ,
	[PrecioIncluyeImpuesto2] [smallint] NOT NULL ,
	[CodigoClienteMostrador] [nvarchar] (15) NOT NULL ,
	[MesInicioAnho] [smallint] NOT NULL ,
	[AnhoActual] [smallint] NOT NULL ,
	[PeriodoActual] [smallint] NOT NULL ,
	[FormatoCodigos] [nvarchar] (20) NOT NULL ,
	[CuentaGanPer] [nvarchar] (20) NULL ,
	[Separador] [nvarchar] (1) NOT NULL ,
	[AcreditarComision] [smallint] NOT NULL ,
	[PComisVenta1] [float] NOT NULL ,
	[PComisVenta2] [float] NOT NULL ,
	[PComisVenta3] [float] NOT NULL ,
	[PComisCobranza1] [float] NOT NULL ,
	[PComisCobranza2] [float] NOT NULL ,
	[PComisCobranza3] [float] NOT NULL ,
	[indexarPrecios] [smallint] NOT NULL ,
	[valoracionInventario] [smallint] NOT NULL ,
	[TituloPrecio1] [nvarchar] (20) NOT NULL ,
	[TituloPrecio2] [nvarchar] (20) NOT NULL ,
	[TituloPrecio3] [nvarchar] (20) NOT NULL ,
	[TituloPrecio4] [nvarchar] (20) NOT NULL ,
	[NombreImpuesto1] [nvarchar] (12) NOT NULL ,
	[NombreImpuesto2] [nvarchar] (12) NULL ,
	[CuentaGeneralVentas] [nvarchar] (20) NULL ,
	[CuentaGeneralInventario] [nvarchar] (20) NULL ,
	[CuentaGeneralDeudas] [nvarchar] (20) NULL ,
	[CuentaGeneralAcreencias] [nvarchar] (20) NULL ,
	[CuentaGeneralBancos] [nvarchar] (20) NULL ,
	[CuentaGeneralCosto] [nvarchar] (20) NULL ,
	[CuentaGeneralDevoluciones] [nvarchar] (20) NULL ,
	[CuentaPasivoComisiones] [nvarchar] (20) NULL ,
	[CuentaGastosComisiones] [nvarchar] (20) NULL ,
	[CuentaImpuesto1] [nvarchar] (20) NULL ,
	[CuentaImpuesto2] [nvarchar] (20) NULL ,
	[CuentaCaja] [nvarchar] (20) NULL ,
	[ProximaMaquina] [int] NOT NULL ,
	[InicioVigenciaIDB] [datetime] NOT NULL ,
	[FinVigenciaIDB] [datetime] NOT NULL ,
	[PorcentajeIDB] [float] NOT NULL ,
	[CuentaGastosIDB] [nvarchar] (20) NULL ,
	[CuentaISLRAnticipado] [nvarchar] (20) NULL ,
	[CuentaEgresosComisionTC] [nvarchar] (50) NULL ,
	[TipoInventarioEnCurso] [smallint] NOT NULL ,
	[AlmacenInventarioFisico] [nvarchar] (8) NULL ,
	[CuentaDescuentosCobranza] [nvarchar] (20) NULL ,
	[CuentaDescuentosPagos] [nvarchar] (20) NULL ,
	[CuentaMercanciaDanhada] [nvarchar] (20) NULL ,
	[CuentaISLRRetenido] [nvarchar] (20) NULL ,
	[Ciudad] [nvarchar] (20) NULL ,
	[CuentaServicio] [nvarchar] (20) NULL ,
	[ClaveActivacion] [int] NOT NULL ,
	[TipoCambio] [money] NOT NULL ,
	[CuentaMercanciaTransito] [nvarchar] (20) NULL,
	[Contribuyente] [INTEGER] NOT NULL,
	[PorcentajeRetencionIVACE] [float] NOT NULL,
	[ValorActualUT] [DECIMAL] NOT NULL
) ON [PRIMARY]

CREATE TABLE Beneficiarios (
	Nombre NVarChar(50) PRIMARY KEY
);

CREATE TABLE [dbo].[Prefijos] (
	[Prefijo] [nvarchar] (1) NOT NULL ,
	[Uso] [tinyint] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[ProveedorProducto] (
	[CodigoProveedor] [nvarchar] (20) NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[RefProductoProveedor] [nvarchar] (20) NULL ,
	[PrecioReferencia] [money] NOT NULL ,
	[FechaOferta] [datetime] NOT NULL ,
	[PrecioUltimaCompra] [money] NOT NULL ,
	[FechaUltimaCompra] [datetime] NOT NULL ,
	[Notas] [nvarchar] (255) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Proveedores] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Nombre] [nvarchar] (50) NOT NULL ,
	[RIF] [nvarchar] (12) NULL ,
	[CGCuenta] [nvarchar] (20) NULL ,
	[Condiciones] [nvarchar] (50) NOT NULL ,
	[Direccion1] [nvarchar] (40) NULL ,
	[Direccion2] [nvarchar] (40) NULL ,
	[Direccion3] [nvarchar] (40) NULL ,
	[Direccion4] [nvarchar] (40) NULL ,
	[Telefono] [nvarchar] (30) NULL ,
	[SaldoActual] [money] NOT NULL ,
	[LimiteCredito] [money] NOT NULL ,
	[FechaUltimaCompra] [datetime] NOT NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[FechaCreacion] [datetime] NOT NULL ,
) ON [PRIMARY]

CREATE TABLE [dbo].[RenglonesConsumoSesion] (
	[OwnerID] [int] NOT NULL ,
	[Renglon] [int] NOT NULL ,
	[Descripcion] [nvarchar] (255) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RenglonesCuentaPOS] (
	[IDCuenta] [int] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[PrecioUnitario] [money] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[NumeroRenglon] [int] NOT NULL ,
	[Usuario] [nvarchar] (20) NULL ,
	[Precio] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RenglonesFacturaPOS] (
	[idMaquina] [int] NOT NULL ,
	[numeroTicket] [int] NOT NULL ,
	[numeroLinea] [smallint] NOT NULL ,
	[Producto] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioUnitario] [money] NOT NULL ,
	[PorcentajeImpuesto] [float] NOT NULL ,
	[Usuario] [nvarchar] (20) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RenglonesSesion] (
	[SessionID] [int] NOT NULL ,
	[NumeroRenglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[PrecioUnitario] [money] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PorcentajeImpuesto] [float] NOT NULL ,
	[TipoImpuesto] [nvarchar] (3) NOT NULL ,
	[PrecioLista] [money] NOT NULL ,
	[Usuario] [nvarchar] (20) NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RenglonesTransferencia] (
	[NumeroTransferencia] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[CodigoProducto] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[CostoUnitario] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RetencionesISLR] (
	[CodigoProveedor] [nvarchar] (20) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[RefDocumento] [nvarchar] (20) NOT NULL ,
	[MontoPagado] [money] NOT NULL ,
	[MontoRetenido] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RetencionesIVA] (
	[Id] [int] IDENTITY (1, 1) NOT NULL ,
	[CodigoCliente] [nvarchar] (20) NOT NULL ,
	[NumFactura] [int] NOT NULL ,
	[FechaCobro] [datetime] NOT NULL ,
	[MontoRetencion] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[RetirosPOS] (
	[idSesion] [int] NOT NULL ,
	[Hora] [datetime] NOT NULL ,
	[Tipo] [smallint] NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[Monto] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[SaldosEntidadPeriodo] (
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[NumeroPeriodo] [int] NOT NULL ,
	[SaldoInicial] [money] NOT NULL ,
	[Debitos] [money] NOT NULL ,
	[Creditos] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[SaldosPeriodo] (
	[CodigoCuenta] [nvarchar] (20) NOT NULL ,
	[NumeroPeriodo] [int] NOT NULL ,
	[SaldoInicial] [float] NOT NULL ,
	[Debitos] [float] NOT NULL ,
	[Creditos] [float] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Seriales] (
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Serial] [nvarchar] (20) NOT NULL ,
	[EnStock] [smallint] NOT NULL ,
	[Locked] [smallint] NOT NULL 
) ON [PRIMARY]

CREATE  INDEX [ndxSerial] ON [dbo].[Seriales]([Serial]) ON [PRIMARY]

CREATE TABLE [dbo].[SerialesDetalles] (
	[NumeroDetalle] [int] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Serial] [nvarchar] (20) NOT NULL ,
	[TipoDocumento] [nvarchar] (5) NOT NULL ,
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[Tipo] [int] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[isTemporal] [int] NOT NULL ,
	[prevStatus] [smallint] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[Series] (
	[CodigoSerie] [nvarchar] (3) NOT NULL ,
	[Descripcion] [nvarchar] (24) NOT NULL ,
	[CuentaIngreso] [nvarchar] (50) NULL ,
	[ProximaFactura] [int] NOT NULL ,
	[CuentaImpuesto1] [nvarchar] (20) NULL ,
	[CuentaImpuesto2] [nvarchar] (50) NULL ,
	[CuentaCosto] [nvarchar] (50) NULL ,
	[Nivel] [smallint] NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[SesionesCerradas] (
	[SessionID] [int] NOT NULL ,
	[MachineID] [int] NOT NULL ,
	[Cerrada] [smallint] NOT NULL ,
	[usrID] [nvarchar] (8) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[StartTime] [datetime] NOT NULL ,
	[ComprobanteAlmacen] [int] NOT NULL ,
	[CurrentAccount] [int] NOT NULL ,
	[CurrentAmount] [money] NOT NULL ,
	[FacturasRealizadas] [int] NOT NULL ,
	[MontoFacturado] [money] NOT NULL ,
	[ImpuestoCobrado] [money] NOT NULL ,
	[EfectivoEnCaja] [money] NOT NULL ,
	[TTCVisa] [money] NOT NULL ,
	[TTCMaster] [money] NOT NULL ,
	[TTCOtras] [money] NOT NULL ,
	[TDebito] [money] NOT NULL ,
	[ChequesEnCaja] [money] NOT NULL ,
	[Anulaciones] [smallint] NOT NULL ,
	[MontoAnulaciones] [money] NOT NULL ,
	[ImpuestoAnulado] [money] NOT NULL ,
	[Retiros] [int] NOT NULL ,
	[MontoRetirado] [money] NOT NULL ,
	[CobrosRealizados] [smallint] NOT NULL ,
	[MontoCobrado] [money] NOT NULL ,
	[ServicioCobrado] [money] NOT NULL ,
	[ServicioAnulado] [money] NOT NULL ,
	[VentasACredito] [money] NOT NULL ,
	[MontoEnCaja] [money] NOT NULL ,
	[TTCAmex] [money] NOT NULL ,
	[OtrosMedios] [money] NOT NULL ,
	[Propinas] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[SesionesPOS] (
	[SessionID] [int] IDENTITY (1, 1) NOT NULL ,
	[MachineID] [int] NOT NULL ,
	[Cerrada] [smallint] NOT NULL ,
	[usrID] [nvarchar] (8) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[StartTime] [datetime] NOT NULL ,
	[ComprobanteAlmacen] [int] NOT NULL ,
	[CurrentAccount] [int] NOT NULL ,
	[CurrentAmount] [money] NOT NULL ,
	[FacturasRealizadas] [int] NOT NULL ,
	[MontoFacturado] [money] NOT NULL ,
	[ImpuestoCobrado] [money] NOT NULL ,
	[EfectivoEnCaja] [money] NOT NULL ,
	[TTCVisa] [money] NOT NULL ,
	[TTCMaster] [money] NOT NULL ,
	[TTCOtras] [money] NOT NULL ,
	[TDebito] [money] NOT NULL ,
	[ChequesEnCaja] [money] NOT NULL ,
	[Anulaciones] [smallint] NOT NULL ,
	[MontoAnulaciones] [money] NOT NULL ,
	[ImpuestoAnulado] [money] NOT NULL ,
	[Retiros] [int] NOT NULL ,
	[MontoRetirado] [money] NOT NULL ,
	[CobrosRealizados] [smallint] NOT NULL ,
	[MontoCobrado] [money] NOT NULL ,
	[ServicioCobrado] [money] NOT NULL ,
	[ServicioAnulado] [money] NOT NULL ,
	[VentasACredito] [money] NOT NULL ,
	[MontoEnCaja] [money] NOT NULL ,
	[TTCAmex] [money] NOT NULL ,
	[OtrosMedios] [money] NOT NULL ,
	[Propinas] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[SubLineas] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Descripcion] [nvarchar] (30) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[TEMPTABLE] (
	[Factura] [nvarchar] (255) NULL ,
	[Hora] [smalldatetime] NULL ,
	[MontoVenta] [money] NULL ,
	[Impuesto] [money] NULL ,
	[Vendedor] [nvarchar] (20) NULL ,
	[Nombre] [nvarchar] (50) NULL ,
	[Comision] [float] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[TarjetasCredito] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Nombre] [nvarchar] (16) NOT NULL ,
	[Banco] [nvarchar] (20) NOT NULL ,
	[PorcentajeComision] [float] NOT NULL ,
	[PorcentajeISLR] [float] NOT NULL ,
	[CuentaComision] [nvarchar] (20) NULL ,
	[CuentaISLR] [nvarchar] (50) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Tickets] (
	[Terminal] [int] NULL ,
	[Factura] [int] NULL ,
	[Ticket] [nvarchar] (20) NULL ,
	[Entrada] [smalldatetime] NULL ,
	[Salida] [smalldatetime] NULL ,
	[Horas] [float] NULL ,
	[Total] [money] NULL ,
	[COdigo] [nvarchar] (20) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[TiposCliente] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[TiposCuentaPOS] (
	[Prefijo] [nvarchar] (3) NOT NULL ,
	[Base] [int] NOT NULL ,
	[Porcentaje] [float] NOT NULL ,
	[IndicePrecio] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[TiposImpuesto] (
	[Codigo] [nvarchar] (3) NOT NULL ,
	[Descripcion] [nvarchar] (30) NOT NULL ,
	[Porcentaje] [float] NOT NULL ,
	[VigenteDesde] [datetime] NOT NULL ,
	[VigenteHasta] [datetime] NOT NULL ,
	[Cuenta] [nvarchar] (20) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Transferencias] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransferencia] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[AlmacenOrigen] [nvarchar] (8) NOT NULL ,
	[AlmacenDestino] [nvarchar] (8) NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Notas] [nvarchar] (255) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Unidades] (
	[Codigo] [nvarchar] (12) NOT NULL ,
	[Unidad] [nvarchar] (20) NOT NULL ,
	[Equivalencia] [nvarchar] (20) NOT NULL ,
	[Factor] [float] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[UnidadesFuncionales] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Descripcion] [nvarchar] (30) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Usuarios] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Clave] [int] NOT NULL ,
	[Nivel] [tinyint] NOT NULL ,
	[Nombre] [nvarchar] (40) NOT NULL ,
	[Perfil] [nvarchar] (12) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[VencimientosISPC] (
	[NumeroDocumento] [int] NOT NULL ,
	[FechaVencimiento] [datetime] NOT NULL ,
	[Monto] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Vendedores] (
	[Codigo] [nvarchar] (15) NOT NULL ,
	[Nombre] [nvarchar] (50) NOT NULL ,
	[CI] [nvarchar] (12) NULL ,
	[Direccion] [nvarchar] (160) NULL ,
	[Telefono] [nvarchar] (30) NULL ,
	[NoCobraComision] [smallint] NOT NULL ,
	[TipoComisionVenta] [smallint] NOT NULL ,
	[TipoComisionCobranza] [smallint] NOT NULL ,
	[SaldoActual] [money] NOT NULL ,
	[FechaCreacion] [datetime] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[XtestInstring] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [smalldatetime] NULL ,
	[FechaTransaccion] [smalldatetime] NULL ,
	[Operador] [nvarchar] (8) NULL ,
	[CodigoBanco] [nvarchar] (20) NULL ,
	[Tipo] [smallint] NULL ,
	[Concepto] [nvarchar] (50) NULL ,
	[Beneficiario] [nvarchar] (50) NULL ,
	[Monto] [money] NULL ,
	[ReferenciaBanco] [nvarchar] (12) NULL ,
	[Conciliado] [bit] NOT NULL ,
	[FechaEfectivo] [smalldatetime] NULL ,
	[TipoDocRel] [nvarchar] (3) NULL ,
	[NumeroDocRel] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[Zonas] (
	[Codigo] [nvarchar] (8) NOT NULL ,
	[Descripcion] [nvarchar] (30) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[consigDetalles] (
	[NumeroDocumento] [int] NULL ,
	[NumeroRenglon] [smallint] NULL ,
	[CodigoItem] [nvarchar] (20) NULL ,
	[Cantidad] [float] NULL ,
	[PrecioUnitario] [money] NULL ,
	[Reportadas] [float] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[consigRecepcion] (
	[Numero] [int] NULL ,
	[CodigoProveedor] [nvarchar] (20) NULL ,
	[Documento] [nvarchar] (12) NULL ,
	[FechaRegistro] [smalldatetime] NULL ,
	[FechaOperacion] [smalldatetime] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[estContratoPF] (
	[Numero] [int] NOT NULL ,
	[Cliente] [nvarchar] (20) NULL ,
	[FechaInicio] [smalldatetime] NULL ,
	[PagadoHasta] [smalldatetime] NULL ,
	[Placa] [nvarchar] (7) NULL ,
	[Marca] [nvarchar] (12) NULL ,
	[Modelo] [nvarchar] (12) NULL ,
	[Color] [nvarchar] (12) NULL ,
	[Tipo] [tinyint] NULL ,
	[TarifaMensual] [money] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[estControlES] (
	[Numero] [int] NOT NULL ,
	[Placas] [nvarchar] (7) NULL ,
	[Ticket] [int] NULL ,
	[Ingreso] [smalldatetime] NULL ,
	[Salida] [smalldatetime] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[estReportes] (
	[id] [int] NOT NULL ,
	[Ticket] [int] NULL ,
	[FechaReporte] [smalldatetime] NULL ,
	[TimeStampReporte] [smalldatetime] NULL ,
	[Supervisor] [nvarchar] (20) NULL ,
	[Notas] [nvarchar] (255) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[estTickets] (
	[Numero] [int] NOT NULL ,
	[Placa] [nvarchar] (7) NULL ,
	[Marca] [nvarchar] (12) NULL ,
	[Modelo] [nvarchar] (12) NULL ,
	[Color] [nvarchar] (12) NULL ,
	[Tipo] [smallint] NULL ,
	[Ingreso] [smalldatetime] NULL ,
	[Salida] [smalldatetime] NULL ,
	[FechaUltimoReporte] [smalldatetime] NULL ,
	[isFijo] [tinyint] NULL ,
	[Bolivares] [money] NULL ,
	[IVA] [money] NULL ,
	[Penalizacion] [money] NULL ,
	[DiasMecanica] [smallint] NULL ,
	[descuento] [tinyint] NULL ,
	[numFac] [int] NULL ,
	[SesionEntrada] [int] NULL ,
	[SesionSalida] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[estTipos] (
	[Numero] [smallint] NULL ,
	[Tipo] [nvarchar] (12) NULL ,
	[ValorHora] [money] NULL ,
	[ValorNoche] [money] NULL ,
	[ValorMesFijo] [money] NULL ,
	[CodigoItem] [nvarchar] (20) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[generalEmisores] (
	[TipoDocumento] [nvarchar] (3) NOT NULL ,
	[CodigoEmisor] [nvarchar] (8) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelDepositos] (
	[Numero] [int] NOT NULL ,
	[Cuenta] [int] NULL ,
	[Fecha] [smalldatetime] NULL ,
	[Monto] [money] NULL ,
	[Medio] [nvarchar] (3) NULL ,
	[Emisor] [nvarchar] (8) NULL ,
	[CuentaBanco] [nvarchar] (15) NULL ,
	[Documento] [nvarchar] (10) NULL ,
	[Clave] [nvarchar] (12) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelDetallesCuentaHabitacion] (
	[idCuenta] [int] NULL ,
	[Correlativo] [int] NOT NULL ,
	[idCentro] [nvarchar] (8) NULL ,
	[Fecha] [smalldatetime] NULL ,
	[NumFactura] [int] NULL ,
	[NumTerminal] [int] NULL ,
	[Consumo] [money] NULL ,
	[IVA] [money] NULL ,
	[IT] [money] NULL ,
	[Servicio] [money] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelHabitaciones] (
	[idHabitacion] [nvarchar] (6) NULL ,
	[Ubicacion] [nvarchar] (8) NULL ,
	[qPax] [int] NULL ,
	[xtraPax] [int] NULL ,
	[Disponibilidad] [smallint] NULL ,
	[CheckIn] [smalldatetime] NULL ,
	[Credito] [tinyint] NULL ,
	[Saldo] [money] NULL ,
	[Estado] [smallint] NULL ,
	[TipoHabitacion] [nvarchar] (12) NULL ,
	[ExpectedDisponible] [smalldatetime] NULL ,
	[Comentarios] [nvarchar] (30) NULL ,
	[Cuenta] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelHuespedes] (
	[idPax] [int] NOT NULL ,
	[idHabitacion] [nvarchar] (50) NULL ,
	[Nombre] [nvarchar] (40) NULL ,
	[IdPersonal] [nvarchar] (14) NULL ,
	[Relacion] [nvarchar] (20) NULL ,
	[Firma] [nvarchar] (80) NULL ,
	[Foto] [nvarchar] (80) NULL ,
	[Autorizado] [bit] NOT NULL ,
	[TipoPax] [nvarchar] (12) NULL ,
	[FechaLlegada] [smalldatetime] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelOcupacionHabitacion] (
	[idHabitacion] [nvarchar] (6) NULL ,
	[IdCuenta] [int] NOT NULL ,
	[TipoTarifa] [nvarchar] (12) NULL ,
	[clienteOcupante] [nvarchar] (14) NULL ,
	[clienteResponsable] [nvarchar] (20) NULL ,
	[FechaCheckIn] [smalldatetime] NULL ,
	[FechaSalida] [smalldatetime] NULL ,
	[FechaActualizacion] [smalldatetime] NULL ,
	[Debitos] [money] NULL ,
	[Creditos] [money] NULL ,
	[LimiteCredito] [money] NULL ,
	[qPax] [smallint] NULL ,
	[TieneCredito] [tinyint] NULL ,
	[TimeStamp] [smalldatetime] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelTarifas] (
	[TipoTarifa] [nvarchar] (12) NULL ,
	[TipoHabitacion] [nvarchar] (12) NULL ,
	[PrecioNoche] [money] NULL ,
	[PrecioOcupanteExtra] [money] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[hotelTiposHabitacion] (
	[CodigoTipo] [nvarchar] (8) NULL ,
	[Descripcion] [nvarchar] (40) NULL ,
	[Matrimoniales] [smallint] NULL ,
	[Individuales] [smallint] NULL ,
	[Adicionales] [smallint] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[items93] (
	[codigo] [nvarchar] (20) NULL ,
	[linea] [nvarchar] (5) NULL ,
	[descripcion] [nvarchar] (40) NULL ,
	[maxpvp] [float] NULL ,
	[curpvp] [float] NULL ,
	[minpvp1] [float] NULL ,
	[minpvp2] [float] NULL ,
	[tipoImpuesto1] [nvarchar] (3) NULL ,
	[costopromedio] [float] NULL ,
	[UltimoCosto] [float] NULL ,
	[Comision] [float] NULL ,
	[Empaque] [nvarchar] (7) NULL ,
	[CantidadEmpaque] [float] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[itemsComanda] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[Precio1] [money] NOT NULL ,
	[UsaExtras] [tinyint] NOT NULL ,
	[UsaRemovibles] [tinyint] NOT NULL ,
	[UsaContornos] [tinyint] NOT NULL ,
	[ExtrasGratis] [smallint] NOT NULL ,
	[TipoImpuesto1] [nvarchar] (3) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[itemsInventario] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[Linea] [nvarchar] (8) NULL ,
	[CostoPromedio] [money] NOT NULL ,
	[UltimoCosto] [money] NOT NULL ,
	[ClaseImpuesto1] [nvarchar] (8) NULL ,
	[ClaseImpuesto2] [nvarchar] (50) NULL ,
	[Existencia] [float] NOT NULL ,
	[Asignadas] [float] NOT NULL ,
	[EnTransito] [float] NOT NULL ,
	[FechaUltimaCompra] [datetime] NOT NULL ,
	[UltimoProveedor] [nvarchar] (15) NULL ,
	[PrecioUltimaCompra] [money] NOT NULL ,
	[CuentaActivo] [nvarchar] (20) NULL ,
	[CostoDeVentas] [nvarchar] (50) NULL ,
	[NombreUnidad] [nvarchar] (12) NOT NULL ,
	[NombreEmpaque] [nvarchar] (12) NULL ,
	[CantidadEmpaque] [float] NOT NULL ,
	[ExistenciaMinima] [float] NOT NULL ,
	[ExistenciaMaxima] [float] NOT NULL ,
	[UsaSeriales] [smallint] NOT NULL ,
	[FechaCreacion] [datetime] NOT NULL ,
	[Grupo] [nvarchar] (50) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[mesasAmbientes] (
	[Codigo] [nvarchar] (16) NOT NULL ,
	[Prefijo] [nvarchar] (3) NULL ,
	[Descripcion] [nvarchar] (32) NOT NULL ,
	[AccountOffset] [int] NOT NULL ,
	[PorcentajeServicio] [float] NOT NULL ,
	[IndicePrecio] [smallint] NOT NULL ,
	[Escala] [float] NOT NULL ,
	[BackColor] [int] NOT NULL ,
	[ColorSillas] [int] NOT NULL ,
	[ColorMesas] [int] NOT NULL ,
	[FormaMesas] [smallint] NOT NULL ,
	[FormaSillas] [smallint] NOT NULL ,
	[SillasVisibles] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[mesasItems] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Precio] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[mesasMesas] (
	[Ambiente] [nvarchar] (16) NOT NULL ,
	[IDMesa] [int] NOT NULL ,
	[x] [int] NOT NULL ,
	[y] [int] NOT NULL ,
	[enmStat] [smallint] NOT NULL ,
	[nPersonas] [smallint] NOT NULL ,
	[cMesonero] [nvarchar] (20) NULL ,
	[MontoDespachado] [money] NOT NULL ,
	[Apertura] [datetime] NOT NULL ,
	[Cuenta] [int] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[mnuDeclares] (
	[ownerMenu] [nvarchar] (10) NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[mnuItems] (
	[ownerMenu] [nvarchar] (10) NOT NULL ,
	[Posicion] [smallint] NOT NULL ,
	[isTerminal] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Imagen] [nvarchar] (64) NULL ,
	[Descripcion] [nvarchar] (40) NOT NULL ,
	[Color] [int] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomAsigDedScript] (
	[CodigoScript] [nvarchar] (20) NOT NULL ,
	[codigoAsigDed] [nvarchar] (24) NOT NULL ,
	[Orden] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomAtribTrabajador] (
	[CodTrab] [nvarchar] (20) NOT NULL ,
	[CodAttrib] [nvarchar] (24) NOT NULL ,
	[ValAttrib] [float] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomCategoriasLaborales] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomCodigosRecibo] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomCodigosReporte] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomDefAsigDed] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[Tipo] [int] NOT NULL ,
	[ClaseLaboral] [nvarchar] (16) NOT NULL ,
	[CodigoReporte] [nvarchar] (20) NOT NULL ,
	[CodigoCuenta] [nvarchar] (20) NULL ,
	[CodigoContrapartida] [nvarchar] (20) NULL ,
	[Formula] [text] NOT NULL ,
	[CodigoRecibo] [nvarchar] (20) NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


CREATE TABLE [dbo].[nomDepartamentos] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (40) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomDescCargos] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (40) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomDescHabilidad] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (40) NOT NULL ,
	[MinRango] [smallint] NOT NULL ,
	[MaxRango] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomDetallesProceso] (
	[ProcessID] [int] NOT NULL ,
	[Trabajador] [nvarchar] (20) NOT NULL ,
	[Departamento] [nvarchar] (24) NOT NULL ,
	[Cargo] [nvarchar] (24) NOT NULL ,
	[Tipo] [smallint] NOT NULL ,
	[FechaCierre] [datetime] NOT NULL ,
	[ClaseLaboral] [nvarchar] (24) NOT NULL ,
	[CodigoReporte] [nvarchar] (24) NOT NULL ,
	[CodigoCuenta] [nvarchar] (20) NULL ,
	[CodigoContrapartida] [nvarchar] (20) NULL ,
	[CodigoRecibo] [nvarchar] (24) NULL ,
	[CodigoAsigDed] [nvarchar] (24) NOT NULL ,
	[Valor] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomDetallesRecibo] (
	[numeroProceso] [int] NOT NULL ,
	[codigoTrabajador] [nvarchar] (20) NOT NULL ,
	[varID] [nvarchar] (40) NOT NULL ,
	[varType] [int] NOT NULL ,
	[Value] [text] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


CREATE TABLE [dbo].[nomEnumHabilidades] (
	[CodigoHabilidad] [nvarchar] (24) NOT NULL ,
	[Enumerador] [nvarchar] (12) NOT NULL ,
	[Valor] [int] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomExcepciones] (
	[NumeroId] [int] NOT NULL ,
	[CodTrabajador] [nvarchar] (20) NOT NULL ,
	[CodExcepcion] [nvarchar] (24) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Valor] [float] NOT NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[TipoRecurrencia] [smallint] NOT NULL ,
	[Recurrencia] [float] NOT NULL ,
	[Operador] [nvarchar] (20) NULL ,
	[FechaRegistro] [datetime] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomFiltros] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[codigoAtributo] [nvarchar] (24) NOT NULL ,
	[valorDesde] [nvarchar] (40) NOT NULL ,
	[valorHasta] [nvarchar] (40) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomFiltrosScript] (
	[CodigoScript] [nvarchar] (20) NOT NULL ,
	[codigoFiltro] [nvarchar] (24) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomHabilidadesTrabajador] (
	[CodigoTrabajador] [nvarchar] (20) NOT NULL ,
	[CodigoHabilidad] [nvarchar] (24) NOT NULL ,
	[Grado] [smallint] NOT NULL ,
	[Notas] [nvarchar] (160) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomHistTrab] (
	[CodigoTrabajador] [nvarchar] (20) NOT NULL ,
	[Desde] [datetime] NOT NULL ,
	[Departamento] [nvarchar] (24) NOT NULL ,
	[Cargo] [nvarchar] (24) NOT NULL ,
	[Sueldo] [money] NOT NULL ,
	[Base] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomObservaciones] (
	[Numero] [int] NOT NULL ,
	[CodigoTrabajador] [nvarchar] (20) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Operador] [nvarchar] (20) NOT NULL ,
	[TipoObservacion] [nvarchar] (24) NOT NULL ,
	[Observacion] [text] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


CREATE TABLE [dbo].[nomPagosProceso] (
	[ProcessID] [int] NOT NULL ,
	[Trabajador] [nvarchar] (20) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Departamento] [nvarchar] (24) NOT NULL ,
	[Cargo] [nvarchar] (24) NOT NULL ,
	[MontoPagado] [money] NOT NULL ,
	[Medio] [nvarchar] (20) NOT NULL ,
	[CodigoBanco] [nvarchar] (20) NULL ,
	[NumeroDocumento] [nvarchar] (12) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomProcesos] (
	[Numero] [int] NOT NULL ,
	[Operador] [nvarchar] (8) NULL ,
	[CodigoScript] [nvarchar] (12) NOT NULL ,
	[FechaInicioPeriodo] [datetime] NOT NULL ,
	[FechaFinPeriodo] [datetime] NOT NULL ,
	[FechaCierre] [datetime] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomRecibosScript] (
	[CodigoScript] [nvarchar] (12) NOT NULL ,
	[FileName] [nvarchar] (64) NOT NULL ,
	[PrinterName] [nvarchar] (64) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomScripts] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[descripcionScript] [nvarchar] (60) NOT NULL ,
	[codePostTrabajador] [text] NOT NULL ,
	[codeVerificarRestricciones] [text] NOT NULL ,
	[codeBaseScript] [text] NULL ,
	[codeTrabajadorElegible] [text] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


CREATE TABLE [dbo].[nomTMPListaExcepciones] (
	[NumeroId] [int] NOT NULL ,
	[CodTrabajador] [nvarchar] (20) NOT NULL ,
	[CodExcepcion] [nvarchar] (24) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Valor] [float] NOT NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[TipoRecurrencia] [smallint] NOT NULL ,
	[Recurrencia] [float] NOT NULL ,
	[Operador] [nvarchar] (20) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomTMPResumenProceso] (
	[sUserID] [nvarchar] (8) NOT NULL ,
	[sCodTrab] [nvarchar] (20) NOT NULL ,
	[sCodDept] [nvarchar] (24) NOT NULL ,
	[sCodGrup] [nvarchar] (24) NOT NULL ,
	[nTipo] [smallint] NOT NULL ,
	[vmValor] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomTiposAtributo] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomTiposExcepcion] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL ,
	[Visible] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomTiposObservacion] (
	[Codigo] [nvarchar] (24) NOT NULL ,
	[Descripcion] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[nomTrabajadores] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Nombre] [nvarchar] (40) NOT NULL ,
	[CI] [nvarchar] (12) NOT NULL ,
	[Departamento] [nvarchar] (16) NOT NULL ,
	[Cargo] [nvarchar] (16) NOT NULL ,
	[FechaIngreso] [datetime] NOT NULL ,
	[FechaAsignacion] [datetime] NOT NULL ,
	[Sueldo] [money] NOT NULL ,
	[BaseSueldo] [smallint] NOT NULL ,
	[Direccion] [nvarchar] (160) NULL ,
	[Telefono] [nvarchar] (30) NULL ,
	[Sexo] [smallint] NOT NULL ,
	[EstadoCivil] [smallint] NOT NULL ,
	[FechaNacimiento] [datetime] NOT NULL ,
	[LugarNacimiento] [nvarchar] (20) NULL ,
	[NombreConyuge] [nvarchar] (40) NULL ,
	[NumeroDeHijos] [smallint] NOT NULL ,
	[Activo] [smallint] NOT NULL ,
	[ImageFile] [nvarchar] (80) NULL ,
	[EstadoAcceso] [tinyint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[ocDetalles] (
	[NumeroDocumento] [int] NOT NULL ,
	[Renglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Presentacion] [nvarchar] (12) NULL ,
	[FactorEmpaque] [float] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioRequerido] [money] NOT NULL ,
	[Recibidas] [float] NOT NULL ,
	[PrecioMedio] [money] NOT NULL ,
	[CantPaga] [float] NOT NULL ,
	[CantPromo] [float] NOT NULL ,
	[PVP] [money] NOT NULL ,
	[Descuentos] [nvarchar] (15) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[ocOrdenes] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [datetime] NOT NULL ,
	[FechaTransaccion] [datetime] NOT NULL ,
	[Operador] [nvarchar] (8) NOT NULL ,
	[CodigoProveedor] [nvarchar] (20) NOT NULL ,
	[NombreProveedor] [nvarchar] (50) NULL ,
	[FechaRequerido] [datetime] NOT NULL ,
	[Estado] [smallint] NOT NULL ,
	[ValorNominal] [money] NOT NULL ,
	[Descuento1] [float] NOT NULL ,
	[Descuento2] [float] NOT NULL ,
	[Notas] [nvarchar] (255) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[ocRecibidas] (
	[NumeroOrden] [int] NOT NULL ,
	[NumeroRenglon] [smallint] NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PrecioUnitario] [money] NOT NULL ,
	[Unidad] [nvarchar] (12) NOT NULL ,
	[Factor] [float] NOT NULL ,
	[TipoDocumento] [nvarchar] (5) NOT NULL ,
	[NumeroDocumento] [int] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[parkingContratos] (
	[NumeroContrato] [int] NULL ,
	[CodigoCliente] [nvarchar] (20) NULL ,
	[Fecha] [smalldatetime] NULL ,
	[Vencimiento] [smalldatetime] NULL ,
	[CanonMensual] [money] NULL ,
	[DiaVencimiento] [smallint] NULL ,
	[PagadoHasta] [smalldatetime] NULL ,
	[qVehiculos] [smallint] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[parkingEstacionamiento] (
	[ProximoTicket] [int] NULL ,
	[ProximoContrato] [int] NULL ,
	[Capacidad] [int] NULL ,
	[Tarifa0] [money] NULL ,
	[Tarifa1] [money] NULL ,
	[Tarifa2] [money] NULL ,
	[Fijo0] [money] NULL ,
	[Fijo1] [money] NULL ,
	[Fijo2] [money] NULL ,
	[PorcentajeImpuesto] [float] NULL ,
	[Penalizacion] [money] NULL ,
	[Ocupadas] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[parkingOcupados] (
	[NumeroPuesto] [nvarchar] (50) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[parkingTickets] (
	[Numero] [int] NULL ,
	[Placa] [nvarchar] (15) NULL ,
	[Tipo] [smallint] NULL ,
	[Puesto] [int] NULL ,
	[Entrada] [smalldatetime] NULL ,
	[Salida] [smalldatetime] NULL ,
	[Bolivares] [money] NULL ,
	[IVA] [money] NULL ,
	[Penalizacion] [money] NULL ,
	[idSesion] [int] NULL ,
	[isFijo] [smallint] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[parkingTurnos] (
	[SessionID] [int] NULL ,
	[UsrID] [nvarchar] (12) NULL ,
	[MachineID] [int] NULL ,
	[StartTime] [smalldatetime] NULL ,
	[Salidas] [int] NULL ,
	[HorasCobradas] [money] NULL ,
	[PenalidadesCobradas] [money] NULL ,
	[ImpuestoCobrado] [money] NULL ,
	[CobrosPF] [smallint] NULL ,
	[MontoCObrosPF] [money] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[parkingVehiculosContrato] (
	[Contrato] [int] NULL ,
	[Placas] [nvarchar] (15) NULL ,
	[Tipo] [smallint] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[pedDetalles] (
	[NumeroPedido] [int] NULL ,
	[NumeroRenglon] [int] NULL ,
	[CodigoProducto] [nvarchar] (20) NULL ,
	[Descuento] [nvarchar] (10) NULL ,
	[PVP] [money] NULL ,
	[idLote] [int] NULL ,
	[Cantidad] [float] NULL ,
	[PrecioNeto] [money] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[pedPedidos] (
	[Numero] [int] NOT NULL ,
	[FechaRegistro] [smalldatetime] NULL ,
	[Operador] [nvarchar] (20) NULL ,
	[CodigoCliente] [nvarchar] (20) NULL ,
	[CodigoVendedor] [nvarchar] (20) NULL ,
	[Estado] [smallint] NULL ,
	[NumeroFactura] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[perfilDescripcion] (
	[CodigoPerfil] [nvarchar] (12) NOT NULL ,
	[DescripcionPerfil] [nvarchar] (36) NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[perfilElementos] (
	[Valor] [smallint] NOT NULL ,
	[Descripcion] [nvarchar] (48) NOT NULL ,
	[Posicion] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[perfilesPermisos] (
	[CodigoPerfil] [nvarchar] (12) NOT NULL ,
	[Permiso] [smallint] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[qryExistenciaGeneral] (
	[CodigoItem] [nvarchar] (20) NULL ,
	[dExistencia] [float] NULL ,
	[dAsignadas] [float] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[qryUltimaTransferencia] (
	[Numero] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[qryUltimoAjuste] (
	[Numero] [int] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[rpBalanceGeneral] (
	[CodigoCuenta] [nvarchar] (24) NOT NULL ,
	[Titulo] [nvarchar] (70) NOT NULL ,
	[SaldoNivel0] [float] NOT NULL ,
	[SaldoNivel1] [float] NOT NULL ,
	[SaldoNivel2] [float] NOT NULL ,
	[SaldoNivel3] [float] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[rwsDetallesOrden] (
	[NumeroOrden] [int] NULL ,
	[NumeroRenglon] [int] NULL ,
	[CodigoProducto] [nvarchar] (20) NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[PrecioUnitario] [money] NULL ,
	[Cantidad] [float] NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[rwsEquipos] (
	[TipoEquipo] [nvarchar] (8) NULL ,
	[Serial] [nvarchar] (20) NULL ,
	[Propietario] [nvarchar] (20) NULL ,
	[Notas] [ntext] NULL ,
	[Estado] [smallint] NULL ,
	[Saldo] [money] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


CREATE TABLE [dbo].[rwsOrdenesTrabajo] (
	[Numero] [int] NULL ,
	[TipoEquipo] [nvarchar] (8) NULL ,
	[Serial] [nvarchar] (20) NULL ,
	[FechaRecepcion] [smalldatetime] NULL ,
	[Sintomas] [ntext] NULL ,
	[Estado] [smallint] NULL ,
	[Tecnico] [nvarchar] (20) NULL ,
	[Notas] [ntext] NULL ,
	[Factura] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


CREATE TABLE [dbo].[rwsTiposEquipo] (
	[Codigo] [nvarchar] (8) NULL ,
	[Descripcion] [nvarchar] (30) NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[subDocsMB] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[TransID] [int] NOT NULL ,
	[TipoDoc] [nvarchar] (3) NOT NULL ,
	[NumDoc] [int] NOT NULL ,
	[Debitos] [money] NOT NULL ,
	[Creditos] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[subDocsMC] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[TransID] [int] NOT NULL ,
	[TipoDoc] [nvarchar] (3) NOT NULL ,
	[NumDoc] [int] NOT NULL ,
	[Debitos] [money] NOT NULL ,
	[Creditos] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[tmpResumenPOS] (
	[Sesion] [int] NOT NULL ,
	[Producto] [nvarchar] (20) NOT NULL ,
	[Precio] [money] NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[PorcentajeImpuesto] [float] NOT NULL ,
	[Fecha] [datetime] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[tmpSaldos] (
	[TipoEntidad] [nvarchar] (3) NOT NULL ,
	[CodigoEntidad] [nvarchar] (20) NOT NULL ,
	[NumeroPeriodo] [int] NOT NULL ,
	[SaldoInicial] [money] NOT NULL ,
	[Debitos] [money] NOT NULL ,
	[Creditos] [money] NOT NULL 
) ON [PRIMARY]


CREATE TABLE [dbo].[valoresCaja] (
	[Numero] [int] IDENTITY (1, 1) NOT NULL ,
	[nSesion] [int] NOT NULL ,
	[MachineID] [int] NOT NULL ,
	[TipoDoc] [nvarchar] (3) NOT NULL ,
	[NumDoc] [int] NOT NULL ,
	[MedioPago] [smallint] NOT NULL ,
	[Emisor] [nvarchar] (20) NOT NULL ,
	[NumCuenta] [nvarchar] (20) NOT NULL ,
	[RefDocumento] [nvarchar] (20) NOT NULL ,
	[ClaveAut] [nvarchar] (8) NOT NULL ,
	[Fecha] [datetime] NOT NULL ,
	[Monto] [money] NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[DetallesTA] (
	[NumeroAjuste] [int] NOT NULL ,
	[NumeroRenglon] [smallint] NOT NULL ,
	[CodigoItem] [nvarchar] (20) NOT NULL ,
	[Cantidad] [float] NOT NULL ,
	[Unidad] [nvarchar] (12) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[TempAjustes] (
	[Numero] [int] IDENTITY (1, 1) NOT NULL ,
	[Fecha] [smalldatetime] NOT NULL ,
	[refAjuste] [nvarchar] (20) NULL ,
	[Tipo] [bit] NOT NULL ,
	[Descripcion] [nvarchar] (50) NULL ,
	[Notas] [nvarchar] (255) NULL ,
	[Contrapartida] [nvarchar] (20) NULL ,
	[Almacen] [nvarchar] (8) NOT NULL 
) ON [PRIMARY]

CREATE TABLE [dbo].[clientesPOS] (
	[Codigo] [nvarchar] (20) NOT NULL ,
	[Nombre] [nvarchar] (40) NOT NULL ,
	[RIF] [nvarchar] (14) NULL ,
	[NIT] [nvarchar] (12) NULL ,
	[Direccion] [nvarchar] (140) NULL ,
	[Tipo] [tinyint] NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[clientesPOS] WITH NOCHECK ADD 
	CONSTRAINT [PK_clientesPOS] PRIMARY KEY  CLUSTERED 
	(
		[Codigo]
	)  ON [PRIMARY]

CREATE  INDEX [ix_Nombre] ON [dbo].[clientesPOS]([Nombre]) ON [PRIMARY]

ALTER TABLE [dbo].[DetallesTA] WITH NOCHECK ADD 
	CONSTRAINT [PK_DetallesTA] PRIMARY KEY  CLUSTERED 
	(
		[NumeroAjuste],
		[NumeroRenglon]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[TempAjustes] WITH NOCHECK ADD 
	CONSTRAINT [PK_TempAjustes] PRIMARY KEY  CLUSTERED 
	(
		[Numero]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[TempAjustes] ADD 
	CONSTRAINT [DF_TempAjustes_Fecha] DEFAULT (getdate()) FOR [Fecha]

ALTER TABLE [dbo].[AcumularSesionPOS] ADD 
	CONSTRAINT [DF_AcumularSesionPOS_SesionID] DEFAULT (0) FOR [SesionID],
	CONSTRAINT [DF_AcumularSesionPOS_Precio] DEFAULT (0) FOR [Precio],
	CONSTRAINT [DF_AcumularSesionPOS_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_AcumularSesionPOS_PorcentajeImpuesto] DEFAULT (0) FOR [PorcentajeImpuesto]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[AcumularSesionPOS]([SesionID], [CodigoProducto], [Precio]) ON [PRIMARY]


 CREATE  INDEX [SesionID] ON [dbo].[AcumularSesionPOS]([SesionID]) ON [PRIMARY]


ALTER TABLE [dbo].[Ajustes] ADD 
	CONSTRAINT [DF_Ajustes_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_Ajustes_refAjuste] DEFAULT ('') FOR [refAjuste],
	CONSTRAINT [DF_Ajustes_Tipo] DEFAULT ((-1)) FOR [Tipo],
	CONSTRAINT [DF_Ajustes_Descripcion] DEFAULT ('') FOR [Descripcion],
	CONSTRAINT [DF_Ajustes_Notas] DEFAULT ('') FOR [Notas],
	CONSTRAINT [DF_Ajustes_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_Ajustes_Operador] DEFAULT ('') FOR [Operador],
	CONSTRAINT [DF_Ajustes_Contrapartida] DEFAULT ('') FOR [Contrapartida],
	CONSTRAINT [DF_Ajustes_Almacen] DEFAULT ('') FOR [Almacen],
	CONSTRAINT [DF_Ajustes_Status] DEFAULT ((-1)) FOR [Status],
	CONSTRAINT [DF_Ajustes_Valor] DEFAULT (0) FOR [Valor]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Ajustes]([Numero]) ON [PRIMARY]


 CREATE  INDEX [Referencia] ON [dbo].[Ajustes]([refAjuste]) ON [PRIMARY]


 CREATE  INDEX [Descripcion] ON [dbo].[Almacenes]([Nombre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Almacenes]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [ItemsVentaAlternosItemVenta] ON [dbo].[AlternosItemVenta]([CodigoItemVenta]) ON [PRIMARY]


 CREATE  INDEX [ItemVenta] ON [dbo].[AlternosItemVenta]([CodigoItemVenta], [CodigoAlterno]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[AlternosItemVenta]([CodigoAlterno]) ON [PRIMARY]


ALTER TABLE [dbo].[AnulacionesPOS] ADD 
	CONSTRAINT [DF_AnulacionesPOS_SessionID] DEFAULT (0) FOR [SessionID],
	CONSTRAINT [DF_AnulacionesPOS_Hora] DEFAULT (getdate()) FOR [Hora],
	CONSTRAINT [DF_AnulacionesPOS_NumeroTicket] DEFAULT (0) FOR [NumeroTicket],
	CONSTRAINT [DF_AnulacionesPOS_MontoVenta] DEFAULT (0) FOR [MontoVenta],
	CONSTRAINT [DF_AnulacionesPOS_Impuesto] DEFAULT (0) FOR [Impuesto],
	CONSTRAINT [DF_AnulacionesPOS_Servicio] DEFAULT (0) FOR [Servicio]


 CREATE  INDEX [PrimaryKey] ON [dbo].[AnulacionesPOS]([SessionID], [Hora]) ON [PRIMARY]


ALTER TABLE [dbo].[Atributos] ADD 
	CONSTRAINT [DF_Atributos_ValorAtributo] DEFAULT ('') FOR [ValorAtributo]


 CREATE  INDEX [PorAtributo] ON [dbo].[Atributos]([CodigoAtributo], [ValorAtributo], [TipoEntidad], [CodigoEntidad]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Atributos]([TipoEntidad], [CodigoEntidad], [CodigoAtributo], [ValorAtributo]) ON [PRIMARY]


ALTER TABLE [dbo].[Bancos] ADD 
	CONSTRAINT [DF_Bancos_TipoCuenta] DEFAULT (0) FOR [TipoCuenta],
	CONSTRAINT [DF_Bancos_SaldoActual] DEFAULT (0) FOR [SaldoActual],
	CONSTRAINT [DF_Bancos_DepositosDiferidos] DEFAULT (0) FOR [DepositosDiferidos],
	CONSTRAINT [DF_Bancos_ChequesPostdatados] DEFAULT (0) FOR [ChequesPostdatados],
	CONSTRAINT [DF_Bancos_ProximoCheque] DEFAULT (0) FOR [ProximoCheque],
	CONSTRAINT [DF_Bancos_UltimaActualizacion] DEFAULT (convert(datetime,floor(convert(float,getdate())))) FOR [UltimaActualizacion], 
	CONSTRAINT [DF_Bancos_FechaCreacion] DEFAULT (getdate()) FOR [FechaCreacion]


 CREATE  INDEX [IndiceNombre] ON [dbo].[Bancos]([Nombre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Bancos]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[BarraItemsPagina] ADD 
	CONSTRAINT [DF_BarraItemsPagina_Pagina] DEFAULT (0) FOR [Pagina],
	CONSTRAINT [DF_BarraItemsPagina_Posicion] DEFAULT (0) FOR [Posicion]


 CREATE  INDEX [BarraPaginasBarraItemsPagina] ON [dbo].[BarraItemsPagina]([Pagina]) ON [PRIMARY]


 CREATE  INDEX [iCodigo] ON [dbo].[BarraItemsPagina]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [ItemsVentaBarraItemsPagina] ON [dbo].[BarraItemsPagina]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[BarraItemsPagina]([Pagina], [Posicion]) ON [PRIMARY]


ALTER TABLE [dbo].[BarraPaginas] ADD 
	CONSTRAINT [DF_BarraPaginas_Numero] DEFAULT (0) FOR [Numero]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[BarraPaginas]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[CierresZ] ADD 
	CONSTRAINT [DF_CierresZ_idTerminal] DEFAULT (0) FOR [idTerminal],
	CONSTRAINT [DF_CierresZ_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_CierresZ_qFacturas] DEFAULT (0) FOR [qFacturas],
	CONSTRAINT [DF_CierresZ_PrimeraFactura] DEFAULT (0) FOR [PrimeraFactura],
	CONSTRAINT [DF_CierresZ_UltimaFactura] DEFAULT (0) FOR [UltimaFactura],
	CONSTRAINT [DF_CierresZ_Turnos] DEFAULT (0) FOR [Turnos],
	CONSTRAINT [DF_CierresZ_Gravable1] DEFAULT (0) FOR [Gravable1],
	CONSTRAINT [DF_CierresZ_Gravable2] DEFAULT (0) FOR [Gravable2],
	CONSTRAINT [DF_CierresZ_Exento] DEFAULT (0) FOR [Exento],
	CONSTRAINT [DF_CierresZ_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_CierresZ_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_CierresZ_Servicio] DEFAULT (0) FOR [Servicio]


 CREATE  INDEX [IFecha] ON [dbo].[CierresZ]([Apertura]) ON [PRIMARY]


 CREATE  INDEX [NumeroUnico] ON [dbo].[CierresZ]([NumeroUnico]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[CierresZ]([idTerminal], [Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[Clientes] ADD 
	CONSTRAINT [DF_Clientes_SaldoActual] DEFAULT (0) FOR [SaldoActual],
	CONSTRAINT [DF_Clientes_LimiteCredito] DEFAULT (0) FOR [LimiteCredito],
	CONSTRAINT [DF_Clientes_Status] DEFAULT (0) FOR [Status],
	CONSTRAINT [DF_Clientes_FechaCreacion] DEFAULT (getdate()) FOR [FechaCreacion]


 CREATE  INDEX [IndiceNombre] ON [dbo].[Clientes]([Nombre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Clientes]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [RIF] ON [dbo].[Clientes]([RIF]) ON [PRIMARY]


 CREATE  INDEX [Ruta] ON [dbo].[Clientes]([Ruta]) ON [PRIMARY]


 CREATE  INDEX [Zona] ON [dbo].[Clientes]([Zona]) ON [PRIMARY]


ALTER TABLE [dbo].[CobrosPOS] ADD 
	CONSTRAINT [DF_CobrosPOS_SessionID] DEFAULT (0) FOR [SessionID],
	CONSTRAINT [DF_CobrosPOS_Hora] DEFAULT (getdate()) FOR [Hora],
	CONSTRAINT [DF_CobrosPOS_Monto] DEFAULT (0) FOR [Monto]


 CREATE  INDEX [PrimaryKey] ON [dbo].[CobrosPOS]([SessionID], [Hora]) ON [PRIMARY]


 CREATE  INDEX [SesionesPOSCobrosPOS] ON [dbo].[CobrosPOS]([SessionID]) ON [PRIMARY]


ALTER TABLE [dbo].[Comandas] ADD 
	CONSTRAINT [DF_Comandas_Cuenta] DEFAULT (0) FOR [Cuenta],
	CONSTRAINT [DF_Comandas_NumeroComanda] DEFAULT (0) FOR [NumeroComanda]


 CREATE  INDEX [NUmeroSesion] ON [dbo].[Comandas]([Cuenta], [NumeroComanda]) ON [PRIMARY]


ALTER TABLE [dbo].[Competencia] ADD 
	CONSTRAINT [DF_Competencia_Precio] DEFAULT (0) FOR [Precio]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Competencia]([CodigoItem], [Establecimiento]) ON [PRIMARY]


ALTER TABLE [dbo].[ComposicionItemsInventario] ADD 
	CONSTRAINT [DF_ComposicionItemsInventario_Cantidad] DEFAULT (0) FOR [Cantidad]


 CREATE  INDEX [IndiceItemInv] ON [dbo].[ComposicionItemsInventario]([CodigoItemInventario]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ComposicionItemsInventario]([CodigoItemVenta], [CodigoItemInventario]) ON [PRIMARY]


ALTER TABLE [dbo].[ComposicionItemsVenta] ADD 
	CONSTRAINT [DF_ComposicionItemsVenta_Cantidad] DEFAULT (0) FOR [Cantidad]


 CREATE  INDEX [IndiceItemInv] ON [dbo].[ComposicionItemsVenta]([CodigoItemInventario]) ON [PRIMARY]


 CREATE  INDEX [itemsInventarioComposicionItemsVenta] ON [dbo].[ComposicionItemsVenta]([CodigoItemInventario]) ON [PRIMARY]


 CREATE  INDEX [ItemsVentaComposicionItemsVenta] ON [dbo].[ComposicionItemsVenta]([CodigoItemVenta]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ComposicionItemsVenta]([CodigoItemVenta], [CodigoItemInventario]) ON [PRIMARY]


ALTER TABLE [dbo].[Compras] ADD 
	CONSTRAINT [DF_Compras_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_Compras_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_Compras_CostoMercancia] DEFAULT (0) FOR [CostoMercancia],
	CONSTRAINT [DF_Compras_Descuento1] DEFAULT (0) FOR [Descuento1],
	CONSTRAINT [DF_Compras_Descuento2] DEFAULT (0) FOR [Descuento2],
	CONSTRAINT [DF_Compras_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_Compras_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_Compras_EstadoRecepcion] DEFAULT (0) FOR [EstadoRecepcion],
	CONSTRAINT [DF_Compras_EstadoAdministrativo] DEFAULT (0) FOR [EstadoAdministrativo],
	CONSTRAINT [DF_Compras_Saldo] DEFAULT (0) FOR [Saldo],
  	CONSTRAINT [DF_Compras_NumeroControl] DEFAULT (0) FOR NumeroControl


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Compras]([Numero]) ON [PRIMARY]


 CREATE  INDEX [ProveedoresCompras] ON [dbo].[Compras]([CodigoProveedor]) ON [PRIMARY]


 CREATE  INDEX [RefProveedor] ON [dbo].[Compras]([CodigoProveedor], [RefProveedor]) ON [PRIMARY]


 CREATE  INDEX [SecuencialProveedor] ON [dbo].[Compras]([CodigoProveedor], [FechaTransaccion], [Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[Comprobantes] ADD 
	CONSTRAINT [DF_Comprobantes_NumeroComprobante] DEFAULT (0) FOR [NumeroComprobante],
	CONSTRAINT [DF_Comprobantes_Periodo] DEFAULT (0) FOR [Periodo],
	CONSTRAINT [DF_Comprobantes_CorrelativoPeriodo] DEFAULT (0) FOR [CorrelativoPeriodo],
	CONSTRAINT [DF_Comprobantes_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_Comprobantes_Creditos] DEFAULT (0) FOR [Creditos],
	CONSTRAINT [DF_Comprobantes_Modificado] DEFAULT (getdate()) FOR [Modificado]


 CREATE  INDEX [CorrPeriodo] ON [dbo].[Comprobantes]([Periodo], [CorrelativoPeriodo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Comprobantes]([NumeroComprobante]) ON [PRIMARY]


 CREATE  INDEX [Referencia] ON [dbo].[Comprobantes]([Referencia]) ON [PRIMARY]


ALTER TABLE [dbo].[ComprobantesAlmacen] ADD 
	CONSTRAINT [DF_ComprobantesAlmacen_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_ComprobantesAlmacen_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_ComprobantesAlmacen_NumeroDocumentoOrigen] DEFAULT (0) FOR [NumeroDocumentoOrigen],
	CONSTRAINT [DF_ComprobantesAlmacen_OrdenDespacho] DEFAULT (0) FOR [OrdenDespacho]


 CREATE  INDEX [AlmacenesComprobantesAlmacen] ON [dbo].[ComprobantesAlmacen]([Almacen]) ON [PRIMARY]


 CREATE  INDEX [IndiceFecha] ON [dbo].[ComprobantesAlmacen]([FechaRegistro]) ON [PRIMARY]


 CREATE  INDEX [IndiceOrigen] ON [dbo].[ComprobantesAlmacen]([TipoEntidadOrigen], [NumeroDocumentoOrigen]) ON [PRIMARY]


 CREATE  INDEX [OrdenDespacho] ON [dbo].[ComprobantesAlmacen]([OrdenDespacho]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ComprobantesAlmacen]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[CondicVen] ADD 
	CONSTRAINT [DF_CondicVen_Correlativo] DEFAULT (0) FOR [Correlativo],
	CONSTRAINT [DF_CondicVen_Plazo] DEFAULT (0) FOR [Plazo],
	CONSTRAINT [DF_CondicVen_Porcentaje] DEFAULT (0) FOR [Porcentaje]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[CondicVen]([CodigoCondicion], [Correlativo]) ON [PRIMARY]


ALTER TABLE [dbo].[Condiciones] ADD 
	CONSTRAINT [DF_Condiciones_Modo] DEFAULT (0) FOR [Modo],
	CONSTRAINT [DF_Condiciones_nCuotas] DEFAULT (0) FOR [nCuotas]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Condiciones]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Contactos]([CodigoEntidad], [TipoEntidad], [NombreContacto]) ON [PRIMARY]


ALTER TABLE [dbo].[Contadores] ADD 
	CONSTRAINT [DF_Contadores_Factura] DEFAULT (1) FOR [Factura],
	CONSTRAINT [DF_Contadores_NotaEntrega] DEFAULT (1) FOR [NotaEntrega],
	CONSTRAINT [DF_Contadores_Cotizacion] DEFAULT (1) FOR [Cotizacion],
	CONSTRAINT [DF_Contadores_DevolucionVenta] DEFAULT (1) FOR [DevolucionVenta],
	CONSTRAINT [DF_Contadores_Compra] DEFAULT (1) FOR [Compra],
	CONSTRAINT [DF_Contadores_OrdenCompra] DEFAULT (1) FOR [OrdenCompra],
	CONSTRAINT [DF_Contadores_DevolucionCompra] DEFAULT (1) FOR [DevolucionCompra],
	CONSTRAINT [DF_Contadores_Ajuste] DEFAULT (1) FOR [Ajuste],
	CONSTRAINT [DF_Contadores_Transferencia] DEFAULT (1) FOR [Transferencia],
	CONSTRAINT [DF_Contadores_NotaDBCR] DEFAULT (1) FOR [NotaDBCR],
	CONSTRAINT [DF_Contadores_Apertura] DEFAULT (getdate()) FOR [Apertura],
	CONSTRAINT [DF_Contadores_Operacion] DEFAULT (0) FOR [Operacion]


ALTER TABLE [dbo].[CorrelativosMaquina] ADD 
	CONSTRAINT [DF_CorrelativosMaquina_Maquina] DEFAULT (0) FOR [Maquina],
	CONSTRAINT [DF_CorrelativosMaquina_ProximaFactura] DEFAULT (0) FOR [ProximaFactura]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[CorrelativosMaquina]([Maquina]) ON [PRIMARY]


ALTER TABLE [dbo].[Cotizaciones] ADD 
	CONSTRAINT [DF_Cotizaciones_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_Cotizaciones_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_Cotizaciones_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_Cotizaciones_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_Cotizaciones_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_Cotizaciones_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_Cotizaciones_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_Cotizaciones_IndiceReferencia] DEFAULT (0) FOR [IndiceReferencia],
	CONSTRAINT [DF_Cotizaciones_IndiceVenta] DEFAULT (0) FOR [IndiceVenta],
	CONSTRAINT [DF_Cotizaciones_Descuento1] DEFAULT (0) FOR [Descuento1],
	CONSTRAINT [DF_Cotizaciones_Descuento2] DEFAULT (0) FOR [Descuento2],
	CONSTRAINT [DF_Cotizaciones_Estado] DEFAULT (0) FOR [Estado]


 CREATE  INDEX [Cliente] ON [dbo].[Cotizaciones]([CodigoCliente], [FechaTransaccion]) ON [PRIMARY]


 CREATE  INDEX [ClientesCotizaciones] ON [dbo].[Cotizaciones]([CodigoCliente]) ON [PRIMARY]


 CREATE  INDEX [Fecha] ON [dbo].[Cotizaciones]([FechaTransaccion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Cotizaciones]([Numero]) ON [PRIMARY]


 CREATE  INDEX [Vendedor] ON [dbo].[Cotizaciones]([CodigoVendedor], [FechaTransaccion]) ON [PRIMARY]


ALTER TABLE [dbo].[CotizacionesDetalles] ADD 
	CONSTRAINT [DF_CotizacionesDetalles_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_CotizacionesDetalles_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_CotizacionesDetalles_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_CotizacionesDetalles_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_CotizacionesDetalles_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_CotizacionesDetalles_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_CotizacionesDetalles_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_CotizacionesDetalles_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_CotizacionesDetalles_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_CotizacionesDetalles_CostoUnitario] DEFAULT (0) FOR [CostoUnitario],
	CONSTRAINT [DF_CotizacionesDetalles_CantidadFacturada] DEFAULT (0) FOR [CantidadFacturada],
	CONSTRAINT [DF_CotizacionesDetalles_Ancho] DEFAULT (0) FOR [Ancho],
	CONSTRAINT [DF_CotizacionesDetalles_Alto] DEFAULT (0) FOR [Alto],
	CONSTRAINT [DF_CotizacionesDetalles_Largo] DEFAULT (0) FOR [Largo],
	CONSTRAINT [DF_CotizacionesDetalles_Descuentos] DEFAULT ('"0-0-0"') FOR [Descuentos]


 CREATE  INDEX [CotizacionesCotizacionesDetalles] ON [dbo].[CotizacionesDetalles]([NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [IndiceItem] ON [dbo].[CotizacionesDetalles]([CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [ItemFactura] ON [dbo].[CotizacionesDetalles]([NumeroDocumento], [CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[CotizacionesDetalles]([NumeroDocumento], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[CotizacionesEntregas] ADD 
	CONSTRAINT [DF_CotizacionesEntregas_NumeroCotizacion] DEFAULT (0) FOR [NumeroCotizacion],
	CONSTRAINT [DF_CotizacionesEntregas_NumeroRenglon] DEFAULT (0) FOR [NumeroRenglon],
	CONSTRAINT [DF_CotizacionesEntregas_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_CotizacionesEntregas_PrecioUnitario] DEFAULT (0) FOR [PrecioUnitario],
	CONSTRAINT [DF_CotizacionesEntregas_Factor] DEFAULT (0) FOR [Factor],
	CONSTRAINT [DF_CotizacionesEntregas_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento]


 CREATE  INDEX [CotizacionesDetallesCotizacionesEntregas] ON [dbo].[CotizacionesEntregas]([NumeroCotizacion], [NumeroRenglon]) ON [PRIMARY]


 CREATE  INDEX [CotizacionesEntregasNumeroDocumento] ON [dbo].[CotizacionesEntregas]([NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [NumeroCotizacion] ON [dbo].[CotizacionesEntregas]([NumeroCotizacion], [NumeroRenglon], [Fecha]) ON [PRIMARY]


ALTER TABLE [dbo].[CuentaMedios] ADD 
	CONSTRAINT [DF_CuentaMedios_Sesion] DEFAULT (0) FOR [Sesion],
	CONSTRAINT [DF_CuentaMedios_qEfectivo] DEFAULT (0) FOR [qEfectivo],
	CONSTRAINT [DF_CuentaMedios_qCheques] DEFAULT (0) FOR [qCheques],
	CONSTRAINT [DF_CuentaMedios_qVisa] DEFAULT (0) FOR [qVisa],
	CONSTRAINT [DF_CuentaMedios_qMaster] DEFAULT (0) FOR [qMaster],
	CONSTRAINT [DF_CuentaMedios_qOtrasTC] DEFAULT (0) FOR [qOtrasTC],
	CONSTRAINT [DF_CuentaMedios_qTDebito] DEFAULT (0) FOR [qTDebito],
	CONSTRAINT [DF_CuentaMedios_qCreditos] DEFAULT (0) FOR [qCreditos],
	CONSTRAINT [DF_CuentaMedios_qAmex] DEFAULT (0) FOR [qAmex],
	CONSTRAINT [DF_CuentaMedios_qOtrosMedios] DEFAULT (0) FOR [qOtrosMedios]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[CuentaMedios]([Sesion]) ON [PRIMARY]


ALTER TABLE [dbo].[Cuentas] ADD 
	CONSTRAINT [DF_Cuentas_Status] DEFAULT (0) FOR [Status],
	CONSTRAINT [DF_Cuentas_Lado] DEFAULT (0) FOR [Lado],
	CONSTRAINT [DF_Cuentas_Saldo] DEFAULT (0) FOR [Saldo]


 CREATE  INDEX [IndiceTitulo] ON [dbo].[Cuentas]([Titulo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Cuentas]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[CuentasPOS] ADD 
	CONSTRAINT [DF_CuentasPOS_IDCuenta] DEFAULT (0) FOR [IDCuenta],
	CONSTRAINT [DF_CuentasPOS_HoraApertura] DEFAULT (getdate()) FOR [HoraApertura],
	CONSTRAINT [DF_CuentasPOS_HoraUltimaTransaccion] DEFAULT (getdate()) FOR [HoraUltimaTransaccion],
	CONSTRAINT [DF_CuentasPOS_Estado] DEFAULT (1) FOR [Estado],
	CONSTRAINT [DF_CuentasPOS_Personas] DEFAULT (1) FOR [Personas],
	CONSTRAINT [DF_CuentasPOS_Cliente] DEFAULT ('') FOR [Cliente],
	CONSTRAINT [DF_CuentasPOS_CodigoCuenta] DEFAULT ('') FOR [CodigoCuenta],
	CONSTRAINT [DF_CuentasPOS_Ambiente] DEFAULT ('') FOR [Ambiente],
	CONSTRAINT [DF_CuentasPOS_idMesa] DEFAULT (0) FOR [idMesa]


 CREATE  INDEX [IDCuenta] ON [dbo].[CuentasPOS]([IDCuenta]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[CuentasPOS]([IDCuenta]) ON [PRIMARY]


ALTER TABLE [dbo].[Despachos] ADD 
	CONSTRAINT [DF_Despachos_Fecha] DEFAULT (getdate()) FOR [Fecha],
	CONSTRAINT [DF_Despachos_Puntos] DEFAULT (1) FOR [Puntos]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Despachos]([Usuario], [Fecha]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [ItemsVentaDestinoComandasItem] ON [dbo].[DestinoComandasItem]([CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DestinoComandasItem]([CodigoItem]) ON [PRIMARY]


ALTER TABLE [dbo].[Detalles] ADD 
	CONSTRAINT [DF_Detalles_NumeroComprobante] DEFAULT (0) FOR [NumeroComprobante],
	CONSTRAINT [DF_Detalles_NumeroLinea] DEFAULT (0) FOR [NumeroLinea],
	CONSTRAINT [DF_Detalles_RefPeriodo] DEFAULT (0) FOR [RefPeriodo],
	CONSTRAINT [DF_Detalles_Debe] DEFAULT (0) FOR [Debe],
	CONSTRAINT [DF_Detalles_Haber] DEFAULT (0) FOR [Haber]


 CREATE  INDEX [ComprobantesDetalles] ON [dbo].[Detalles]([NumeroComprobante]) ON [PRIMARY]


 CREATE  INDEX [CuentasDetalles] ON [dbo].[Detalles]([Cuenta]) ON [PRIMARY]


 CREATE  INDEX [IndicePorCuenta] ON [dbo].[Detalles]([Cuenta], [RefPeriodo], [NumeroComprobante], [NumeroLinea]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Detalles]([NumeroComprobante], [NumeroLinea]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesCompra] ADD 
	CONSTRAINT [DF_DetallesCompra_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_DetallesCompra_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_DetallesCompra_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_DetallesCompra_CantidadFacturada] DEFAULT (0) FOR [CantidadFacturada],
	CONSTRAINT [DF_DetallesCompra_CantidadPromocion] DEFAULT (0) FOR [CantidadPromocion],
	CONSTRAINT [DF_DetallesCompra_PrecioNominal] DEFAULT (0) FOR [PrecioNominal],
	CONSTRAINT [DF_DetallesCompra_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_DetallesCompra_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_DetallesCompra_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_DetallesCompra_CostoUnitario] DEFAULT (0) FOR [CostoUnitario],
	CONSTRAINT [DF_DetallesCompra_Recibidas] DEFAULT (0) FOR [Recibidas],
	CONSTRAINT [DF_DetallesCompra_Devueltas] DEFAULT (0) FOR [Devueltas]


 CREATE  INDEX [ComprasDetallesCompra] ON [dbo].[DetallesCompra]([NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [iCodigoItem] ON [dbo].[DetallesCompra]([CodigoItem], [NumeroDocumento]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DetallesCompra]([NumeroDocumento], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesCuentaEntidad] ADD 
	CONSTRAINT [DF_DetallesCuentaEntidad_Correlativo] DEFAULT (0) FOR [Correlativo],
	CONSTRAINT [DF_DetallesCuentaEntidad_Documento] DEFAULT (0) FOR [Documento],
	CONSTRAINT [DF_DetallesCuentaEntidad_RefPeriodo] DEFAULT (0) FOR [RefPeriodo],
	CONSTRAINT [DF_DetallesCuentaEntidad_Debe] DEFAULT (0) FOR [Debe],
	CONSTRAINT [DF_DetallesCuentaEntidad_Haber] DEFAULT (0) FOR [Haber]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DetallesCuentaEntidad]([CodigoEntidad], [TipoEntidad], [Correlativo]) ON [PRIMARY]


 CREATE  INDEX [SecuenciaDocumento] ON [dbo].[DetallesCuentaEntidad]([Documento], [Fecha], [Correlativo]) ON [PRIMARY]


 CREATE  INDEX [SecuenciaEntidad] ON [dbo].[DetallesCuentaEntidad]([CodigoEntidad], [TipoEntidad], [Fecha], [Correlativo]) ON [PRIMARY]


 CREATE  INDEX [SecuenciaPeriodo] ON [dbo].[DetallesCuentaEntidad]([CodigoEntidad], [TipoEntidad], [RefPeriodo], [Correlativo]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesDevolucionCompra] ADD 
	CONSTRAINT [DF_DetallesDevolucionCompra_NumeroDevolucion] DEFAULT (0) FOR [NumeroDevolucion],
	CONSTRAINT [DF_DetallesDevolucionCompra_NumeroRenglon] DEFAULT (0) FOR [NumeroRenglon],
	CONSTRAINT [DF_DetallesDevolucionCompra_CantidadDevuelta] DEFAULT (0) FOR [CantidadDevuelta],
	CONSTRAINT [DF_DetallesDevolucionCompra_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_DetallesDevolucionCompra_Costo] DEFAULT (0) FOR [Costo]


 CREATE  INDEX [DevolucionesCompraDetallesDevolucionCompra] ON [dbo].[DetallesDevolucionCompra]([NumeroDevolucion]) ON [PRIMARY]


 CREATE  INDEX [Item] ON [dbo].[DetallesDevolucionCompra]([CodigoItem], [NumeroDevolucion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DetallesDevolucionCompra]([NumeroDevolucion], [NumeroRenglon]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesDevolucionVenta] ADD 
	CONSTRAINT [DF_DetallesDevolucionVenta_NumeroDevolucion] DEFAULT (0) FOR [NumeroDevolucion],
	CONSTRAINT [DF_DetallesDevolucionVenta_NumeroRenglon] DEFAULT (0) FOR [NumeroRenglon],
	CONSTRAINT [DF_DetallesDevolucionVenta_CantidadDevuelta] DEFAULT (0) FOR [CantidadDevuelta],
	CONSTRAINT [DF_DetallesDevolucionVenta_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_DetallesDevolucionVenta_Valor] DEFAULT (0) FOR [Valor],
	CONSTRAINT [DF_DetallesDevolucionVenta_Costo] DEFAULT (0) FOR [Costo]


 CREATE  INDEX [DevolucionesVentaDetallesDevolucionVenta] ON [dbo].[DetallesDevolucionVenta]([NumeroDevolucion]) ON [PRIMARY]


 CREATE  INDEX [Item] ON [dbo].[DetallesDevolucionVenta]([CodigoItemVenta], [NumeroDevolucion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DetallesDevolucionVenta]([NumeroDevolucion], [NumeroRenglon]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesFactura] ADD 
	CONSTRAINT [DF_DetallesFactura_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_DetallesFactura_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_DetallesFactura_CodigoItem] DEFAULT ('') FOR [CodigoItem],
	CONSTRAINT [DF_DetallesFactura_Descripcion] DEFAULT ('') FOR [Descripcion],
	CONSTRAINT [DF_DetallesFactura_Presentacion] DEFAULT ('') FOR [Presentacion],
	CONSTRAINT [DF_DetallesFactura_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_DetallesFactura_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_DetallesFactura_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_DetallesFactura_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_DetallesFactura_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_DetallesFactura_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_DetallesFactura_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_DetallesFactura_CostoUnitario] DEFAULT (0) FOR [CostoUnitario],
	CONSTRAINT [DF_DetallesFactura_Entregadas] DEFAULT (0) FOR [Entregadas],
	CONSTRAINT [DF_DetallesFactura_Asignadas] DEFAULT (0) FOR [Asignadas],
	CONSTRAINT [DF_DetallesFactura_Transito] DEFAULT (0) FOR [Transito],
	CONSTRAINT [DF_DetallesFactura_Devueltas] DEFAULT (0) FOR [Devueltas]


 CREATE  INDEX [FacturasDetallesFactura] ON [dbo].[DetallesFactura]([NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [IndiceItem] ON [dbo].[DetallesFactura]([CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [ItemFactura] ON [dbo].[DetallesFactura]([NumeroDocumento], [CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DetallesFactura]([NumeroDocumento], [Renglon]) ON [PRIMARY]


 CREATE  INDEX [MovimientosCajaDetallesIngresoCaja] ON [dbo].[DetallesIngresoCaja]([TransID]) ON [PRIMARY]


 CREATE  INDEX [TransID] ON [dbo].[DetallesIngresoCaja]([TransID]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesItemVenta] ADD 
	CONSTRAINT [DF_DetallesItemVenta_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_DetallesItemVenta_PrecioReferencia] DEFAULT (0) FOR [PrecioReferencia],
	CONSTRAINT [DF_DetallesItemVenta_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_DetallesItemVenta_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_DetallesItemVenta_CostoStandard] DEFAULT (0) FOR [CostoStandard]


 CREATE  INDEX [Cliente] ON [dbo].[DetallesItemVenta]([CodigoCliente], [FechaOperacion]) ON [PRIMARY]


 CREATE  INDEX [IndiceDocumento] ON [dbo].[DetallesItemVenta]([TipoDocumento], [NumeroDocumento], [CodigoItem], [PrecioVenta]) ON [PRIMARY]


 CREATE  INDEX [Item] ON [dbo].[DetallesItemVenta]([CodigoItem], [FechaOperacion]) ON [PRIMARY]


 CREATE  INDEX [ItemCliente] ON [dbo].[DetallesItemVenta]([CodigoCliente], [CodigoItem], [FechaOperacion]) ON [PRIMARY]


 CREATE  INDEX [ItemsVentaDetallesItemVenta] ON [dbo].[DetallesItemVenta]([CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [ItemVendedor] ON [dbo].[DetallesItemVenta]([CodigoVendedor], [CodigoItem], [FechaOperacion]) ON [PRIMARY]


 CREATE  INDEX [Vendedor] ON [dbo].[DetallesItemVenta]([CodigoVendedor], [CodigoItem]) ON [PRIMARY]


ALTER TABLE [dbo].[DetallesMINV] ADD 
	CONSTRAINT [DF_DetallesMINV_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_DetallesMINV_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_DetallesMINV_Entradas] DEFAULT (0) FOR [Entradas],
	CONSTRAINT [DF_DetallesMINV_Salidas] DEFAULT (0) FOR [Salidas],
	CONSTRAINT [DF_DetallesMINV_Costo] DEFAULT (0) FOR [Costo]


 CREATE  INDEX [ComprobantesAlmacenDetallesMINV] ON [dbo].[DetallesMINV]([NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [IndiceFecha] ON [dbo].[DetallesMINV]([FechaOperacion], [CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [IndiceItem] ON [dbo].[DetallesMINV]([CodigoItem], [FechaOperacion]) ON [PRIMARY]


 CREATE  INDEX [ItemDocumento] ON [dbo].[DetallesMINV]([NumeroDocumento], [CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [itemsInventarioDetallesMINV] ON [dbo].[DetallesMINV]([CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DetallesMINV]([NumeroDocumento], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[DevolucionesCompra] ADD 
	CONSTRAINT [DF_DevolucionesCompra_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_DevolucionesCompra_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_DevolucionesCompra_Factura] DEFAULT (0) FOR [Factura],
	CONSTRAINT [DF_DevolucionesCompra_ValorMercancia] DEFAULT (0) FOR [ValorMercancia],
	CONSTRAINT [DF_DevolucionesCompra_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_DevolucionesCompra_Impuesto2] DEFAULT (0) FOR [Impuesto2]


 CREATE  UNIQUE  INDEX [Numero] ON [dbo].[DevolucionesCompra]([Numero]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DevolucionesCompra]([Numero]) ON [PRIMARY]


 CREATE  INDEX [ProveedoresDevolucionesCompra] ON [dbo].[DevolucionesCompra]([CodigoProveedor]) ON [PRIMARY]


ALTER TABLE [dbo].[DevolucionesVenta] ADD 
	CONSTRAINT [DF_DevolucionesVenta_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_DevolucionesVenta_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_DevolucionesVenta_NumeroFactura] DEFAULT (0) FOR [NumeroFactura],
	CONSTRAINT [DF_DevolucionesVenta_Valor] DEFAULT (0) FOR [Valor],
	CONSTRAINT [DF_DevolucionesVenta_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_DevolucionesVenta_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_DevolucionesVenta_Costo] DEFAULT (0) FOR [Costo],
	CONSTRAINT [DF_DevolucionesVenta_ComisionAnulada] DEFAULT (0) FOR [ComisionAnulada]


 CREATE  INDEX [ClientesDevolucionesVenta] ON [dbo].[DevolucionesVenta]([CodigoCliente]) ON [PRIMARY]


 CREATE  INDEX [iCliente] ON [dbo].[DevolucionesVenta]([CodigoCliente], [FechaTransaccion], [Numero]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DevolucionesVenta]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[DiferidosBanco] ADD 
	CONSTRAINT [DF_DiferidosBanco_MontoDiferido] DEFAULT (0) FOR [MontoDiferido],
	CONSTRAINT [DF_DiferidosBanco_TipoMovimiento] DEFAULT (0) FOR [TipoMovimiento]


 CREATE  INDEX [IndiceBanco] ON [dbo].[DiferidosBanco]([CodigoBanco], [FechaPresentacion]) ON [PRIMARY]


 CREATE  INDEX [IndiceFecha] ON [dbo].[DiferidosBanco]([FechaPresentacion]) ON [PRIMARY]


ALTER TABLE [dbo].[DocumentosISPC] ADD 
	CONSTRAINT [DF_DocumentosISPC_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_DocumentosISPC_TipoEntidad] DEFAULT ('nil') FOR [TipoEntidad],
	CONSTRAINT [DF_DocumentosISPC_CodigoEntidad] DEFAULT ('<nil>') FOR [CodigoEntidad],
	CONSTRAINT [DF_DocumentosISPC_NumDoc] DEFAULT (0) FOR [NumDoc],
	CONSTRAINT [DF_DocumentosISPC_TipoDoc] DEFAULT ('nil') FOR [TipoDoc],
	CONSTRAINT [DF_DocumentosISPC_FechaDoc] DEFAULT (getdate()) FOR [FechaDoc],
	CONSTRAINT [DF_DocumentosISPC_Monto] DEFAULT (0) FOR [Monto],
	CONSTRAINT [DF_DocumentosISPC_Saldo] DEFAULT (0) FOR [Saldo]


 CREATE  INDEX [IndiceDoc] ON [dbo].[DocumentosISPC]([NumDoc], [TipoDoc]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [IndiceEntidad] ON [dbo].[DocumentosISPC]([CodigoEntidad], [TipoEntidad], [Numero]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[DocumentosISPC]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[Empaques] ADD 
	CONSTRAINT [DF_Empaques_Factor] DEFAULT (0) FOR [Factor]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Empaques]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[ExistenciaUbicacion] ADD 
	CONSTRAINT [DF_ExistenciaUbicacion_TipoUbicacion] DEFAULT (0) FOR [TipoUbicacion],
	CONSTRAINT [DF_ExistenciaUbicacion_Existencia] DEFAULT (0) FOR [Existencia],
	CONSTRAINT [DF_ExistenciaUbicacion_Asignadas] DEFAULT (0) FOR [Asignadas]


 CREATE  INDEX [AlmacenesExistenciaUbicacion] ON [dbo].[ExistenciaUbicacion]([Almacen]) ON [PRIMARY]


 CREATE  INDEX [IndiceAlmacen] ON [dbo].[ExistenciaUbicacion]([Almacen], [TipoUbicacion], [CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [itemsInventarioExistenciaUbicacion] ON [dbo].[ExistenciaUbicacion]([CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ExistenciaUbicacion]([CodigoItem], [TipoUbicacion], [Almacen]) ON [PRIMARY]


ALTER TABLE [dbo].[Facturas] ADD 
	CONSTRAINT [DF_Facturas_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_Facturas_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_Facturas_Correlativo] DEFAULT (0) FOR [Correlativo],
	CONSTRAINT [DF_Facturas_EstadoDespacho] DEFAULT (0) FOR [EstadoDespacho],
	CONSTRAINT [DF_Facturas_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_Facturas_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_Facturas_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_Facturas_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_Facturas_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_Facturas_IndiceReferencia] DEFAULT (0) FOR [IndiceReferencia],
	CONSTRAINT [DF_Facturas_IndiceVenta] DEFAULT (0) FOR [IndiceVenta],
	CONSTRAINT [DF_Facturas_Descuento1] DEFAULT (0) FOR [Descuento1],
	CONSTRAINT [DF_Facturas_Descuento2] DEFAULT (0) FOR [Descuento2],
	CONSTRAINT [DF_Facturas_Costo] DEFAULT (0) FOR [Costo],
	CONSTRAINT [DF_Facturas_SituacionAdministrativa] DEFAULT (0) FOR [SituacionAdministrativa],
	CONSTRAINT [DF_Facturas_DescuentosProntoPago] DEFAULT (0) FOR [DescuentosProntoPago],
	CONSTRAINT [DF_Facturas_Comision] DEFAULT (0) FOR [Comision],
	CONSTRAINT [DF_Facturas_ComisionAcreditada] DEFAULT (0) FOR [ComisionAcreditada],
	CONSTRAINT [DF_Facturas_OrdenDespacho] DEFAULT (0) FOR [OrdenDespacho],
	CONSTRAINT [DF_Facturas_ComprobanteInventario] DEFAULT (0) FOR [ComprobanteInventario],
	CONSTRAINT [DF_Facturas_PrecioDevuelto] DEFAULT (0) FOR [PrecioDevuelto],
	CONSTRAINT [DF_Facturas_CostoDevuelto] DEFAULT (0) FOR [CostoDevuelto],
	CONSTRAINT [DF_Facturas_Saldo] DEFAULT (0) FOR [Saldo],
	CONSTRAINT [DF_Facturas_Impuesto1Devuelto] DEFAULT (0) FOR [Impuesto1Devuelto],
	CONSTRAINT [DF_Facturas_Impuesto2Devuelto] DEFAULT (0) FOR [Impuesto2Devuelto]


 CREATE  INDEX [Cliente] ON [dbo].[Facturas]([CodigoCliente], [FechaTransaccion]) ON [PRIMARY]


 CREATE  INDEX [ClientesFacturas] ON [dbo].[Facturas]([CodigoCliente]) ON [PRIMARY]


 CREATE  INDEX [Correlativo] ON [dbo].[Facturas]([Serie], [Correlativo]) ON [PRIMARY]


 CREATE  INDEX [Fecha] ON [dbo].[Facturas]([FechaTransaccion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Facturas]([Numero]) ON [PRIMARY]


 CREATE  INDEX [Referencia] ON [dbo].[Facturas]([ExtRef]) ON [PRIMARY]


 CREATE  INDEX [Vendedor] ON [dbo].[Facturas]([CodigoVendedor], [FechaTransaccion]) ON [PRIMARY]


ALTER TABLE [dbo].[FacturasPOS] ADD 
	CONSTRAINT [DF_FacturasPOS_idMaquina] DEFAULT (0) FOR [idMaquina],
	CONSTRAINT [DF_FacturasPOS_NumeroTicket] DEFAULT (0) FOR [NumeroTicket],
	CONSTRAINT [DF_FacturasPOS_idSesion] DEFAULT (0) FOR [idSesion],
	CONSTRAINT [DF_FacturasPOS_Hora] DEFAULT (getdate()) FOR [Hora],
	CONSTRAINT [DF_FacturasPOS_MontoVenta] DEFAULT (0) FOR [MontoVenta],
	CONSTRAINT [DF_FacturasPOS_Impuesto] DEFAULT (0) FOR [Impuesto],
	CONSTRAINT [DF_FacturasPOS_Servicio] DEFAULT (0) FOR [Servicio],
	CONSTRAINT [DF_FacturasPOS_Personas] DEFAULT (0) FOR [Personas],
	CONSTRAINT [DF_FacturasPOS_Cuenta] DEFAULT (0) FOR [Cuenta],
	CONSTRAINT [DF_FacturasPOS_Cliente] DEFAULT ('') FOR [Cliente],
	CONSTRAINT [DF_FacturasPOS_Propina] DEFAULT (0) FOR [Propina],
	CONSTRAINT [DF_FacturasPOS_NombreHuesped] DEFAULT ('') FOR [NombreHuesped],
	CONSTRAINT [DF_FacturasPOS_IT] DEFAULT (0) FOR [IT]


 CREATE  INDEX [idSesion] ON [dbo].[FacturasPOS]([idSesion], [NumeroTicket]) ON [PRIMARY]
 CREATE UNIQUE INDEX [PrimaryKey] ON [dbo].[FacturasPOS]([idMaquina], [NumeroTicket]) ON [PRIMARY]
 CREATE UNIQUE CLUSTERED INDEX [ndxNumero]  ON [dbo].[FacturasPOS]([Numero]) ON [PRIMARY]
 
 CREATE  INDEX [iKey] ON [dbo].[HotKeys]([Tecla]) ON [PRIMARY]

 CREATE  INDEX [ItemsVentaHotKeys] ON [dbo].[HotKeys]([Normal]) ON [PRIMARY]

 CREATE  INDEX [idxProveedor] ON [dbo].[IVARetenido]([CodigoProveedor]) WITH  FILLFACTOR = 90 ON [PRIMARY]
 CREATE  INDEX [IvaRetenidoDOC] ON [dbo].[IVARetenido]([TipoDoc], [NumeroDoc]) ON [PRIMARY]
 CREATE  INDEX [IX_NombreProveedor] ON [dbo].[IVARetenido]([NombreProveedor]) ON [PRIMARY]
 CREATE  INDEX [IX_RifProveedor] ON [dbo].[IVARetenido]([RifProveedor]) ON [PRIMARY]
 CREATE  INDEX [IX_NUmeroReporte] ON [dbo].[IVARetenido]([Relacionado]) ON [PRIMARY]

 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Indicadores]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[ItemsVenta] ADD 
	CONSTRAINT [DF_ItemsVenta_Precio1] DEFAULT (0) FOR [Precio1],
	CONSTRAINT [DF_ItemsVenta_Precio2] DEFAULT (0) FOR [Precio2],
	CONSTRAINT [DF_ItemsVenta_Precio3] DEFAULT (0) FOR [Precio3],
	CONSTRAINT [DF_ItemsVenta_Precio4] DEFAULT (0) FOR [Precio4],
	CONSTRAINT [DF_ItemsVenta_CostoStandard] DEFAULT (0) FOR [CostoStandard],
	CONSTRAINT [DF_ItemsVenta_PComis1] DEFAULT (0) FOR [PComis1],
	CONSTRAINT [DF_ItemsVenta_PComis2] DEFAULT (0) FOR [PComis2],
	CONSTRAINT [DF_ItemsVenta_PComis3] DEFAULT (0) FOR [PComis3],
	CONSTRAINT [DF_ItemsVenta_CantidadPresentacion] DEFAULT (0) FOR [CantidadPresentacion],
	CONSTRAINT [DF_ItemsVenta_NumeroPLU] DEFAULT (0) FOR [NumeroPLU],
	CONSTRAINT [DF_ItemsVenta_PrecioIndexado] DEFAULT (0) FOR [PrecioIndexado],
	CONSTRAINT [DF_ItemsVenta_FechaCreacion] DEFAULT (getdate()) FOR [FechaCreacion]


 CREATE  INDEX [Descripcion] ON [dbo].[ItemsVenta]([Descripcion]) ON [PRIMARY]


 CREATE  INDEX [Grupo] ON [dbo].[ItemsVenta]([Grupo], [Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [Linea] ON [dbo].[ItemsVenta]([Linea], [Codigo]) ON [PRIMARY]


 CREATE  INDEX [LineaDesc] ON [dbo].[ItemsVenta]([Linea], [Descripcion]) ON [PRIMARY]


 CREATE  INDEX [LineaGrupo] ON [dbo].[ItemsVenta]([Linea], [Grupo], [Codigo]) ON [PRIMARY]


 CREATE  INDEX [NumeroPLU] ON [dbo].[ItemsVenta]([NumeroPLU]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ItemsVenta]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [Ubicacion] ON [dbo].[ItemsVenta]([Ubicacion]) ON [PRIMARY]


ALTER TABLE [dbo].[LibroCompras] ADD 
	CONSTRAINT [DF_LibroCompras_MontoBruto] DEFAULT (0) FOR [MontoBruto],
	CONSTRAINT [DF_LibroCompras_Exento] DEFAULT (0) FOR [Exento],
	CONSTRAINT [DF_LibroCompras_Gravable1] DEFAULT (0) FOR [Gravable1],
	CONSTRAINT [DF_LibroCompras_Porcentaje1] DEFAULT (0) FOR [Porcentaje1],
	CONSTRAINT [DF_LibroCompras_MontoRetencion1] DEFAULT (0) FOR [MontoRetencion1],
	CONSTRAINT [DF_LibroCompras_Gravable2] DEFAULT (0) FOR [Gravable2],
	CONSTRAINT [DF_LibroCompras_Porcentaje2] DEFAULT (0) FOR [Porcentaje2],
	CONSTRAINT [DF_LibroCompras_MontoRetencion2] DEFAULT (0) FOR [MontoRetencion2]


 CREATE  INDEX [Cronologico] ON [dbo].[LibroCompras]([Fecha], [Factura]) ON [PRIMARY]


 CREATE  INDEX [Fatura] ON [dbo].[LibroCompras]([Factura]) ON [PRIMARY]


 CREATE  INDEX [Proveedor] ON [dbo].[LibroCompras]([Proveedor], [Factura]) ON [PRIMARY]


 CREATE  INDEX [ProveedoresLibroCompras] ON [dbo].[LibroCompras]([Proveedor]) ON [PRIMARY]


ALTER TABLE [dbo].[LibroVentas] ADD 
	CONSTRAINT [DF_LibroVentas_MontoBruto] DEFAULT (0) FOR [MontoBruto],
	CONSTRAINT [DF_LibroVentas_Exento] DEFAULT (0) FOR [Exento],
	CONSTRAINT [DF_LibroVentas_Gravable1] DEFAULT (0) FOR [Gravable1],
	CONSTRAINT [DF_LibroVentas_Porcentaje1] DEFAULT (0) FOR [Porcentaje1],
	CONSTRAINT [DF_LibroVentas_MontoRetencion1] DEFAULT (0) FOR [MontoRetencion1]


 CREATE  INDEX [Cliente] ON [dbo].[LibroVentas]([Cliente], [Factura]) ON [PRIMARY]


 CREATE  INDEX [ClientesLibroVentas] ON [dbo].[LibroVentas]([Cliente]) ON [PRIMARY]


 CREATE  INDEX [Cronologico] ON [dbo].[LibroVentas]([Fecha], [Factura]) ON [PRIMARY]


 CREATE  INDEX [Factura] ON [dbo].[LibroVentas]([Factura]) ON [PRIMARY]


 CREATE  INDEX [IndiceDescripcion] ON [dbo].[Lineas]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Lineas]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[MovimientosBanco] ADD 
	CONSTRAINT [DF_MovimientosBanco_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_MovimientosBanco_Tipo] DEFAULT (0) FOR [Tipo],
	CONSTRAINT [DF_MovimientosBanco_Monto] DEFAULT (0) FOR [Monto],
	CONSTRAINT [DF_MovimientosBanco_Conciliado] DEFAULT (0) FOR [Conciliado],
	CONSTRAINT [DF_MovimientosBanco_TipoDocRel] DEFAULT ('"NIL"') FOR [TipoDocRel],
	CONSTRAINT [DF_MovimientosBanco_NumeroDocRel] DEFAULT (0) FOR [NumeroDocRel]


 CREATE  INDEX [BancoFecha] ON [dbo].[MovimientosBanco]([CodigoBanco], [FechaTransaccion], [Numero]) ON [PRIMARY]


 CREATE  INDEX [BancoNumero] ON [dbo].[MovimientosBanco]([CodigoBanco], [Numero]) ON [PRIMARY]


 CREATE  INDEX [BancosMovimientosBanco] ON [dbo].[MovimientosBanco]([CodigoBanco]) ON [PRIMARY]


 CREATE  INDEX [FechaTransaccion] ON [dbo].[MovimientosBanco]([FechaTransaccion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[MovimientosBanco]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[MovimientosCaja] ADD 
	CONSTRAINT [DF_MovimientosCaja_Sesion] DEFAULT (0) FOR [Sesion],
	CONSTRAINT [DF_MovimientosCaja_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_MovimientosCaja_Creditos] DEFAULT (0) FOR [Creditos],
	CONSTRAINT [DF_MovimientosCaja_TipoEntidad] DEFAULT ('') FOR [TipoEntidad],
	CONSTRAINT [DF_MovimientosCaja_CodigoEntidad] DEFAULT ('') FOR [CodigoEntidad],
	CONSTRAINT [DF_MovimientosCaja_TipoDocumento] DEFAULT ('') FOR [TipoDocumento],
	CONSTRAINT [DF_MovimientosCaja_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_MovimientosCaja_Fecha] DEFAULT (getdate()) FOR [Fecha]


 CREATE  INDEX [Documento] ON [dbo].[MovimientosCaja]([TipoDocumento], [NumeroDocumento]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[MovimientosCaja]([TransID]) ON [PRIMARY]


ALTER TABLE [dbo].[NNEE] ADD 
	CONSTRAINT [DF_NNEE_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_NNEE_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_NNEE_Estado] DEFAULT (0) FOR [Estado],
	CONSTRAINT [DF_NNEE_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_NNEE_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_NNEE_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_NNEE_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_NNEE_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_NNEE_IndiceReferencia] DEFAULT (0) FOR [IndiceReferencia],
	CONSTRAINT [DF_NNEE_IndiceVenta] DEFAULT (0) FOR [IndiceVenta],
	CONSTRAINT [DF_NNEE_Descuento1] DEFAULT (0) FOR [Descuento1],
	CONSTRAINT [DF_NNEE_Descuento2] DEFAULT (0) FOR [Descuento2],
	CONSTRAINT [DF_NNEE_ComprobanteAlmacen] DEFAULT (0) FOR [ComprobanteAlmacen],
	CONSTRAINT [DF_NNEE_NumeroFacturaOrigen] DEFAULT (0) FOR [NumeroFacturaOrigen],
	CONSTRAINT [DF_NNEE_SaldoActual] DEFAULT (0) FOR [SaldoActual]


 CREATE  INDEX [Cliente] ON [dbo].[NNEE]([CodigoCliente], [FechaTransaccion], [Numero]) ON [PRIMARY]


 CREATE  INDEX [ClientesNNEE] ON [dbo].[NNEE]([CodigoCliente]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[NNEE]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[NNEEDetalleSuplemento] ADD 
	CONSTRAINT [DF_NNEEDetalleSuplemento_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_NNEEDetalleSuplemento_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_NNEEDetalleSuplemento_NumeroRenglonOrigen] DEFAULT (0) FOR [NumeroRenglonOrigen],
	CONSTRAINT [DF_NNEEDetalleSuplemento_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_NNEEDetalleSuplemento_FactorPresentacion] DEFAULT (0) FOR [FactorPresentacion],
	CONSTRAINT [DF_NNEEDetalleSuplemento_PrecioNeto] DEFAULT (0) FOR [PrecioNeto],
	CONSTRAINT [DF_NNEEDetalleSuplemento_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_NNEEDetalleSuplemento_Impuesto2] DEFAULT (0) FOR [Impuesto2]


 CREATE  INDEX [NNEESuplementoNNEEDetalleSuplemento] ON [dbo].[NNEEDetalleSuplemento]([NumeroDocumento]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[NNEEDetalleSuplemento]([NumeroDocumento], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[NNEEDetalles] ADD 
	CONSTRAINT [DF_NNEEDetalles_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_NNEEDetalles_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_NNEEDetalles_CodigoItem] DEFAULT ('') FOR [CodigoItem],
	CONSTRAINT [DF_NNEEDetalles_Descripcion] DEFAULT ('') FOR [Descripcion],
	CONSTRAINT [DF_NNEEDetalles_Presentacion] DEFAULT ('') FOR [Presentacion],
	CONSTRAINT [DF_NNEEDetalles_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_NNEEDetalles_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_NNEEDetalles_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_NNEEDetalles_PrecioVenta] DEFAULT (0) FOR [PrecioVenta],
	CONSTRAINT [DF_NNEEDetalles_PrecioEfectivo] DEFAULT (0) FOR [PrecioEfectivo],
	CONSTRAINT [DF_NNEEDetalles_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_NNEEDetalles_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_NNEEDetalles_CostoUnitario] DEFAULT (0) FOR [CostoUnitario],
	CONSTRAINT [DF_NNEEDetalles_SaldoCantidad] DEFAULT (0) FOR [SaldoCantidad],
	CONSTRAINT [DF_NNEEDetalles_Descuentos] DEFAULT ('"0-0-0"') FOR [Descuentos]


 CREATE  INDEX [CodigoItem] ON [dbo].[NNEEDetalles]([CodigoItem], [NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [NNEENNEEDetalles] ON [dbo].[NNEEDetalles]([NumeroDocumento]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[NNEEDetalles]([NumeroDocumento], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[NNEESuplemento] ADD 
	CONSTRAINT [DF_NNEESuplemento_NumeroNota] DEFAULT (0) FOR [NumeroNota],
	CONSTRAINT [DF_NNEESuplemento_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_NNEESuplemento_Descripcion] DEFAULT ('') FOR [Descripcion],
	CONSTRAINT [DF_NNEESuplemento_Impuesto1] DEFAULT (0) FOR [Impuesto1],
	CONSTRAINT [DF_NNEESuplemento_Impuesto2] DEFAULT (0) FOR [Impuesto2],
	CONSTRAINT [DF_NNEESuplemento_Valor] DEFAULT (0) FOR [Valor],
	CONSTRAINT [DF_NNEESuplemento_TipoDocRel] DEFAULT ('') FOR [TipoDocRel],
	CONSTRAINT [DF_NNEESuplemento_NumeroDocRel] DEFAULT (0) FOR [NumeroDocRel]


 CREATE  INDEX [IndiceDocumento] ON [dbo].[NNEESuplemento]([TipoDocRel], [NumeroDocRel]) ON [PRIMARY]


 CREATE  INDEX [IndiceNota] ON [dbo].[NNEESuplemento]([NumeroNota], [FechaTransaccion]) ON [PRIMARY]


 CREATE  INDEX [NNEENNEESuplemento] ON [dbo].[NNEESuplemento]([NumeroNota]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[NNEESuplemento]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[NotasDCCP] ADD 
	CONSTRAINT [DF_NotasDCCP_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_NotasDCCP_Monto] DEFAULT (0) FOR [Monto],
	CONSTRAINT [DF_NotasDCCP_Saldo] DEFAULT (0) FOR [Saldo]


 CREATE  INDEX [Entidad] ON [dbo].[NotasDCCP]([TipoEntidad], [CodigoEntidad], [FechaDoc], [Numero]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[NotasDCCP]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[ParametrosEmpresa] ADD 
	CONSTRAINT [DF_ParametrosEmpresa_FactorRedondeoPrecios] DEFAULT (0) FOR [FactorRedondeoPrecios],
	CONSTRAINT [DF_ParametrosEmpresa_MesInicioAnho] DEFAULT (0) FOR [MesInicioAnho],
	CONSTRAINT [DF_ParametrosEmpresa_AnhoActual] DEFAULT (0) FOR [AnhoActual],
	CONSTRAINT [DF_ParametrosEmpresa_PeriodoActual] DEFAULT (0) FOR [PeriodoActual],
	CONSTRAINT [DF_ParametrosEmpresa_PComisVenta1] DEFAULT (0) FOR [PComisVenta1],
	CONSTRAINT [DF_ParametrosEmpresa_PComisVenta2] DEFAULT (0) FOR [PComisVenta2],
	CONSTRAINT [DF_ParametrosEmpresa_PComisVenta3] DEFAULT (0) FOR [PComisVenta3],
	CONSTRAINT [DF_ParametrosEmpresa_PComisCobranza1] DEFAULT (0) FOR [PComisCobranza1],
	CONSTRAINT [DF_ParametrosEmpresa_PComisCobranza2] DEFAULT (0) FOR [PComisCobranza2],
	CONSTRAINT [DF_ParametrosEmpresa_PComisCobranza3] DEFAULT (0) FOR [PComisCobranza3],
	CONSTRAINT [DF_ParametrosEmpresa_indexarPrecios] DEFAULT (0) FOR [indexarPrecios],
	CONSTRAINT [DF_ParametrosEmpresa_valoracionInventario] DEFAULT (0) FOR [valoracionInventario],
	CONSTRAINT [DF_ParametrosEmpresa_ProximaMaquina] DEFAULT (1) FOR [ProximaMaquina],
	CONSTRAINT [DF_ParametrosEmpresa_PorcentajeIDB] DEFAULT (0) FOR [PorcentajeIDB],
	CONSTRAINT [DF_ParametrosEmpresa_TipoInventarioEnCurso] DEFAULT (0) FOR [TipoInventarioEnCurso],
	CONSTRAINT [DF_ParametrosEmpresa_CuentaDescuentosCobranza] DEFAULT ('') FOR [CuentaDescuentosCobranza],
	CONSTRAINT [DF_ParametrosEmpresa_ClaveActivacion] DEFAULT (0) FOR [ClaveActivacion],
	CONSTRAINT [DF_ParametrosEmpresa_TipoCambio] DEFAULT (1) FOR [TipoCambio],
  CONSTRAINT [DF_ParametrosEmpresa_Contribuyente] DEFAULT (0) FOR [Contribuyente],
  CONSTRAINT [DF_ParametrosEmpresa_PorcentajeRetencionIVACE] DEFAULT (75) FOR [PorcentajeRetencionIVACE],
  CONSTRAINT [DF_ParametrosEmpresa_ValorActualUT] DEFAULT (29400) FOR [ValorActualUT]

ALTER TABLE [dbo].[Prefijos] ADD 
	CONSTRAINT [DF_Prefijos_Uso] DEFAULT (0) FOR [Uso]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Prefijos]([Prefijo]) ON [PRIMARY]


ALTER TABLE [dbo].[ProveedorProducto] ADD 
	CONSTRAINT [DF_ProveedorProducto_PrecioReferencia] DEFAULT (0) FOR [PrecioReferencia],
	CONSTRAINT [DF_ProveedorProducto_FechaOferta] DEFAULT (getdate()) FOR [FechaOferta],
	CONSTRAINT [DF_ProveedorProducto_PrecioUltimaCompra] DEFAULT (0) FOR [PrecioUltimaCompra],
	CONSTRAINT [DF_ProveedorProducto_FechaUltimaCompra] DEFAULT (getdate()) FOR [FechaUltimaCompra]


 CREATE  UNIQUE  INDEX [iItem] ON [dbo].[ProveedorProducto]([CodigoItem], [CodigoProveedor]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [iProveedor] ON [dbo].[ProveedorProducto]([CodigoProveedor], [CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [itemsInventarioProveedorProducto] ON [dbo].[ProveedorProducto]([CodigoItem]) ON [PRIMARY]


 CREATE  INDEX [ProveedoresProveedorProducto] ON [dbo].[ProveedorProducto]([CodigoProveedor]) ON [PRIMARY]


 CREATE  INDEX [refProveedor] ON [dbo].[ProveedorProducto]([CodigoProveedor], [RefProductoProveedor]) ON [PRIMARY]


ALTER TABLE [dbo].[Proveedores] ADD 
	CONSTRAINT [DF_Proveedores_SaldoActual] DEFAULT (0) FOR [SaldoActual],
	CONSTRAINT [DF_Proveedores_LimiteCredito] DEFAULT (0) FOR [LimiteCredito],
	CONSTRAINT [DF_Proveedores_FechaCreacion] DEFAULT (getdate()) FOR [FechaCreacion]


 CREATE  INDEX [IndiceNombre] ON [dbo].[Proveedores]([Nombre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Proveedores]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[RenglonesConsumoSesion] ADD 
	CONSTRAINT [DF_RenglonesConsumoSesion_OwnerID] DEFAULT (0) FOR [OwnerID],
	CONSTRAINT [DF_RenglonesConsumoSesion_Renglon] DEFAULT (0) FOR [Renglon]


 CREATE  INDEX [OwnerID] ON [dbo].[RenglonesConsumoSesion]([OwnerID]) ON [PRIMARY]


 CREATE  INDEX [PrimaryKey] ON [dbo].[RenglonesConsumoSesion]([OwnerID], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[RenglonesCuentaPOS] ADD 
	CONSTRAINT [DF_RenglonesCuentaPOS_IDCuenta] DEFAULT (0) FOR [IDCuenta],
	CONSTRAINT [DF_RenglonesCuentaPOS_PrecioUnitario] DEFAULT (0) FOR [PrecioUnitario],
	CONSTRAINT [DF_RenglonesCuentaPOS_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_RenglonesCuentaPOS_NumeroRenglon] DEFAULT (0) FOR [NumeroRenglon],
	CONSTRAINT [DF_RenglonesCuentaPOS_Usuario] DEFAULT ('') FOR [Usuario],
	CONSTRAINT [DF_RenglonesCuentaPOS_Precio] DEFAULT (0) FOR [Precio]


 CREATE  INDEX [CuentasPOSRenglonesCuentaPOS] ON [dbo].[RenglonesCuentaPOS]([IDCuenta]) ON [PRIMARY]


 CREATE  INDEX [PrimaryKey] ON [dbo].[RenglonesCuentaPOS]([IDCuenta], [CodigoItem], [PrecioUnitario]) ON [PRIMARY]


ALTER TABLE [dbo].[RenglonesFacturaPOS] ADD 
	CONSTRAINT [DF_RenglonesFacturaPOS_idMaquina] DEFAULT (0) FOR [idMaquina],
	CONSTRAINT [DF_RenglonesFacturaPOS_numeroTicket] DEFAULT (0) FOR [numeroTicket],
	CONSTRAINT [DF_RenglonesFacturaPOS_numeroLinea] DEFAULT (0) FOR [numeroLinea],
	CONSTRAINT [DF_RenglonesFacturaPOS_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_RenglonesFacturaPOS_PrecioUnitario] DEFAULT (0) FOR [PrecioUnitario],
	CONSTRAINT [DF_RenglonesFacturaPOS_PorcentajeImpuesto] DEFAULT (0) FOR [PorcentajeImpuesto],
	CONSTRAINT [DF_RenglonesFacturaPOS_Usuario] DEFAULT ('') FOR [Usuario]


 CREATE  INDEX [FacturasPOSRenglonesFacturaPOS] ON [dbo].[RenglonesFacturaPOS]([idMaquina], [numeroTicket]) ON [PRIMARY]


 CREATE  INDEX [ndxUsuario] ON [dbo].[RenglonesFacturaPOS]([Usuario]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[RenglonesFacturaPOS]([idMaquina], [numeroTicket], [numeroLinea]) ON [PRIMARY]


ALTER TABLE [dbo].[RenglonesSesion] ADD 
	CONSTRAINT [DF_RenglonesSesion_SessionID] DEFAULT (0) FOR [SessionID],
	CONSTRAINT [DF_RenglonesSesion_NumeroRenglon] DEFAULT (0) FOR [NumeroRenglon],
	CONSTRAINT [DF_RenglonesSesion_PrecioUnitario] DEFAULT (0) FOR [PrecioUnitario],
	CONSTRAINT [DF_RenglonesSesion_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_RenglonesSesion_PorcentajeImpuesto] DEFAULT (0) FOR [PorcentajeImpuesto],
	CONSTRAINT [DF_RenglonesSesion_TipoImpuesto] DEFAULT ('') FOR [TipoImpuesto],
	CONSTRAINT [DF_RenglonesSesion_PrecioLista] DEFAULT (0) FOR [PrecioLista],
	CONSTRAINT [DF_RenglonesSesion_Usuario] DEFAULT ('') FOR [Usuario]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[RenglonesSesion]([SessionID], [NumeroRenglon]) ON [PRIMARY]


ALTER TABLE [dbo].[RenglonesTransferencia] ADD 
	CONSTRAINT [DF_RenglonesTransferencia_NumeroTransferencia] DEFAULT (0) FOR [NumeroTransferencia],
	CONSTRAINT [DF_RenglonesTransferencia_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_RenglonesTransferencia_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_RenglonesTransferencia_CostoUnitario] DEFAULT (0) FOR [CostoUnitario]


 CREATE  INDEX [NumeroTransferencia] ON [dbo].[RenglonesTransferencia]([NumeroTransferencia]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[RenglonesTransferencia]([NumeroTransferencia], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[RetencionesISLR] ADD 
	CONSTRAINT [DF_RetencionesISLR_MontoPagado] DEFAULT (0) FOR [MontoPagado],
	CONSTRAINT [DF_RetencionesISLR_MontoRetenido] DEFAULT (0) FOR [MontoRetenido]


 CREATE  INDEX [FechaProv] ON [dbo].[RetencionesISLR]([Fecha], [CodigoProveedor]) ON [PRIMARY]


 CREATE  INDEX [ProvFecha] ON [dbo].[RetencionesISLR]([CodigoProveedor], [Fecha]) ON [PRIMARY]


ALTER TABLE [dbo].[RetencionesIVA] ADD 
	CONSTRAINT [DF_RetencionesIVA_NumFactura] DEFAULT (0) FOR [NumFactura],
	CONSTRAINT [DF_RetencionesIVA_MontoRetencion] DEFAULT (0) FOR [MontoRetencion]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[RetencionesIVA]([Id]) ON [PRIMARY]


ALTER TABLE [dbo].[RetirosPOS] ADD 
	CONSTRAINT [DF_RetirosPOS_idSesion] DEFAULT (0) FOR [idSesion],
	CONSTRAINT [DF_RetirosPOS_Hora] DEFAULT (getdate()) FOR [Hora],
	CONSTRAINT [DF_RetirosPOS_Tipo] DEFAULT (0) FOR [Tipo],
	CONSTRAINT [DF_RetirosPOS_Monto] DEFAULT (0) FOR [Monto]


 CREATE  INDEX [SesionesPOSRetirosPOS] ON [dbo].[RetirosPOS]([idSesion]) ON [PRIMARY]


 CREATE  INDEX [tmSesion] ON [dbo].[RetirosPOS]([idSesion], [Hora]) ON [PRIMARY]


ALTER TABLE [dbo].[SaldosEntidadPeriodo] ADD 
	CONSTRAINT [DF_SaldosEntidadPeriodo_SaldoInicial] DEFAULT (0) FOR [SaldoInicial],
	CONSTRAINT [DF_SaldosEntidadPeriodo_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_SaldosEntidadPeriodo_Creditos] DEFAULT (0) FOR [Creditos]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[SaldosEntidadPeriodo]([TipoEntidad], [CodigoEntidad], [NumeroPeriodo]) ON [PRIMARY]


ALTER TABLE [dbo].[SaldosPeriodo] ADD 
	CONSTRAINT [DF_SaldosPeriodo_NumeroPeriodo] DEFAULT (0) FOR [NumeroPeriodo],
	CONSTRAINT [DF_SaldosPeriodo_SaldoInicial] DEFAULT (0) FOR [SaldoInicial],
	CONSTRAINT [DF_SaldosPeriodo_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_SaldosPeriodo_Creditos] DEFAULT (0) FOR [Creditos]


 CREATE  INDEX [CuentasSaldosPeriodo] ON [dbo].[SaldosPeriodo]([CodigoCuenta]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[SaldosPeriodo]([CodigoCuenta], [NumeroPeriodo]) ON [PRIMARY]


ALTER TABLE [dbo].[Seriales] ADD 
	CONSTRAINT [DF_Seriales_EnStock] DEFAULT (0) FOR [EnStock],
	CONSTRAINT [DF_Seriales_Locked] DEFAULT (0) FOR [Locked]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Seriales]([CodigoItem], [Serial]) ON [PRIMARY]


ALTER TABLE [dbo].[SerialesDetalles] ADD 
	CONSTRAINT [DF_SerialesDetalles_NumeroDetalle] DEFAULT (0) FOR [NumeroDetalle],
	CONSTRAINT [DF_SerialesDetalles_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_SerialesDetalles_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_SerialesDetalles_Tipo] DEFAULT (0) FOR [Tipo],
	CONSTRAINT [DF_SerialesDetalles_isTemporal] DEFAULT (0) FOR [isTemporal],
	CONSTRAINT [DF_SerialesDetalles_prevStatus] DEFAULT (0) FOR [prevStatus]


 CREATE  INDEX [iDocLinea] ON [dbo].[SerialesDetalles]([NumeroDocumento], [TipoDocumento], [Renglon]) ON [PRIMARY]


 CREATE  INDEX [iItem] ON [dbo].[SerialesDetalles]([CodigoItem], [Serial], [FechaTransaccion]) ON [PRIMARY]


 CREATE  INDEX [iSerial] ON [dbo].[SerialesDetalles]([Serial]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[SerialesDetalles]([NumeroDetalle]) ON [PRIMARY]


ALTER TABLE [dbo].[Series] ADD 
	CONSTRAINT [DF_Series_ProximaFactura] DEFAULT (0) FOR [ProximaFactura]


 CREATE  INDEX [Descripcion] ON [dbo].[Series]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Series]([CodigoSerie]) ON [PRIMARY]


ALTER TABLE [dbo].[SesionesCerradas] ADD 
	CONSTRAINT [DF_SesionesCerradas_SessionID] DEFAULT (0) FOR [SessionID],
	CONSTRAINT [DF_SesionesCerradas_TTCAmex] DEFAULT (0) FOR [TTCAmex],
	CONSTRAINT [DF_SesionesCerradas_OtrosMedios] DEFAULT (0) FOR [OtrosMedios],
	CONSTRAINT [DF_SesionesCerradas_Propinas] DEFAULT (0) FOR [Propinas]


 CREATE  INDEX [MachineID] ON [dbo].[SesionesCerradas]([MachineID]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[SesionesCerradas]([SessionID]) ON [PRIMARY]


 CREATE  INDEX [usrID] ON [dbo].[SesionesCerradas]([usrID]) ON [PRIMARY]


ALTER TABLE [dbo].[SesionesPOS] ADD 
	CONSTRAINT [DF_SesionesPOS_MachineID] DEFAULT (0) FOR [MachineID],
	CONSTRAINT [DF_SesionesPOS_Cerrada] DEFAULT (0) FOR [Cerrada],
	CONSTRAINT [DF_SesionesPOS_Fecha] DEFAULT (convert(datetime,floor(convert(float,getdate())))) FOR [Fecha],
	CONSTRAINT [DF_SesionesPOS_StartTime] DEFAULT (getdate()) FOR [StartTime],
	CONSTRAINT [DF_SesionesPOS_ComprobanteAlmacen] DEFAULT (0) FOR [ComprobanteAlmacen],
	CONSTRAINT [DF_SesionesPOS_CurrentAccount] DEFAULT (0) FOR [CurrentAccount],
	CONSTRAINT [DF_SesionesPOS_CurrentAmount] DEFAULT (0) FOR [CurrentAmount],
	CONSTRAINT [DF_SesionesPOS_FacturasRealizadas] DEFAULT (0) FOR [FacturasRealizadas],
	CONSTRAINT [DF_SesionesPOS_MontoFacturado] DEFAULT (0) FOR [MontoFacturado],
	CONSTRAINT [DF_SesionesPOS_ImpuestoCobrado] DEFAULT (0) FOR [ImpuestoCobrado],
	CONSTRAINT [DF_SesionesPOS_EfectivoEnCaja] DEFAULT (0) FOR [EfectivoEnCaja],
	CONSTRAINT [DF_SesionesPOS_TTCVisa] DEFAULT (0) FOR [TTCVisa],
	CONSTRAINT [DF_SesionesPOS_TTCMaster] DEFAULT (0) FOR [TTCMaster],
	CONSTRAINT [DF_SesionesPOS_TTCOtras] DEFAULT (0) FOR [TTCOtras],
	CONSTRAINT [DF_SesionesPOS_TDebito] DEFAULT (0) FOR [TDebito],
	CONSTRAINT [DF_SesionesPOS_ChequesEnCaja] DEFAULT (0) FOR [ChequesEnCaja],
	CONSTRAINT [DF_SesionesPOS_Anulaciones] DEFAULT (0) FOR [Anulaciones],
	CONSTRAINT [DF_SesionesPOS_MontoAnulaciones] DEFAULT (0) FOR [MontoAnulaciones],
	CONSTRAINT [DF_SesionesPOS_ImpuestoAnulado] DEFAULT (0) FOR [ImpuestoAnulado],
	CONSTRAINT [DF_SesionesPOS_Retiros] DEFAULT (0) FOR [Retiros],
	CONSTRAINT [DF_SesionesPOS_MontoRetirado] DEFAULT (0) FOR [MontoRetirado],
	CONSTRAINT [DF_SesionesPOS_CobrosRealizados] DEFAULT (0) FOR [CobrosRealizados],
	CONSTRAINT [DF_SesionesPOS_MontoCobrado] DEFAULT (0) FOR [MontoCobrado],
	CONSTRAINT [DF_SesionesPOS_ServicioCobrado] DEFAULT (0) FOR [ServicioCobrado],
	CONSTRAINT [DF_SesionesPOS_ServicioAnulado] DEFAULT (0) FOR [ServicioAnulado],
	CONSTRAINT [DF_SesionesPOS_VentasACredito] DEFAULT (0) FOR [VentasACredito],
	CONSTRAINT [DF_SesionesPOS_MontoEnCaja] DEFAULT (0) FOR [MontoEnCaja],
	CONSTRAINT [DF_SesionesPOS_TTCAmex] DEFAULT (0) FOR [TTCAmex],
	CONSTRAINT [DF_SesionesPOS_OtrosMedios] DEFAULT (0) FOR [OtrosMedios],
	CONSTRAINT [DF_SesionesPOS_Propinas] DEFAULT (0) FOR [Propinas]


 CREATE  INDEX [MachineID] ON [dbo].[SesionesPOS]([MachineID]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[SesionesPOS]([SessionID]) ON [PRIMARY]


 CREATE  INDEX [usrID] ON [dbo].[SesionesPOS]([usrID]) ON [PRIMARY]


 CREATE  INDEX [IndiceDescripcion] ON [dbo].[SubLineas]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[SubLineas]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[TarjetasCredito] ADD 
	CONSTRAINT [DF_TarjetasCredito_PorcentajeComision] DEFAULT (0) FOR [PorcentajeComision],
	CONSTRAINT [DF_TarjetasCredito_PorcentajeISLR] DEFAULT (0) FOR [PorcentajeISLR]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[TarjetasCredito]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [IndiceDescripcion] ON [dbo].[TiposCliente]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[TiposCliente]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[TiposCuentaPOS] ADD 
	CONSTRAINT [DF_TiposCuentaPOS_Base] DEFAULT (0) FOR [Base],
	CONSTRAINT [DF_TiposCuentaPOS_Porcentaje] DEFAULT (0) FOR [Porcentaje],
	CONSTRAINT [DF_TiposCuentaPOS_IndicePrecio] DEFAULT (1) FOR [IndicePrecio]


ALTER TABLE [dbo].[TiposImpuesto] ADD 
	CONSTRAINT [DF_TiposImpuesto_Porcentaje] DEFAULT (0) FOR [Porcentaje]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[TiposImpuesto]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[Transferencias] ADD 
	CONSTRAINT [DF_Transferencias_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_Transferencias_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Transferencias]([Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[Unidades] ADD 
	CONSTRAINT [DF_Unidades_Factor] DEFAULT (0) FOR [Factor]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Unidades]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [IndiceDescripcion] ON [dbo].[UnidadesFuncionales]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[UnidadesFuncionales]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[Usuarios] ADD 
	CONSTRAINT [DF_Usuarios_Clave] DEFAULT (0) FOR [Clave],
	CONSTRAINT [DF_Usuarios_Nivel] DEFAULT (0) FOR [Nivel]


 CREATE  INDEX [ClaveUsuario] ON [dbo].[Usuarios]([Clave]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Usuarios]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[VencimientosISPC] ADD 
	CONSTRAINT [DF_VencimientosISPC_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_VencimientosISPC_Monto] DEFAULT (0) FOR [Monto]


 CREATE  INDEX [DocumentosISPCVencimientosISPC] ON [dbo].[VencimientosISPC]([NumeroDocumento]) ON [PRIMARY]


 CREATE  INDEX [FechaVencimiento] ON [dbo].[VencimientosISPC]([FechaVencimiento]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[VencimientosISPC]([NumeroDocumento], [FechaVencimiento]) ON [PRIMARY]


ALTER TABLE [dbo].[Vendedores] ADD 
	CONSTRAINT [DF_Vendedores_TipoComisionVenta] DEFAULT (0) FOR [TipoComisionVenta],
	CONSTRAINT [DF_Vendedores_TipoComisionCobranza] DEFAULT (0) FOR [TipoComisionCobranza],
	CONSTRAINT [DF_Vendedores_SaldoActual] DEFAULT (0) FOR [SaldoActual],
	CONSTRAINT [DF_Vendedores_FechaCreacion] DEFAULT (getdate()) FOR [FechaCreacion]


 CREATE  INDEX [Nombre] ON [dbo].[Vendedores]([Nombre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Vendedores]([Codigo]) ON [PRIMARY]


 CREATE  INDEX [IndiceDescripcion] ON [dbo].[Zonas]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[Zonas]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[itemsComanda] ADD 
	CONSTRAINT [DF_itemsComanda_Precio1] DEFAULT (0) FOR [Precio1],
	CONSTRAINT [DF_itemsComanda_UsaExtras] DEFAULT (0) FOR [UsaExtras],
	CONSTRAINT [DF_itemsComanda_UsaRemovibles] DEFAULT (0) FOR [UsaRemovibles],
	CONSTRAINT [DF_itemsComanda_UsaContornos] DEFAULT (0) FOR [UsaContornos],
	CONSTRAINT [DF_itemsComanda_ExtrasGratis] DEFAULT (0) FOR [ExtrasGratis],
	CONSTRAINT [DF_itemsComanda_TipoImpuesto1] DEFAULT ('"IV1"') FOR [TipoImpuesto1]


 CREATE  INDEX [Descripcion] ON [dbo].[itemsComanda]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[itemsComanda]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[itemsInventario] ADD 
	CONSTRAINT [DF_itemsInventario_CostoPromedio] DEFAULT (0) FOR [CostoPromedio],
	CONSTRAINT [DF_itemsInventario_UltimoCosto] DEFAULT (0) FOR [UltimoCosto],
	CONSTRAINT [DF_itemsInventario_Existencia] DEFAULT (0) FOR [Existencia],
	CONSTRAINT [DF_itemsInventario_Asignadas] DEFAULT (0) FOR [Asignadas],
	CONSTRAINT [DF_itemsInventario_EnTransito] DEFAULT (0) FOR [EnTransito],
	CONSTRAINT [DF_itemsInventario_PrecioUltimaCompra] DEFAULT (0) FOR [PrecioUltimaCompra],
	CONSTRAINT [DF_itemsInventario_CantidadEmpaque] DEFAULT (0) FOR [CantidadEmpaque],
	CONSTRAINT [DF_itemsInventario_ExistenciaMinima] DEFAULT (0) FOR [ExistenciaMinima],
	CONSTRAINT [DF_itemsInventario_ExistenciaMaxima] DEFAULT (0) FOR [ExistenciaMaxima],
	CONSTRAINT [DF_itemsInventario_UsaSeriales] DEFAULT (0) FOR [UsaSeriales],
	CONSTRAINT [DF_itemsInventario_FechaCreacion] DEFAULT (getdate()) FOR [FechaCreacion]


 CREATE  INDEX [Descripcion] ON [dbo].[itemsInventario]([Descripcion]) ON [PRIMARY]


 CREATE  INDEX [Grupo] ON [dbo].[itemsInventario]([Grupo], [Codigo]) ON [PRIMARY]


 CREATE  INDEX [LineaCodigo] ON [dbo].[itemsInventario]([Linea], [Codigo]) ON [PRIMARY]


 CREATE  INDEX [LineaDescripcion] ON [dbo].[itemsInventario]([Linea], [Descripcion]) ON [PRIMARY]


 CREATE  INDEX [LineaGrupo] ON [dbo].[itemsInventario]([Linea], [Grupo], [Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[itemsInventario]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[mesasAmbientes] ADD 
	CONSTRAINT [DF_mesasAmbientes_AccountOffset] DEFAULT (0) FOR [AccountOffset],
	CONSTRAINT [DF_mesasAmbientes_PorcentajeServicio] DEFAULT (0) FOR [PorcentajeServicio],
	CONSTRAINT [DF_mesasAmbientes_IndicePrecio] DEFAULT (0) FOR [IndicePrecio],
	CONSTRAINT [DF_mesasAmbientes_Escala] DEFAULT (0) FOR [Escala],
	CONSTRAINT [DF_mesasAmbientes_BackColor] DEFAULT (0) FOR [BackColor],
	CONSTRAINT [DF_mesasAmbientes_ColorSillas] DEFAULT (0) FOR [ColorSillas],
	CONSTRAINT [DF_mesasAmbientes_ColorMesas] DEFAULT (0) FOR [ColorMesas],
	CONSTRAINT [DF_mesasAmbientes_FormaMesas] DEFAULT (0) FOR [FormaMesas],
	CONSTRAINT [DF_mesasAmbientes_FormaSillas] DEFAULT (0) FOR [FormaSillas]


 CREATE  UNIQUE  INDEX [Account] ON [dbo].[mesasAmbientes]([AccountOffset]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [Prefijo] ON [dbo].[mesasAmbientes]([Prefijo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[mesasAmbientes]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[mesasItems] ADD 
	CONSTRAINT [DF_mesasItems_Precio] DEFAULT (0) FOR [Precio]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[mesasItems]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[mesasMesas] ADD 
	CONSTRAINT [DF_mesasMesas_IDMesa] DEFAULT (0) FOR [IDMesa],
	CONSTRAINT [DF_mesasMesas_x] DEFAULT (0) FOR [x],
	CONSTRAINT [DF_mesasMesas_y] DEFAULT (0) FOR [y],
	CONSTRAINT [DF_mesasMesas_enmStat] DEFAULT (0) FOR [enmStat],
	CONSTRAINT [DF_mesasMesas_nPersonas] DEFAULT (0) FOR [nPersonas],
	CONSTRAINT [DF_mesasMesas_cMesonero] DEFAULT ('') FOR [cMesonero],
	CONSTRAINT [DF_mesasMesas_MontoDespachado] DEFAULT (0) FOR [MontoDespachado],
	CONSTRAINT [DF_mesasMesas_Cuenta] DEFAULT (0) FOR [Cuenta]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[mesasMesas]([Ambiente], [IDMesa]) ON [PRIMARY]


ALTER TABLE [dbo].[mnuItems] ADD 
	CONSTRAINT [DF_mnuItems_Posicion] DEFAULT (0) FOR [Posicion],
	CONSTRAINT [DF_mnuItems_isTerminal] DEFAULT (0) FOR [isTerminal],
	CONSTRAINT [DF_mnuItems_Imagen] DEFAULT ('"imageNA"') FOR [Imagen]


 CREATE  INDEX [item] ON [dbo].[mnuItems]([CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[mnuItems]([ownerMenu], [Posicion]) ON [PRIMARY]


ALTER TABLE [dbo].[nomAsigDedScript] ADD 
	CONSTRAINT [DF_nomAsigDedScript_Orden] DEFAULT (0) FOR [Orden]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomAsigDedScript]([CodigoScript], [codigoAsigDed]) ON [PRIMARY]


ALTER TABLE [dbo].[nomAtribTrabajador] ADD 
	CONSTRAINT [DF_nomAtribTrabajador_ValAttrib] DEFAULT (0) FOR [ValAttrib]


 CREATE  INDEX [CodAttrib] ON [dbo].[nomAtribTrabajador]([CodAttrib]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomAtribTrabajador]([CodTrab], [CodAttrib]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomCategoriasLaborales]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomCodigosRecibo]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomCodigosReporte]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[nomDefAsigDed] ADD 
	CONSTRAINT [DF_nomDefAsigDed_Tipo] DEFAULT (0) FOR [Tipo]


 CREATE  INDEX [I1] ON [dbo].[nomDefAsigDed]([Descripcion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomDefAsigDed]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomDepartamentos]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomDescCargos]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[nomDescHabilidad] ADD 
	CONSTRAINT [DF_nomDescHabilidad_MinRango] DEFAULT (0) FOR [MinRango],
	CONSTRAINT [DF_nomDescHabilidad_MaxRango] DEFAULT (0) FOR [MaxRango]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomDescHabilidad]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[nomDetallesProceso] ADD 
	CONSTRAINT [DF_nomDetallesProceso_ProcessID] DEFAULT (0) FOR [ProcessID],
	CONSTRAINT [DF_nomDetallesProceso_Tipo] DEFAULT (0) FOR [Tipo],
	CONSTRAINT [DF_nomDetallesProceso_Valor] DEFAULT (0) FOR [Valor]


 CREATE  INDEX [I1] ON [dbo].[nomDetallesProceso]([Trabajador], [ClaseLaboral], [FechaCierre]) ON [PRIMARY]


 CREATE  INDEX [I2] ON [dbo].[nomDetallesProceso]([Trabajador], [CodigoReporte], [FechaCierre]) ON [PRIMARY]


 CREATE  INDEX [I3] ON [dbo].[nomDetallesProceso]([Trabajador], [ProcessID]) ON [PRIMARY]


 CREATE  INDEX [I4] ON [dbo].[nomDetallesProceso]([ProcessID], [Trabajador]) ON [PRIMARY]


ALTER TABLE [dbo].[nomDetallesRecibo] ADD 
	CONSTRAINT [DF_nomDetallesRecibo_numeroProceso] DEFAULT (0) FOR [numeroProceso],
	CONSTRAINT [DF_nomDetallesRecibo_varType] DEFAULT (0) FOR [varType]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomDetallesRecibo]([numeroProceso], [codigoTrabajador], [varID]) ON [PRIMARY]


 CREATE  INDEX [varID] ON [dbo].[nomDetallesRecibo]([varID]) ON [PRIMARY]


ALTER TABLE [dbo].[nomEnumHabilidades] ADD 
	CONSTRAINT [DF_nomEnumHabilidades_Valor] DEFAULT (0) FOR [Valor]


 CREATE  INDEX [Enumerador] ON [dbo].[nomEnumHabilidades]([Enumerador]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomEnumHabilidades]([CodigoHabilidad], [Valor]) ON [PRIMARY]


ALTER TABLE [dbo].[nomExcepciones] ADD 
	CONSTRAINT [DF_nomExcepciones_NumeroId] DEFAULT (0) FOR [NumeroId],
	CONSTRAINT [DF_nomExcepciones_Valor] DEFAULT (0) FOR [Valor],
	CONSTRAINT [DF_nomExcepciones_TipoRecurrencia] DEFAULT (0) FOR [TipoRecurrencia],
	CONSTRAINT [DF_nomExcepciones_Recurrencia] DEFAULT (0) FOR [Recurrencia]


 CREATE  INDEX [CodTrabajador] ON [dbo].[nomExcepciones]([CodTrabajador], [Fecha], [NumeroId]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomExcepciones]([NumeroId]) ON [PRIMARY]


ALTER TABLE [dbo].[nomFiltros] ADD 
	CONSTRAINT [DF_nomFiltros_valorDesde] DEFAULT ('') FOR [valorDesde],
	CONSTRAINT [DF_nomFiltros_valorHasta] DEFAULT ('') FOR [valorHasta]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomFiltros]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomFiltrosScript]([CodigoScript], [codigoFiltro]) ON [PRIMARY]


ALTER TABLE [dbo].[nomHabilidadesTrabajador] ADD 
	CONSTRAINT [DF_nomHabilidadesTrabajador_Grado] DEFAULT (0) FOR [Grado]


 CREATE  INDEX [CodigoHabilidad] ON [dbo].[nomHabilidadesTrabajador]([CodigoHabilidad]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomHabilidadesTrabajador]([CodigoTrabajador], [CodigoHabilidad]) ON [PRIMARY]


 CREATE  INDEX [TrabHabil] ON [dbo].[nomHabilidadesTrabajador]([CodigoHabilidad], [CodigoTrabajador]) ON [PRIMARY]


ALTER TABLE [dbo].[nomHistTrab] ADD 
	CONSTRAINT [DF_nomHistTrab_Sueldo] DEFAULT (0) FOR [Sueldo],
	CONSTRAINT [DF_nomHistTrab_Base] DEFAULT (0) FOR [Base]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomHistTrab]([CodigoTrabajador], [Desde]) ON [PRIMARY]


ALTER TABLE [dbo].[nomObservaciones] ADD 
	CONSTRAINT [DF_nomObservaciones_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_nomObservaciones_Fecha] DEFAULT (getdate()) FOR [Fecha]


 CREATE  INDEX [CodTrabFecha] ON [dbo].[nomObservaciones]([CodigoTrabajador], [Fecha], [Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[nomPagosProceso] ADD 
	CONSTRAINT [DF_nomPagosProceso_ProcessID] DEFAULT (0) FOR [ProcessID],
	CONSTRAINT [DF_nomPagosProceso_MontoPagado] DEFAULT (0) FOR [MontoPagado]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomPagosProceso]([ProcessID], [Trabajador]) ON [PRIMARY]


 CREATE  INDEX [ProcessID] ON [dbo].[nomPagosProceso]([ProcessID]) ON [PRIMARY]


ALTER TABLE [dbo].[nomProcesos] ADD 
	CONSTRAINT [DF_nomProcesos_Numero] DEFAULT (0) FOR [Numero]


 CREATE  INDEX [I1] ON [dbo].[nomProcesos]([CodigoScript], [FechaInicioPeriodo]) ON [PRIMARY]


 CREATE  INDEX [I2] ON [dbo].[nomProcesos]([CodigoScript], [FechaFinPeriodo]) ON [PRIMARY]


 CREATE  INDEX [I3] ON [dbo].[nomProcesos]([CodigoScript], [FechaCierre]) ON [PRIMARY]


 CREATE  INDEX [I4] ON [dbo].[nomProcesos]([FechaCierre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomProcesos]([Numero]) ON [PRIMARY]


 CREATE  INDEX [I1] ON [dbo].[nomRecibosScript]([CodigoScript], [FileName]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomScripts]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[nomTMPListaExcepciones] ADD 
	CONSTRAINT [DF_nomTMPListaExcepciones_NumeroId] DEFAULT (0) FOR [NumeroId],
	CONSTRAINT [DF_nomTMPListaExcepciones_Valor] DEFAULT (0) FOR [Valor],
	CONSTRAINT [DF_nomTMPListaExcepciones_TipoRecurrencia] DEFAULT (0) FOR [TipoRecurrencia],
	CONSTRAINT [DF_nomTMPListaExcepciones_Recurrencia] DEFAULT (0) FOR [Recurrencia]


 CREATE  INDEX [CodExcepcion] ON [dbo].[nomTMPListaExcepciones]([NumeroId], [CodExcepcion], [Fecha]) ON [PRIMARY]


 CREATE  INDEX [CodTrabajador] ON [dbo].[nomTMPListaExcepciones]([NumeroId], [CodTrabajador], [CodExcepcion], [Fecha]) ON [PRIMARY]


ALTER TABLE [dbo].[nomTMPResumenProceso] ADD 
	CONSTRAINT [DF_nomTMPResumenProceso_nTipo] DEFAULT (0) FOR [nTipo],
	CONSTRAINT [DF_nomTMPResumenProceso_vmValor] DEFAULT (0) FOR [vmValor]


 CREATE  INDEX [I1] ON [dbo].[nomTMPResumenProceso]([sUserID], [sCodDept], [sCodTrab], [nTipo], [sCodGrup]) ON [PRIMARY]


 CREATE  INDEX [sUserID] ON [dbo].[nomTMPResumenProceso]([sUserID]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomTiposAtributo]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[nomTiposExcepcion] ADD 
	CONSTRAINT [DF_nomTiposExcepcion_Visible] DEFAULT ((-1)) FOR [Visible]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomTiposExcepcion]([Codigo]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomTiposObservacion]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[nomTrabajadores] ADD 
	CONSTRAINT [DF_nomTrabajadores_FechaAsignacion] DEFAULT ('#1/1/1980#') FOR [FechaAsignacion],
	CONSTRAINT [DF_nomTrabajadores_Sueldo] DEFAULT (0) FOR [Sueldo],
	CONSTRAINT [DF_nomTrabajadores_BaseSueldo] DEFAULT (0) FOR [BaseSueldo],
	CONSTRAINT [DF_nomTrabajadores_Sexo] DEFAULT (0) FOR [Sexo],
	CONSTRAINT [DF_nomTrabajadores_EstadoCivil] DEFAULT (0) FOR [EstadoCivil],
	CONSTRAINT [DF_nomTrabajadores_NumeroDeHijos] DEFAULT (0) FOR [NumeroDeHijos],
	CONSTRAINT [DF_nomTrabajadores_Activo] DEFAULT ('True') FOR [Activo],
	CONSTRAINT [DF_nomTrabajadores_EstadoAcceso] DEFAULT (0) FOR [EstadoAcceso]


 CREATE  INDEX [CI] ON [dbo].[nomTrabajadores]([CI]) ON [PRIMARY]


 CREATE  INDEX [Nombre] ON [dbo].[nomTrabajadores]([Nombre]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[nomTrabajadores]([Codigo]) ON [PRIMARY]


ALTER TABLE [dbo].[ocDetalles] ADD 
	CONSTRAINT [DF_ocDetalles_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento],
	CONSTRAINT [DF_ocDetalles_Renglon] DEFAULT (0) FOR [Renglon],
	CONSTRAINT [DF_ocDetalles_FactorEmpaque] DEFAULT (0) FOR [FactorEmpaque],
	CONSTRAINT [DF_ocDetalles_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_ocDetalles_PrecioRequerido] DEFAULT (0) FOR [PrecioRequerido],
	CONSTRAINT [DF_ocDetalles_Recibidas] DEFAULT (0) FOR [Recibidas],
	CONSTRAINT [DF_ocDetalles_PrecioMedio] DEFAULT (0) FOR [PrecioMedio],
	CONSTRAINT [DF_ocDetalles_CantPaga] DEFAULT (0) FOR [CantPaga],
	CONSTRAINT [DF_ocDetalles_CantPromo] DEFAULT (0) FOR [CantPromo],
	CONSTRAINT [DF_ocDetalles_PVP] DEFAULT (0) FOR [PVP]


 CREATE  INDEX [CodigoItem] ON [dbo].[ocDetalles]([CodigoItem]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ocDetalles]([NumeroDocumento], [Renglon]) ON [PRIMARY]


ALTER TABLE [dbo].[ocOrdenes] ADD 
	CONSTRAINT [DF_ocOrdenes_Numero] DEFAULT (0) FOR [Numero],
	CONSTRAINT [DF_ocOrdenes_FechaRegistro] DEFAULT (getdate()) FOR [FechaRegistro],
	CONSTRAINT [DF_ocOrdenes_Estado] DEFAULT (0) FOR [Estado],
	CONSTRAINT [DF_ocOrdenes_ValorNominal] DEFAULT (0) FOR [ValorNominal],
	CONSTRAINT [DF_ocOrdenes_Descuento1] DEFAULT (0) FOR [Descuento1],
	CONSTRAINT [DF_ocOrdenes_Descuento2] DEFAULT (0) FOR [Descuento2]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[ocOrdenes]([Numero]) ON [PRIMARY]


 CREATE  INDEX [Proveedor] ON [dbo].[ocOrdenes]([CodigoProveedor], [FechaTransaccion], [Numero]) ON [PRIMARY]


ALTER TABLE [dbo].[ocRecibidas] ADD 
	CONSTRAINT [DF_ocRecibidas_NumeroOrden] DEFAULT (0) FOR [NumeroOrden],
	CONSTRAINT [DF_ocRecibidas_NumeroRenglon] DEFAULT (0) FOR [NumeroRenglon],
	CONSTRAINT [DF_ocRecibidas_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_ocRecibidas_PrecioUnitario] DEFAULT (0) FOR [PrecioUnitario],
	CONSTRAINT [DF_ocRecibidas_Factor] DEFAULT (0) FOR [Factor],
	CONSTRAINT [DF_ocRecibidas_NumeroDocumento] DEFAULT (0) FOR [NumeroDocumento]


 CREATE  INDEX [Renglon] ON [dbo].[ocRecibidas]([NumeroOrden], [NumeroRenglon], [Fecha]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[perfilDescripcion]([CodigoPerfil]) ON [PRIMARY]


ALTER TABLE [dbo].[perfilElementos] ADD 
	CONSTRAINT [DF_perfilElementos_Valor] DEFAULT (0) FOR [Valor],
	CONSTRAINT [DF_perfilElementos_Posicion] DEFAULT (0) FOR [Posicion]


 CREATE  INDEX [Posicion] ON [dbo].[perfilElementos]([Posicion]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[perfilElementos]([Valor]) ON [PRIMARY]


ALTER TABLE [dbo].[perfilesPermisos] ADD 
	CONSTRAINT [DF_perfilesPermisos_Permiso] DEFAULT (0) FOR [Permiso]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[perfilesPermisos]([CodigoPerfil], [Permiso]) ON [PRIMARY]


ALTER TABLE [dbo].[rpBalanceGeneral] ADD 
	CONSTRAINT [DF_rpBalanceGeneral_SaldoNivel0] DEFAULT (0) FOR [SaldoNivel0],
	CONSTRAINT [DF_rpBalanceGeneral_SaldoNivel1] DEFAULT (0) FOR [SaldoNivel1],
	CONSTRAINT [DF_rpBalanceGeneral_SaldoNivel2] DEFAULT (0) FOR [SaldoNivel2],
	CONSTRAINT [DF_rpBalanceGeneral_SaldoNivel3] DEFAULT (0) FOR [SaldoNivel3]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[rpBalanceGeneral]([CodigoCuenta]) ON [PRIMARY]


ALTER TABLE [dbo].[subDocsMB] ADD 
	CONSTRAINT [DF_subDocsMB_TransID] DEFAULT (0) FOR [TransID],
	CONSTRAINT [DF_subDocsMB_NumDoc] DEFAULT (0) FOR [NumDoc],
	CONSTRAINT [DF_subDocsMB_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_subDocsMB_Creditos] DEFAULT (0) FOR [Creditos]


 CREATE  INDEX [MovimientosCajasubDocsMC] ON [dbo].[subDocsMB]([TransID]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[subDocsMB]([ID]) ON [PRIMARY]


 CREATE  INDEX [TransID] ON [dbo].[subDocsMB]([TransID]) ON [PRIMARY]


ALTER TABLE [dbo].[subDocsMC] ADD 
	CONSTRAINT [DF_subDocsMC_TransID] DEFAULT (0) FOR [TransID],
	CONSTRAINT [DF_subDocsMC_NumDoc] DEFAULT (0) FOR [NumDoc],
	CONSTRAINT [DF_subDocsMC_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_subDocsMC_Creditos] DEFAULT (0) FOR [Creditos]


 CREATE  INDEX [MovimientosCajasubDocsMC] ON [dbo].[subDocsMC]([TransID]) ON [PRIMARY]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[subDocsMC]([ID]) ON [PRIMARY]


 CREATE  INDEX [TransID] ON [dbo].[subDocsMC]([TransID]) ON [PRIMARY]


ALTER TABLE [dbo].[tmpResumenPOS] ADD 
	CONSTRAINT [DF_tmpResumenPOS_Sesion] DEFAULT (0) FOR [Sesion],
	CONSTRAINT [DF_tmpResumenPOS_Precio] DEFAULT (0) FOR [Precio],
	CONSTRAINT [DF_tmpResumenPOS_Cantidad] DEFAULT (0) FOR [Cantidad],
	CONSTRAINT [DF_tmpResumenPOS_PorcentajeImpuesto] DEFAULT (0) FOR [PorcentajeImpuesto],
	CONSTRAINT [DF_tmpResumenPOS_Fecha] DEFAULT (getdate()) FOR [Fecha]


 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[tmpResumenPOS]([Sesion], [Producto], [Precio]) ON [PRIMARY]


 CREATE  INDEX [Producto] ON [dbo].[tmpResumenPOS]([Producto], [Sesion]) ON [PRIMARY]


ALTER TABLE [dbo].[tmpSaldos] ADD 
	CONSTRAINT [DF_tmpSaldos_SaldoInicial] DEFAULT (0) FOR [SaldoInicial],
	CONSTRAINT [DF_tmpSaldos_Debitos] DEFAULT (0) FOR [Debitos],
	CONSTRAINT [DF_tmpSaldos_Creditos] DEFAULT (0) FOR [Creditos]

 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[tmpSaldos]([TipoEntidad], [CodigoEntidad], [NumeroPeriodo]) ON [PRIMARY]

 CREATE  INDEX [iFactura] ON [dbo].[valoresCaja]([MachineID], [NumDoc], [Numero]) ON [PRIMARY]

 CREATE  UNIQUE  INDEX [PrimaryKey] ON [dbo].[valoresCaja]([Numero]) ON [PRIMARY]



	INSERT INTO [dbo].[Condiciones] (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C00', 'Contado contra entrega', 0, '', 1);

	INSERT INTO [dbo].[Condiciones] (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C07', 'Credito a siete dias', 0, '', 1);

	INSERT INTO [dbo].[Condiciones] (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C15', 'Credito a quince dias', 0, '', 1);

	INSERT INTO [dbo].[Condiciones] (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C30', 'Credito a treinta dias', 0, '', 1);

	INSERT INTO [dbo].[Condiciones] (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C3060', 'Credito a 30 y 60 dias', 0, '', 2);

	INSERT INTO [dbo].[Condiciones] (Codigo, Descripcion, Modo, CuentaIngresos, nCuotas)
		VALUES ('C306090', 'Credito a 30, 60 y 90 dias', 0, '', 3);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C00', 1, 0, 100);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C07', 1, 7, 100);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C15', 1, 15, 100);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C30', 1, 30, 100);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C3060', 1, 30, 50);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C3060', 2, 60, 50);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C306090', 1, 30, 33.3);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C306090', 2, 60, 33.3);

	INSERT INTO [dbo].[CondicVen] (CodigoCondicion, Correlativo, Plazo, Porcentaje)
		VALUES ('C306090', 3, 90, 33.4);



	INSERT INTO [dbo].[TiposImpuesto] (Codigo, Descripcion, Porcentaje, VigenteDesde, VigenteHasta, CUenta)
		VALUES ('EXE', 'EXENTO', 0, '1980-1-1', '2079-12-31', '');

	INSERT INTO [dbo].[TiposImpuesto] (Codigo, Descripcion, Porcentaje, VigenteDesde, VigenteHasta, CUenta)
		VALUES ('IV1', 'TASA GENERAL', 14, '1980-1-1', '2079-12-31', '');

	INSERT INTO [dbo].[TiposImpuesto] (Codigo, Descripcion, Porcentaje, VigenteDesde, VigenteHasta, CUenta)
		VALUES ('IV2', 'TASA PREFERENCIAL', 8, '1980-1-1', '2079-12-31', '');




	INSERT INTO [dbo].[Usuarios] (Codigo, Clave, Nivel, Nombre, Perfil) 
		VALUES ('ADMIN', 14933, 5, 'Administrador del sistema', 'SUPER');




	INSERT INTO [dbo].[Almacenes] (Codigo, Nombre, CUentaActivo)
		VALUES ('GENERAL', 'ALMACEN GENERAL', '');



	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 0 , 'Cambiar empresa seleccionada',  0 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 17 , 'Cambiar impresora seleccionada',  100 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 1 , 'Operar fichas de inventario',  200 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 2 , 'Operar fichas de bancos',  300 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 3 , 'Operar fichas de Clientes',  400 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 4 , 'Operar fichas de cuentas',  500 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 5 , 'Operar fichas de Productos',  600 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 56 , 'Definir Teclas Programables',  610 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 6 , 'Operar fichas de proveedores',  700 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 45 , 'Operar Fichas de Trabajadores',  710 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 51 , 'Registrar Nuevos Trabajadores',  720 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 52 , 'Eliminar Trabajadores',  721 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 53 , 'Modificar fichas de trabajadores',  722 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 16 , 'Operar fichas de vendedores',  800 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 15 , 'Abrir fichas de usuarios (!!!)',  900 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 43 , 'Editar perfiles de usuario (!!)',  950 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 18 , 'Registrar cobranzas',  1000 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 19 , 'Registrar egresos de caja',  1100 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 20 , 'Anotar cheques emitidos',  1200 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 21 , 'Registrar pagos a proveedores',  1300 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 22 , 'Registrar depsitos bancarios',  1400 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 23 , 'Emitir notas de credito o debito',  1500 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 24 , 'Cerrar sesiones de caja',  1600 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 25 , 'Pasar facturas de compra',  1700 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 26 , 'Registrar devoluciones de compras',  1800 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 27 , 'Registrar crditos fiscales',  1900 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 28 , 'Transcribir comprobantes contables',  2000 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 29 , 'Eliminar comprobantres contables',  2100 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 30 , 'Modificar comprobantes contables',  2200 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 31 , 'Registrar ajustes de inventario',  2300 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 32 , 'Registrar transferencias de mercancia',  2400 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 33 , 'Realizar facturas',  2500 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 44 , 'Elaborar Cotizaciones',  2510 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 34 , 'Devolucion de ventas',  2600 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 35 , 'Ver reportes de compras',  2700 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 36 , 'Ver reportes contables',  2800 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 37 , 'Ver reportes de CxC',  2900 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 38 , 'Ver reportes de CxP',  3000 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 39 , 'Ver reportes de inventario',  3100 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 40 , 'Ver reportes de ventas',  3200 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 41 , 'Ver estados de cuenta generales',  3300 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 42 , 'Ver reportes de usuario',  3400 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 7 , 'Abrir forma de almacenes',  3600 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 8 , 'Mantener lineas de inventario',  3700 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 9 , 'Mantener condiciones de crdito',  3800 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 10 , 'Mantener definiciones de impuestos',  3900 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 11 , 'Mantener lineas de productos',  4000 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 12 , 'Modificar definiciones de Tarjetas de Credito',  4100 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 13 , 'Mantener tipos de clientes',  4200 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 14 , 'Mantener zonas',  4300 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 48 , 'Cargar Excepciones (Nomina)',  4400 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 47 , 'Definir Categoras Laborales',  4405 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 49 , 'Definir Cargos (Nomina)',  4410 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 55 , 'Modificar Tabla de Departamentos',  4420 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 46 , 'Definir ADAP (Nomina)',  4500 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 50 , 'Definir Procesos de Nomina',  4510 );
	INSERT INTO [dbo].[perfilElementos] (Valor, Descripcion, Posicion) VALUES ( 54 , 'Definir Filtros',  4520 );

 CREATE TABLE MediosPago (
  Codigo nVarChar (8) PRIMARY KEY NOT NULL,
  Descripcion nVarChar(24) NOT NULL,
  Atributos INT NOT NULL DEFAULT 0,
  PorcentajeRetencionEmisor float NOT NULL default 0,
  PorcentajeISLR float NOT NULL default 0,
  CuentaActivo nVarchar(20) NOT NULL DEFAULT '',
  CuentaComisiones NVARCHAR(20) NOT NULL DEFAULT '',
  BancoRelacionado NVARCHAR(20) NOT NULL DEFAULT '',
  Clase SMALLINT NOT NULL DEFAULT 0
);

CREATE TABLE RelacionesIVARetenido (
	NumeroRetencion bigint PRIMARY KEY NOT NULL ,
	Fecha datetime NOT NULL ,
	Operador nvarchar (20) NOT NULL ,
	AnhoFiscal int NOT NULL ,
	Mes int NOT NULL ,
	RifProveedor nvarchar (13) NOT NULL ,
	NombreProveedor nvarchar (50) NOT NULL, 
	Numero bigint IDENTITY (1, 1) NOT NULL
);

CREATE INDEX IX_Numero ON RelacionesIVARetenido (Numero);

CREATE TABLE DocumentosFiscales (
  Id bigint NOT NULL IDENTITY (1, 1) PRIMARY KEY,
  Fecha datetime NOT NULL default getdate(),
  TipoDoc nvarchar(3) NOT NULL default '',
  NumeroDoc bigint NOT NULL default 0,
  TipoEntidad nvarchar(3) NOT NULL default 0,
  CodigoEntidad nvarchar(20) NOT NULL default 0,
  Referencia nvarchar(20) NOT NULL default '',
  NumeroControlInicial bigint NOT NULL default 0,
  NumeroControlFinal bigint NOT NULL default 0,
  FacturaRelacionada nvarchar(20) NOT NULL default '',
  Exento money NOT NULL default 0,
  Gravable1 money NOT NULL default 0,
  Tasa1 float NOT NULL default 0,
  Gravable2 money NOT NULL default 0,
  Tasa2 float NOT NULL default 0,
  Impuesto1 money NOT NULL default 0,
  Impuesto2 money NOT NULL default 0,
  Retencion money NOT NULL default 0,
  TipoDocFiscal nvarchar(3) NOT NULL,
  RifEntidad nvarchar(14) NOT NULL default '',
  NombreEntidad nvarchar(50) NOT NULL default '',
  Relacionado bigint NOT NULL default 0
);

CREATE INDEX Documentos_Fiscales_DocumentosEntidad  ON DocumentosFiscales (TipoEntidad, CodigoEntidad, Fecha, Id);
CREATE INDEX DocumentosFiscales_Documentos ON DocumentosFiscales (TipoDoc, NumeroDoc);
CREATE INDEX DocumentosDocumento ON DocumentosFiscales (TipoEntidad, CodigoEntidad, TipoDoc, Referencia);

CREATE TABLE mesasZonas (
  CodigoZona nvarchar (8) PRIMARY KEY NOT NULL,
  Rangos nvarchar (36) NOT NULL 
);
